// WFSHistoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "WFSHistoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWFSHistoryDlg dialog
int CALLBACK CWFSHistoryDlg::CompareItems(LPARAM lp1, LPARAM lp2, LPARAM lp)
{
	int i1 = -1, i2 = 1;
	ItemData *data = (ItemData*)lp;
	if(data->dec)
	{
		i1 = 1;
		i2 = -1;
	}
	CaplInstance *inst1 = (CaplInstance*)lp1;
	CaplInstance *inst2 = (CaplInstance*)lp2;
	CString val1=_T(""), val2 = _T("");
	data->m_api->m_data.GetAttrBN(inst1,_T("date"),val1);
	data->m_api->m_data.GetAttrBN(inst2,_T("date"),val2);
	if(val1>val2) return i1;
	if(val1<val2) return i2;
	return 0;
}

CWFSHistoryDlg::CWFSHistoryDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CWFSHistoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWFSHistoryDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api = 0;
	m_inst = 0;
	m_sort_dec = true;
}


void CWFSHistoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWFSHistoryDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_WFSH_LIST, m_list_ctrl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWFSHistoryDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CWFSHistoryDlg)
	ON_NOTIFY(LVN_COLUMNCLICK, IDC_WFSH_LIST, OnColumnclickWfshList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWFSHistoryDlg message handlers

BOOL CWFSHistoryDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	if(m_api==0 || m_inst==0)
	{
#ifdef _DEBUG
		AfxMessageBox( APL_T("  m_api  m_inst"));
		EndDialog(0);
		return FALSE;
#endif
	}
	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));

	// TODO: Add extra initialization here
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	AddAnchor(m_ok_btn,BOTTOM_RIGHT);
	AddAnchor(m_list_ctrl,TOP_LEFT,BOTTOM_RIGHT);

	m_list_ctrl.InsertColumn(0, APL_T(""),LVCFMT_LEFT,180);
	m_list_ctrl.InsertColumn(1, APL_T(" "),LVCFMT_LEFT,180);
	m_list_ctrl.InsertColumn(2, APL_T(" "),LVCFMT_LEFT,100);
	m_list_ctrl.InsertColumn(3, APL_T(""),LVCFMT_LEFT,210);
	m_list_ctrl.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	LoadData();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

bool CWFSHistoryDlg::LoadData()
{
	m_list_ctrl.DeleteAllItems();
	CaplLoadData ld(&m_api->m_data,DEF_SOURCE);
	CaplEntity *ent = m_api->m_data.GetEntityBN(_T("apl_workflow_state_history"));
	CaplAttr *a_item = m_api->m_data.GetAttrDefinition(ent,_T("item"));
	CaplAttr *a_user = m_api->m_data.GetAttrDefinition(ent,_T("user"));
	CaplAttr *a_date = m_api->m_data.GetAttrDefinition(ent,_T("date"));
	CaplAttr *a_old_state = m_api->m_data.GetAttrDefinition(ent,_T("old_state"));
	CaplAttr *a_new_state = m_api->m_data.GetAttrDefinition(ent,_T("new_state"));
	int i = ld.AddQuery(_T('b'),m_inst->GetId(),ent,a_item,true);
			ld.AddQuery(_T('d'),i,0,a_item, true);
			ld.AddQuery(_T('d'),i,0,a_user, true);
			ld.AddQuery(_T('d'),i,0,a_date, true);
			ld.AddQuery(_T('d'),i,0,a_old_state, true);
			ld.AddQuery(_T('d'),i,0,a_new_state, true);
		ld.LoadEx();
	aplExtent ext;
	m_api->m_data.GetEntityExtent(ent,ext);
	for(i=0; i<ext.Size;i++)
	{
		CaplInstance *inst = 0;
		m_api->m_data.GetAttr(ext[i],a_item,inst);
		if(inst==m_inst)
		{
			CString val=_T("");
			m_api->m_data.GetAttr(ext[i],a_new_state,val);
			int ind = m_list_ctrl.InsertItem(m_list_ctrl.GetItemCount(),m_api->m_doc_mgr.GetWFStateName(val));
			m_api->m_data.GetAttr(ext[i],a_old_state,val);
			m_list_ctrl.SetItemText(ind,1,m_api->m_doc_mgr.GetWFStateName(val));
			m_api->m_data.GetAttr(ext[i],a_date,val);
			COleDateTime time;
			aplString2Date(val,time);
			val = time.Format(_T("%d.%m.%Y %H:%M"));
			m_list_ctrl.SetItemText(ind,2,val);
			m_api->m_data.GetAttr(ext[i],a_user,val);
			m_list_ctrl.SetItemText(ind,3,val);
			m_list_ctrl.SetItemData(ind,(DWORD)ext[i]);
		}
	}
	ItemData id;
	id.dec = false;
	m_sort_dec = false;
	id.m_api = m_api;
	m_list_ctrl.SortItems(/*CWFSHistoryDlg::*/CompareItems,(unsigned long)&id);
	return true;
}

void CWFSHistoryDlg::OnColumnclickWfshList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	*pResult = 0;
	if(pNMListView->iSubItem!=2) return;

	ItemData id;
	m_sort_dec = !m_sort_dec;
	id.dec = m_sort_dec;
	id.m_api = m_api;
	m_list_ctrl.SortItems(/*CWFSHistoryDlg::*/CompareItems,(unsigned long)&id);
}
