// apl_api.h
//     PSS API

#ifndef _APL_API_MAIN_HEADER
#define _APL_API_MAIN_HEADER

//    
#ifndef APL_STEP_MGR_NOAUTOLIB
#ifdef _DEBUG
#ifdef UNICODE
#pragma comment (lib,"CaplData_ud.lib")
#pragma comment (lib,"AplTransportClient_ud.lib")
#pragma comment (lib,"aplStepMgr_ud.lib")
#else
#pragma comment (lib,"CaplDataD.lib")
#pragma comment (lib,"AplTransportClientD.lib")
#pragma comment (lib,"aplStepMgrD.lib")
#endif
#else
#ifdef UNICODE
#pragma comment (lib,"CaplData_u.lib")
#pragma comment (lib,"AplTransportClient_u.lib")
#pragma comment (lib,"aplStepMgr_u.lib")
#else
#pragma comment (lib,"CaplData.lib")
#pragma comment (lib,"AplTransportClient.lib")
#pragma comment (lib,"aplStepMgr.lib")
#endif
#endif
#endif

;
#include <atlbase.h>

class CaplAPI;
class CaplStepManager;
class CaplAutorizationManager;
class CaplBPManager;
class CaplCategoryManager;
class CaplChangeManager;
class CaplCharacteristicManager;
class CaplDocManager;
class CaplExchangeManager;
class CaplQueryManager;
class CaplFolderManager;
class CaplMessageManager;
class CaplPrdInstManager;
class CaplProductManager;
class CaplUnitExchangeManager;
class CShowOpt;
class CaplFormManager;
class CaplRequirementMgr;

#define apidata m_api->m_data

#include <aplNetStepData.h>
#include "aplClassifierMgr.h"
#include "CaplPreExploitationMgr.h"

#ifdef _AFXEXT
	#include "aplStepManager.h"
#else
	#include <aplStepManager.h>
#endif

class AFX_EXT_CLASS CShowOpt  
{
public:
	BOOL ShowOption();
	void GetValue(CRegKey &key, CString name, BOOL &param);
	BOOL SaveData();
	BOOL LoadData();
	CShowOpt();
	virtual ~CShowOpt();
	
	BOOL	m_showbpinst_id;
	BOOL	m_showbpinst_name;
	BOOL	m_showbpinst_date;

	BOOL	m_showbpres_id;
	BOOL	m_showbpres_type;
	BOOL	m_showbpres_object;
	BOOL	m_showbpres_amount;
	
	BOOL	m_show_org_struct;
	BOOL	m_show_classificators;

	BOOL	m_prd_id;
	BOOL	m_prd_name;
	BOOL	m_prd_count;
	BOOL	m_prd_position;
	BOOL	m_prd_code;
	BOOL	m_pdf_code;
	BOOL	m_pdf_code1;
	BOOL	m_pdf_code2;

	BOOL	m_appr_pers;
	BOOL	m_appr_status;
	BOOL	m_appr_pers_role;
	BOOL	m_appr_date;
	BOOL	m_appr_time;

	BOOL	m_charact_id;
	BOOL	m_charact_name;
	BOOL	m_charact_value;
	BOOL	m_charact_unit;
	BOOL	m_charact_scope;

	BOOL	m_doc_id;
	BOOL	m_doc_show_add_code_document_type;
	BOOL	m_doc_name;
	BOOL	m_doc_ver;
	BOOL	m_doc_type;
	BOOL	m_doc_editing_user;
	BOOL	m_doc_show_addional_code;
	BOOL	m_doc_show_date;
	BOOL	m_doc_show_inv_num;
	BOOL	m_doc_show_recipient;
	

	bool	m_doc__view_on_dblclick;

	BOOL	m_org_id;
	BOOL	m_org_name;

	BOOL	m_PrdNoShowPlusToPart;

	BOOL m_PrdNoShowReplacedPart; //    ( )  

	BOOL	m_categ_id;
	BOOL	m_categ_name;

	BOOL	m_show_charactId_or_name;

	BOOL	m_task_cancel;
	BOOL	m_task_complete;
	BOOL	m_task_suspend;

	BOOL	m_BPType;
	BOOL	m_BPId;
	BOOL	m_BPName;
	BOOL	m_BPDescr;
	BOOL	m_BPNum;

	BOOL	m_auto_wfstate;

	BOOL	m_PrdInstId;
	BOOL	m_PrdInstSN;
	BOOL	m_PrdInstPrd;
	
	BOOL	m_PersonFullInitials;
	BOOL	m_PersonId;

	//Project
	BOOL	m_show_project_id;
	BOOL	m_show_project_num_zak;
	BOOL	m_show_project_name;
	BOOL	m_show_project_type;
	BOOL	m_show_project_state;
	BOOL	m_show_project_number;

	// Refusal
	BOOL	m_show_refusal_doc_type;
	BOOL	m_show_refusal_doc_id;
	BOOL	m_show_refusal_doc_date;
	BOOL	m_show_refusal_state;
	BOOL	m_show_refusal_type;
	BOOL	m_show_refusal_descr;
	BOOL	m_show_refusal_stage;
	BOOL	m_show_refusal_planer;
	BOOL	m_show_refusal_item;

	//Classifier
	BOOL	m_show_classifier_system_id;
	BOOL	m_show_classifier_system_name;

	BOOL	m_show_classifier_level_id;
	BOOL	m_show_classifier_level_name;
	BOOL	m_show_classifier_level_level;

	BOOL	m_show_task_id;
	BOOL	m_show_task_name;
	BOOL	m_show_task_process_id;
	BOOL	m_show_task_process_name;

	BOOL	m_show_process_id;
	BOOL	m_show_process_name;
};

class AFX_EXT_CLASS CaplAPI
{
public:
	bool ChangeCurrentUserPassword();
	bool ChangeUserPassword(CaplInstance* pUser);
	bool SetPasswordSecurity();
	
	bool SelectPdf(CaplInstance** Pdf, LPCTSTR Id=NULL, bool bFindExecute = false, aplStringBindMode BindMode = aplSBLeft);
	CaplAPI();
	virtual ~CaplAPI();

	CShowOpt m_show;//      

	CaplNetStepData m_data;						/**< */

public:
	CaplCategoryManager m_categ_mgr;			/**< */
	CaplDocManager m_doc_mgr;					/**< */
	CaplProductManager m_prd_mgr;				/**< */
	CaplPrdInstManager m_prd_inst_mgr;			/**<  */
	CaplBPManager m_bp_mgr;						/**< -*/
	CaplCharacteristicManager m_charact_mgr;	/**< */
	CaplUnitExchangeManager m_unit_exch_mgr;	/**<   */
	CaplFolderManager m_folder_mgr;				/**< */
	CaplMessageManager m_message_mgr;			/**< */
	CaplAutorizationManager m_appr_mgr;			/**< */
	CaplChangeManager m_change_mgr;				/**< */
	CaplQueryManager m_query_mgr;				/**< */
	CaplPreProjectManager* m_project_mgr;		/**< */
	CaplPreForumManager* m_forum_mgr;			/**< */
	CaplOptionsManager m_options_mgr;			/**< */
	CaplClassifierMgr	m_classifier_mgr;		/**< >*/
	CaplFormManager		m_form_mgr;				/**< >*/
	CaplRequirementMgr	m_req_mgr;				/**< */
	CaplPreWMSManager	*m_wms_mgr;				/**<   */
	CaplPreExploitationMgr	*m_expl_mgr;		/**< >*/
	CaplStepManager		*m_packet_mgr;			/**< > ( )*/
	CaplStepManager		*m_techGuide_mgr;		/**<  >*/	
	CaplDeclareWorkflowManager *m_wf_mgr;		/**< >*/	
	CaplPreConfigurationMgr *m_config_mgr;		/**< >*/	

	/**@name  */
	//@{
	/**         (  true)*/
	bool m_AutoSave;

	//     .    SetAutoSave(true)(     m_data) - SetAutoSave(false)()
	bool m_old_mode_save_access;

	/**       c  SaveChanges  .     (  true)*/
	bool m_AutoUsurpire;

	/**        (  true)*/
	bool m_ModeInteractive;

	/**      1 */
	int m_MaxItemsLoad;

	/**    */
	bool m_bModeIntegration;

	/**       (pdf)*/
	bool m_bUseConfigurationPdfs;
	//@}

	bool m_bLoadedOrgstruct; //   true   .   false -    .

	/**     3*/
	static bool m_bLss3Mode;
	static void SetLss3Mode();
	static bool GetLss3Mode();

	/**@name  */
	//@{

	/**          
		@param _username  .    ,        
		@param _pwd  
		@param _name_connect  ,    .    ,        
		@param connection_type   (  )
		@param supress_dlg    
		@param wait_text ,        .       
		@return <b>true</b>     <b>false</b>    */
	bool Connect(const TCHAR *_username=0, const TCHAR *_pwd=0,const TCHAR* _name_connect=0, long connection_type=apl_LT_DEF_TYPE, const TCHAR* wait_text=0, bool supress_dlg= false);

	/**    
		@return <b>true</b>     <b>false</b>    */
	bool Disconnect();

	/**    */
	bool SaveChanges();

	/**      ( Connect  )*/
	void Init();

	//@}


	/**      item 
		@return <b>true</b>     <b>false</b>    */
	bool GetItemName(CaplInstance * item, CString &buf);
	CString GetItemName(CaplInstance * item);

	/**   names      extent,  razdelit
		 razdelit==0,   "; "
	    @return true     false    */
	bool GetItemsName(aplExtent &ext, CString &names, const TCHAR *razdelit=0);

	/**        item 
		  -   item        */
	CString GetItemTypeName(CaplInstance * item);


		/**     c      bShowCode==true -     
	    @return true     false    */
	bool GetPdfName(CaplInstance * pdf, CString &buf, bool bShowCode=false);

	/**       ,   ext 
	    @return <b>true</b>     <b>false</b>    */
	bool LoadExtentInfo(aplExtent &ext);

	//      TGB (  )
	bool LoadExtentInfoPrimitive(aplExtent &ext);

	/**      
	    @return <b>true</b>     <b>false</b>    */
	bool LoadItemInfo(CaplInstance *item);

	/**         Instance
		item - Instance,      
		return     Instance  -1   */
	int GetInstIco(CaplInstance* item);

	/**    
		Image1 -   Instance
		Image2 -   Instance
		return <b>-1</b>   Instance    , <b>1</b>        <b>0</b>    */
	static int aplCompareItemsImage(int Image1, int Image2);

	
	/**  GUID
		guid - ,     GUID
		@return <b>true</b>     false    */
	static bool CreateGuid(CString &guid);
	
	/**         
		mode -   
		*/
	void SetModeInteractive(bool mode);
	
	/**     
		mode -   
		*/
	void SetAutoUsurpire(bool mode);
	
	/**    
		mode -   
		*/
	void SetAutoSave(bool mode);

	/**       1 */
	void SetMaxItemsLoad(int MaxItemsLoad);

	/**	  
		@param Item - ,     
		@return <b>true</b>     (  "")  <b>false</b>   */
	bool ShowItemProperties(CaplInstance* Item);

	/**	       /,   
		@param Item - ,      
		@return <b>true</b>     <b>false</b>    */
	bool SetRecursiveAccess(CaplInstance* Item);

	/**	,      /: 1)      
	   2)      .
	    ()   -      
		@param Item - ,     
		@param extent -  ,     
		@return <b>true</b>        <b>false</b>           */
	bool TestAccessChecked(CaplInstance* Item);
	bool TestAccessChecked(aplExtent &extent, bool single=false);

	/**	   ,     
		@param Item - ,    
		@return <b>true</b>     <b>false</b>    */
	bool DeleteItem(CaplInstance* Item);

	bool aplGetCurrentTime(COleDateTime &time);
	bool aplGetCurrentTime(CString &time);
	
	/**       ext,    
		  .
		@param nMaxLoad -   ,   .
			 nMaxLoad > ext.GetSize(),      .
			 0,     .
		@param bLoadAttrs -      ext.
		@param fn -    .
		@param data -     .
		@return <b>true</b>     <b>false</b>   
	*/
	bool LoadByParts(aplExtent &ext, int nMaxLoad, bool bLoadAttrs, void(*fn)(CaplAPI *, CaplLoadData &, DWORD), DWORD data);

	/**    LoadExtentInfo/LoadItemInfo   
		  true    CaplCharacteristicManager,   
		    
		  false        instance
		
	*/
	bool SetLoadCharacteristicValues(bool is_load);
	bool m_load_characteristic_values;

protected:
	TCHAR *m_data_moved;
	long m_data_moved_size;

private:
};

//     
bool AFX_EXT_API aplInputStrValue(LPCTSTR sHader, LPCTSTR sName, CString &sVal);

#endif





















