#ifndef _APL_WF_MGR_COMMON_
#define _APL_WF_MGR_COMMON_

#include "apl_api.h"
#include "aplWorkFlowManager.h"
  
class CTaskInfo
{
public:
	CaplAPI* m_api;
	CaplWorkFlowManager* m_wfMgr;
	CaplInstance* m_activity;
	CaplInstance* m_performer;
	aplExtent m_performers;
	CaplInstance* m_manager;
	CaplInstance* m_role;
	double m_rDuration;
	CString m_sId;
	CString m_sName;

	bool GetDefaultPersons()
	{
		if(!m_activity) return false;
		if(!m_api) return false;
		if(!m_api->m_data.IsConnected()) return false;
		if(m_performer || m_manager) return true;
	
		aplExtent ext;
		m_api->m_data.GetAttr(m_activity, m_wfMgr->a_activity_executors, ext);
		if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org)) m_performer= ext[0];
		m_api->m_data.GetAttr(m_activity, m_wfMgr->a_activity_managers, ext);
		if(1==ext.GetSize() && !m_api->m_data.IsKindOf(ext[0], m_api->m_appr_mgr.e_org)) m_manager= ext[0];

		return true;
	}
	
	CTaskInfo(CaplAPI* api= NULL, CaplWorkFlowManager* wfMgr= NULL,
		CaplInstance* act= NULL, double d= 0, 
		CaplInstance* prf= NULL, CaplInstance* mgr= NULL, CaplInstance* role= NULL,
		CString id= _T(""), CString name= _T(""))
	{
		m_api= api;
		m_wfMgr= wfMgr;
		
		m_activity= act; m_performer= prf; m_manager= mgr; m_rDuration= d; 
		m_role= role;
		m_sId= id; m_sName= name;

		if(m_activity && !m_performer && !m_manager)
			GetDefaultPersons();
		
		m_performers.Clear();
	}

	CTaskInfo(const CTaskInfo &ti)
	{
		m_api= ti.m_api;
		m_wfMgr= ti.m_wfMgr;
		m_activity= ti.m_activity;
		m_performer= ti.m_performer;
		m_manager= ti.m_manager;
		m_role= ti.m_role;
		m_rDuration= ti.m_rDuration;
		m_sId= ti.m_sId;
		m_sName= ti.m_sName;
		m_performers.Append(ti.m_performers);
	}
};

class CApprObject
{
public:
	CaplInstance* m_item;
	CaplInstance* m_apprStatus;
	CApprObject(CaplInstance* item= NULL, CaplInstance* status= NULL)
	{
		m_item= item;
		m_apprStatus= status;
	}
};

class CPersonsWG
{
public:
	CaplInstance* m_person;
	aplExtent m_orgs;
	CPersonsWG(CaplInstance* person= NULL, aplExtent* orgs= NULL)
	{
		m_person= person;
		if(orgs)
		{
			for(int i= 0; i<orgs->GetSize(); i++)
				m_orgs.Add(orgs->GetAt(i));
		}
	}
};

typedef CArray <CPersonsWG, CPersonsWG> CPersWgArray;
typedef CArray <CTaskInfo, CTaskInfo> CTaskInfoArray;

#define APL_ICON_NULL 0 
#define APL_ICON_PERS_FOLDER 1
#define APL_ICON_FOLDERS 2
#define APL_ICON_FOLDER 3
#define APL_ICON_CATEGORIES 4
#define APL_ICON_CATEGORY 5
#define APL_ICON_DOCUMENT 6
#define APL_ICON_PROD 8
#define APL_ICON_ASSEMBLY 9
#define APL_ICON_PART 10
#define APL_ICON_MATERIAL 11
#define APL_ICON_KIT 12
#define APL_ICON_KOMPLEX 13
#define APL_ICON_FILE 14
#define APL_ICON_TASK 15
#define APL_ICON_PERSON 17
#define APL_ICON_ORGANIZATION 18
#define APL_ICON_OFFICIAL 19
#define APL_ICON_CHANGE 21
#define APL_ICON_ACTION 22

#define APL_WF_EVENT_RUN 0x0001
#define APL_WF_EVENT_SUSPEND 0x0002
#define APL_WF_EVENT_COMPLETE 0x0004
#define APL_WF_EVENT_TERMINATE 0x0008
#define APL_WF_EVENT_ACCEPT 0x0010

#define APL_WF_EVENT_MGR_CHANGE 0x0001
#define APL_WF_EVENT_PER_CHANGE 0x0002

#endif

	/**    <b>user</b>   <b>access_def</b>  <B>instance</B>,
		  <b>extent</b>
		@return <b>true</b>     <b>false</b>    
	bool NET_SetInstancesAccess(aplExtent* extent,CaplInstance* user,aplAccessModeType access_def);
	/**       "" (aplOWNER)  <B>instance</B>,
		  <b>extent</b>.      
		   " " (aplRO)
		@return <b>true</b>     <b>false</b>    
	bool NET_BecomeInstancesOwner(aplExtent* extent);
	/**  ,          
		    <B>instance</B>,   <b>extent</b>.
		@return <b>true</b>     <b>false</b>    
	bool NET_SetInstancesAccess(aplExtent* extent);*/