// SelConnectorDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SelConnectorDlg.h"


// CSelConnectorDlg dialog

IMPLEMENT_DYNAMIC(CSelConnectorDlg, CDialog)

CSelConnectorDlg::CSelConnectorDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSelConnectorDlg::IDD, pParent)
{
	m_api=0;
	m_wf_mgr=0;
	m_task=0;
	m_connector=0;
}

CSelConnectorDlg::~CSelConnectorDlg()
{
}

void CSelConnectorDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_ET_CONNECTOR, m_connector_ctrl);
	DDX_Control(pDX, IDC_ET_TASK_ID, m_st_id_ctrl);
	DDX_Control(pDX, IDC_ET_TASK_NAME, m_st_name_ctrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
}


BEGIN_MESSAGE_MAP(CSelConnectorDlg, CDialog)
END_MESSAGE_MAP()


// CSelConnectorDlg message handlers

BOOL CSelConnectorDlg::OnInitDialog()
{
	if(0==m_api || 0==m_task || 0== m_wf_mgr) return FALSE;

	CDialog::OnInitDialog();

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);


	CString buf,buf1;
	m_api->m_data.GetAttr(m_task, m_wf_mgr->a_action_id, buf);
	m_st_id_ctrl.SetWindowText(buf);
	m_api->m_data.GetAttr(m_task,  m_wf_mgr->a_action_name, buf);	
	m_st_name_ctrl.SetWindowText(buf);


	aplExtent ext_in,ext_out;
	m_wf_mgr->GetConnectors(m_task, ext_in, ext_out);

	int i;
	for(i= 0; i<ext_out.GetSize(); i++)
	{
		CaplInstance *status, *conn=ext_out[i];
		m_api->m_data.GetAttr(conn, m_wf_mgr->a_act_rel_name, buf);

		m_api->m_data.GetAttr(conn, m_wf_mgr->a_act_secuence_status, status);
		if(0!=status)
		{
			m_api->m_data.GetAttr(status, m_api->m_appr_mgr.a_appr_status_name, buf1);
			if(buf1!=_T("")){buf+=_T("   /   '"); buf+=buf1; buf+=_T("'");}
		}
		int n= m_connector_ctrl.AddString(buf);
		m_connector_ctrl.SetItemData(n, (DWORD)conn);
	}


	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CSelConnectorDlg::OnOK()
{
	int i=m_connector_ctrl.GetCurSel();
	if(i>=0)m_connector= (CaplInstance*)m_connector_ctrl.GetItemData(i);
	if(0==m_connector){MessageBox(APL_T("  "), APL_T(""), MB_OK|MB_ICONERROR);return;}
	

	CDialog::OnOK();
}
