#pragma once
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// WfGanttView.h : header file
//
#include "resource.h"
#include <apl_gui.h>
#include "WfGanttCtrl.h"


#ifdef APL_PROGECT_MGR
#define APL_PM_CLASS_EXPORT		_declspec(dllexport)
#else
#define APL_PM_CLASS_EXPORT		_declspec(dllimport)
#endif



/////////////////////////////////////////////////////////////////////////////
// CWfGanttView view

class CWfGanttView : public CView
{
protected:
	CWfGanttView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CWfGanttView)

// Attributes
public:
	CaplTreeListCtrlView *m_tree_view;
	CWfGanttCtrl m_gantt;
	CScrollBar m_horScrollBar;
	bool m_bShrinkToFit;
// Operations
public:
	bool ZoomOut(int step=0);
	bool ZoomIn(int step=0);
	void Initialize();
	void Update(bool bUpdateCalendar=false);
	void ResetScrollBar();

	BOOL VerticalScrollVisible();
	BOOL HorizontalScrollVisible();

	int StretchWidth(int m_nWidth, int m_nMeasure);
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWfGanttView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	BOOL m_TLInitialized;	
	virtual ~CWfGanttView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CWfGanttView)
	afx_msg int OnMouseActivate( CWnd* pDesktopWnd,UINT nHitTest,UINT message);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.


