﻿// ErrMess.h - содержит определения ошибок и часть тела функции для 
// вывода сообъщений об ошибках (внутри оператора switch)


#ifndef _DEF_ER_FUNCT

#include "StepData.h"


// Макросы для обработки исключений
#define MY_THROW(err) throw(SaplErrorDescription((AplNetErrors)err,_T(__FILE__),_T(__DATE__),__LINE__,_T(""),SaplErrorDescriptionLevel_NetStepData,__APL_FUNC__));
#define MY_THROW_EX(err,descr) throw(SaplErrorDescription((AplNetErrors)err,_T(__FILE__),_T(__DATE__),__LINE__,descr,SaplErrorDescriptionLevel_NetStepData,__APL_FUNC__));

#define ERR_MESS_EX(id,text) case id:m_error_definition.Format(text);break;
#define THROW_IF(condition,err_code) if(condition){MY_THROW((AplNetErrors) err_code);}
#define THROW_IF_EX(condition,err_code,descr) if(condition){MY_THROW_EX((AplNetErrors) err_code,descr);}

#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_NOT_ERR			0
#else
//ERR_MESS_EX(STEP_QL_ERR_NOT_ERR,APL_T("Нет ошибки"))
#endif


#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_COULD_NOT_READ			101
#else
ERR_MESS_EX(STEP_QL_ERR_COULD_NOT_READ,APL_T("Неправильное окончание запроса"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_SELECT				102
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_SELECT,APL_T("Ожидается SELECT или SELECT_LOAD_ALL"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_OUTPUT_DESCR		103
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_OUTPUT_DESCR,APL_T("Ожидается определение выходного множества"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_CONDITION_DEF				104
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_CONDITION_DEF,APL_T("Ожидается определение условия (символы \".\" или \"(\" )"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_FROM				105
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_FROM,APL_T("Ожидается FROM"))
#endif

// #ifndef _DEF_ER_FUNCT
// #define STEP_QL_ERR_INVALID_FROM			106
// #else
// ERR_MESS_EX(STEP_QL_ERR_INVALID_FROM,APL_T("Неправильный FROM"))
// #endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_1234				107
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_1234,APL_T("Ожидается AND, OR, ')' или FROM"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_NAME			108
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_NAME,APL_T("Ожидается имя атрибута или псевдоатрибута"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ENTITY_NAME		109
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ENTITY_NAME,APL_T("Ожидается имя энтити"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ENTITY_POINTER		110
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ENTITY_POINTER,APL_T("Ожидается символ ентити \"->\""))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_ENTITY_DEF		111
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_ENTITY_DEF,APL_T("Отсутствует ентити с таким именем"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_ATTR_DEF		112
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_ATTR_DEF,APL_T("У текущей ентити нет такого атрибута"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_ATTR_ENTITY		113
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_ATTR_ENTITY,APL_T("Атрибут указывает на ентити другого типа"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_BRAKETS_TOO_MUCH_OPEN	114
#else
ERR_MESS_EX(STEP_QL_ERR_BRAKETS_TOO_MUCH_OPEN,APL_T("Ожидается закрывающая скобка"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_BRAKETS_TOO_MUCH_CLOSE	115
#else
ERR_MESS_EX(STEP_QL_ERR_BRAKETS_TOO_MUCH_CLOSE,APL_T("Лишняя закрывающая скобка"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_UNDEFAINED_WORD			116
#else
ERR_MESS_EX(STEP_QL_ERR_UNDEFAINED_WORD,APL_T("Неизвестное в этом контексте слово"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_NAME_EXT			117
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_NAME_EXT,APL_T("Ожидается имя экстента"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_NAME_EXT		118
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_NAME_EXT,APL_T("Некорректное имя экстента"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_EXTENT_DEF			119
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_EXTENT_DEF,APL_T("Ожидается определение экстента"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_EXT_DEFINED				120
#else
ERR_MESS_EX(STEP_QL_ERR_EXT_DEFINED,APL_T("Экстент уже определен"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_EXT_NOT_DEFINED			121
#else
ERR_MESS_EX(STEP_QL_ERR_EXT_NOT_DEFINED,APL_T("Экстент не определен"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_OPEN_CURLY_BRAKET	122
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_OPEN_CURLY_BRAKET,APL_T("Ожидается {"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_CLOSE_CURLY_BRAKET	123
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_CLOSE_CURLY_BRAKET,APL_T("Ожидается }"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_BEGIN_CONDITIONS	124
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_BEGIN_CONDITIONS,APL_T("Ожидается {"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_LOG_OPERATION		125
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_LOG_OPERATION,APL_T("Ожидается логическое выражение или \"->\""))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_123				126
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_123,APL_T("Ожидается AND, OR, или ')'"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_VALUE				127
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_VALUE,APL_T("Ожидается значение выражения"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_INST_VALUE		128
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_INST_VALUE,APL_T("Ожидается значение #INSTANCE"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_INST_EXT_VALUE		129
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_INST_EXT_VALUE,APL_T("Ожидается значение #INSTANCE или #EXTENT"))
#endif

// #ifndef _DEF_ER_FUNCT
// #define STEP_QL_ERR_INVALID_INST_EXT_VALUE	130
// #else
// ERR_MESS_EX(STEP_QL_ERR_INVALID_INST_EXT_VALUE,APL_T("Недопустимое значение #INSTANCE или #EXTENT"))
// #endif

// #ifndef _DEF_ER_FUNCT
// #define STEP_QL_ERR_INVALID_STRING_VALUE	131
// #else
// ERR_MESS_EX(STEP_QL_ERR_INVALID_STRING_VALUE,APL_T("Недопустимое строковое значение"))
// #endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_STRING_VALUE	132
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_STRING_VALUE,APL_T("Ожидается строковое значение"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_INT_VALUE	133
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_INT_VALUE,APL_T("Ожидается целое значение"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_REAL_VALUE	134
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_REAL_VALUE,APL_T("Ожидается дробное значение"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_BOOL_VALUE	135
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_BOOL_VALUE,APL_T("Ожидается булевое значение (true или false)"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_INST_NUMBER	136
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_INST_NUMBER,APL_T("Несуществующий номер #INSTANCE"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_FUNCTION_ONLY_DB	137
#else
ERR_MESS_EX(STEP_QL_ERR_FUNCTION_ONLY_DB,APL_T("Выражение допустимо только для сервера приложения под ORACLE или Postgre"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_TYPE_COLUMN	138
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_TYPE_COLUMN,APL_T("Ожидается определение типа столбца атрибута; формат: \"&определение типа&\""))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_MISSED_TYPE_SQL	139
#else
ERR_MESS_EX(STEP_QL_ERR_MISSED_TYPE_SQL,APL_T("Неверный формат SQL-запроса. Запрос должен иметь форму \"SELECT атрибут FROM ...\", причем атрибут должен быть только один"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_LOG_OP			140
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_LOG_OP,APL_T("Недопустимое логическое отношение"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_INVALID_ATTR_TYPE		141
#else
ERR_MESS_EX(STEP_QL_ERR_INVALID_ATTR_TYPE,APL_T("Тип используемого атрибута не поддерживается запросами"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_BUSH_STRUCTURE_MISSED	150
#else
ERR_MESS_EX(STEP_QL_ERR_BUSH_STRUCTURE_MISSED,APL_T("Ошибка в структуре выходных кустов"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_MISSED_POINTER			151
#else
ERR_MESS_EX(STEP_QL_ERR_MISSED_POINTER,APL_T("Неправильный указатель"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_LOG_OP			152
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_LOG_OP,APL_T("Ожидается логическая операция"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_INST			153
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_INST,APL_T("Ожидается атрибут типа aplINSTANCE или aplSELECT"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_COMMA			154
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_COMMA,APL_T("Ожидается запятая"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_STRING			155
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_STRING,APL_T("Ожидается атрибут типа aplSTRING или aplENUMERATION"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_INTEGER			156
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_INTEGER,APL_T("Ожидается атрибут типа aplINTEGER"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_REAL			157
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_REAL,APL_T("Ожидается атрибут типа aplREAL"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_ATTR_BOOL			158
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_ATTR_BOOL,APL_T("Ожидается атрибут типа aplBOOL"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_OP_AGGR_NOT_AVAIL			159
#else
ERR_MESS_EX(STEP_QL_ERR_OP_AGGR_NOT_AVAIL,APL_T("Операция недопустима для атрибута типа aplAGGR"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_NEED_OPEN_BRAKETS			160
#else
ERR_MESS_EX(STEP_QL_ERR_NEED_OPEN_BRAKETS,APL_T("Ожидается открывающая скобка"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_OP_ONLY_FOR_AGGR			161
#else
ERR_MESS_EX(STEP_QL_ERR_OP_ONLY_FOR_AGGR,APL_T("Операция допустима только для атрибута типа aplAGGR"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_ONLY_EXT_BY_ENT			162
#else
ERR_MESS_EX(STEP_QL_ERR_ONLY_EXT_BY_ENT,APL_T("Уточняющие атрибуты могут быть только у подзапроса на основе entity"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_PSEUDO_ATTR			163
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_PSEUDO_ATTR,APL_T("Ожидается один из псевдоатрибутов: #id, #user_create, #user_update, #date_create, #date_update"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_PSEUDO_ATTR_NO_ARITHMETIC			164
#else
ERR_MESS_EX(STEP_QL_ERR_PSEUDO_ATTR_NO_ARITHMETIC,APL_T("Для псевдоатрибутов недопустимы арифметические операции!"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_PSEUDO_ATTR_DATE_MISSED_VAL			165
#else
ERR_MESS_EX(STEP_QL_ERR_PSEUDO_ATTR_DATE_MISSED_VAL,APL_T("Для псевдоатрибутов даты создания/изменения значение должно представлять строку в формате ГГГГMMДДччммсс где ГГГГ - год, ММ - месяц, ДД - день, чч-часы, мм - минуты, сс - секунды"))
#endif

#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_WAIT_IS_NULL		166
#else
ERR_MESS_EX(STEP_QL_ERR_WAIT_IS_NULL,APL_T("Ожидается продолжение отношения \"is null\" или \"is not null\""))
#endif


#ifndef _DEF_ER_FUNCT
#define STEP_QL_ERR_IS_NULL_NEED_ATTR		167
#else
ERR_MESS_EX(STEP_QL_ERR_IS_NULL_NEED_ATTR,APL_T("Отношения \"is null\" и \"is not null\" не применимы к псевдоатрибутам и арифметическим выражениям"))
#endif
