// WaitDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "WaitDlg.h"
#include "WaitDlgThread.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWaitDlg dialog

extern CImageList g_wait_dlg_img_lst;

long aplGetWaitDlgImgLst()
{
	return (long)&g_wait_dlg_img_lst;
}

CWaitDlg::CWaitDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWaitDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWaitDlg)
	m_txt = APL_T("  . . .");
	//}}AFX_DATA_INIT
	m_idx=0;
	m_Thread=0;

	m_last_icon=0;
	m_sTitle =  APL_T(" ");

	m_bShowDlg = TRUE;
}
CWaitDlg::~CWaitDlg()
{
	if(m_last_icon!=0) DestroyIcon(m_last_icon);
	if(windowPos!=NULL/* && setPos*/)//   ( ) 
	{
		if(windowPos!= HWND_TOPMOST &&
		   windowPos!= HWND_NOTOPMOST &&
		   windowPos!= HWND_BOTTOM &&
		   windowPos!= HWND_TOP)
		{
			HWND hFGND= ::GetForegroundWindow();
			if(hFGND!=NULL &&
				hFGND!= windowPos)
			{
				::SetForegroundWindow(windowPos);
			}
		}
	}
}


void CWaitDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWaitDlg)
	DDX_Control(pDX, IDC_WAIT_IMG, m_img);
	DDX_Text(pDX, IDC_MY_TEXT, m_txt);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWaitDlg, CDialog)
	//{{AFX_MSG_MAP(CWaitDlg)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWaitDlg message handlers

void CWaitDlg::OnTimer(UINT nIDEvent) 
{
	DWORD res=WaitForSingleObject(m_Thread->m_event_End,0);
	if (res==WAIT_FAILED || res==WAIT_OBJECT_0)
	{
		KillTimer(1);
		//CDialog::OnOK();
		m_Thread->PostThreadMessage(WM_QUIT,0,0);
		//DestroyWindow();
		return;
	}

	if (m_Thread->m_bSetText)
	{
		SetTextAreaRect();
		m_Thread->m_bSetText = false;
		SetWindowText(m_sTitle);
		GetDlgItem(IDC_MY_TEXT)->SetWindowText(m_txt);
	}

	if (m_Thread->m_bShowWaitDlg)
	{
		m_Thread->m_bShowWaitDlg = false;
		ShowWindow(m_bShowDlg);
	}

	if(nIDEvent==1)
	{
		m_idx++; if(m_idx>8) m_idx=0;
		m_last_icon=g_wait_dlg_img_lst.ExtractIcon(m_idx/3);
		HICON old_ico=m_img.SetIcon(m_last_icon);
		if(old_ico!=0) DestroyIcon(old_ico);
	}
}

void CWaitDlg::OnOK() 
{
//	CDialog::OnOK();
}

void CWaitDlg::SetTextAreaRect()
{
	// Create a DC for accessing the display driver.
	CDC dcDisplay;
	dcDisplay.CreateDC(_T("DISPLAY"), NULL, NULL, NULL);
	// Select the new font and store the old one.
	CFont* pOldFont = dcDisplay.SelectObject(GetFont());
	// Define the maximum width of the message.
	int nMaxWidth = ( GetSystemMetrics(SM_CXSCREEN) / 2 ) + 100;
	// Create a rect with the maximum width.
	CRect rcMessage(0, 0, nMaxWidth, nMaxWidth);
	// Draw the text and retrieve the size of the text.
	dcDisplay.DrawText(m_txt, rcMessage, DT_LEFT | DT_NOPREFIX | DT_WORDBREAK | DT_CALCRECT);

	int num = 0;
	int start = 0;
	while( start != -1 )
	{
		start = m_txt.Find(_T('\n'), start);
		if( start != -1 )
		{
			num++;
			start++;
		}
	}

	CRect rc, rcWin, rcText;
	CWnd* wText = GetDlgItem(IDC_MY_TEXT);
	GetWindowRect(rcWin);
	wText->GetWindowRect(rcText);
	rc.left = rcText.left - rcWin.left - GetSystemMetrics(SM_CXFIXEDFRAME);
	rc.right = rcText.right - rcWin.left - GetSystemMetrics(SM_CXFIXEDFRAME);
	int y = rcWin.bottom - rcWin.top - GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYFIXEDFRAME)*2;

	if( rcMessage.right-rcMessage.left > (rc.right-rc.left)*2.8 )
	{
		int x = rcWin.right-rcText.right;

		rcWin.right = rcWin.left + (rcWin.right-rcWin.left)*3/2;
		if( rcMessage.right-rcMessage.left > (rc.right-rc.left)*4 )
			rcWin.right = rcWin.left + (rcWin.right-rcWin.left)*3/2;
		if( rcMessage.right-rcMessage.left > (rc.right-rc.left)*5.5 )
			rcWin.right = rcWin.left + (rcWin.right-rcWin.left)*3/2;
		SetWindowPos(NULL, rcWin.left, rcWin.top, rcWin.right-rcWin.left, rcWin.bottom-rcWin.top, SWP_NOZORDER);

		rcText.right = rcWin.right-x;
		rc.left = rcText.left - rcWin.left - GetSystemMetrics(SM_CXFIXEDFRAME);
		rc.right = rcText.right - rcWin.left - GetSystemMetrics(SM_CXFIXEDFRAME);
		y = rcWin.bottom - rcWin.top - GetSystemMetrics(SM_CYCAPTION) - GetSystemMetrics(SM_CYFIXEDFRAME)*2;
	}

	if( rcMessage.right-rcMessage.left < rc.right-rc.left && !num )
	{
		rc.top = (y-rcMessage.bottom-rcMessage.top)/2;
		rc.bottom = rc.top + rcMessage.bottom-rcMessage.top + 2;
	}
	else if( (rcMessage.right-rcMessage.left < (rc.right-rc.left)*1.7 && !num) || num == 1 )
	{
		rc.top = (y-rcMessage.bottom-rcMessage.top)/4 + 1;
		rc.bottom = rc.top + (rcMessage.bottom-rcMessage.top)*3;
	}
	else
	{
		rc.top = 0;
		rc.bottom = y;
		if( rcMessage.right-rcMessage.left > (rc.right-rc.left)*2.6 )
		{
			CRect rcIcon;
			CWnd* wIcon = GetDlgItem(IDC_WAIT_IMG);
			wIcon->GetWindowRect(rcIcon);
			wIcon->SetWindowPos(NULL, 0, rcIcon.top-rcWin.top-GetSystemMetrics(SM_CYCAPTION)-GetSystemMetrics(SM_CYFIXEDFRAME), 0, 0, SWP_NOZORDER|SWP_NOSIZE);

			wIcon->GetWindowRect(rcIcon);
			rc.left = rcIcon.right - rcWin.left;
			rc.right = rcWin.right - rcWin.left - GetSystemMetrics(SM_CXFIXEDFRAME);
		}
	}

	wText->SetWindowPos(NULL, rc.left, rc.top, rc.right-rc.left, rc.bottom-rc.top, SWP_NOZORDER);
}

BOOL CWaitDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	SetTextAreaRect();

	SetWindowText(m_sTitle);

	if ( setPos )
	{
		::SetWindowPos(m_hWnd, windowPos, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE );
	}

	SetTimer(1,50,NULL);
	return TRUE;  // return TRUE unless you set the focus to a control
               // EXCEPTION: OCX Property Pages should return FALSE
}


void CWaitDlg::OnCancel() 
{
///	CDialog::OnCancel();
}
