// WiatProgressDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_gui.h"
#include "WiatProgressDlg.h"


// CWiatProgressDlg dialog

IMPLEMENT_DYNAMIC(CWiatProgressDlg, CaplTranslateDialog)

CWiatProgressDlg::CWiatProgressDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CWiatProgressDlg::IDD, pParent)
{
	m_bInit = false;
}

CWiatProgressDlg::~CWiatProgressDlg()
{
}

void CWiatProgressDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_TEXT, m_txt);
	DDX_Control(pDX, IDC_STOP, m_stop);
	DDX_Control(pDX, IDC_PROGRESS, m_progress);
}

BEGIN_MESSAGE_MAP(CWiatProgressDlg, CaplTranslateDialog)
	ON_WM_TIMER()

	ON_BN_CLICKED(IDC_STOP, OnStop)
END_MESSAGE_MAP()

void CWiatProgressDlg::OnCancel()
{

}

void CWiatProgressDlg::OnOK()
{

}

void CWiatProgressDlg::OnTimer(UINT nIDEvent) 
{
	if(m_Thread->m_End == 1)
		Exit();	
}

void CWiatProgressDlg::Exit()
{
	KillTimer(1);
	EndDialog(IDOK);	
}

BOOL CWiatProgressDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	m_stop.SetFlat(FALSE);
	m_stop.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	m_bInit = true;
	SetTimer(1, 50, NULL);

	SetText(m_txt);
	SetWindowText(m_sTitle);
	::SetWindowPos(m_hWnd, HWND_TOP, 0,0,0,0, SWP_NOMOVE | SWP_NOSIZE );

	m_progress.SetStep(1);
	m_progress.SetRange(0 , 100);
	
	return TRUE;  	
}

void CWiatProgressDlg::SetText( const TCHAR * text )
{
	m_txt = text;
	GetDlgItem(IDC_TEXT)->SetWindowText(text);	
}

void CWiatProgressDlg::OnStop()
{
	m_Thread->m_bCanceled = true;
	SetText( APL_T(" ..."));
}

void CWiatProgressDlg::SetTitle( const TCHAR *title )
{
	m_sTitle = title;
	SetWindowText(m_sTitle);	
}