// aplImage.cpp: implementation of the CaplImageGuiEx class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
/*#include "aplguiex.h"
#include <ximage.h>

#include <aplAggr.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CaplImageGuiEx::CaplImageGuiEx()
{
	m_pImage = NULL;
}

CaplImageGuiEx::~CaplImageGuiEx()
{
	if(m_pImage)
		delete m_pImage;
}

bool CaplImageGuiEx::LoadImage(LPCTSTR lpszFileName)
{
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;
	if(lpszFileName==NULL) return false;
	CString buf(lpszFileName);
	buf.TrimLeft(); buf.TrimRight();
	if(buf.IsEmpty()) return false;
	
	m_pImage = new CxImage;
	if(m_pImage==0) return FALSE;
	if(!m_pImage->Load(buf))
		return FALSE;
	if (m_pImage->GetWidth() <= 0 || m_pImage->GetHeight() <= 0)
	{
		AfxMessageBox(CaplStringAdapter(m_pImage->GetLastError()));
		delete 	m_pImage;
		m_pImage = NULL;
		return FALSE;
	}
	return TRUE;
}

void CaplImageGuiEx::Draw(CRect &rect, CDC *pDC, UINT flags)
{
	if(pDC==NULL) return;
	if(m_pImage==NULL) return;

	CRect draw_rect = rect;
	if(flags&APL_DI_FIT_TO_RECT_WSCALE)
	{
		int cx, cy, rcx, rcy;
		cx = m_pImage->GetWidth();
		cy = m_pImage->GetHeight();
		rcx = rect.Width();
		rcy = rect.Height();
		double p1 = double(cx)/double(cy);
		double p2 = double(rcx)/double(rcy);
		if(p1!=p2)
		{
			int tmp_cy = int(rcx/p1);
			int tmp_cx = rcx;
			if(tmp_cy>rcy)
			{
				tmp_cy = rcy;
				tmp_cx = int(rcy*p1);
			}
			draw_rect.left = rect.left + (rcx-tmp_cx)/2;
			draw_rect.right = draw_rect.left + tmp_cx;
			draw_rect.bottom = rect.bottom - (rcy-tmp_cy)/2;
			draw_rect.top = draw_rect.bottom - tmp_cy;
		}
	}
	else if(!(flags&APL_DI_FIT_TO_RECT))
		return;

	draw_rect.NormalizeRect();
	m_pImage->Stretch(pDC->m_hDC,draw_rect);
	
	return;
}

bool CaplImageGuiEx::GetImageDimensions(CSize &sizes)
{
	if(m_pImage==NULL) return false;
	sizes = CSize(m_pImage->GetWidth(), m_pImage->GetHeight());
	return true;
}

bool CaplImageGuiEx::SaveAs(LPCTSTR lpszFileName)
{
	if(lpszFileName==NULL) return false;
	if(m_pImage==NULL) return false;
	
	CString pathname = lpszFileName;
	if(pathname.IsEmpty()) return FALSE;
	
	m_pImage = new CxImage();
	if(!m_pImage->Load(pathname))
	{

		delete m_pImage;
		m_pImage = NULL;
		return false;
	}
	if(m_pImage==0) return FALSE;
	if (m_pImage->GetWidth() <= 0 || m_pImage->GetHeight() <= 0)
	{
		AfxMessageBox(CaplStringAdapter(m_pImage->GetLastError()));
		delete 	m_pImage;
		m_pImage = NULL;
		return FALSE;
	}
	return TRUE;
}

bool CaplImageGuiEx::LoadFromBuf(BYTE *pBuf, DWORD size, DWORD type)
{
	if(pBuf==NULL) return false;
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;
	
	m_pImage = new CxImage(pBuf, size, type);
	if(m_pImage==0) return FALSE;
	if (m_pImage->GetWidth() <= 0 || m_pImage->GetHeight() <= 0)
	{
		AfxMessageBox(CaplStringAdapter(m_pImage->GetLastError()));
		delete 	m_pImage;
		m_pImage = NULL;
		return FALSE;
	}
	return TRUE;
}

void CaplImageGuiEx::Clear()
{
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;
}


bool CaplImageGuiEx::HasImage()
{
	return m_pImage!=NULL;
}

bool CaplImageGuiEx::CreateFromBitmap(HBITMAP hBm)
{
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;

	m_pImage = new CxImage();
	if(m_pImage==0) return false;
	m_pImage->CreateFromHBITMAP(hBm);
	if (m_pImage->GetWidth() <= 0 || m_pImage->GetHeight() <= 0)
	{
		AfxMessageBox(CaplStringAdapter(m_pImage->GetLastError()));
		delete 	m_pImage;
		m_pImage = NULL;
		return false;
	}
	return true;
}

bool CaplImageGuiEx::SetImage(CaplImageGuiEx* pImage)
{
	if(pImage==NULL) return false;
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;
	
	m_pImage = new CxImage(*pImage->m_pImage);
	if(m_pImage==0) return false;

	return true;
}

bool CaplImageGuiEx::SetImage(CxImage* pImage)
{
	if(pImage==NULL) return false;
	if(m_pImage)
		delete m_pImage;
	m_pImage = NULL;
	
	m_pImage = new CxImage(*pImage);
	if(m_pImage==0) return false;

	return true;
}

long CaplImageGuiEx::GetNumFrames()
{
	if(0==m_pImage) return -1;
	return m_pImage->GetNumFrames();

}

long CaplImageGuiEx::GetFrame()
{
	if(0==m_pImage) return -1;
	return m_pImage->GetFrame();
}

void CaplImageGuiEx::SetFrame(long nFrame)
{
	if(0==m_pImage) return;
	return m_pImage->SetFrame(nFrame);
}

bool CaplImageGuiEx::Decode(BYTE *pBuf, DWORD size, DWORD type)
{
	if(0==m_pImage) return false;
	return m_pImage->Decode(pBuf,size,type);
}
*/

