// aplStatic.cpp : implementation file
//

#include "stdafx.h"
#include "aplguiex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplStatic

CaplStaticImage::CaplStaticImage()
{
	m_bShowImage = false;
	m_Flags = APL_DI_FIT_TO_RECT_WSCALE;

}

CaplStaticImage::~CaplStaticImage()
{
}


BEGIN_MESSAGE_MAP(CaplStaticImage, CStatic)
	//{{AFX_MSG_MAP(CaplStaticImage)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplStatic message handlers

void CaplStaticImage::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CRect rect;
	GetClientRect(rect);

	if(m_Image.HasImage())
	{
		dc.FillSolidRect(rect, ::GetSysColor(COLOR_3DFACE));
		m_Image.Draw(rect, &dc, m_Flags);
		return;
	}

	HBITMAP hBm = GetBitmap();
	if(hBm==NULL)
	{
		dc.FillSolidRect(rect, ::GetSysColor(COLOR_3DFACE));
		return;
	}

	m_Image.CreateFromBitmap(hBm);
	m_Flags = APL_DI_FIT_TO_RECT;
	m_Image.Draw(rect, &dc, m_Flags);
	::DeleteObject(hBm);

}
/*
bool CaplStaticImage::SetImage(CxImage* pImage)
{
	if(pImage==NULL) return false;
	
	m_bShowImage = true;
	if(!m_Image.SetImage(pImage)) return false;
	Invalidate();

	return true;
}
*/
bool CaplStaticImage::SetImage(CaplImage* pImage)
{
	if(pImage==NULL) return false;

	m_bShowImage = true;
	if(!m_Image.SetImage(pImage)) return false;
	Invalidate();

	return true;
}

bool CaplStaticImage::LoadFromBuf(BYTE *pBuf, long iSzie, UINT flag)
{
	if(m_Image.LoadFromBuf(pBuf, iSzie, 0))
	{
		m_Flags = flag;
		m_bShowImage = true;
	}

	return true;
}

bool CaplStaticImage::LoadFromFile(LPCTSTR lpszFileName, UINT flag)
{
	if(m_Image.LoadImage(lpszFileName))
	{
		m_Flags = flag;
		m_bShowImage = true;
	}

	return true;
}


bool CaplStaticImage::HasImage()
{
	if(m_Image.HasImage())
		return true;
	else
	{
		if(GetBitmap()!=NULL)
			return true;
	}
	return false;
}

bool CaplStaticImage::GetDimensions(CSize &sizes)
{
	if(m_Image.HasImage())
	{
		m_Image.GetImageDimensions(sizes);
		return true;
	}
	else
	{
		HBITMAP hBm = GetBitmap();
		if(hBm==NULL)
			return false;
		
		CBitmap cbm;
		BITMAP bm;
		cbm.Attach(hBm);
		cbm.GetBitmap(&bm);
		cbm.Detach();

		sizes = CSize(bm.bmWidth, bm.bmHeight);
		return true;
	}
	return false;
}

void CaplStaticImage::Clear()
{
	m_Image.Clear();
}
