// AshMoImportDialog.cpp : implementation file
//

#include "stdafx.h"

//#define ENABLE_ASH_MO 

#ifdef ENABLE_ASH_MO

#include "resource.h"
#include "PSM.h"
#include "AshMoImportDialog.h"


void WriteAshMoDBLog(CaplAPI *m_api,LPCTSTR txt)
{
	if(0==m_api) return;
	if(!m_api->m_data.IsConnected()) return;
	m_api->m_data.NET_WriteLog(_T("ASH-MO.log"), txt, false);
}

//           (  )
CaplInstance *FindFolderByName(LPCTSTR name , CaplAPI *m_api )
{
	CaplAttrValue tst_value;
	aplExtent ext;
	tst_value.value.Set((LPTSTR)name);
	tst_value.attr=m_api->m_folder_mgr.a_folder_name;
	m_api->m_data.NET_FindInstancesWithAttrValues(m_api->m_folder_mgr.e_folder,1,&tst_value,ext,false);
	
	if(0==ext.GetSize()) return 0;
	CaplInstance *folder=ext[0];
	m_api->m_folder_mgr.LoadFolderInfo(folder);
	return folder;
}

CString FindSubstrInStrMap(CaplStrStrMap &strmap,LPCTSTR str)
{
	if(0==str) return _T("");
	if(_T('\0')==str[0]) return _T("");

	int i;
	for(i=0;i<strmap.GetSize();i++)
	{
		CaplStrStrMap::CaplStrStrMapItem *item=strmap.GetAt(i);
		if(item->str.Find(str)>=0) return item->val;
	}
	return _T("");
}


//*******************************************************************************************************

bool bFindSignFilesForPackage(LPCTSTR sPackageFullPath, CStringArray &saSignFiles)
{
	saSignFiles.RemoveAll();
	if(0==sPackageFullPath) return false;
	if(_T('\0')==sPackageFullPath[0]) return false;

	CStringArray sSignExtentions; 
	sSignExtentions.Add(_T("*.sign"));
	sSignExtentions.Add(_T("*.sig"));
	sSignExtentions.Add(_T("*.p7s"));

	CString sMask0, sPackagePath=sPackageFullPath;
	int i=sPackagePath.ReverseFind(_T('.'));

	if(i>0) sMask0=sPackagePath.Left(i);
	else sMask0=sPackagePath;

	CFileFind ff;

	for(i=0;i<sSignExtentions.GetSize();i++)
	{
	  BOOL bFind = ff.FindFile(sMask0+sSignExtentions[i]);
	  while(bFind)
	  {
		  bFind = ff.FindNextFile();
		  saSignFiles.Add(ff.GetFilePath());
	  }
	}
	return true;
}

//*******************************************************************************************************

bool str2strArry(CString &str, CStringArray &sa)
{
	sa.RemoveAll();
	if(str==_T("")) return true;

	CString sLine;
	int i=0,j=0;
	while(true)
	{
	  j=str.Find(_T('\n'),i);
	  if(j>0) sLine=str.Mid(i,j-i);
	  else sLine=str.Right(str.GetLength()-i);

	  sLine.TrimLeft(); sLine.TrimRight();
	  if(sLine!=_T("")) sa.Add(sLine);
	  if(j<0) break;

	  i=j+sizeof(_T('\n'));
	}
	return true;
};

//*******************************************************************************************************
//        
/* bool LoadEKPS(CaplAPI &m_api)
{
	//if(!m_api.m_data.IsConnected()){AfxMessageBox(_T("    !"),MB_ICONSTOP|MB_OK); return false;}

	CaplStringFile strFile;

	if(!strFile.Open(_T("C:\\_____ASH\\ekps.txt"),CFile::modeRead, aplANSI)) {AfxMessageBox(_T("  !"),MB_ICONSTOP|MB_OK); return false;}

	int i,j;
	CaplInstance *instLastClass=0;
	CaplInstance *instLastGroup=0;
	CString sLine,sType,sId,sName,sDescr;

	CaplInstance *instSystem=m_api.m_classifier_mgr.GetClassifierSystemById(_T(""));
	if(0!=instSystem){AfxMessageBox(_T("   !   !"),MB_ICONSTOP|MB_OK); return false;}

	instSystem=m_api.m_classifier_mgr.CreateClassifierSystem(0,_T(""),_T("   "));
	if(0==instSystem){AfxMessageBox(_T("  !"),MB_ICONSTOP|MB_OK); return false;}

	while(true)
	{
		if(!strFile.ReadString(sLine)) break;  //  
		sLine.TrimLeft(); sLine.TrimRight();

		if(sLine==_T("")) continue;

		bool isKlass=false;

		i=sLine.Find(_T(' '));
		if(i>0)
		{
			sType=sLine.Left(i);
			if(sType==_T("") || sType==_T(""))
			{
				isKlass=true;
				if(0!=instLastClass && sDescr!=_T("")) m_api.m_data.PutAttr(instLastClass,m_api.m_classifier_mgr.a_apl_classifier_level_descr,sDescr);
				sDescr=_T("");

				i++;
				while(sLine[i]==_T(' ')) i++;
				j=sLine.Find(_T(' '),i);
				sId=sLine.Mid(i,j-i);

				i=j+1;
				while(sLine[i]==_T(' ')) i++;

				sName=sLine.Right(sLine.GetLength()-i);

				//   
				CaplInstance *instParent=instLastGroup;
				if(sType==_T("")) instParent=0;

				instLastClass=m_api.m_classifier_mgr.CreateClassifierLevel(instSystem,instParent,sId,sName,_T(""),0,false);
				if(sType==_T("")) instLastGroup= instLastClass;
			}
		}
		if(!isKlass) 
		{
			if(sDescr!=_T("")) sDescr+=_T("\n");
			sDescr += sLine;
		}
	}
	if(0!=instLastClass && sDescr!=_T("")) m_api.m_data.PutAttr(instLastClass,m_api.m_classifier_mgr.a_apl_classifier_level_descr,sDescr);
	sDescr=_T("");

	m_api.SaveChanges();
	strFile.Close();

	AfxMessageBox(_T("!"));

	return true;
}*/




// CAshMoImportDialog dialog

IMPLEMENT_DYNAMIC(CAshMoImportDialog, CaplResizableDialog)

CAshMoImportDialog::CAshMoImportDialog(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CAshMoImportDialog::IDD, pParent)
{

	m_instEkpsSystem=0;
	m_bOnlyVerify=false;
}

CAshMoImportDialog::~CAshMoImportDialog()
{
}

void CAshMoImportDialog::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LOG, m_log_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_START, m_start_btn);
	DDX_Control(pDX, IDC_USE_DIG_SIGN, m_use_dig_sign);
}


BEGIN_MESSAGE_MAP(CAshMoImportDialog, CaplResizableDialog)

	ON_BN_CLICKED(IDC_START, &CAshMoImportDialog::OnBnClickedStart)
END_MESSAGE_MAP()


// CAshMoImportDialog message handlers

BOOL CAshMoImportDialog::OnInitDialog()
{
	CaplResizableDialog::OnInitDialog();

	// TODO:  Add extra initialization here
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_START,BOTTOM_LEFT);
	AddAnchor(IDC_USE_DIG_SIGN,BOTTOM_LEFT);
	AddAnchor(IDC_LOG,TOP_LEFT,BOTTOM_RIGHT);
	

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_start_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLAY));
	m_start_btn.SetFlat(FALSE);

	m_use_dig_sign.SetCheck(AfxGetApp()->GetProfileInt(_T("ASH_MO"),_T("USE_DIG_SIGN"), 1));

	if(m_bOnlyVerify)
	{
		SetWindowText(_T("  -      "));
		m_use_dig_sign.ShowWindow(SW_HIDE);
		m_start_btn.SetWindowText(_T(""));
		m_start_btn.SetIcon(GetAplTableIco(APL_TABLE_OPEN));
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CAshMoImportDialog::OnCancel()
{
	AfxGetApp()->WriteProfileInt(_T("ASH_MO"),_T("USE_DIG_SIGN"), m_use_dig_sign.GetCheck());
	CaplResizableDialog::OnCancel();
}



void CAshMoImportDialog::AddLog(LPCTSTR txt, int bShowMsg)
{
	if(0==txt) return;
	if(_T('\0')==txt[0]) return;
	m_log_ctrl.SetSel(-1,-1);
	m_log_ctrl.ReplaceSel(_T("\r\n"));
	m_log_ctrl.SetSel(-1,-1);
	CString buf=txt;
	buf.Replace(_T("\n"),_T("\r\n"));
	m_log_ctrl.ReplaceSel(buf);
	if(0==bShowMsg) return;
	AfxMessageBox(txt,bShowMsg);
}
//*******************************************************************************************
bool CAshMoImportDialog::Init()
{
	if(0==m_api) return false;
	if(!m_api->m_data.IsConnected()){AfxMessageBox(_T("    !"),MB_ICONSTOP|MB_OK); return false;}
	if(0==m_api->m_appr_mgr.GetCurrentPerson()){AfxMessageBox(_T("     !"),MB_ICONSTOP|MB_OK); return false;}

	CString sRarPath=_T("C:\\Program Files\\WinRAR\\winrar.exe");
	if(!CaplFile::IsFileExist(sRarPath))
	{
		sRarPath=_T("C:\\Program Files (x86)\\WinRAR\\winrar.exe");
		if(!CaplFile::IsFileExist(sRarPath)){AfxMessageBox(_T("WinRar  !  !"),MB_ICONSTOP|MB_OK); return false;}
	}
	m_sRarPath=sRarPath;

	m_api->m_classifier_mgr.LoadDictionary();
	m_instEkpsSystem=m_api->m_classifier_mgr.GetClassifierSystemById(_T(""));
	if(0==m_instEkpsSystem){AfxMessageBox(_T("    !  !"),MB_ICONSTOP|MB_OK); return false;}

	m_api->m_classifier_mgr.LoadClassifierInfo(m_instEkpsSystem);

	return true;
}
//*******************************************************************************************
void CAshMoImportDialog::OnBnClickedStart()
{
	AshMoImportPackage();
}
//*******************************************************************************************

bool CAshMoImportDialog::AshMoImportPackage()
{
	if(0==m_api) return false;
	if(m_sRarPath==_T(""))  return false;
	if(0==m_instEkpsSystem) return false;

	m_log_ctrl.SetWindowText(_T(""));

	CString sLog;
	m_sTempPath.GetEnvironmentVariable(_T("TEMP"));
	if(m_sTempPath[m_sTempPath.GetLength()]!=_T('\\')) m_sTempPath+=_T('\\');
	m_sTempPath+=_T("ASH_MO\\");
	CreateDirectory(m_sTempPath,NULL);

	CFileDialog f_dlg(TRUE,_T("*.rar"),0,OFN_HIDEREADONLY, APL_T("  (*.rar)|*.rar|  (*.*)|*.*|"),0);
	if(f_dlg.DoModal()!=IDOK) return false;
	CString sPackagePath=f_dlg.GetPathName();
	//CString sPackagePath=_T("C:\\_____ASH\\Package_000000_01.rar");

	sLog=_T("\n :")+sPackagePath;
	AddLog(sLog); 

		
	CString sPackageName,sPackageFile;	
	int i,j;
	i=sPackagePath.ReverseFind(_T('\\'));
	j=sPackagePath.ReverseFind(_T('.'));

	if(i>=0 && i<=i) sPackageName=sPackagePath.Mid(i+1,j-(i+1));
	if(sPackageName==_T("")){AddLog(_T("  !  !"),MB_ICONSTOP|MB_OK); return false;}

	i=sPackagePath.ReverseFind(_T('\\'));
	if(i>=0) sPackageFile= sPackagePath.Right(sPackagePath.GetLength()-(i+1));
	else sPackageFile= sPackagePath;


	CString sReqFileName=sPackageName+_T(".requisite");

	//sReqFileName="Package_000_01.requisite";

	CString sReqFilePath=m_sTempPath+sReqFileName;
	if(CaplFile::IsFileExist(sReqFilePath))
	{
		::SetFileAttributes(sReqFilePath, FILE_ATTRIBUTE_NORMAL);
		::DeleteFile(sReqFilePath);
		if(CaplFile::IsFileExist(sReqFilePath)){AddLog(_T("    !  !"),MB_ICONSTOP|MB_OK); return false;}
	}

	long res;
	CString sCmd;

	//    
	AddLog(_T("  ... "));

	ULONGLONG flen=0x80000000;
	CFile file;
	if(file.Open(sPackagePath,CFile::modeRead))
	{
		flen=file.GetLength();
		file.Close();
	}
	
	if(flen<(100*1024*1024))  //   100   , .. 
	{
		sCmd.Format(_T("\"%s\" t -r \"%s\""),m_sRarPath,sPackagePath);
		res=aplCreateProcess(0,sCmd,true);
		if(0!=res)
		{
			AddLog(_T("  !"),MB_ICONSTOP|MB_OK);
			GenerateUveoml(false,sPackageFile, _T(""), _T(""), _T(""),_T("  !"));
			return false;
		}
	}

	AddLog(_T("  .\n"));

	//    

	AddLog(_T("  ... "));

	sCmd.Format(_T("\"%s\" e \"%s\" \"%s\" \"%s\""),m_sRarPath,sPackagePath,sReqFileName, m_sTempPath);

	res=aplCreateProcess(0,sCmd,true);

	if(0!=res)
	{
		AddLog(_T("      !"),MB_ICONSTOP|MB_OK); 
		GenerateUveoml(false,sPackageFile, _T(""), _T(""), _T(""),_T("      !"));
		return false;
	}
	if(!CaplFile::IsFileExist(sReqFilePath))
	{
		AddLog(_T("    !"),MB_ICONSTOP|MB_OK); 
		GenerateUveoml(false,sPackageFile, _T(""), _T(""), _T(""),_T("     !"));
		return false;
	}


	AddLog(_T("  .\n"));

	CaplStrStrMap mapRequsite;
	if(!CaplDocManager::LoadRequisiteFromFile(sReqFilePath,mapRequsite))
	{
		AddLog(_T("   !"),MB_OK|MB_ICONSTOP);
		GenerateUveoml(false,sPackageFile, _T(""), _T(""), _T(""),_T("  ."));
		return false;
	}
	::SetFileAttributes(sReqFilePath, FILE_ATTRIBUTE_NORMAL);
	::DeleteFile(sReqFilePath);

	AddLog(_T("   \n"));


	//   

	CString buf, sErrLog;
	CString sId, sName, sVer, sDescr, sType, sLitera, sFormat, sOrg, sEKPS, sShifr;

	sId=mapRequsite.Get(_T(""));
	if(sId==_T("")) {if(sErrLog!=_T("")) sErrLog+=_T("\n"); sErrLog+=_T("  \"\".");}

	sName=mapRequsite.Get(_T(""));
	if(sName==_T("")) {if(sErrLog!=_T("")) sErrLog+=_T("\n"); sErrLog+=_T("  \"\".");}

	sDescr=mapRequsite.Get(_T(""));

	sType=mapRequsite.Get(_T(""));
	if(sType==_T("")) sType=_T(" ");
	
	sVer=mapRequsite.Get(_T(""));
	if(sVer==_T("")) {if(sErrLog!=_T("")) sErrLog+=_T("\n"); sErrLog+=_T("  \"\".");}

	sLitera=mapRequsite.Get(_T(""));
	sFormat=mapRequsite.Get(_T(""));

	
	sOrg=mapRequsite.Get(_T(" -"));
	if(sOrg==_T(""))
	{
		sOrg=mapRequsite.Get(_T("-"));
		if(sOrg==_T("")) {if(sErrLog!=_T("")) sErrLog+=_T("\n"); sErrLog+=_T("  \" -\".");}
	}
	
	sEKPS=mapRequsite.Get(_T("   "));
	if(sEKPS==_T(""))
	{
		sEKPS=FindSubstrInStrMap(mapRequsite,_T(""));
		if(sEKPS==_T(""))
		{
			if(sErrLog!=_T("")) sErrLog+=_T("\n"); 
			sErrLog+=_T("  \"   \".");
		}
	}

	sShifr=mapRequsite.Get(_T(" "));

	if(sErrLog!=_T(""))
	{
		buf=_T("     !  !");
		buf+=_T("\n\n");
		buf+=sErrLog;
		AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
		buf.Replace(_T("\n"),_T("\r\n"));
		AddLog(buf);

		buf=_T("     :\n");
		buf+=sErrLog;
		GenerateUveoml(false,sPackageFile, sOrg,sId,sVer,buf);
		return false;
	}

	if(m_bOnlyVerify)
	{
		AfxMessageBox(_T("     !"),MB_OK);
		return true;

	}

	CaplInstance *instZavod=0, *instEkpsFolder=0;

	instZavod=FindFolderByName(sOrg,m_api);

	if(0==instZavod)
	{
		buf .Format(APL_T(" \"%s\"   .  ?"),sOrg);
			if(IDYES!=AfxMessageBox(buf,MB_ICONQUESTION|MB_YESNO)) {AfxMessageBox(_T(" !"),MB_OK); return false;}

		instZavod=m_api->m_folder_mgr.CreateFolder(0,sOrg,_T(""));
	}

	/*instEkpsFolder=m_api->m_folder_mgr.FindFolderByName(sEKPS);
	if(0==instEkpsFolder)
	{
		buf .Format(APL_T("  \"%s\"   .  ?"),sEKPS);
		if(IDYES!=AfxMessageBox(buf,MB_ICONQUESTION|MB_YESNO)) {AfxMessageBox(_T(" !"),MB_OK); return false;}

		instEKPS=m_api->m_folder_mgr.CreateFolder(0,instEkpsFolder,_T(""));
	}*/
	
	CaplInstance *instEkpsLevel=m_api->m_classifier_mgr.GetClassifierLevelById(sEKPS,m_instEkpsSystem);
	if(0==instEkpsLevel) 
	{
		AfxMessageBox(_T("       .\n  .\n !"),MB_OK);
		GenerateUveoml(false,sPackageFile, sOrg,sId,sVer,_T("   ."));
		return false;
	}
	m_api->m_classifier_mgr.LoadClassifierInfo(instEkpsLevel);

	//   
	CaplInstance *instDocType=m_api->m_doc_mgr.GetDocumentTypeBN(sType);
	if(0==instDocType) 
	{
		instDocType=m_api->m_data.CreateInstance(m_api->m_doc_mgr.e_dt);
		m_api->m_data.PutAttr(instDocType,m_api->m_doc_mgr.a_dt_pdt,sType);
	}

	CaplInstance *instDoc=m_api->m_doc_mgr.FindDocById(sId);
	CaplInstance *instDocVer=0;
	bool bMakeActive=false;

	if(0==instDoc)
	{
		//   
		instDoc=m_api->m_doc_mgr.CreateDocument(sId, sName, sDescr,instDocType,sPackagePath);
		if(0==instDoc) {AddLog(_T("   !"),MB_OK); return false;}

		m_api->m_data.GetAttr(instDoc,m_api->m_doc_mgr.a_apl_doc_active,instDocVer);
	}
	else
	{
		m_api->m_doc_mgr.LoadDocInfo(instDoc);
		//    
		aplExtent ext_rev;
		m_api->m_doc_mgr.LoadAllDocumentRevision(instDoc,ext_rev);
		int i;
		for(i=0;i<ext_rev.GetSize();i++)
		{
			CaplInstance *InstOldRev=ext_rev[i];
			m_api->m_data.GetAttr(InstOldRev,m_api->m_doc_mgr.a_apl_doc_rev_id,buf);
			if(buf==sVer)
			{
				int cur_crc32=0, old_crc32=0;
				cur_crc32=GetFileCRC32(sPackagePath);
				m_api->m_data.GetAttr(InstOldRev,m_api->m_doc_mgr.a_apl_doc_rev_crc,old_crc32);

				if(cur_crc32==old_crc32){AddLog(_T("       !\n\n(      .)"),MB_OK|MB_ICONINFORMATION); return false;}
				else  
				{
					AddLog(_T("         ,    !\n\n   .\n\n !"),MB_OK|MB_ICONSTOP);
					GenerateUveoml(false,sPackageFile, sOrg,sId,sVer,_T("         ,    ."));
					return false;
				}

				return false;
			}
		}

		//    - .
		
		instDocVer=m_api->m_doc_mgr.CreateDocumentRevision(instDoc,sPackagePath);
		bMakeActive=true;
	}

	if(0!=instDocVer)
	{
		m_api->m_doc_mgr.SaveRequisiteToRevision(instDocVer,mapRequsite,true);
		//if(sVer!=_T("")) m_api->m_data.PutAttr(instDocVer,m_api->m_doc_mgr.a_apl_doc_rev_id,sVer);
		//if(sLitera!=_T("")) m_api->m_data.PutAttr(instDocVer,m_api->m_doc_mgr.a_apl_doc_rev_litera,sLitera);
		//if(sFormat!=_T("")) m_api->m_data.PutAttr(instDocVer,m_api->m_doc_mgr.a_apl_doc_rev_format,sFormat);
	}

	if(bMakeActive) m_api->m_doc_mgr.CreateChange(instDocVer,true,false);

	m_api->m_folder_mgr.AddToFolder(instZavod,instDoc);
	if(0!=instEkpsFolder) m_api->m_folder_mgr.AddToFolder(instEkpsFolder,instDoc);

	if(0!=instEkpsLevel) m_api->m_classifier_mgr.CreateClassifierAssociation(instDoc,instEkpsLevel);

	if(sShifr!=_T(""))
	{
		CaplInstance *prd=0, *pdf=0;
		prd=m_api->m_prd_mgr.FindPrdById(sShifr);
		if(0!=prd) pdf=m_api->m_prd_mgr.FindPdfById(prd,_T(""));

		if(0!=pdf) m_api->m_prd_mgr.LoadPrdInfo(pdf);
		else if(0!=prd) m_api->m_prd_mgr.LoadPrdInfo(prd);

		if(0==pdf)
		{
			if(0!=prd) pdf=m_api->m_prd_mgr.CreatePdf(prd,_T(""),false);
			else pdf=m_api->m_prd_mgr.CreatePdf(sShifr,_T(""),_T(""),false);

			m_api->m_data.PutAttr(pdf,m_api->m_prd_mgr.a_apl_pdf_type,_T("assembly"));
		}
		
		m_api->m_folder_mgr.AddToFolder(instZavod,pdf);

		m_api->m_doc_mgr.CreateAssociation(pdf,instDoc);
	}

	//   
	CStringArray saSignFiles;
	bFindSignFilesForPackage(sPackagePath,saSignFiles);
	for(i=0;i<saSignFiles.GetSize();i++)
	{
		CaplInstance *instFile=m_api->m_doc_mgr.CreateFile(saSignFiles[i],true);
		if(0==instFile) continue;
		
		CaplInstance * ass=m_api->m_doc_mgr.CreateAssociation(instDocVer,instFile);
		ass=0;
	}

	//AddLog(_T(" .\r\n"));
	//if(IDYES!=AfxMessageBox(APL_T(" .  ?"),MB_ICONQUESTION|MB_YESNO)) return true;

	AddLog(_T("  ...\n"));

	CaplInstance *instStatus=m_api->m_appr_mgr.FindApprovalStatusBN(_T("  "));
	if(0==instStatus)instStatus=m_api->m_appr_mgr.CreateApprovalStatus(_T("  "));

	LPSTR sCruptSytem=0;
	if(m_use_dig_sign.GetCheck()) sCruptSytem=APL_CRYPTO_PRO_34_10_2012;

	CaplInstance *instSign=m_api->m_appr_mgr.CreateApproval(instDocVer,instStatus,0,0,0,_T(" "),0,sCruptSytem,0,0,0,0,0,false,false);

	if(0==instSign)  AddLog(_T("   !"),MB_ICONSTOP|MB_OK);
	else AddLog(_T("  !"));

	CString sDbLog,sUserName=_T("");
	CaplInstance *curuser=m_api->m_appr_mgr.GetCurrentPerson();
	if(0!=curuser) m_api->m_appr_mgr.GetPersonName(curuser,sUserName,false);
	
	buf.Format(_T("\n %s      \"%s\""),sUserName,sPackagePath);
	 sDbLog+=buf;
	sDbLog+=_T("\n :"); 
	buf.Format(_T("\n: %s"),sId);  sDbLog+=buf;
	buf.Format(_T("\n: %s"),sName); sDbLog+=buf;
	buf.Format(_T("\n: %s"),sVer); sDbLog+=buf;
	buf.Format(_T("\n: %s"),sOrg); sDbLog+=buf;
	buf.Format(_T("\n: %s"),sEKPS);sDbLog+=buf;

	AddLog(sDbLog);
	WriteAshMoDBLog(m_api,sDbLog);

	//AfxMessageBox(_T(" !"));
	//if(IDYES!=AfxMessageBox(_T(" !  ?"),MB_YESNO|MB_ICONQUESTION)) return true;

	GenerateUveoml(true,sPackageFile, sOrg,sId,sVer,_T(""));
	return true;
}

//***************************************************************************************

//***********************************************************************************

bool CAshMoImportDialog::AshMoVerifyPackage()
{

	CString sCpTestPath=_T("C:\\Program Files\\Crypto Pro\\CSP\\csptest.exe");
	if(!CaplFile::IsFileExist(sCpTestPath))
	{
		sCpTestPath=_T("C:\\Program Files (x86)\\Crypto Pro\\CSP\\csptest.exe");
		if(!CaplFile::IsFileExist(sCpTestPath)){AfxMessageBox(_T("csptest.exe  !  !"),MB_ICONSTOP|MB_OK); return false;}
	}

	/*CString sTempPath; sTempPath.GetEnvironmentVariable(_T("TEMP"));
	if(sTempPath[sTempPath.GetLength()]!=_T('\\')) sTempPath+=_T('\\');
	sTempPath+=_T("ASH_MO\\");
	CreateDirectory(sTempPath,NULL);*/

	int i,j;
	CString buf,sPackagePath;
	
	//sPackagePath=_T("C:\\____sign\\3\\111.txt");
	//sPackagePath=_T("C:\\_____ASH\\0\\Package_000000_01.rar");
	CFileDialog f_dlg(TRUE,_T("*.rar"),0,OFN_HIDEREADONLY, APL_T("  (*.rar)|*.rar|  (*.*)|*.*|"),0);
	if(f_dlg.DoModal()!=IDOK) return false;
	sPackagePath=f_dlg.GetPathName();
		
	/*
	CString sPackageName;
	i=sPackagePath.ReverseFind(_T('\\'));
	j=sPackagePath.ReverseFind(_T('.'));

	if(i>=0 && i<=i) sPackageName=sPackagePath.Mid(i+1,j-(i+1));
	if(sPackageName==_T("")){AfxMessageBox(_T("  !  !"),MB_ICONSTOP|MB_OK); return false;}*/


	//   

	CStringArray saSignFiles;
	bFindSignFilesForPackage(sPackagePath,saSignFiles);
	
	buf.Format(_T(" %i  ."),saSignFiles.GetCount());
	AfxMessageBox(buf);

	int res;
	CString sCmd, sOutBuf, sSignFile,sTempFile;


	//   

	for(i=0;i<saSignFiles.GetCount();i++)
	{
		CString sSignFile=saSignFiles[i];
		//     
		sCmd.Format(_T("\"%s\" -certlic -check -certfile \"%s\""),sCpTestPath,sSignFile);
		res=aplCreateProcessEx(0, sCmd, true, true, &sOutBuf);
		if(0!=res)
		{
			buf.Format(_T("     '%s'!\n     ."),sSignFile);
			AfxMessageBox(buf,MB_ICONSTOP|MB_OK);
			continue;
		}

		CStringArray sa;
		CString sLine, sWord,sVal, sSubject, sIssuer, sCertDate;
		str2strArry(sOutBuf,sa);

		for(j=0;j<sa.GetCount();j++)
		{
			sLine=sa[j];
			int k=sLine.Find(_T(':'),0);
			if(k<0) continue;
			sWord=sLine.Left(k);
			sWord.MakeLower(); sWord.TrimRight(); sWord.TrimLeft();
			sVal=sLine.Right(sLine.GetLength()-(k+1)); 
			sVal.TrimLeft(); sWord.TrimRight();
			if(sWord==_T("subject"))  sSubject=sVal;
			else if(sWord==_T("valid"))  sCertDate=sVal;
			else if(sWord==_T("issuer"))  sIssuer=sVal;
		}

		//   

		sCmd.Format(_T("\"%s\" -sfsign -verify -detached -in \"%s\" -signature \"%s\""), sCpTestPath, sPackagePath, sSignFile);
		sOutBuf;
		res=aplCreateProcessEx(0, sCmd, true, true, &sOutBuf);

		if(0==res)
		{
			//  
		}
		else if(0x80091007==res)
		{
			buf.Format(_T("     \n\n'%s' !\n\n  (       )."),sSignFile);
			AfxMessageBox(buf,MB_ICONSTOP|MB_OK); 
			continue;
		}
		else if(0x8009310b==res)
		{
			buf.Format(_T("     \n\n'%s' !\n\n    ASN1."),sSignFile);
			AfxMessageBox(buf,MB_ICONSTOP|MB_OK); 
			continue;
		}
		else if(0!=res)
		{
			buf.Format(_T("      '%s' !"),sSignFile);
			AfxMessageBox(buf,MB_ICONSTOP|MB_OK); return false;
			continue;
		}

		sLine=_T("");

	}
	return true;
}

//**********************************************************************************************
bool  CAshMoImportDialog::GenerateUveoml(bool bResult, CString sFileName, CString sRecipient, CString sPackageId, CString sPackageVer, CString sErrors)
{
	//if(IDYES!=AfxMessageBox(_T("  ?"),MB_YESNO|MB_ICONQUESTION)) return false;


	CString buf, sHtml;
	sHtml+=_T("<HTML>\n<HEAD>\n<META HTTP-EQUIV=\"Content-Type\" content=\"text/html; charset=windows-1251\">\n<TITLE>%title%</TITLE>\n</HEAD>\n");
	sHtml+=_T("<BODY>\n<font name = \"Arial\" size = 12>\n");
	sHtml+=_T("<p align=\"right\">%recip%</p><br/>\n");
	sHtml+=_T("<p align=\"center\"><b>%title%<br/>%type%</b></p><br/>\n");
	sHtml+=_T("<p align=\"left\">%text%</p><br/><br/>\n");
	sHtml+=_T("<p align=\"right\"> _____________ %operator%<br/>%date%</p><br/>");
	sHtml+=_T("\n</BODY>\n</HTML>");


	if(bResult)
	{
		if(IDYES!=AfxMessageBox(_T("  !  ?"),MB_YESNO|MB_ICONQUESTION)) return true;
	}
	else
	{
		if(IDYES!=AfxMessageBox(_T("    !\n\n ?"),MB_YESNO|MB_ICONSTOP)) return true;
	}
	
	sHtml.Replace(_T("%recip%"),sRecipient);

	int nNumber = m_api->m_options_mgr.GetCounterWithIncrementBN(_T("   "));

	buf.Format(_T("  %i"),nNumber);
	sHtml.Replace(_T("%title%"),buf);

	buf.Format(_T("uvedomlenie_%i.htm"),nNumber);
	CString sUvedFileName=m_sTempPath+buf;

	if(bResult)
	{
		sHtml.Replace(_T("%type%"),_T("    "));
		buf.Format(_T(" \"%s\"  \"%s\"     \n   \"%s\"."),sPackageId,sPackageVer,sFileName);
		sHtml.Replace(_T("%text%"),buf);
	}
	else
	{
		sHtml.Replace(_T("%type%"),_T("     "));

		CString sText=_T("   ");
		if(sPackageId!=_T(""))
		{
			sText+=_T('\"')+ sPackageId + _T("\" ");
			if(sPackageVer!=_T(""))sText+=_T(" \"")+ sPackageVer + _T("\" ");
		}
		if(sFileName!=_T("")) sText+=_T("  \"")+ sFileName + _T("\" ");

		if(sErrors==_T("")) sText+=_T(" .");
		else
		{
			sText+=_T("  :<br/>");
			sErrors.Replace(_T("\n"),_T("<br/>"));
			sText+=sErrors;
		}
		//sText+=_T("br");
		//sText+=_T("  \n");

		sHtml.Replace(_T("%text%"),sText);
	}


	buf=_T("");
	CaplInstance *curuser=m_api->m_appr_mgr.GetCurrentPerson();
	if(0!=curuser) m_api->m_appr_mgr.GetPersonName(curuser,buf,true);

	sHtml.Replace(_T("%operator%"),buf);

	COleDateTime odt=COleDateTime::GetCurrentTime(); 
	buf=odt.Format(_T("%d.%m.%Y  %H:%M"));
	sHtml.Replace(_T("%date%"),buf);
	
	//aplShowBigMsg(sHtml);

	if(CaplFile::IsFileExist(sUvedFileName))
	{
		::SetFileAttributes(sUvedFileName, FILE_ATTRIBUTE_NORMAL);
		::DeleteFile(sUvedFileName);
	}

	CStdioFile  fUvedFile;
	if(!fUvedFile.Open(sUvedFileName,CaplFile::modeCreate|CaplFile::modeWrite))
	{
		if(IDYES!=AfxMessageBox(_T("   !"),MB_OK|MB_ICONSTOP)) return false;
	}
	
	fUvedFile.WriteString(sHtml);
	fUvedFile.Flush();
	fUvedFile.Close();

	ShellExecute(0,_T("open"),sUvedFileName,NULL,NULL,SW_SHOW);

	return true;
}



#endif