// CharactListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "CharactListView.h"
#include "aplDocTreeItem.h"
#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "aplTopLevelItem.h"
#include "aplTreeCharacteristicItem.h"
//#include "aplCharacteristicGroupTreeItem.h"
#include "apl_lot_item.h"
#include "apl_prd_inst_item.h"
#include "aplBPTreeItem.h"
#include "aplBPInstTreeItem.h"
#include "act_res_treeitem.h"
#include "aplProjectTreeItem.h"
#include "aplDocCopyItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCharactListView

IMPLEMENT_DYNCREATE(CCharactListView, CaplListView)

CCharactListView::CCharactListView()
{
	SetUniqueName(_T("CCharactListView"));
}

CCharactListView::~CCharactListView()
{
}


BEGIN_MESSAGE_MAP(CCharactListView, CaplListView)
	//{{AFX_MSG_MAP(CCharactListView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCharactListView drawing

void CCharactListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CCharactListView diagnostics

#ifdef _DEBUG
void CCharactListView::AssertValid() const
{
	CListView::AssertValid();
}

void CCharactListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCharactListView message handlers
int CCharactListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
	m_ImageList.Create(aplGetInstImageList());
	LIST.SetImageList(&m_ImageList,LVSIL_SMALL);

    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T(""),LVCFMT_LEFT,200);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,100);
	LIST.InsertColumn(3, APL_T(""),LVCFMT_LEFT,100);
	LoadColumnWidths();
	return 0;
}

void CCharactListView::UpdateTreeItem(CaplTreeItem *item)
{
	//if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	
	aplExtent ext_rel,ext0,extGroup;
	int i,j;

	
	CaplInstance *val=0; 
	if(item->m_type==APL_TREE_ITEM_PRODUCT)
	{
		ext0.Add(((CaplProductTreeItem*)item)->m_pdf);
		ext0.Add(((CaplProductTreeItem*)item)->m_prd);
	}
	else if(item->m_type==APL_TREE_ITEM_LOT)
		ext0.Add(((CaplLotTreeItem*)item)->m_lot);
	else if(item->m_type==APL_TREE_ITEM_PRDINST)
		ext0.Add(((CaplPrdInstTreeItem*)item)->m_inst);
	else if(item->m_type==APL_TREE_ITEM_CHARACTERISTIC)
		ext0.Add(((CaplCharacteristicTreeItem*)item)->m_val);
	else if(item->m_type==APL_TREE_ITEM_CATEGORIES)	
		ext0.Add(((CaplCategoryTreeItem*)item)->m_inst);
	else if(item->m_type==APL_TREE_ITEM_BP)
	{
		CaplInstance *rev=((CaplBPTreeItem*)item)->m_rev;
		if(rev==0) 
		{
			CaplInstance *inst=((CaplBPTreeItem*)item)->m_inst;
			CaplInstance *lock=item->m_doc->m_api.m_bp_mgr.CheckMyLock(inst,false);
			if(lock) ext0.Add(lock);
			else ext0.Add(inst);
		}
		else ext0.Add(rev);
		
	}
	else if(item->m_type==APL_TREE_ITEM_BPINST)
		ext0.Add(((CaplBPInstTreeItem*)item)->m_inst);
	else if(item->m_type==APL_TREE_ITEM_PROJECT)
		ext0.Add(((CaplProjectTreeItem*)item)->m_inst);
	else if(item->m_type==APL_TREE_ITEM_BPRES)	
		ext0.Add(((CaplBPResourceTreeItem*)item)->m_inst);
	else if(item->m_type==APL_TREE_ITEM_DOCUMENT)
	{
		CaplInstance *rev=((CaplDocTreeItem*)item)->m_rev;
		if(rev==0) 
		{
			ext0.Add(((CaplDocTreeItem*)item)->m_inst);
			item->m_doc_data.GetAttr(
			((CaplDocTreeItem*)item)->m_inst,item->m_doc->m_api.m_doc_mgr.a_apl_doc_active,rev);
			if(rev!=0) ext0.Add(rev);
		}
		else ext0.Add(rev);
	}
	else if(item->m_type==_T("DocHardCopy"))
		ext0.Add(((CaplDocCopyTreeItem*)item)->m_inst);
	else
	{
		item->GetAccessedInstances(ext0);
		if(ext0.Size==0)
			return;
	}
	

	StartBusy();
	SetRedraw(FALSE);

	int bWithSystem= 0;
	item->m_doc->m_api.m_options_mgr.GetOptionValueBN( APL_NO_T("     "), bWithSystem, 0);

	for(i=0;i<ext0.Size;i++)
	{
		if(ext0[i]==0) continue;
		if(ext0[i]->GetType()==0) continue;
		
		item->m_doc->m_api.m_charact_mgr.FindAssociatedCharacteristic(ext0[i],ext_rel,extGroup, false, false, true, (bWithSystem!=0)?true:false);
		
		int ico=ICON_CHARACTERISTIC;
		if(item->m_doc_data.IsKindOf(ext0[i],item->m_doc->m_api.m_prd_mgr.e_prd)) ico=ICON_CHARACTERISTIC;
		else if(item->m_doc_data.IsKindOf(ext0[i],item->m_doc->m_api.m_prd_mgr.e_pdf)) ico=ICON_CHARACTERISTIC+1;
		else if(item->m_doc_data.IsKindOf(ext0[i],item->m_doc->m_api.m_prd_inst_mgr.e_lot)) ico=ICON_CHARACTERISTIC+3;
		else if(item->m_doc_data.IsKindOf(ext0[i],item->m_doc->m_api.m_prd_inst_mgr.e_prd_inst)) ico=ICON_CHARACTERISTIC+2;
		else if(item->m_doc_data.IsKindOf(ext0[i],item->m_doc->m_api.m_categ_mgr.e_categ)) ico=ICON_CHARACTERISTIC+4;

		for(j=0;j<ext_rel.Size;j++)
		{
			CaplInstance *inst0;
			val=ext_rel[j];

			CString type=_T("");
			if(ext_rel[j]->GetAccessmode()>aplRO) continue;
			CaplInstance *lock=0;
			if(item->m_doc_data.IsKindOf(ext_rel[j],item->m_doc->m_api.m_charact_mgr.e_apl_charact_value) && item->m_doc->m_api.m_charact_mgr.m_bUseVersions)
			{
				lock=item->m_doc->m_api.m_charact_mgr.CheckMyLock(val,false);
			}	
			if(lock)
				item->m_doc_data.GetAttrBN(lock,_T("assignment_type"),inst0);
			else
				item->m_doc_data.GetAttrBN(val,_T("assignment_type"),inst0);
			if(inst0!=0) item->m_doc_data.GetAttrBN(inst0,_T("name"),type);

			CaplInstance *inst,*m_unit;
			CString buf,buf1;
			item->m_doc_data.GetAttrBN(val,_T("characteristic"),inst);
			if(inst!=0)
			{
				item->m_doc->m_api.GetItemName(inst,buf);
//				item->m_doc_data.GetAttrBN(inst,S::name,buf);
			}
			int idx=LIST.InsertItem(0,LPCTSTR(buf),ico);
			LIST.SetItemData(idx,(long)val);
			

			LIST.SetItemText(idx,3,type);
			
			//  
			if(val==0) buf= APL_T(" ");
			else item->m_doc->m_api.m_charact_mgr.PrintCharacteristicValue(val,0,buf);
			LIST.SetItemText(idx,1,buf);

			item->m_doc_data.GetAttrBN(inst,_T("unit"),m_unit);
			item->m_doc->m_api.m_charact_mgr.GetUnitName(m_unit,buf);
			LIST.SetItemText(idx,2,buf);
		}
	}
	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	StopBusy();
	SetRedraw(TRUE);
}


void CCharactListView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	if(m_cur_item!=0)
	{
		int i=LIST.HitTest(point); 
		if(i!=-1)
		{
			CaplInstance *inst=(CaplInstance *)LIST.GetItemData(i);
			if(inst!=0)
			{
				CaplCharacteristicTreeItem *doc_item=new CaplCharacteristicTreeItem(0,m_cur_item->m_doc,inst);
				if(doc_item!=0) 
				{
					doc_item->ShowProperties();
					//     
					for(int i=0;i<m_cur_item->m_doc->m_items.GetSize();i++)
					{
						if(m_cur_item->m_doc->m_items[i]->m_type==APL_TREE_ITEM_CHARACTERISTIC)
						{
							CaplCharacteristicTreeItem *tree_char_item=(CaplCharacteristicTreeItem*)m_cur_item->m_doc->m_items[i];
							if(tree_char_item) if(tree_char_item->m_val==inst) tree_char_item->RefreshItem();
						}
					}

					m_cur_item->m_doc->m_items.Remove(m_cur_item->m_doc->m_items.Find(doc_item));
					UpdateTreeItem(m_cur_item);
				}
			}
		}
	}	
	CListView::OnLButtonDblClk(nFlags, point);
}


LRESULT CCharactListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}
