// TreeProductItem.h

#include "aplTreeItem.h"
class CaplSubstTreeItem;

class CaplProductTreeItem : public CaplTreeItem
{
        //Attributes
public:
//	CaplCategoryTreeItem *m_parent;
	CaplInstance *m_prd;
	CaplInstance *m_pdf;
	CaplInstance *m_nauo;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_alt;
	CaplInstance *m_project;
	CaplInstance *m_rule;
	CaplInstance *m_subst;// pdf    
	CString m_prd_item_type;
	CaplInstance* m_change;

	static bool m_ShowId;
	static bool m_ShowName;
	static bool m_ShowPosition;
	static bool m_ShowCount;
	static bool m_PrdNoShowPlusToPart;
	
protected:
	aplExtent m_all_sub_product;
	aplExtent m_all_parent;
	aplExtent m_all_parent_bps;
	aplExtent m_all_zagotov;
	aplExtent m_all_supplier;
	aplExtent m_all_alternate;
	aplExtent m_all_lots;
	aplExtent m_all_prd_inst;
	aplExtent m_all_category;
	aplExtent m_all_changes;
	aplExtent m_all_req;
	aplExtent m_all_eff;
	CArray<CaplSubstTreeItem*,CaplSubstTreeItem*> m_all_substitutes;//     	
    // Methods
public:
    CaplProductTreeItem(CTreeCtrl *tree=0, CPSMDoc *doc=0,
		CaplInstance *prd=0,CaplInstance *pdf=0);
	~CaplProductTreeItem(){RemoveFromParenContents(m_prd);RemoveFromParenContents(m_pdf);}
    bool GetName(CString &name);
    bool RefreshItem();
	bool RefreshAllThisPrdItem();
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
    bool CreateTreeItem(HTREEITEM parent_item);
    bool Expand(UINT action);
    
	bool ShowInListCtrl(CListCtrl *list);
	void ShowProperties();
	void LoadProperties();
	
	void CopyRelations(CaplInstance* from, CaplInstance* to, bool bAskBeforCopy= false);

	// 
	void CreateProductVersion();
	void CreateSubPart();
	void CreateProductCopy();
	void ReplaceToProductCopy();
	void CreateCharacteristic(CaplInstance *val=0);
	void CreateCharacteristicGroup(CaplInstance *group=0);
	void CreateBP(CaplInstance *inst_for_id);
	void CreateBPCopy(CaplInstance *base_bp);
	void CreateBPInstCopy(CaplInstance *base_bp_inst);
	void CreateBPInst();
	void CreateProject();
	
	// 
	void ShowCmd(long cmd);
	//void ShowToolBarButton(CToolBarCtrl *tb);
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);

	void ShowAllVersion(bool showMsg = true);
	void ShowAllSubProduct();
	void ShowRecurseFind();
	void ShowAllSubstitutes();
	void ShowAllParentProduct();
	void ShowAllUsesBP();
	void ShowAllSupplied();
	void ShowAllBPs(bool showMsg);
	void ShowAllBPInst(bool showMsg);
	void ShowAllAlternate();
	void ShowAllZagotov();
	void ShowAllLot();
	void ShowAllPrdInst();
	void ShowAllChanges(bool bFromExpand=false); //bFromExpand=true -   
	void ShowAllRequirement();
	void ShowRelationProperties(CaplInstance *rel=0); //  rel==0 - 
	
	virtual void GetAccessedInstances(aplExtent &ext);
	virtual void GetMainInstances(aplExtent &ext);
	
	void RemoveRelation();
	void RemoveProductVersion();
	void RemoveProduct();
	void RemoveFromCategory();

	bool PasteItem(CaplTreeItem *item, CPoint *point);
	bool PasteFile(LPCTSTR file, CPoint *point);
	
	bool RemoveDocument(CaplInstance * pDocument);

	// 
	void ExportStructureToTextFile();
	void ExportStructureToEF();
	void EportSpecific();

	void ShowBOM();
	void ShowExplosion();
	void FindInContents();

	//   
	bool CreateSubstitute(CaplProductTreeItem *pitem, LPCTSTR subst_name=0, LPCTSTR subst_descr=0);
	void InsertSubstItem(CaplInstance *subst);
	void RemoveSubst(bool delete_instance=false);	
};

