// aplPluginItem.h: interface for the CaplPluginItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLPLUGINITEM_H__4240AC4A_2719_4B61_8088_AEDB8B6AEB77__INCLUDED_)
#define AFX_APLPLUGINITEM_H__4240AC4A_2719_4B61_8088_AEDB8B6AEB77__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "apl_api.h"
#include "CommonClasses.h"

#define APL_LOAD_DATA 1
#define APL_LOAD_INFO 2

class CPSMDoc;
class CMainFrame;

typedef bool (*LPFUNCTION)(CaplAPI*, aplExtent&, bool);

class CaplPluginItem 
{
public:
	CaplPluginItem();
	virtual ~CaplPluginItem();

	void CreateDocbar(CaplViewInfo* viewInfo, HMODULE hMod);
	CString Create(LPCTSTR file_name);
	bool UpdateItem();
	void FreeItem();
	void WriteDataToFile(CaplStringFile &f);
	int ReadDataFromFile(CaplStringFile &f, CString &sPath, UINT flag = APL_LOAD_DATA, CString *err_log=0);
	bool InitMenuItems(long &iIndex, CArray <CaplAddInMenuItem, CaplAddInMenuItem>	& addin_menu_items);

	static CString m_sDisableItems;
	static void LoadFileContent(CaplTAggr <CaplPluginItem*, CaplPluginItem*, APLAGGR_AUTOKILLREF|APLAGGR_LIST> &arPLItems, CString* sErrorDscr);
	int ReadItem(CStringArray& arFileContent, int &iIndex, 	
		CaplTAggr <CaplPluginItem*, CaplPluginItem*, APLAGGR_AUTOKILLREF|APLAGGR_LIST> &arPLItems,
		CString *err_log= 0);
	void FillFunctions(CArray<CaplItemInfo*, CaplItemInfo*>&);
	bool CreateTabViews();
	bool CreateDocbars();

	static CWnd* m_parent;
	static CPSMDoc* m_doc;
	static CMainFrame* m_frame;

	static UINT m_msg;
	static UINT m_allMess[2]; //     PSS   

	CString m_sName;
	CString m_sDescr;
	CString m_sPath;

	HMODULE m_hModule;
	DWORD file_pos;
	int m_index;

	struct FunctionInfo
	{
		void* lpFunction;
		CString sFunction;
		CString sDescr;
		CString sType;
		DWORD flag;
		HICON ico;
		int iFunctionParamType;

		FunctionInfo(){lpFunction=0; flag=0; ico=0; iFunctionParamType=0;}
		~FunctionInfo(){if(0!=ico) DestroyIcon(ico);}

	};

	CaplTAggr <FunctionInfo*, FunctionInfo*, APLAGGR_AUTOKILLREF|APLAGGR_LIST> m_Functions;
	CaplAddinViews* m_global_views;
	CaplAddinViews* m_local_views;
	
	CString m_sFileContents;
	
	bool m_bShowWarningMessage;
	static CStringArray m_arForcedPlagins;
	static void CheckForcedPlagins(CString& sPath);
	static void InitForcedPlagins();
 	
	CaplPluginItem &operator=(CaplPluginItem &item);
	CaplPluginItem(const CaplPluginItem & item );
private:
	CString GetMenuPath(CString menu);
};

#endif // !defined(AFX_APLPLUGINITEM_H__4240AC4A_2719_4B61_8088_AEDB8B6AEB77__INCLUDED_)
