// aplProjectTreeItem.h: interface for the CaplProjectTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_APLPROJECTTREEITEM_H__A7FEA3B5_AE63_4301_A3F3_6958A1133DD2__INCLUDED_)
#define AFX_APLPROJECTTREEITEM_H__A7FEA3B5_AE63_4301_A3F3_6958A1133DD2__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "aplTreeItem.h"

class CaplProjectTreeItem : public CaplTreeItem  
{
public:
	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	CaplInstance *m_parent;
	CaplProjectTreeItem *m_parent_item;
	aplExtent m_all_items;
	int m_index;
	aplExtent m_sub_projects;
	CaplInstance *m_subitem;
	aplExtent m_parent_projects;
	bool m_is_in_content;

	CaplInstance *m_rev;
	CaplInstance *m_pLockInfo;
	CaplProjectTreeItem *m_parent_project_item;
	
	CaplInstance *m_alert;
	CaplInstance *m_rel;

	bool m_has_version;
	
	CaplProjectTreeItem(CTreeCtrl *tree, CPSMDoc *doc,CaplInstance *inst);
	virtual ~CaplProjectTreeItem();

    bool CreateTreeItem(HTREEITEM parent_item); 
	bool GetName(CString &name);
    bool RefreshItem();
	bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool Expand(UINT action);
	void ShowProperties();
	bool PasteItem(CaplTreeItem *item, CPoint *point);
	bool PasteFile(LPCTSTR file, CPoint *point);

	bool ShowInListCtrl(CListCtrl *list);
 	void GetAccessedInstances(aplExtent &ext);

	void CreateProject();
	void CreateDoc(CaplInstance *inst_for_id=0, LPCTSTR file_name=0);

	void ShowCmd(long cmd);
	void AddToParentContent();
	void RemoveFromParentContent();
	void RemoveRelation();
	void DeleteProject();
	void ShowWhereUsedProject();
	void ShowAccociatedItems(bool showMsg=true);
	void CheckOut();
	void CheckIn();
	void UndoCheckOut();
	void ShowAllVersion(bool showMsg = true);
	void InsertRevisionInTree(aplExtent &ext_rev,CaplProjectTreeItem *parent_project_item);
	void HideAllVersion();
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);

};

#endif // !defined(AFX_APLPROJECTTREEITEM_H__A7FEA3B5_AE63_4301_A3F3_6958A1133DD2__INCLUDED_)
