// aplPublicationTreeItem.cpp: implementation of the CaplPublicationTreeItem class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aplPublicationTreeItem.h"
#include "psmdoc.h"
#include "psm.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
CaplPublicationTreeItem::CaplPublicationTreeItem( CTreeCtrl *tree, CPSMDoc *pDoc, CaplInstance *inst/*=0*/ )
{
	m_doc = pDoc;
	m_tree = tree;
	m_type = APL_TREE_ITEM_PUBLICATION;
	m_inst = inst;
	m_used_inst_rel = NULL;
	if(m_doc)
		m_doc->m_items.Add(this);
}

CaplPublicationTreeItem::~CaplPublicationTreeItem()
{
	RemoveFromParenContents(m_inst);
}

bool CaplPublicationTreeItem::RefreshItem()
{
	if (!m_inst) return true;
	CString name;
	GetName(name);
	m_tree->SetItemText(m_item,name);
	return true;
}

bool CaplPublicationTreeItem::GetName( CString &name )
{
	_APL_TREE_ITEM_CHEK_PARAM_BOOL
	name =  APL_T("");
	if (m_inst == NULL) return true;
	name = _T("???");
	m_doc->m_api.GetItemName(m_inst, name);
	return true;	
}

bool CaplPublicationTreeItem::CreateTreeItem( HTREEITEM parent_item )
{
	if (m_tree== 0) return false;
    if (m_doc==0) return false;
	CString name;
	GetName(name);
	int ico = -1;
	if (m_inst)
		ico = m_doc->m_api.GetInstIco(m_inst);
	InsetItem(name, ico, parent_item);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_fictive_item = m_tree->InsertItem(_T("fictive"),-1,-1,m_item);
	m_expanded = false;
	return true;	
}

bool CaplPublicationTreeItem::Expand( UINT action )
{
	if(action==2)
	{
	}
	else if (action == 1)
	{
		CollapseItem();	
		m_publication.Clear();
		m_datamodule.Clear();
	}
	return true;
}

void CaplPublicationTreeItem::GetAccessedInstances( aplExtent &ext )
{
	ext.Clear();
	if(m_inst!=0){if(m_inst->GetType()!=0)ext.Add(m_inst);}	
}

bool CaplPublicationTreeItem::PasteItem( CaplTreeItem *item, CPoint *point/*=0*/ )
{
	if(!m_inst) return false;
	return true;
}

void CaplPublicationTreeItem::ShowProperties()
{
		
}

bool CaplPublicationTreeItem::ShowInListCtrl( CListCtrl *list )
{
	CHECK_SHOW_LIST_CTRL(m_inst);

	CString sCode, SName, access;

	//m_doc->m_api.m_data.GetAttr(m_inst, m_doc->m_tg_mgr.a_apl_publication_code, sCode);
	//m_doc->m_api.m_data.GetAttr(m_inst,m_doc->m_tg_mgr.a_apl_publication_name, SName);
	int ind = list->InsertItem(0, APL_T(":"));
	list->SetItemText(ind, 1, sCode);
	ind = list->InsertItem(list->GetItemCount(), APL_T(":"));
	list->SetItemText(ind, 1, SName);
	list->InsertItem(list->GetItemCount(), _T(""));
	ind = list->InsertItem(list->GetItemCount(),  APL_T(":"));
	GetAccessName(m_inst, access);
	list->SetItemText(ind, 1, access);

	aplExtent ext;
	CStringArray  comment;
	
	comment.Add(_T("m_inst"));
	ext.Add(m_inst);
	
	ShowInstanceInfoInListCtrl(ext,list,&comment);

	return true;
}

bool CaplPublicationTreeItem::TrackPopupMenu( CWnd *wnd, CPoint &point, UINT view_mode/*= APLICM_NORMALE*/ )
{
	if(m_inst==0) return false;
	return true;
}

BOOL CaplPublicationTreeItem::ShowToolBarButton( CCmdUI* pCmdUI )
{
	if(m_inst==0) return FALSE;
	if(m_inst->GetType()==0) return FALSE;
	return FALSE;
}

void CaplPublicationTreeItem::ShowCmd( long cmd )
{
	/*
	switch(cmd)
	{
		default: PrepareContextMenu(cmd);break;
	}
	*/
}