// aplQueryItem.h

#include "aplTreeItem.h"

class CaplQueryTreeItem : public CaplTreeItem
{
        //Attributes
public:
    CaplQueryTreeItem (CTreeCtrl *tree,CPSMDoc *doc,CaplInstance* inst=0,CaplInstance* folder=0,CString type=APL_TREE_ITEM_QUERY);
	~CaplQueryTreeItem(){RemoveFromParenContents(m_inst);}
    bool CreateTreeItem(HTREEITEM parent_item);

	static int query_count;

	HTREEITEM m_queries_item;
	aplExtent m_exec_result;
	
	//
	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CaplInstance *m_classifier;
	bool m_is_root;
	bool m_executed;
	COleDateTime m_exec_date;
	CString m_execute_state;
	
    // Methods
public:
    bool GetName(CString &name);
	void ShowProperties();
    bool TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode= APLICM_NORMALE);
	bool Expand(UINT action);
	void UpdateIcon();

    bool ShowInListCtrl(CListCtrl *list);
	void ShowCmd(long cmd);
	bool ShowContents(bool is_run=false);
	void SaveQuery();
	static bool MoveQuery(CPSMDoc* doc, CaplQueryTreeItem* q_item, CaplTreeItem* from_item, CaplTreeItem* to_item);
	void GetAccessedInstances(aplExtent &ext);

	//   true -     
	bool Run(bool is_dlg=true,CString mode=_T(""),CString predef_id=_T(""),bool old_style=false);
	//   true -     
	bool Create(CString mode=_T(""),bool old_style=false);

	bool LoadQueryResult();
	BOOL ShowToolBarButton(CCmdUI* pCmdUI);
	bool RefreshAllThisQueryItem(bool executed);

};
