// TableContentTitleSetupdlg.cpp : implementation file
//

#include "stdafx.h"
#include "TableContentTitleSetupdlg.h"
#include "PropertyDlg.h"
#include "Functions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTableContentTitleSetupdlg dialog


CTableContentTitleSetupdlg::CTableContentTitleSetupdlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CTableContentTitleSetupdlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTableContentTitleSetupdlg)
	m_dWidth = 0.0;
	m_dTextWidth = 0.0;
	m_iHeght = 0;
	m_sTitle = _T("");
	m_sFont = _T("");
	//}}AFX_DATA_INIT
	m_TCTitle = NULL;
	m_iEditString = -1;
}


void CTableContentTitleSetupdlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTableContentTitleSetupdlg)
	DDX_Control(pDX, IDC_LIST, m_ListCtrl);
	DDX_Control(pDX, IDC_DEL_LEVEL, m_DelLevel_btn);
	DDX_Control(pDX, IDC_ADD_LEVEL, m_AddLevel_btn);
	DDX_Text(pDX, IDC_TITLE, m_sTitle);
	DDX_Text(pDX, IDC_FONT, m_sFont);
	DDX_Text(pDX, IDC_WIDTH, m_dWidth);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTableContentTitleSetupdlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CTableContentTitleSetupdlg)
	ON_BN_CLICKED(IDC_ADD_LEVEL, OnAddLevel)
	ON_BN_CLICKED(IDC_DEL_LEVEL, OnDelLevel)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblclkList)
	ON_NOTIFY(NM_SETFOCUS, IDC_LIST, OnSetfocusList)
	ON_BN_CLICKED(IDC_SELECT_FONT, OnSelectFont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTableContentTitleSetupdlg message handlers

bool CTableContentTitleSetupdlg::BrowseFont(LOGFONT &lf)
{
	bool res = false;
	LOGFONT Old = lf;
	CDC* pDC = GetDC();
	lf.lfHeight = -MulDiv(-lf.lfHeight/10, GetDeviceCaps(pDC->m_hDC, LOGPIXELSY), 72);
	CFontDialog dlg(&lf);
	dlg.m_cf.Flags |=CF_INITTOLOGFONTSTRUCT|CF_LIMITSIZE;
	dlg.m_cf.nSizeMax = 1638;
	dlg.m_cf.nSizeMin = 1;

	if(dlg.DoModal()==IDOK)
	{
		res = true;
		lf = dlg.m_lf;
		lf.lfHeight = dlg.GetSize();
	}
	else
		lf = Old;
	ReleaseDC(pDC);
	return res;
}

BOOL CTableContentTitleSetupdlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	ASSERT(m_TCTitle);

	m_pTCTitle = new CTableContentTitle(m_TCTitle->m_ReportMgr);
	for(int i=0; i<m_TCTitle->m_TableContentTitle->m_Levels.GetSize(); i++)
	{
		CTableContentTitleLevel* level = new CTableContentTitleLevel(m_TCTitle->m_ReportMgr);
		level->m_Font = m_TCTitle->m_TableContentTitle->m_Levels[i]->m_Font;
		level->m_ParaDelta = m_TCTitle->m_TableContentTitle->m_Levels[i]->m_ParaDelta;
		m_pTCTitle->m_Levels.Add(level);
	}

	AddAnchor(IDC_ADD_LEVEL, TOP_RIGHT);
	AddAnchor(IDC_DEL_LEVEL, TOP_RIGHT);
	AddAnchor(IDC_LIST, TOP_LEFT, BOTTOM_RIGHT);

	m_AddLevel_btn.SetIcon(aplGetStdIco16(APL_STD_PLUS));
//	m_AddLevel_btn.SetFlat(FALSE);
	m_DelLevel_btn.SetIcon(aplGetStdIco16(APL_STD_DELETE));
//	m_DelLevel_btn.SetFlat(FALSE);

	m_EditText.Create(WS_BORDER|WS_CHILD|ES_AUTOHSCROLL, CRect(0,0,100,10), &m_ListCtrl, ID_EDIT_LC_VALUE_CTRL);
	m_EditText.SetFont(GetFont());

	m_ListCtrl.InsertColumn(0, _T(""), LVCFMT_LEFT, 60);
	m_ListCtrl.InsertColumn(1, APL_T(""), LVCFMT_LEFT, 60);
	m_ListCtrl.InsertColumn(2, APL_T(""), LVCFMT_LEFT, 120);
	m_ListCtrl.SetExtendedStyle(LVS_EX_FULLROWSELECT+LVS_EX_GRIDLINES);

	m_dWidth = m_TCTitle->m_PageWidth;
	m_sTitle = m_TCTitle->m_sTitle;
	m_Font = m_TCTitle->m_lfTitleFont;
	m_dTextWidth = m_TCTitle->m_TextWidth;
	m_iHeght = m_TCTitle->m_iHeight;

	m_sFont.Format(APL_T("%s (%d )"), m_Font.lfFaceName, m_Font.lfHeight/10);
	ShowData();
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTableContentTitleSetupdlg::ShowData()
{
	m_ListCtrl.DeleteAllItems();		
	if(m_pTCTitle==NULL) return;
	CString level, para, font, buf;;
	for(int i=0; i<m_pTCTitle->m_Levels.GetSize(); i++)
	{
		level.Format(APL_T(" %d"), i+1);
		para.Format(_T("%.1f"), m_pTCTitle->m_Levels[i]->m_ParaDelta);
		font.Format(APL_T("%s (%d )"), m_pTCTitle->m_Levels[i]->m_Font.lfFaceName, m_pTCTitle->m_Levels[i]->m_Font.lfHeight/10);
		m_ListCtrl.InsertItem(i, level);
		m_ListCtrl.SetItemText(i, 1, para);
		m_ListCtrl.SetItemText(i, 2, font);
		m_ListCtrl.SetItemData(i, DWORD(m_pTCTitle->m_Levels[i]));
	}
}

void CTableContentTitleSetupdlg::OnAddLevel() 
{
	m_pTCTitle->AddLevel();
	ShowData();
}

void CTableContentTitleSetupdlg::OnDelLevel() 
{
	int cur = m_ListCtrl.GetNextItem(-1, LVIS_SELECTED);
	m_pTCTitle->DelLevel(cur);
	ShowData();
}

void CTableContentTitleSetupdlg::OnDblclkList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LPNMLISTVIEW pLV = (LPNMLISTVIEW)pNMHDR;
	if(pLV->iItem>-1)
	{
		if(pLV->iSubItem==1)
		{
			m_iEditString = pLV->iItem;
			CRect rect;
			m_ListCtrl.GetSubItemRect(pLV->iItem,pLV->iSubItem, 0, rect);
			CString buf = m_ListCtrl.GetItemText(pLV->iItem,pLV->iSubItem);
			m_EditText.SetWindowText(buf);
			m_EditText.MoveWindow(rect, FALSE);
			m_EditText.ShowWindow(SW_SHOW);
			m_EditText.SetSel(0,-1);
			m_EditText.SetFocus();
		}
		else if(pLV->iSubItem==2)
		{
			CTableContentTitleLevel* level = (CTableContentTitleLevel*)m_ListCtrl.GetItemData(pLV->iItem);
			if(level)
			{
				if(BrowseFont(level->m_Font))
				{
					CString font;
					font.Format(APL_T("%s (%d )"), level->m_Font.lfFaceName, level->m_Font.lfHeight/10);
					m_ListCtrl.SetItemText(pLV->iItem, 2, font);
				}
			}
		}
	}
	
	*pResult = 0;
}

void CTableContentTitleSetupdlg::OnSetfocusList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	if(m_iEditString>-1)
	{
		CString buf;
		m_EditText.GetWindowText(buf);
		m_ListCtrl.SetItemText(m_iEditString, 1, buf);
		if(!IsRealOrEmpty(buf))
		{
			m_EditText.SetFocus();
			return;
		}
		CTableContentTitleLevel* level = (CTableContentTitleLevel*)m_ListCtrl.GetItemData(m_iEditString);
		ASSERT(level);
		level->m_ParaDelta = __atof(buf);
		m_EditText.ShowWindow(SW_HIDE);
		m_iEditString = -1;
	}
	*pResult = 0;
}

bool CTableContentTitleSetupdlg::UpdateDlg()
{
	if(!TestUpdate()) return false;
	m_TCTitle->Delete();
	m_TCTitle->m_inst = NULL;
	while(m_TCTitle->m_TableContentTitle->m_Levels.GetSize())
		m_TCTitle->m_TableContentTitle->DelLevel(0);
	while(m_pTCTitle->m_Levels.GetSize()>0)
	{
		CTableContentTitleLevel* level = m_pTCTitle->m_Levels[0];
		m_TCTitle->m_TableContentTitle->m_Levels.Add(level);
		m_pTCTitle->m_Levels.RemoveAt(0);
	}
	m_TCTitle->m_PageWidth = m_dWidth;
	m_TCTitle->m_sTitle = m_sTitle;
	m_TCTitle->m_lfTitleFont = m_Font;
	m_TCTitle->m_TextWidth = m_dTextWidth;
	m_TCTitle->m_iHeight = m_iHeght;
	return true;
}

BOOL CTableContentTitleSetupdlg::DestroyWindow() 
{
	if(m_pTCTitle)
		delete m_pTCTitle;
	
	return CaplResizableDialog::DestroyWindow();
}

void CTableContentTitleSetupdlg::OnSelectFont() 
{
	UpdateData();
	LOGFONT lf = m_Font;
	if(BrowseFont(lf))
	{
		m_Font = lf;
		m_sFont.Format(APL_T("%s (%d )"), m_Font.lfFaceName, m_Font.lfHeight/10);
		UpdateData(FALSE);
	}
}

void CTableContentTitleSetupdlg::OnOK()
{
	if(m_iEditString>-1)
	{
		CString buf;
		m_EditText.GetWindowText(buf);
		m_ListCtrl.SetItemText(m_iEditString, 1, buf);
		if(!IsRealOrEmpty(buf))
		{
			m_EditText.SetFocus();
			return;
		}
		CTableContentTitleLevel* level = (CTableContentTitleLevel*)m_ListCtrl.GetItemData(m_iEditString);
		ASSERT(level);
		level->m_ParaDelta = __atof(buf);
		m_EditText.ShowWindow(SW_HIDE);
		m_iEditString = -1;
		return;
	}
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnOK();
}

void CTableContentTitleSetupdlg::OnCancel()
{
	if(m_iEditString>-1)
	{
		m_iEditString = -1;
		m_EditText.ShowWindow(SW_HIDE);
		return;
	}
	CWnd* wnd = GetParent();
	ASSERT(wnd);
	wnd = wnd->GetParent();
	CPropertyDlg* dlg = (CPropertyDlg*)wnd;
	dlg->OnCancel();
}

bool CTableContentTitleSetupdlg::TestUpdate()
{
	if(!UpdateData()) return false;

	return true;
}
