// TemplateMasterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TemplateMasterDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTemplateMasterDlg dialog


CTemplateMasterDlg::CTemplateMasterDlg(CaplReportMgr *ReportMgr, CTemplateMaster *pTemplate, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CTemplateMasterDlg::IDD, pParent), m_SelectDatasourcePage(ReportMgr)
{
	ASSERT(pTemplate);
	ASSERT(ReportMgr);
	m_ReportMgr = ReportMgr;
	m_pTemplate = pTemplate;
	//{{AFX_DATA_INIT(CTemplateMasterDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pHeader = NULL;
	m_SetupSortPage.m_pTemplate = m_pTemplate;
	m_SetupColumnsPage.m_pTemplate = m_pTemplate;

	m_bEnableSelectPage = true;
}


void CTemplateMasterDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTemplateMasterDlg)
	DDX_Control(pDX, IDC_PREV, m_prev_btn);
	DDX_Control(pDX, IDC_NEXT, m_next_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTemplateMasterDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CTemplateMasterDlg)
	ON_BN_CLICKED(IDC_NEXT, OnNext)
	ON_BN_CLICKED(IDC_PREV, OnPrev)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTemplateMasterDlg message handlers

void CTemplateMasterDlg::OnOK() 
{
	if(!m_SetupVisibleColumnsPage.TestUpdate()) return;
	if(!m_SetupColumnsPage.TestUpdate()) return;

	m_SetupColumnsPage.FillData();
	
	CaplTranslateDialog::OnOK();
}

BOOL CTemplateMasterDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_ok_btn.SetIcon(aplGetStdIco16(APL_STD_OK));
	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.EnableWindow(FALSE);
	m_cancel_btn.SetIcon(aplGetStdIco16(APL_STD_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	
	CRect cl_rect, btn_rect, wnd_rect;
	m_ok_btn.GetWindowRect(btn_rect);
	GetClientRect(cl_rect);
	m_SelectDatasourcePage.Create(IDD_SELECT_DATASOURCE_PAGE, (CWnd*)this);
	m_SelectDatasourcePage.GetWindowRect(wnd_rect);

	cl_rect.OffsetRect(CPoint((cl_rect.Width()-wnd_rect.Width())/2, (cl_rect.Width()-wnd_rect.Width())/2));
	cl_rect.bottom-=btn_rect.Height()+15;
	
	if(m_bEnableSelectPage)
	{
		m_SelectDatasourcePage.MoveWindow(cl_rect);
		m_SelectDatasourcePage.ShowWindow(SW_SHOW);
	}
	else
	{
		m_SelectDatasourcePage.MoveWindow(cl_rect);
		m_SelectDatasourcePage.ShowWindow(SW_HIDE);
	}
	
	m_SetupVisibleColumnsPage.Create(IDD_SETUP_VISIBLE_COLUMNS_PAGE, (CWnd*)this);
	m_SetupVisibleColumnsPage.MoveWindow(cl_rect);
	m_SetupVisibleColumnsPage.ShowWindow(m_bEnableSelectPage?SW_HIDE:SW_SHOW);
	if(!m_bEnableSelectPage)
	{
		m_SetupVisibleColumnsPage.m_pHeader = m_pTemplate->m_pInitialHeader;
		m_SetupVisibleColumnsPage.UpdateLists();
	}

	m_SetupGroupsPage.Create(IDD_SETUP_GROUPS_PAGE, (CWnd*)this);
	m_SetupGroupsPage.MoveWindow(cl_rect);
	m_SetupGroupsPage.ShowWindow(SW_HIDE);
	
	m_SetupSortPage.Create(IDD_SETUP_SORT_PAGE, (CWnd*)this);
	m_SetupSortPage.MoveWindow(cl_rect);
	m_SetupSortPage.ShowWindow(SW_HIDE);

	m_SetupColumnsPage.Create(IDD_SETUP_COLUMNS_PAGE, (CWnd*)this);
	m_SetupColumnsPage.MoveWindow(cl_rect);
	m_SetupColumnsPage.ShowWindow(SW_HIDE);

	m_prev_btn.EnableWindow(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CTemplateMasterDlg::OnNext() 
{
	if(m_SelectDatasourcePage.IsWindowVisible())
	{
		if(!m_SelectDatasourcePage.TestUpdate()) return;
		if(m_pHeader)
			delete m_pHeader;
		m_pHeader = m_SelectDatasourcePage.GetHeader();
		m_SelectDatasourcePage.ShowWindow(SW_HIDE);
		m_SetupVisibleColumnsPage.m_pHeader = m_pHeader;
		m_SetupVisibleColumnsPage.UpdateLists();
		m_SetupVisibleColumnsPage.ShowWindow(SW_SHOW);
		m_prev_btn.EnableWindow(TRUE);
	} 
	else if(m_SetupVisibleColumnsPage.IsWindowVisible())
	{
		if(!m_SetupVisibleColumnsPage.TestUpdate()) return;
		m_SetupVisibleColumnsPage.GetVisibleHeader(m_pTemplate->m_pHeader);
		m_SetupVisibleColumnsPage.ShowWindow(SW_HIDE);
		m_SetupGroupsPage.m_pHeader = m_pTemplate->m_pHeader;
		m_SetupGroupsPage.UpdateLists();
		m_SetupGroupsPage.ShowWindow(SW_SHOW);
		m_prev_btn.EnableWindow(TRUE);
	}
	else if(m_SetupGroupsPage.IsWindowVisible())
	{
		m_SetupGroupsPage.GetGroups(&m_pTemplate->m_GroupsArray);
		m_SetupGroupsPage.ShowWindow(SW_HIDE);
		m_SetupSortPage.UpdateList();
		m_SetupSortPage.ShowWindow(SW_SHOW);
	}
	else if(m_SetupSortPage.IsWindowVisible())
	{
		m_SetupSortPage.GetSortList();
		m_SetupSortPage.ShowWindow(SW_HIDE);
		m_SetupColumnsPage.UpdateList();
		m_SetupColumnsPage.ShowWindow(SW_SHOW);

		m_next_btn.EnableWindow(FALSE);
	}
}

void CTemplateMasterDlg::OnPrev() 
{
	if(m_SetupVisibleColumnsPage.IsWindowVisible() && m_bEnableSelectPage)
	{
		m_SetupVisibleColumnsPage.ShowWindow(SW_HIDE);
		m_SelectDatasourcePage.ShowWindow(SW_SHOW);
		m_prev_btn.EnableWindow(FALSE);
	}
	else if(m_SetupGroupsPage.IsWindowVisible())
	{
		m_SetupGroupsPage.ShowWindow(SW_HIDE);
		m_SetupVisibleColumnsPage.ShowWindow(SW_SHOW);
		m_prev_btn.EnableWindow(m_bEnableSelectPage?TRUE:FALSE);
	}
	else if(m_SetupSortPage.IsWindowVisible())
	{
		m_SetupSortPage.ShowWindow(SW_HIDE);
		m_SetupGroupsPage.ShowWindow(SW_SHOW);
	}
	else if(m_SetupColumnsPage.IsWindowVisible())
	{
		m_SetupColumnsPage.ShowWindow(SW_HIDE);
		m_SetupSortPage.ShowWindow(SW_SHOW);
		
		m_next_btn.EnableWindow(TRUE);
		m_ok_btn.EnableWindow(FALSE);
	}
}

BOOL CTemplateMasterDlg::DestroyWindow() 
{
	if(m_pHeader)
		delete m_pHeader;
	m_SelectDatasourcePage.DestroyWindow();
	
	return CaplTranslateDialog::DestroyWindow();
}

void CTemplateMasterDlg::OnCancel() 
{
	if(m_pTemplate->m_GroupsArray.GetSize()==0)
		m_SetupGroupsPage.ResetData();
	
	CaplTranslateDialog::OnCancel();
}
