// SetupPrintDlg.cpp : implementation file
//

#include "stdafx.h"
#include "SetupPrintDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSetupPrintDlg dialog


CSetupPrintDlg::CSetupPrintDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CSetupPrintDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupPrintDlg)
	m_printer_name = _T("");
	m_hPages = 1;
	//}}AFX_DATA_INIT
}


void CSetupPrintDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupPrintDlg)
	DDX_Text(pDX, IDC_PRINT_NAME, m_printer_name);
	DDX_Text(pDX, IDC_PAGES, m_hPages);
	DDV_MinMaxInt(pDX, m_hPages, 1, 50);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSetupPrintDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CSetupPrintDlg)
	ON_BN_CLICKED(IDC_PRINT_SETUP, OnPrintSetup)
	ON_EN_CHANGE(IDC_PAGES, OnChangePages)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupPrintDlg message handlers

BOOL CSetupPrintDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	PRINTDLG pd;
	pd.hDevMode = NULL;
	pd.hDevNames = NULL;
	AfxGetApp()->GetPrinterDeviceDefaults(&pd);

	DEVMODE* pDM = (DEVMODE*)LocalLock(pd.hDevMode);
	m_printer_name = pDM->dmDeviceName;
	LocalUnlock(pd.hDevMode);

	UpdateData(FALSE);

	DrawPages();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupPrintDlg::OnPrintSetup() 
{
	UpdateData(TRUE);
	CPrintDialog PDlg(TRUE);
	PRINTDLG pd;
	pd.lStructSize = sizeof(PRINTDLG);
	pd.Flags = PD_PRINTSETUP;
	pd.hDevMode = NULL;
	pd.hDevNames = NULL;
	AfxGetApp()->GetPrinterDeviceDefaults(&pd);
	PDlg.m_pd.hDevMode = pd.hDevMode;
	if(PDlg.DoModal()==IDOK)
	{
//		DEVMODE* pDM = (DEVMODE*)LocalLock(pd.hDevMode);
//		*pDM = *(DEVMODE*)PDlg.GetDevMode();
//		LocalUnlock(pd.hDevMode);
	}
	UpdateData(FALSE);
	Invalidate();
}

void CSetupPrintDlg::OnOK() 
{
	if(!UpdateData()) return;
	
	CaplTranslateDialog::OnOK();
}

void CSetupPrintDlg::DrawPages()
{
	CDC dc;
	AfxGetApp()->CreatePrinterDC(dc);
	CDC *pDC = GetDC();
	CRect r;
	CWnd* wnd = GetDlgItem(IDC_STATIC_FRAME);
	ASSERT(wnd);
	wnd->GetWindowRect(r);
	ScreenToClient(r);
	r.DeflateRect(5,5);
	int PageCX, PageCY;
	PageCX = dc.GetDeviceCaps(HORZSIZE);
	PageCY = dc.GetDeviceCaps(VERTSIZE);
	int spaces = 5*(m_hPages-1);
	int cx = r.Width() - spaces;
	int mpcx = int(double(cx)/double(m_hPages));
	int mpcy = int(double(mpcx)/double(PageCX)*PageCY);
	CPen pen;
	pen.CreatePen(PS_SOLID,1,RGB(0,0,0));
	CPen* old = pDC->SelectObject(&pen);
	if(mpcy>r.Height())
	{
		mpcy = r.Height();
		mpcx = int(double(mpcy)/double(PageCY)*PageCX);
	}
	int x = r.left + (r.Width() - m_hPages*mpcx - spaces)/2;
	int y = r.top + (r.Height() - mpcy)/2;
	for(int i=0; i<m_hPages;i++)
	{
		pDC->Rectangle(x,y,x+mpcx,y+mpcy);
		x+=mpcx+5;
	}
	pDC->SelectObject(old);
	pen.DeleteObject();
	dc.DeleteDC();
	ReleaseDC(pDC);
}

void CSetupPrintDlg::OnChangePages() 
{
	if(UpdateData())
	{
		Invalidate();
	}
}

void CSetupPrintDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	DrawPages();
}
