// BPResDlg.cpp : implementation file
//

#include "stdafx.h"
#include "BPResDlg.h"
#include "apl_api.h"
#include "dictionary.h"
#include "aplguiex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBPResDlg dialog


CBPResDlg::CBPResDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CBPResDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBPResDlg)
	m_id = _T("");
	m_name = _T("");
	m_descr = _T("");
	m_ranking_rationale = _T("");
	//}}AFX_DATA_INIT
	m_inst=0; m_bp=0; m_obj=0; m_base_pdr=0; m_base_res=0;m_bp_rev=0;m_unit_der=0;m_assortment=0;m_bp_inst=0;
	m_api=0;m_ReadOnly=false;m_type=0;m_unit=0;m_res_value=1;m_res_der_value=0;m_ranking_value=0;
}


void CBPResDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBPResDlg)
	DDX_Control(pDX, IDC_RANKING, m_ranking_ctrl);
	DDX_Control(pDX, IDC_RANK_RAT, m_ranking_rationale_ctrl);
	//DDX_Control(pDX, IDC_SORTAMENT, m_sortament);
	DDX_Control(pDX, IDC_VALUE_DER, m_val_der_ctrl);
	DDX_Control(pDX, IDC_UNIT_DER, m_unit_der_ctrl);
	DDX_Control(pDX, IDC_VALUE, m_val_ctrl);
	DDX_Control(pDX, IDC_DESCR, m_descr_ctrl);
	DDX_Control(pDX, IDC_UNIT, m_unit_ctrl);
	DDX_Control(pDX, IDC_RES_TYPE, m_type_ctrl);
	DDX_Control(pDX, IDC_OBJ, m_obj_ctrl);
	DDX_Control(pDX, IDC_NAME, m_name_ctrl);
	DDX_Control(pDX, IDC_ID, m_id_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Text(pDX, IDC_ID, m_id);
	DDX_Text(pDX, IDC_NAME, m_name);
	DDX_Text(pDX, IDC_DESCR, m_descr);
	DDX_Text(pDX, IDC_RANK_RAT, m_ranking_rationale);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBPResDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CBPResDlg)
	ON_BN_CLICKED(IDC_OBJ_BROWSE, OnObjBrowse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBPResDlg message handlers
//****************************************************************************
BOOL CBPResDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	int i,j;
	aplExtent ext;
	CString buf,buf1;

	//  
	m_api->m_data.GetEntityExtent(m_api->m_bp_mgr.e_bp_res_type,ext);
	for(i=0;i<ext.Size;i++)
	{
		m_api->m_data.GetAttr(ext[i],m_api->m_bp_mgr.a_bp_res_type_name,buf);
		j=m_type_ctrl.AddString(buf);
		m_type_ctrl.SetItemData(j,(int)ext[i]);
	}
	// 
	/*int k=m_sortament.AddString(_T(" "));
	m_sortament.SetItemData(k,0);

	aplExtent ext0;
	m_api->m_data.GetEntityExtent(m_api->m_prd_mgr.e_assortment,ext0);
	for(i=0;i<ext0.Size;i++)
	{
		m_api->m_data.GetAttr(ext0[i],m_api->m_prd_mgr.a_assortment_name,buf);
		if(buf==_T("")) m_api->m_data.GetAttr(ext0[i],m_api->m_prd_mgr.a_assortment_id,buf);
		buf+=_T(" ");
		m_api->m_data.GetAttrBN(ext0[i],_T("standard"),buf1);
		buf+=buf1;
		int k=m_sortament.AddString(buf);
		m_sortament.SetItemData(k,(UINT)ext0[i]);
	}*/

	// 
	CString scht;
	m_api->m_data.GetEntityExtentBN(_T("step_unit"),ext);
	for(i=0;i<ext.Size;i++)
	{
		m_api->m_charact_mgr.GetUnitName(ext[i],buf);
		j=m_unit_ctrl.AddString(buf);
		m_unit_ctrl.SetItemData(j,(UINT)ext[i]);
		buf1=buf;
		buf1.MakeLower();
		if(buf1.GetLength()>=2)	{if((buf1[0]==_T(''))&&(buf1[1]==_T('')))scht=buf;}

		j=m_unit_der_ctrl.AddString(buf);
		m_unit_der_ctrl.SetItemData(j,(UINT)ext[i]);
	}
	j=m_unit_ctrl.AddString(_T(""));
	m_unit_ctrl.SetItemData(j,0);
	if(scht!=_T("")) m_unit_ctrl.SelectString(-1,scht);

	j=m_unit_der_ctrl.AddString(_T(""));
	m_unit_der_ctrl.SetItemData(j,0);

	if(m_base_res!=0)
	{
		m_api->m_data.GetAttrBN(m_base_res,S::id,m_id);
		m_api->m_data.GetAttrBN(m_base_res,S::name,m_name);
		m_api->m_data.GetAttrBN(m_base_res,S::description,m_descr);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_unit,m_unit);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_val,m_res_value);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_derive_unit,m_unit_der);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_derive_val,m_res_der_value);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_assortment,m_assortment);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_object,m_obj);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_ranking,m_ranking_value);
		m_api->m_data.GetAttr(m_base_res,m_api->m_bp_mgr.a_bp_res_ranking_rationale,m_ranking_rationale);
	}
	else if(m_base_pdr!=0)
	{
		m_api->m_data.GetAttrBN(m_base_pdr,S::id,m_id);
		m_api->m_data.GetAttrBN(m_base_pdr,S::name,m_name);
		m_api->m_data.GetAttrBN(m_base_pdr,S::description,m_descr);

		if(m_api->m_data.IsKindOfBN(m_base_pdr,S::apl_qacu))
		{
			m_api->m_data.GetAttrBN(m_base_pdr,S::value_component,m_res_value);
			m_api->m_data.GetAttrBN(m_base_pdr,S::unit_component,m_unit);
		}
		else if(m_api->m_data.IsKindOfBN(m_base_pdr,_T("apl_make_from_usage_option")))
		{
			m_api->m_data.GetAttrBN(m_base_pdr,S::value_component,m_res_value);
			m_api->m_data.GetAttrBN(m_base_pdr,_T("derive_value_component"),m_res_der_value);
			m_api->m_data.GetAttrBN(m_base_pdr,S::unit_component,m_unit);
			m_api->m_data.GetAttrBN(m_base_pdr,_T("derive_unit_component"),m_unit_der);
			m_api->m_data.GetAttrBN(m_base_pdr,_T("apl_assortment"),m_assortment);
		}
	}
	
	//   
	if(m_inst!=0)
	{
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_id,m_id);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_name,m_name);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_descr,m_descr);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_type,m_type);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_unit,m_unit);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_val,m_res_value);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_unit,m_unit_der);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_val,m_res_der_value);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_assortment,m_assortment);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_object,m_obj);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking,m_ranking_value);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking_rationale,m_ranking_rationale);
	}

	if(m_type!=0)
	{
		for(i=0;i<m_type_ctrl.GetCount();i++)
		{
			j=m_type_ctrl.GetItemData(i);
			if(j==(int)m_type) { m_type_ctrl.SetCurSel(i); break;	}
		}
	}
	if(m_ranking_value!=0)
	{	buf.Format(_T("%d"),m_ranking_value);
		m_ranking_ctrl.SetWindowText(buf);
	}
	if(m_res_value!=0)
	{	buf.Format(_T("%f"),m_res_value);
		m_val_ctrl.SetWindowText(buf);
	}
	if(m_res_der_value!=0)
	{	buf.Format(_T("%f"),m_res_der_value);
		m_val_der_ctrl.SetWindowText(buf);
	}
	if(m_unit!=0)
	{
		for(i=0;i<m_unit_ctrl.GetCount();i++)
		{
			j=m_unit_ctrl.GetItemData(i);
			if(j==(int)m_unit) { m_unit_ctrl.SetCurSel(i); break;	}
		}
	}
	if(m_unit_der!=0)
	{
		for(i=0;i<m_unit_der_ctrl.GetCount();i++)
		{
			j=m_unit_der_ctrl.GetItemData(i);
			if(j==(int)m_unit_der) { m_unit_der_ctrl.SetCurSel(i); break;	}
		}
	}
	/*if(m_assortment!=0)
	{
		i=0;
		while(1)
		{
			j=m_sortament.GetItemData(i);
			if(j==CB_ERR) break;
			if(j==(int)m_assortment){m_sortament.SetCurSel(i);break;}
			i++;
		}
	}*/

	if(m_obj!=0)
	{
		m_api->m_bp_mgr.GetItemName(m_obj,buf);
		m_obj_ctrl.SetWindowText(buf);

		/*if(!m_api->m_data.IsKindOf(m_obj,m_api->m_prd_mgr.e_pdf))
		{
			m_sortament.SelectString(0,_T(""));
			m_sortament.EnableWindow(FALSE);
		}
		else m_sortament.EnableWindow(TRUE);*/

		SetIdNameByRes(m_obj);

	}
	if(m_inst)
		if(m_inst->GetAccessmode()>=aplRO)
			m_ReadOnly=true;
	if(m_ReadOnly)
	{
		//m_sortament.EnableWindow(FALSE);
		m_val_der_ctrl.SetReadOnly(TRUE);
		m_unit_der_ctrl.EnableWindow(FALSE);
		m_val_ctrl.SetReadOnly(TRUE);
		m_descr_ctrl.SetReadOnly(TRUE);
		m_unit_ctrl.EnableWindow(FALSE);
		m_type_ctrl.EnableWindow(FALSE);
		m_obj_ctrl.SetReadOnly(TRUE);
		m_name_ctrl.SetReadOnly(TRUE);
		m_id_ctrl.SetReadOnly(TRUE);
		m_ok_btn.EnableWindow(FALSE);
		m_ranking_rationale_ctrl.SetReadOnly(TRUE);
		m_ranking_ctrl.SetReadOnly(TRUE);

	}
	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//****************************************************************************
void CBPResDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(!UpdateData()) return;
	int i;
	CString buf,buf1;

	m_val_ctrl.GetWindowText(buf1);
	buf1.TrimLeft();buf1.TrimRight();
	buf1.Replace(_T(','),_T('.'));
	if(!IsRealOrEmpty(buf1)) {AfxMessageBox( APL_T("  \" \"    "));return;}
	if(buf1!=_T(""))m_res_value=__atof(buf1);

	m_val_der_ctrl.GetWindowText(buf1);
	buf1.TrimLeft();buf1.TrimRight();
	buf1.Replace(_T(','),_T('.'));
	if(!IsRealOrEmpty(buf1)) {AfxMessageBox( APL_T("  \" \"    "));return;}
	if(buf1!=_T(""))m_res_der_value=__atof(buf1);


	m_ranking_ctrl.GetWindowText(buf1);
	buf1.TrimLeft();buf1.TrimRight();
	buf1.Replace(_T(','),_T('.'));
	if(buf1==_T("")) buf1=_T("0");
	if(!IsRealOrEmpty(buf1)) {AfxMessageBox( APL_T("  \"\"    "));return;}
	if(buf1!=_T(""))m_ranking_value=_atoi(buf1);

	if(m_obj==0) {AfxMessageBox( APL_T("  ")); return;}

	i=m_unit_ctrl.GetCurSel();
	if(i>=0)m_unit=(CaplInstance*)m_unit_ctrl.GetItemData(i);
	else m_unit=0;
	
	if((m_unit!=0)&&(m_res_value==0)){AfxMessageBox( APL_T("   ,     "));return;}

	i=m_unit_der_ctrl.GetCurSel();
	if(i>=0)m_unit_der=(CaplInstance*)m_unit_der_ctrl.GetItemData(i);
	else m_unit_der=0;
	
	if((m_unit_der!=0)&&(m_res_der_value==0)){AfxMessageBox( APL_T("   ,     "));return;}
	
	i=m_type_ctrl.GetCurSel();
	if(i>=0 )m_type=(CaplInstance*)m_type_ctrl.GetItemData(i);
	else m_type=0;
	/*m_assortment=0;
	if(m_api->m_data.IsKindOf(m_obj,m_api->m_prd_mgr.e_pdf))
	{	
		m_assortment=(CaplInstance*)m_sortament.GetItemData(m_sortament.GetCurSel());
		if(m_assortment==(CaplInstance*)-1)m_assortment=0;
	}*/
	bool something_changed=true;
	bool create_new_version=false;
	if(m_inst)
	{
		//  
		CaplInstance *m_old_obj=0,*old_unit=0,*old_der_unit=0,*old_type=0,*old_assortment=0;
		CString old_id=_T(""),old_name=_T(""),old_descr=_T(""),old_ranking_rationale=_T("");
		double old_val=0,old_der_val=0;
		int old_ranking;

		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_object,m_old_obj);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_unit,old_unit);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_unit,old_der_unit);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_id,old_id);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_name,old_name);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_descr,old_descr);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_val,old_val);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_type,old_type);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_val,old_der_val);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_assortment,old_assortment);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking,old_ranking);
		m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking_rationale,old_ranking_rationale);


		if(m_old_obj==m_obj)
			if(old_unit==m_unit) 
				if(old_der_unit==m_unit_der) 
					if(old_id==m_id)
						if(old_name==m_name)
							if(old_descr==m_descr)
								if(old_type==m_type) 
									if(old_val==m_res_value)
										if(old_der_val==m_res_der_value) 
											if(m_assortment==old_assortment)
												if(m_ranking_value==old_ranking)
													if(m_ranking_rationale==old_ranking_rationale)
														something_changed=false;

		if(something_changed && m_api->m_bp_mgr.m_bUseVersions)
		{
			CaplInstance *ver=0;
			CaplInstance *process=0;
			if(m_bp_rev)
			{
				m_bp_inst=0;
				m_api->m_data.GetAttr(m_bp_rev,m_api->m_bp_mgr.a_bp_ver_bp,m_bp);
				m_api->m_bp_mgr.LoadBPInfo(m_bp_rev);
				ver=m_bp_rev;
			}
			else
			{
				m_bp=0;
				m_api->m_data.GetAttr(m_inst,m_api->m_bp_mgr.a_bp_res_process,process);
				if(m_api->m_data.IsKindOf(process,m_api->m_bp_mgr.e_bp))
				{
					m_bp=process;
					ver=m_api->m_bp_mgr.CheckMyLock(m_bp,true);
					if(!ver) return;
				}
				else m_bp_inst=process;

			}
			if(!process) return;
			
			if(m_bp)
			{
				//     
				
				CaplAggr aggr0;
				CaplInstance *inst0=0;
				CaplInstance *base_bp=0;
				m_api->m_data.GetAttr(ver,m_api->m_bp_mgr.a_bp_ver_base,base_bp);
				if(base_bp)
				{
					m_api->m_bp_mgr.LoadBPInfo(base_bp);
					m_api->m_data.GetAttr(base_bp,m_api->m_bp_mgr.a_bp_ver_res,aggr0);
				}
				else
					m_api->m_data.GetAttr(m_bp,m_api->m_bp_mgr.a_bp_res,aggr0);
				bool found_in_base_process=false;
				int i;
				CaplInstance *inst;
				for(i=0;i<aggr0.GetSize();i++)
				{
					aggr0.GetByIndex(i,inst);
					if(inst==m_inst)
					{
						found_in_base_process=true;
						break;
					}
				}
			
				CaplAggr aggr;
				if(found_in_base_process)
				{
					m_api->m_data.GetAttr(ver,m_api->m_bp_mgr.a_bp_ver_res,aggr);
					for(i=0;i<aggr.GetSize();i++)
					{
						aggr.GetByIndex(i,inst);
						if(inst==m_inst)
						{
							if(m_bp_rev)
								if(IDNO==AfxMessageBox( APL_T("     -!\n\n    ?"),
									MB_YESNO|MB_ICONQUESTION)) return;
							create_new_version=true;
							aggr.Remove(i);
							m_inst=m_api->m_data.CreateInstance(m_api->m_bp_mgr.e_bp_res);
							m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_process,m_bp);
							CaplValue c_value;
							c_value.Set(m_inst);
							aggr.Insert(i,c_value);
							m_api->m_data.PutAttr(ver,m_api->m_bp_mgr.a_bp_ver_res,aggr);
							break;
						}
					}
				}
			}
		}
	}	
	if(m_inst && something_changed)
	{
		if(m_bp_rev && !create_new_version)
			if(IDNO==AfxMessageBox( APL_T("     -!\n\nC ?"),
				MB_YESNO|MB_ICONQUESTION)) return;
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_object,m_obj);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_unit,m_unit);	
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_unit,m_unit_der);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_id,m_id);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_name,m_name);
	    m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_descr,m_descr);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_type,m_type);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_val,m_res_value);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_derive_val,m_res_der_value);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_assortment,m_assortment);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking,m_ranking_value);
		m_api->m_data.PutAttr(m_inst,m_api->m_bp_mgr.a_bp_res_ranking_rationale,m_ranking_rationale);
	}
	
	CaplTranslateDialog::OnOK();
}
//****************************************************************************
void CBPResDlg::OnObjBrowse() 
{
	// TODO: Add your control notification handler code here
	CaplInstance *inst=m_api->m_bp_mgr.SelectInstance(/*APL_MODE_SELECT_PRD|*/ //     22.12.2017
		APL_MODE_SELECT_PDF|APL_MODE_SELECT_PRDINST|APL_MODE_SELECT_LOT|
		APL_MODE_SELECT_PERSON|APL_MODE_SELECT_ORG|APL_MODE_SELECT_CLASSIF_ELEMENT,
		 APL_T(" "));
	if(inst!=0 && inst!=m_obj)
	{
		
		//    
		if(m_bp)
		{
			CaplAggr aggr;
			if(m_api->m_bp_mgr.m_bUseVersions)
			{
				CaplInstance *lock=0;
				m_api->m_data.GetAttr(m_bp,m_api->m_bp_mgr.a_bp_lock,lock);
				if(lock) m_api->m_data.GetAttr(lock,m_api->m_bp_mgr.a_bp_ver_res,aggr);
				
			}
			else
				m_api->m_data.GetAttr(m_bp,m_api->m_bp_mgr.a_bp_res,aggr);
		
			CaplInstance *res=0,*res_obj=0;
			for(int i=0;i<aggr.GetSize();i++)
			{
				aggr.GetByIndex(i,res);
				if(res==m_inst) continue;
				if(!res) continue;if(res->GetAccessmode()>aplRO) continue;
				m_api->m_data.GetAttr(res,m_api->m_bp_mgr.a_bp_res_object,res_obj);
				if(res_obj==inst) 
				{
					if(IDYES!=AfxMessageBox( APL_T("   ! ?"),MB_YESNO|MB_ICONWARNING)) return;
					break;
				}
			}
		}




		CString buf;
		m_api->m_bp_mgr.GetItemName(inst,buf);
		m_obj_ctrl.SetWindowText(buf);
		m_obj=inst;

		/*if(!m_api->m_data.IsKindOf(m_obj,m_api->m_prd_mgr.e_pdf))
		{
			m_sortament.SelectString(0,_T(""));
			m_sortament.EnableWindow(FALSE);
		}
		else m_sortament.EnableWindow(TRUE);*/

		SetIdNameByRes(m_obj);

	}
}

void CBPResDlg::SetIdNameByRes(CaplInstance *new_obj)
{
	if(0==new_obj) return;
	if(m_ReadOnly) return;

	if(!m_api->m_options_mgr.CheckInstallCode(_T(""))) return;


	CString sNewId, sNewName,sVer;
	
	if(m_api->m_data.IsKindOf(new_obj,m_api->m_prd_mgr.e_pdf))
	{
		CaplInstance *prd;
		m_api->m_data.GetAttr(new_obj,m_api->m_prd_mgr.a_pdf_prd,prd);
		m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,sNewId);
		m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,sNewName);
		m_api->m_data.GetAttr(new_obj,m_api->m_prd_mgr.a_pdf_id,sVer);

		if(sVer!=""){sNewId+=_T("-");sNewId+=sVer;}
	}
	else if(m_api->m_data.IsKindOf(new_obj,m_api->m_prd_mgr.e_prd))
	{
		m_api->m_data.GetAttr(new_obj,m_api->m_prd_mgr.a_prd_id,sNewId);
		m_api->m_data.GetAttr(new_obj,m_api->m_prd_mgr.a_prd_name,sNewName);
	}

	m_id=sNewId;
	m_name=sNewName;
	m_id_ctrl.SetWindowText(sNewId);
	m_name_ctrl.SetWindowText(sNewName);
}
