#if !defined(AFX_CHANGEDLG_H__D8D6D3C1_101C_4F6C_B69D_F5F7A5AC6A0E__INCLUDED_)
#define AFX_CHANGEDLG_H__D8D6D3C1_101C_4F6C_B69D_F5F7A5AC6A0E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ChangeDlg.h : header file
//
#include "resource.h"
#include "ResizableDialog.h"
#include "apl_gui.h"
#include "CommonChangeClasses.h"
#include "apl_api.h"
#include "AddSerialNum.h"
#include "afxwin.h"
#include "afxdtctl.h"
/////////////////////////////////////////////////////////////////////////////
// CChangeDlg dialog
 
class CChangeDlg : public CResizableDialog
{
// Construction
public:
	CChangeDlg(CWnd* pParent = NULL);   // standard constructor

	static CaplToolTip st_tooltip; 
	CFont m_tooltip_font;
// Dialog Data
	//{{AFX_DATA(CChangeDlg)
	enum { IDD = IDD_CHANGE_DIALOG };
	CEdit	m_basis;
	CTabCtrl	m_tabCtrl;
	CListCtrl	m_list;
	CEdit	m_idCtrl;
	CEdit	m_nameCtrl;
	CEdit	m_dscrCtrl;
	CEdit	m_userCtrl;
	CaplButton	m_okBtn;
	CaplButton	m_cancelBtn;
	CaplButton	m_propBtn;
	CaplButton	m_deleteBtn;
	CaplButton	m_applyBtn;
	CaplButton	m_addBtn;

	CString	m_sId;
	CString	m_sName;
	CString	m_sDscr;
	CString	m_sUser;
	CString	m_sBasis;
	CString	m_sStock;
	CString	m_sStock_ceh;

	CString m_sGrpNum;
	CString m_sOrgCode;
	CString m_sDocId;
	CString m_sUsage;
	CString m_sBasisCode;
	CString m_sComplNum;
	CString m_sList;
	CString m_sStockIntr;
	CString m_sTOdate;
	CString m_sOTDdate;
	CString m_sCritDate;
	CString m_sSeriaPrimen; //   ( )
	CString m_sSeriaPrimenStart;
	CString m_sSeriaPrimenEnd;
	CString m_sEffType; //   
	void GetEffectivityDscr(); //     
	//}}AFX_DATA

	CaplAPI *m_api;
	CaplInstance* m_change;

	CString m_sType;
	CString m_sUrgency;
	
	aplExtent m_items;
	CArray<CPSCItemInfo, CPSCItemInfo> m_new_items;
	aplExtent m_del_items;

	aplExtent m_dependent_items; //   (  
	
	aplExtent m_maters;
	CArray<CPSCItemInfo, CPSCItemInfo> m_new_maters;
	aplExtent m_del_maters;
	
	aplExtent m_docs;
	CArray<CDAVCItemInfo, CDAVCItemInfo> m_new_docs;
	aplExtent m_del_docs;
	
	aplExtent m_bps;
	CArray<CDAVCItemInfo, CDAVCItemInfo> m_new_bps;
	aplExtent m_del_bps;
	
	aplExtent m_chars; // -
	CArray<CDAVCItemInfo, CDAVCItemInfo> m_new_chars; //  -
	aplExtent m_del_chars; //  -

	aplExtent m_others; // ,    ,    

	CaplInstance *m_rep_pi; //     

	int m_index;
	CaplInstance* m_curItem;
	bool m_bReadOnly;
	
	int m_iCurTab;

	CImageList m_imageList;

	bool m_bMenuAdd;
	aplExtent m_aeSpravExt;

	bool m_bHasDI_iteem;  //  true,    . -     ( )

	HINSTANCE m_hLibraryGenII; 
	bool (*m_pGenerateII)(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI);

protected:
	//  -
	void ShowChCharactProp();
	void ShowChMaterProp();
	void ShowChItemProp(int iMode);
	void ShowChDocProp();
	void ShowChBPProp();
	
	//    
	void AddChCharact();
	void AddChMater();
	void AddChItem(int iMode);
	void AddChDoc();
	void AddChBP();
	
	void DeleteChCharact();//  -
	void DeleteChMater();//  
	void DeleteChItem();	
	void DeleteChDoc();//  
	void DeleteChBP();//  -
	
	int FindCurCharact();
	int FindCurMater();
	int FindCurItem();
	int FindCurDoc();
	int FindCurBP();

	bool SaveInOk();

public:
	void ShowChangedCharacts();
	void ShowChangedMaters();
	void ShowChangedItems();
	void ShowChangedDocs();
	void ShowChangedBPs();
	
	void ShowProductsInCtrl(CaplInstance* prd_ed, CaplInstance*prd_ing, int n);
	void ShowEffectivityInCtrl(CString type, CString start, CString end, int n);

	//       
	bool CheckAccess();

	//   ,   
	CaplInstance* GetTopOrganization(CaplInstance *ciOrganization);

	//   a_chng_doc_id   e_avc
	void ChangeDocId();

	//    avc 
	void GetExistingAVCItems(aplExtent &aeAVC);

	//    
	void FindAllDocUsage(CaplInstance *ciDoc, aplExtent &aeAllPrdUsage);

	//    
	void LoadChangeReasonSprav();

	//  
	void SetControlsState(); 
	
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CChangeDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CChangeDlg)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnItemchangedChsItemsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnChsAddButton();
	afx_msg void OnChsDeleteButton();
	afx_msg void OnChsPropButton();
	afx_msg void OnChsApplyButton();
	afx_msg void OnDblclkChsItemsList(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSelchangeSelectTab(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnAddAssemblyChange();
	afx_msg void OnAddSEChange();
	afx_msg void OnAddAssemblyGlobalChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
	CaplButton m_editBtn;
	afx_msg void OnBnClickedChnStartEditButton();
	CaplButton m_notesBtn;
	afx_msg void OnBnClickedChnNotesButton();
	afx_msg void OnBnClickedChooseBasisCode();
	afx_msg void OnBnClickedChooseUsage();
	afx_msg void OnBnClickedEditSeria();
	CaplButton m_create_ii_btn;
	afx_msg void OnBnClickedCreateIi();
	CComboBox m_type_ctrl;
	afx_msg void OnCbnSelchangeType();
	CEdit m_stock_ceh;
	CComboBox m_urgency_ctrl;
	CStatic m_st_name;
	CEdit m_issue_date_ctrl;
	CString m_sIssue_date;
	CString m_sValidity_pi_date;
	CaplButton m_view_ii_btn;
	afx_msg void OnBnClickedViewIi();
	CComboBox m_stock_combo;
	CDateTimeCtrl m_validity_pi_date_ctrl;
	CStatic m_st_src_pi;
	CEdit m_src_pi_ctrl;
	afx_msg void OnNMRClickChsItemsList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedSelEnterprise();
	afx_msg void OnBnClickedSelWg();
	CEdit m_sGrpNumCtrl;
	CEdit m_sOrgCodeCtrl;
	CEdit m_sSeriaPrimenCtrl;
	afx_msg void OnBnClickedGenerateChangeId();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_CHANGEDLG_H__D8D6D3C1_101C_4F6C_B69D_F5F7A5AC6A0E__INCLUDED_)
