// ChangesTreeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ChangesTreeDlg.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChangesTreeDlg dialog
CChangesTreeDlg::CChangesTreeDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CChangesTreeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CChangesTreeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CChangesTreeDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CChangesTreeDlg)
	DDX_Control(pDX, IDC_CT_TREE, m_chngTreeCtrl);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CChangesTreeDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CChangesTreeDlg)
	ON_NOTIFY(TVN_ITEMEXPANDED, IDC_CT_TREE, OnItemexpandedCtTree)
	ON_NOTIFY(NM_RCLICK, IDC_CT_TREE, OnRclickCtTree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChangesTreeDlg message handlers

void CChangesTreeDlg::OnOK() 
{
	
	CaplTranslateDialog::OnOK();
}

void CChangesTreeDlg::OnCancel() 
{
	
	CaplTranslateDialog::OnCancel();
}

BOOL CChangesTreeDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 25, RGB(255, 0, 255));
	m_chngTreeCtrl.SetImageList(&m_imageList, TVSIL_NORMAL);
	
	if(m_api && m_api->m_data.IsConnected())
	{
		CString buf, name;

		if(m_change)
		{
			m_api->m_data.GetAttr(m_change, m_api->m_change_mgr.a_chng_id, name);
			m_api->m_data.GetAttr(m_change, m_api->m_change_mgr.a_chng_name, buf);
			if(!name.IsEmpty()) name+=_T(" : "); name+=buf;
			
			HTREEITEM item= m_chngTreeCtrl.InsertItem(name, ICON_CHANGE, ICON_CHANGE);			
//			CCangeItemData* item_data= new CCangeItemData(m_change, item, 0, true);		
//			m_chngTreeCtrl.SetItemData(item, (DWORD)item_data);
		}
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CChangesTreeDlg::OnItemexpandedCtTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	
/*	if(pNMTreeView->action==2)
	{
		CCangeItemData* item_data= (CCangeItemData*)m_chngTreeCtrl.GetItemData(pNMTreeView->itemOld.hItem);
		if(item_data && item_data->fictive) m_chngTreeCtrl.DeleteItem(item_data->fictive);
		aplExtent changes;
	}
	else if(pNMTreeView->action==1)
	{
		
	}*/
	
	*pResult = 0;
}

void CChangesTreeDlg::OnRclickCtTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CChangesTreeDlg::FillChangesTree(HTREEITEM item)
{
	aplExtent chng_items;
	CaplInstance* chng= NULL;
	if(item== TVI_ROOT)	chng= m_change;
	else chng= (CaplInstance*)m_chngTreeCtrl.GetItemData(item);

	m_api->m_data.GetAttr(m_change, m_api->m_change_mgr.a_chng_items, chng_items);
	for(int i= 0; i<chng_items.GetSize(); i++)
	{
		if(m_api->m_data.IsKindOf(chng_items[i], m_api->m_change_mgr.e_psc))
		{
			aplExtent effs;
			m_api->m_data.GetAttr(chng_items[i], m_api->m_change_mgr.a_psc_add_set, effs);
			for(int j= 0; j<effs.GetSize(); j++)
			{
				bool bNotActive= false;				
				if(!bNotActive)
				{
					
				}
			}
		}
		else if(m_api->m_data.IsKindOf(chng_items[i], m_api->m_change_mgr.e_avc))
		{
			
		}
		else if(m_api->m_data.IsKindOf(chng_items[i], m_api->m_change_mgr.e_abpc))
		{
			
		}
	}
}
