// CharacterysticTypeForced.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "dictionary.h"
#include "CharacterysticTypeForced.h"
#include "apl_gui.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCharacterysticTypeForced dialog


CCharacterysticTypeForced::CCharacterysticTypeForced(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CCharacterysticTypeForced::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCharacterysticTypeForced)
	m_IsRequired = FALSE;
	//}}AFX_DATA_INIT
	m_api=0;	
	m_data=0;
	
	m_charactteristic=0;
	m_unit=0;
	m_readonly=false;
	m_ext_mode=false;


}


void CCharacterysticTypeForced::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCharacterysticTypeForced)
	DDX_Control(pDX, IDC_CHECK_FORCED, m_CheckRequired);
	DDX_Control(pDX, IDC_SEL_CHARACT, m_BtnSelCharact);
	DDX_Control(pDX, IDC_TYPE, m_CmbxType);
	DDX_Control(pDX, IDCANCEL, m_BtnCancel);
	DDX_Control(pDX, IDOK, m_BtnOk);
	DDX_Control(pDX, IDC_CHARACTERYSTIC, m_charact);
	DDX_Control(pDX, IDC_MEASURE_UNIT, m_measure_unit_ctrl);
	DDX_Check(pDX, IDC_CHECK_FORCED, m_IsRequired);
	DDX_Control(pDX, IDC_ST_CHARACT_NAME, m_st_charact_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCharacterysticTypeForced, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CCharacterysticTypeForced)
	ON_BN_CLICKED(IDC_SEL_CHARACT, OnSelCharact)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCharacterysticTypeForced message handlers

BOOL CCharacterysticTypeForced::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	if(m_api==0) return FALSE;
	
	m_data=&(m_api->m_data);

	COLORMAP  cm;
	cm.from=RGB(192,192,192);
	cm.to=GetSysColor(COLOR_BTNFACE);
	
	if(aplGetBitPerPixel(this)>8)
		m_name_bmp.LoadMappedBitmap(IDB_CHARACT_NAME,0,&cm,1);
	else
		m_name_bmp.LoadMappedBitmap(IDB_CHARACT_NAME_16,0,&cm,1);
	
	HBITMAP hBmpOld=m_st_charact_name.SetBitmap(HBITMAP(m_name_bmp));	
	::DeleteObject(hBmpOld);
	
	m_BtnCancel.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_BtnCancel.SetFlat(FALSE);
	m_BtnOk.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_BtnOk.SetFlat(FALSE);

	if(m_charactteristic!=0)
	{
		SetCharacterystic(m_charactteristic);
	}
	aplExtent ext0;
	CString buf;
	int i;
	int k=m_CmbxType.AddString(_T(""));
	m_CmbxType.SetItemData(k,0);
	m_CmbxType.SetCurSel(k);
	m_data->GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type,ext0);
	for(i=0;i<ext0.Size;i++)
	{
		m_data->GetAttr(ext0[i],m_api->m_charact_mgr.a_apl_charact_type_name,buf);
		k=m_CmbxType.AddString(buf);
		m_CmbxType.SetItemData(k,(UINT)ext0[i]);
		if(ext0[i]==m_type){
			m_CmbxType.SetCurSel(k);
		}
	}

	// TODO: Add extra initialization here
	if(m_readonly){
		m_CmbxType.EnableWindow(FALSE);
		m_BtnSelCharact.EnableWindow(FALSE);
		m_CheckRequired.EnableWindow(FALSE);
		m_BtnOk.EnableWindow(FALSE);
	}
	if(m_ext_mode){
		CRect rect_all;
		int delta=30;
		m_CheckRequired.ShowWindow(SW_HIDE);
		m_BtnOk.GetWindowRect(&rect_all);
		ScreenToClient(&rect_all);
		rect_all.top-=delta;
		rect_all.bottom-=delta;
		m_BtnOk.MoveWindow(&rect_all);
		m_BtnCancel.GetWindowRect(&rect_all);
		ScreenToClient(&rect_all);
		rect_all.top-=delta;
		rect_all.bottom-=delta;
		m_BtnCancel.MoveWindow(&rect_all);

		GetWindowRect(&rect_all);
		rect_all.bottom-=delta;
		MoveWindow(&rect_all);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CCharacterysticTypeForced::OnSelCharact() 
{
	// TODO: Add your control notification handler code here
	CaplInstance *newCharact=m_api->m_charact_mgr.SelectCharacteristic(m_charactteristic);
	SetCharacterystic(newCharact);
	
}

void CCharacterysticTypeForced::SetCharacterystic(CaplInstance *new_charact)
{
	if(new_charact==0) return;
	m_measure_unit_ctrl.SetWindowText(_T("???"));

	CString buf,buf1;
	CaplInstance *inst1;
	m_data->GetAttrBN(new_charact,S::name,buf);
	m_charact.SetWindowText(buf);
	m_charactteristic=new_charact;
	//CString buf1;
	//m_data->GetAttrBN(m_charactteristic,_T("unit"),inst1);
	//m_api->m_charact_mgr.GetUnitName(inst1,buf1);
	//buf+=_T("  [");buf+=buf1;buf+=_T("]");

	m_data->GetAttrBN(new_charact,_T("unit"),inst1);
	CaplInstance *old_unit=m_unit;
	m_unit=inst1;
	m_api->m_charact_mgr.GetUnitName(inst1,buf);
	m_measure_unit_ctrl.SetWindowText(buf);

}


void CCharacterysticTypeForced::OnOK() 
{
	// TODO: Add extra validation here
	if(m_charactteristic==0){
		AfxMessageBox( APL_T("  !"));return;
	}
	int k=m_CmbxType.GetCurSel();
	if(k==-1){m_type=0;}
	else{m_type=(CaplInstance*)m_CmbxType.GetItemData(k);}

	CaplTranslateDialog::OnOK();
}
