// FindOrgDlg.cpp : implementation file
//

#include "stdafx.h"
#include "FindOrgDlg.h"
#include <AplGuiEx.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindOrgDlg dialog


CFindOrgDlg::CFindOrgDlg(CaplAPI* api,CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindOrgDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindOrgDlg)
	m_code = _T("");
	m_name = _T("");
	//}}AFX_DATA_INIT
	m_api=api;
	m_inst=NULL;
}


void CFindOrgDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindOrgDlg)
	DDX_Control(pDX, IDC_LSTORG, m_ListOrg);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_BTNFIND, m_find_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Text(pDX, IDC_EDT_CODE, m_code);
	DDX_Text(pDX, IDC_EDT_NAME, m_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindOrgDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindOrgDlg)
	ON_BN_CLICKED(IDC_BTNFIND, OnBtnfind)
	ON_NOTIFY(NM_DBLCLK, IDC_LSTORG, OnDblclkLstorg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindOrgDlg message handlers

BOOL CFindOrgDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_find_btn.SetIcon(aplGetButtonIco(APL_24_FIND));
	m_find_btn.SetFlat(FALSE);

	m_ok_btn.EnableWindow(FALSE);
	CRect rect;
	m_ListOrg.GetClientRect(rect);
	int cl_width=rect.Width();
	cl_width-=::GetSystemMetrics(SM_CXVSCROLL)+1;
	m_ListOrg.SetExtendedStyle(m_ListOrg.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);

	m_ListOrg.InsertColumn(0, APL_T(""),LVCFMT_LEFT,(int)(cl_width * 0.2));
	m_ListOrg.InsertColumn(1, APL_T(""),LVCFMT_LEFT,(int)(cl_width * 0.8));
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindOrgDlg::OnBtnfind() 
{
	UpdateData();
	bool bCond=true;
	bool bFind=true;
	if(m_name.IsEmpty() && m_code.IsEmpty())
	{
		if(MessageBox( APL_T("   .   ?"), APL_T(""),MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2)==IDNO)
			return;
		else
			bCond=false;
	}
	m_name.MakeLower();
	m_code.MakeLower();
	
	CWinApp *app=AfxGetApp(); //    ActiveX  0
	if(0!=app)app->DoWaitCursor(1);
	aplExtent ext;
	m_api->m_data.GetEntityExtent(m_api->m_appr_mgr.e_org, ext);
	
	m_ListOrg.DeleteAllItems();

	CString atr_name;
	CString atr_code;
	CString atr_name_low;
	CString atr_code_low;
	for(int i=0;i<ext.Size;i++)
	{
		if(0==ext[i]) continue;
		if(0==ext[i]->GetType()) continue;
		if(ext[i]->GetAccessmode()>aplRO) continue;

		m_api->m_data.GetAttr(ext[i],m_api->m_appr_mgr.a_org_name,atr_name);
		m_api->m_data.GetAttr(ext[i],m_api->m_appr_mgr.a_org_id,atr_code);
		if(bCond)
		{
			atr_name_low=atr_name; atr_name_low.MakeLower();
			atr_code_low=atr_code; atr_code_low.MakeLower();
			bFind=(atr_name_low.Find(m_name,0)>-1 && atr_code_low.Find(m_code,0)>-1);
		}
		if(bFind)
		{
			m_ListOrg.InsertItem(0,atr_code);
			m_ListOrg.SetItemText(0,1,atr_name);
			m_ListOrg.SetItemData(0,(DWORD)ext[i]);
		}
	}
	if(0!=app) app->EndWaitCursor();
	int count=m_ListOrg.GetItemCount();
	m_ok_btn.EnableWindow(count);
	CString buf;
	if(count)
		buf.Format( APL_T(" %d ."),count);
	else
		buf= APL_T("  .");
	MessageBox(buf, APL_T(" ."));
	
}

void CFindOrgDlg::OnOK() 
{
	int ind=m_ListOrg.GetNextItem(-1, LVIS_SELECTED);
	if(ind==-1)
		CaplTranslateDialog::OnCancel();
	m_inst=(CaplInstance*)m_ListOrg.GetItemData(ind);
	CaplTranslateDialog::OnOK();
	
}

void CFindOrgDlg::OnDblclkLstorg(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnOK();
	*pResult = 0;
}