#pragma once

#include <apl_gui.h>
#include "afxwin.h"
// CFindPKIDlgEx dialog

class CFindPKIDlgEx : public CaplResizableDialog
{
	DECLARE_DYNAMIC(CFindPKIDlgEx)

public:
	CFindPKIDlgEx(CaplAPI *api, CString sTitle, CWnd* pParent = NULL);   // standard constructor
	virtual ~CFindPKIDlgEx();

// Dialog Data
	enum { IDD = IDD_FIND_PKI_EX };

	CaplAPI *m_api;

	CString m_sSpravId;

	bool m_bClearPrdInstList;
	bool m_bPrdInstOnly;
	bool m_bDisableLot;
	bool m_bDisablePrdInst;
	bool m_bProcessItemChange;
	
	bool m_bShowFindCount;
	
	bool m_bNoShowSprav;
	static BOOL m_bShowSpravCheck;

	CaplInstance *m_ciItem;
	CaplInstance *m_ciLot;

	aplExtent m_base_classifiers;

	CString m_sTitle;
	CString m_sPrdId;
	CString m_sPrdName;
	CString m_sSN;
	CString m_sLotId;

	CaplButton m_ok_btn;
	CaplButton m_cancel_btn;

	CaplButton m_btn_search_pdf;
	CaplButton m_btn_search_prd_inst;
	CaplButton m_btn_search_lot;
	CaplButton m_btn_create_pdf;
	CaplButton m_btn_create_prd_inst;
	CaplButton m_btn_create_lot;

	CaplButton m_btn_pdf_prop;
	CaplButton m_btn_prd_inst_prop;
	CaplButton m_btn_lot_prop;

	CSortListCtrl m_list_pdf;
	CSortListCtrl m_list_prd_inst;
	CSortListCtrl m_list_lot;

protected:
	//         aplSocketTransport
	CaplParentWndProcesser m_pwp;

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnOK();

	void MoveOKCancelBtn(int delta);
	void InitBtns();
	void InitLists();
	void SetAnhors();
	void UpdateDataByPdfList();
	bool IsSystem(CaplInstance *PrdInst);
	void AddLot(CaplInstance *ciLot, int nInsertAt = -1);
	void AddPdf(CaplInstance *ciPdf, int nInsertAt = -1, bool bSelect=false);
	void AddPrdInst(CaplInstance *ciPrdInst, int nInsertAt = -1);
	void DeselectPdfList();
	void SelectInPdfList(CaplInstance *pdf);
	void DisableLot();
	void DisablePrdInst();
	void GetPrdNameAndId(int nIndex);

	DECLARE_MESSAGE_MAP()

	afx_msg void OnSearchPdf();
	afx_msg void OnSearchPrdInst();
public:
	afx_msg void OnLvnItemchangedListPdf(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnItemchangedListPrdInst(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedSearchLot();
	afx_msg void OnBnClickedCreatePdf();
	afx_msg void OnBnClickedCreatePrdInst();
	afx_msg void OnBnClickedCreateLot();
	afx_msg void OnBnClickedOk();
	afx_msg void OnNMDblclkListPdf(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMDblclkListPrdInst(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMDblclkListLot(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedPdfProp();
	afx_msg void OnBnClickedPrdInstProp();
	afx_msg void OnBnClickedLotProp();
	afx_msg void OnNMClickListPdf(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedSelfromClassif();
	CEdit m_prd_classif_ctrl;
	CButton m_prd_classif_check;
	afx_msg void OnBnClickedCheckShowSprav();
	CButton m_find_only_in_strav_check;
};
