// ItemSubscribeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ItemSubscribeDlg.h"
#include "icons_defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CItemSubscribeDlg dialog


CItemSubscribeDlg::CItemSubscribeDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CItemSubscribeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CItemSubscribeDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	
	m_item= NULL;
	m_curPerson= NULL;
	m_sbscr= NULL;
	m_offSbscr= NULL;
	m_api= NULL;
	m_bInList= false;
	m_index= -1;
}

void CItemSubscribeDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CItemSubscribeDlg)
	DDX_Control(pDX, IDC_SBSCR_DEL_BUTTON, m_delOfficialBtn);
	DDX_Control(pDX, IDC_TO_SUBSCRIBE_BUTTON, m_addBtn);
	DDX_Control(pDX, IDC_ITEM_SUBSCR_LIST, m_list);
	DDX_Control(pDX, IDC_DELETE_SUBSCR_BUTTON, m_deleteBtn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CItemSubscribeDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CItemSubscribeDlg)
	ON_BN_CLICKED(IDC_TO_SUBSCRIBE_BUTTON, OnToSubscribeButton)
	ON_BN_CLICKED(IDC_SUBSCRIBE_BUTTON, OnSubscribeButton)
	ON_BN_CLICKED(IDC_DELETE_SUBSCR_BUTTON, OnDeleteSubscrButton)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_ITEM_SUBSCR_LIST, OnItemchangedItemSubscrList)
	ON_BN_CLICKED(IDC_SBSCR_DEL_BUTTON, OnSbscrDelButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CItemSubscribeDlg message handlers

BOOL CItemSubscribeDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	
	m_imageList.Create(IDR_NAVIGATOR_ICON, 20, 11, RGB(255, 0, 255));
	m_list.SetImageList(&m_imageList, LVSIL_SMALL);	
	m_list.SetExtendedStyle(m_list.GetExtendedStyle()|LVS_EX_FULLROWSELECT|
		LVS_EX_SUBITEMIMAGES);
	
	m_list.InsertColumn(0,  APL_T(""), LVCFMT_LEFT, 500);	
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	
	m_curPerson= m_api->m_appr_mgr.GetCurrentPerson();
	ShowPersonsInList();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CItemSubscribeDlg::OnToSubscribeButton() 
{
	if(!m_item) return;
	if(!m_api || !m_api->m_data.IsConnected()) return;
	
	m_sbscr= m_api->m_message_mgr.CreateSubscribe(m_item, m_curPerson);
	ShowPersonsInList();
}

void CItemSubscribeDlg::OnSubscribeButton() 
{
	if(!m_item) return;
	if(!m_api || !m_api->m_data.IsConnected()) return;
	
	aplExtent ext;
	m_api->m_appr_mgr.SelectPersonsOrganizations(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_OFFICIAL, ext,
		true, true,  APL_T(" "),  APL_T(" :"));
	m_api->m_message_mgr.CreateSubscribe(m_item, ext);
	
	ShowPersonsInList();
}

void CItemSubscribeDlg::OnDeleteSubscrButton() 
{
	if(!m_item) return;
	if(!m_api || !m_api->m_data.IsConnected()) return;
	if(!m_sbscr) return;

	m_api->m_message_mgr.DeleteSubscribe(m_sbscr);
	m_sbscr= NULL;
	
	ShowPersonsInList();
}

bool CItemSubscribeDlg::ShowPersonsInList()
{
	m_list.DeleteAllItems();
	
	m_bInList= false;
	m_delOfficialBtn.EnableWindow(FALSE);	

	if(m_api && m_api->m_data.IsConnected())
	{
		if(m_item)
		{
			m_api->m_message_mgr.GetItemsSubscribers(m_item, m_pers);
			for(int i= 0; i<m_pers.GetSize(); i++)
			{
				if(m_curPerson && m_pers[i]==m_curPerson) m_bInList= true;
				CString buf;
				m_api->m_appr_mgr.GetPersonName(m_pers[i], buf);
				if(!buf.IsEmpty())
				{
					int icon= ICON_PERSON;
					
					if(m_api->m_data.IsKindOf(m_pers[i], m_api->m_appr_mgr.e_official))
						icon= ICON_OFFICIAL;

					int n= m_list.InsertItem(i, buf, icon);
					m_list.SetItemData(n, (DWORD)m_pers[i]);
				}
			}
		}
	}

	if(!m_bInList)
	{
		m_addBtn.EnableWindow();
		m_deleteBtn.EnableWindow(FALSE);
		m_sbscr= NULL;
	}
	else
	{
		m_addBtn.EnableWindow(FALSE);
		m_deleteBtn.EnableWindow();		
		
		aplExtent ext;
		m_api->m_message_mgr.GetPersonSubscribeList(m_curPerson, ext);
		for(int i= 0; i<ext.GetSize(); i++)
		{
			CaplInstance* item= NULL;
			m_api->m_data.GetAttr(ext[i], m_api->m_message_mgr.a_subscr_item, item);
			if(item==m_item)
			{
				m_sbscr= ext[i];
				break;
			}
		}
	}

	return true;
}

void CItemSubscribeDlg::OnItemchangedItemSubscrList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	m_index= m_list.GetNextItem(-1, LVNI_ALL|LVNI_SELECTED);
	
	m_delOfficialBtn.EnableWindow(FALSE);
	
	if(-1!=m_index)
	{
		CaplInstance* inst= (CaplInstance*)m_list.GetItemData(m_index);
		if(inst && m_api->m_data.IsKindOf(inst, m_api->m_appr_mgr.e_official))
		{
			CaplInstance* person= NULL;
			m_api->m_data.GetAttr(inst, m_api->m_appr_mgr.a_official_act_person, person);
			if(person==m_curPerson)
			{
				m_delOfficialBtn.EnableWindow();
				
				aplExtent ext;
				m_api->m_message_mgr.GetPersonSubscribeList(inst, ext);
				for(int i= 0; i<ext.GetSize(); i++)
				{
					CaplInstance* item= NULL;
					m_api->m_data.GetAttr(ext[i], m_api->m_message_mgr.a_subscr_item, item);
					if(item==m_item)
					{
						m_offSbscr= ext[i];
						break;
					}
				}
			}
		}
	}

	*pResult = 0;
}

void CItemSubscribeDlg::OnSbscrDelButton() 
{
	if(!m_item) return;
	if(!m_api || !m_api->m_data.IsConnected()) return;
	if(!m_offSbscr) return;

	m_api->m_message_mgr.DeleteSubscribe(m_offSbscr);
	m_offSbscr= NULL;	
	
	ShowPersonsInList();
}
