// PrdInstChangeDlg.cpp : implementation file
//

#include "stdafx.h"
#include "PrdInstChangeDlg.h"
#include "apl_api.h"
#include "SelectPrdInstDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrdInstChangeDlg dialog


CPrdInstChangeDlg::CPrdInstChangeDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CPrdInstChangeDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPrdInstChangeDlg)
	m_date0 = COleDateTime::GetCurrentTime();
	m_time0 = COleDateTime::GetCurrentTime();
	m_date1 = COleDateTime::GetCurrentTime();
	m_time1 = COleDateTime::GetCurrentTime();
	m_prichina = _T("");
	m_prd_ver_1 = _T("");
	m_prd_ver_0 = _T("");
	m_prd_id_0 = _T("");
	m_prd_id_1 = _T("");
	m_prd_name_0 = _T("");
	m_prd_name_1 = _T("");
	m_pi_id_0 = _T("");
	m_pi_id_1 = _T("");
	m_pi_sn_0 = _T("");
	m_pi_sn_1 = _T("");
	m_base_bp = _T("");
	//}}AFX_DATA_INIT

	m_api=0;
	m_src_pi_rel=0;
	m_new_pi=0;
	m_new_pi_rel=0;
	m_new_pi_change=0;
	m_bp = NULL;
}


void CPrdInstChangeDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrdInstChangeDlg)
	DDX_Control(pDX, IDC_BP_NAME_COMBO, m_bp_names_ctrl);
	DDX_Control(pDX, IDC_SELECT_PRD_INST, m_select_prd_inst);
	DDX_Control(pDX, IDC_SELECT_BP, m_select_bp);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_DateTimeCtrl(pDX, IDC_DATE_0, m_date0);
	DDX_DateTimeCtrl(pDX, IDC_TIME_0, m_time0);
	DDX_DateTimeCtrl(pDX, IDC_DATE_1, m_date1);
	DDX_DateTimeCtrl(pDX, IDC_TIME_1, m_time1);
	DDX_Text(pDX, IDC_PRICHINA, m_prichina);
	DDX_Text(pDX, IDC_PRD_VER_1, m_prd_ver_1);
	DDX_Text(pDX, IDC_PRD_VER_0, m_prd_ver_0);
	DDX_Text(pDX, IDC_PRD_ID_0, m_prd_id_0);
	DDX_Text(pDX, IDC_PRD_ID_1, m_prd_id_1);
	DDX_Text(pDX, IDC_PRD_NAME_0, m_prd_name_0);
	DDX_Text(pDX, IDC_PRD_NAME_1, m_prd_name_1);
	DDX_Text(pDX, IDC_PI_ID_0, m_pi_id_0);
	DDX_Text(pDX, IDC_PI_ID_1, m_pi_id_1);
	DDX_Text(pDX, IDC_PI_SN_0, m_pi_sn_0);
	DDX_Text(pDX, IDC_PI_SN_1, m_pi_sn_1);
	DDX_Text(pDX, IDC_BASE_BP, m_base_bp);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPrdInstChangeDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CPrdInstChangeDlg)
	ON_BN_CLICKED(IDC_SELECT_PRD_INST, OnSelectPrdInst)
	ON_BN_CLICKED(IDC_SELECT_BP, OnSelectBp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrdInstChangeDlg message handlers

BOOL CPrdInstChangeDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();
	// TODO: Add extra initialization here
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	m_bp_names_ctrl.AddString(_T(""));
	m_bp_names_ctrl.AddString( APL_T("  "));
	m_bp_names_ctrl.AddString( APL_T("  "));

	ASSERT(m_api);


	CaplInstance *old_pi;
	CaplInstance *prd,*pdf;

	m_api->m_data.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_relating,m_par_pi);
	m_api->m_data.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_related,old_pi);

	if(m_new_pi!=0)
	{
		m_select_prd_inst.EnableWindow(FALSE);
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_id,m_pi_id_1);
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_sn,m_pi_sn_1);
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,pdf);
		if(pdf!=0)
		{
			m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_prd_id,m_prd_ver_1);
			m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_pdf_prd,prd);
			if(prd!=0)
			{
				m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,m_prd_id_1);
				m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,m_prd_name_1);
			}
		}
	}



	m_api->m_data.GetAttr(old_pi,m_api->m_prd_inst_mgr.a_prd_inst_id,m_pi_id_0);
	m_api->m_data.GetAttr(old_pi,m_api->m_prd_inst_mgr.a_prd_inst_sn,m_pi_sn_0);


	m_api->m_data.GetAttr(old_pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,pdf);
	m_old_pdf = pdf;
	if(pdf!=0)
	{
		m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_prd_id,m_prd_ver_0);
		m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_pdf_prd,prd);
		if(prd!=0)
		{
			m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,m_prd_id_0);
			m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,m_prd_name_0);
		}
	}
	


	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CPrdInstChangeDlg::OnOK() 
{
	// TODO: Add extra validation here
	if(!UpdateData(TRUE)) return;

	CString buf, s_odt_ins, s_odt_rem;
	COleDateTime odt_ins, odt_rem;
	CaplAggr aggr;

	odt_ins.SetDateTime(m_date1.GetYear(),m_date1.GetMonth(),m_date1.GetDay(),
				m_time1.GetHour(),m_time1.GetMinute(),m_time1.GetSecond());
	odt_rem.SetDateTime(m_date0.GetYear(),m_date0.GetMonth(),m_date0.GetDay(),
				m_time0.GetHour(),m_time0.GetMinute(),m_time0.GetSecond());

	if(odt_rem>odt_ins)
	{
		AfxMessageBox( APL_T("      !"));
		return;
	}

	m_new_pi_rel=apidata.CreateInstance(m_api->m_prd_inst_mgr.e_apl_component);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_relating,m_par_pi);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_related,m_new_pi);

	aplDate2String(odt_rem,s_odt_rem);
	aplDate2String(odt_ins,s_odt_ins);

	apidata.PutAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_removed,s_odt_rem);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_date_installed,s_odt_ins);
	

	apidata.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_id,buf);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_id,buf);
	apidata.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_name,buf);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_name,buf);
	apidata.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_descr,buf);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_descr,buf);

	apidata.GetAttr(m_src_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,aggr);
	apidata.PutAttr(m_new_pi_rel,m_api->m_prd_inst_mgr.a_prd_inst_rel_frames_of_reference,aggr);
		
	m_new_pi_change=m_api->m_data.CreateInstance(m_api->m_prd_inst_mgr.e_pi_subst);
	m_api->m_data.PutAttr(m_new_pi_change,m_api->m_prd_inst_mgr.a_pi_subst_predecessor,m_src_pi_rel);
	m_api->m_data.PutAttr(m_new_pi_change,m_api->m_prd_inst_mgr.a_pi_subst_successor,m_new_pi_rel);
	m_api->m_data.PutAttr(m_new_pi_change,m_api->m_prd_inst_mgr.a_pi_subst_reason,m_prichina);
	
	int cur = m_bp_names_ctrl.GetCurSel();
	if(cur>0)//   
	{
		CString id, name;
		aplDate2String(COleDateTime::GetCurrentTime(),id);
		m_bp_names_ctrl.GetLBText(cur, name);
		CaplInstance* BpInsrt = m_api->m_bp_mgr.CreateBPInst(0,id,name,_T(""),m_bp,m_par_pi,0,0,false);
		m_api->m_data.PutAttr(m_new_pi_change,m_api->m_prd_inst_mgr.a_pi_subst_bp, BpInsrt);
	}

	CaplTranslateDialog::OnOK();
}

void CPrdInstChangeDlg::OnSelectPrdInst() 
{
	if(!UpdateData(TRUE)) return;
	CSelectPrdInstDlg dlg;
	dlg.m_api = m_api;
	dlg.m_pdf = m_old_pdf;
	if(dlg.DoModal()==IDOK)
	{
		CaplInstance *pdf, *prd;
		m_new_pi = dlg.m_selected_prd_inst;
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_id,m_pi_id_1);
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_sn,m_pi_sn_1);
		m_api->m_data.GetAttr(m_new_pi,m_api->m_prd_inst_mgr.a_prd_inst_pdf,pdf);
		if(pdf!=0)
		{
			m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_prd_id,m_prd_ver_1);
			m_api->m_data.GetAttr(pdf,m_api->m_prd_mgr.a_pdf_prd,prd);
			if(prd!=0)
			{
				m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_id,m_prd_id_1);
				m_api->m_data.GetAttr(prd,m_api->m_prd_mgr.a_prd_name,m_prd_name_1);
			}
		}
	}
	UpdateData(FALSE);
}

void CPrdInstChangeDlg::OnSelectBp() 
{
	if(!UpdateData()) return;

	CaplInstance* pdf;
	m_api->m_data.GetAttr(m_par_pi, m_api->m_prd_inst_mgr.a_prd_inst_pdf, pdf);

	aplExtent ext;
	ext.Add(pdf);
	CaplInstance* inst = m_api->m_appr_mgr.SelectInstance(APL_MODE_SELECT_BP, 0, &ext);
	if(inst!=0)
	{
		m_bp = inst;
		m_api->GetItemName(m_bp,m_base_bp);
		UpdateData(FALSE);
	}
}
