// SelectName.cpp : implementation file
//

#include "stdafx.h"
#include "SelectName.h"
#include "SelectQuantity.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectName dialog

CSelectName::CSelectName(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSelectName::IDD, pParent)
{
	m_FileName=_T("");
	m_api=0;
	m_exch=0;
}


void CSelectName::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectName)
//	DDX_Control(pDX, IDC_CHECK1, m_check);
	DDX_Control(pDX, IDC_LISTNAME, m_listName);
	DDX_Text(pDX, IDC_FILE_NAME, m_FileName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectName, CResizableDialog)
	//{{AFX_MSG_MAP(CSelectName)
	ON_BN_CLICKED(IDOK, OnOk)
	ON_NOTIFY(NM_DBLCLK, IDC_LISTNAME, OnDblclkListname)
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_SELECT_ALL, OnSelectAll)
	ON_BN_CLICKED(IDC_DESELECT_ALL, OnDeselectAll)
	ON_BN_CLICKED(IDC_SELECT_NUM, OnSelectNum)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectName message handlers

BOOL CSelectName::OnInitDialog() 
{
	int k=0;
	if(m_exch==0 || m_api==0)return FALSE;
	
	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   
	aplExtent ext_org,ext_pers,ext_off;
	
	ListView_SetExtendedListViewStyle(m_listName.m_hWnd,
		ListView_GetExtendedListViewStyle(m_listName.m_hWnd)
			|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_CHECKBOXES|LVS_EX_INFOTIP);

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
//	AddAnchor(IDC_CHECK1, TOP_LEFT);
	AddAnchor(IDC_SELECT_ALL,TOP_LEFT);
	AddAnchor(IDC_DESELECT_ALL,TOP_LEFT);
	AddAnchor(IDC_SELECT_NUM,TOP_RIGHT);
	AddAnchor(IDC_STATIC_F,BOTTOM_LEFT);
	AddAnchor(IDC_FILE_NAME,BOTTOM_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDC_BROWSE,BOTTOM_RIGHT);
	AddAnchor(IDC_LISTNAME,TOP_LEFT, BOTTOM_RIGHT);


	m_listName.InsertColumn(0, _T("   ")     );
	m_listName.InsertColumn(1,  APL_T("") );
	m_listName.InsertColumn(2,  APL_T(""));

	m_listName.SetColumnWidth(0, 25);
	m_listName.SetColumnWidth(1, 180);
	m_listName.SetColumnWidth(2, 180);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrPersOrg);
	aplExtent ext, rels;
	//        -      
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_pers_org, m_all_arrPersOrg);
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_person, ext);
	m_all_arrPersOrg.Append(ext);
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_org, ext);
	m_all_arrPersOrg.Append(ext);
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_org_rel, rels);
	m_all_arrPersOrg.Append(rels);
	//          -  
	m_api->m_appr_mgr.GetAllSubPerson(NULL, ext, rels);
	m_all_arrPersOrg.Append(ext);


//	k=m_listName.InsertItem(++k,_T(""));
//	m_listName.SetItemText(k,1,APL_T(""));
//	m_listName.SetItemData(k,(long)&m_arrCat);
//	apidata.GetEntityExtent(m_api->m_categ_mgr.e_categ, m_all_arrCat);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrUnit);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_unit, m_all_arrUnit);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrChar);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact, m_all_arrChar);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrCharUnion);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_union, m_all_arrCharUnion);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrEntries);
	apidata.GetEntityExtent(m_api->m_doc_mgr.e_entry, m_all_arrEntries);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrDocT);
	apidata.GetEntityExtent(m_api->m_doc_mgr.e_dt, m_all_arrDocT);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrCharT);
	apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_type, m_all_arrCharT);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" -"));
	m_listName.SetItemData(k,(long)&m_arrBPT);
	apidata.GetEntityExtent(m_api->m_bp_mgr.e_bp_type, m_all_arrBPT);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrBPResT);
	apidata.GetEntityExtent(m_api->m_bp_mgr.e_bp_res_type, m_all_arrBPResT);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrContext);
	apidata.GetEntityExtent(m_api->m_bp_mgr.e_pd_context, m_all_arrContext);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrStat);
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_appr_status, m_all_arrStat);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrRole);
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_po_role, m_all_arrRole);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(" "));
	m_listName.SetItemData(k,(long)&m_arrProjectT);
	apidata.GetEntityExtent(m_api->m_project_mgr->e_project_type, m_all_arrProjectT);
	
	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrProf);
	apidata.GetEntityExtent(m_api->m_prd_mgr.e_assortment_shape, m_all_arrProf);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrSort);
	apidata.GetEntityExtent(m_api->m_prd_mgr.e_assortment, m_all_arrSort);

	k=m_listName.InsertItem(++k,_T(""));
	m_listName.SetItemText(k,1, APL_T(""));
	m_listName.SetItemData(k,(long)&m_arrLang);
	apidata.GetEntityExtent(m_api->m_prd_mgr.e_apl_language, m_all_arrLang);
	
	return TRUE;  
}

#define ADD_EXT2EXPORT(name_ext)extFull.Append(name_ext);count_saved+=name_ext.GetSize();

void CSelectName::OnOk() 
{
	int i,count_saved=0;
	CString OutPath;
	if(m_FileName.IsEmpty()){
		AfxMessageBox( APL_T("   !"));
		return;
	}
	i=m_FileName.ReverseFind(_T('\\'));
	if(i>0) OutPath=m_FileName.Left(i+1);

	for(i=0; i<m_listName.GetItemCount(); i++)
	{
		if(m_listName.GetCheck(i)==1)
		{
			aplExtent extFull,ext;
			CString name=m_listName.GetItemText(i,1);
			CString buf=m_listName.GetItemText(i,2);
			//        
			// (buf==_T(""))    
			if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrPersOrg);}
				else{ADD_EXT2EXPORT(m_arrPersOrg);extFull.Append(m_arrPersOrgRel);}
//			}else if(name==APL_T("")){
//				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrCat);}
//				else{ADD_EXT2EXPORT(m_arrCat);}
			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrUnit);}
				else{ADD_EXT2EXPORT(m_arrUnit);}
				//    - ,        
				apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_unit_group , ext);
				extFull.Append(ext);
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrChar);}
				else{ADD_EXT2EXPORT(m_arrChar);}
				//    - ,        
				apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_group , ext);
				extFull.Append(ext);
				//          
				apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_union_group,ext);
				extFull.Append(ext);
			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrCharUnion);}
				else{ADD_EXT2EXPORT(m_arrCharUnion);}
				//      
				apidata.GetEntityExtent(m_api->m_charact_mgr.e_apl_charact_union_group,ext);
				extFull.Append(ext);

			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrDocT);}
				else{ADD_EXT2EXPORT(m_arrDocT);}
				//     
				apidata.GetEntityExtent(m_api->m_doc_mgr.e_dt_group,ext);
				extFull.Append(ext);

				ext.Clear();
				apidata.GetEntityExtent(m_api->m_doc_mgr.e_dt_entry,ext);
				m_api->LoadExtentInfo(ext);
				extFull.Append(ext);

				ext.Clear();
				apidata.GetEntityExtent(m_api->m_doc_mgr.e_entry,ext);
				extFull.Append(ext);

			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrEntries);}
				else{ADD_EXT2EXPORT(m_arrEntries);}				
			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrCharT);}
				else{ADD_EXT2EXPORT(m_arrCharT);}
			}else if(name== APL_T(" -")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrBPT);}
				else{ADD_EXT2EXPORT(m_arrBPT);}
			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrBPResT);}
				else{ADD_EXT2EXPORT(m_arrBPResT);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrContext);}
				else{ADD_EXT2EXPORT(m_arrContext);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrStat);}
				else{ADD_EXT2EXPORT(m_arrStat);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrRole);}
				else{ADD_EXT2EXPORT(m_arrRole);}
			}else if(name== APL_T(" ")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrProjectT);}
				else{ADD_EXT2EXPORT(m_arrProjectT);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrProf);}
				else{ADD_EXT2EXPORT(m_arrProf);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrSort);}
				else{ADD_EXT2EXPORT(m_arrSort);}
			}else if(name== APL_T("")){
				if(buf==_T("")){ADD_EXT2EXPORT(m_all_arrLang);}
				else{ADD_EXT2EXPORT(m_arrLang);}
			}
			for(int j=0; j<extFull.GetSize();j++){
//				if(name==APL_T("")){
//					m_exch->ExportDocument(extFull[j],OutPath);
//					m_exch->ExportCharacteristic(extFull[j]);
//				}else 
				if(name== APL_T("")){
					m_exch->ExportDocument(extFull[j],OutPath);
					m_exch->ExportCharacteristic(extFull[j]);
				}
				LoadInstanceTree(extFull[j],m_arrCopy);
			}
		}
	}
	CaplMap map;
	m_exch->m_array.Append(m_arrCopy);
	m_exch->m_OutFile=m_FileName;
	
	if(m_exch->SaveArr2File())
	{
		CString buf;
		buf.Format( APL_T(" !\n : %d"), count_saved);
		AfxMessageBox(buf);
	}
	else
	{
		CString buf;
		buf= APL_T("   .\n")+m_exch->m_LastErrDescr;
		AfxMessageBox(buf);
	}

	CResizableDialog::OnOK();	
}

void CSelectName::OnSelectNum() 
{
	// TODO: Add your control notification handler code here
	CString name;
	int i;
	POSITION pos;
	pos=m_listName.GetFirstSelectedItemPosition();
	i=m_listName.GetNextSelectedItem(pos);
	
	if(i==-1) return;
	
	if(m_listName.GetCheck(i)==0)
		m_listName.SetCheck(i, true);
	
	name=m_listName.GetItemText( i, 1 );
	
	CaplSetResourceHandle setres(module_inst);
	
	CSelectQuantity dlg;
//	dlg.m_data=m_data;
	dlg.m_api=m_api;
	dlg.m_sel=name;
//	dlg.m_appr=m_appr;
//	dlg.m_catg=m_catg;
//	dlg.m_doc=m_doc;
//	dlg.m_prMan=m_prMan;
//	dlg.m_char=m_char;
	
	if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrPersOrg;
		dlg.ext=&m_arrPersOrg;
		dlg.ext_rel=&m_arrPersOrgRel;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrCat;
		dlg.ext=&m_arrCat;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrUnit;
		dlg.ext=&m_arrUnit;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrChar;
		dlg.ext=&m_arrChar;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrCharUnion;
		dlg.ext=&m_arrCharUnion;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrStat;
		dlg.ext=&m_arrStat;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrEntries;
		dlg.ext=&m_arrEntries;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrDocT;
		dlg.ext=&m_arrDocT;
	}
	else if(name== APL_T(" -"))
	{
		dlg.ext_all=&m_all_arrBPT;
		dlg.ext=&m_arrBPT;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrBPResT;
		dlg.ext=&m_arrBPResT;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrRole;
		dlg.ext=&m_arrRole;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrContext;
		dlg.ext=&m_arrContext;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrCharT;
		dlg.ext=&m_arrCharT;
	}
	else if(name== APL_T(" "))
	{
		dlg.ext_all=&m_all_arrProjectT;
		dlg.ext=&m_arrProjectT;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrProf;
		dlg.ext=&m_arrProf;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrSort;
		dlg.ext=&m_arrSort;
	}
	else if(name== APL_T(""))
	{
		dlg.ext_all=&m_all_arrLang;
		dlg.ext=&m_arrLang;
	}
	else return ;
	
	if(dlg.DoModal()==IDOK)
	{	
		CString buf;
		int size=dlg.ext->GetSize();
		
		if(size==0) 
		{
			buf=_T("");
			m_listName.SetItemText(i,2,buf);
		}
		else {buf.Format(_T("%i"),size);m_listName.SetItemText(i,2,buf);}
	}
}

void CSelectName::OnDblclkListname(NMHDR* pNMHDR, LRESULT* pResult) 
{
	OnSelectNum();

	*pResult = 0;
}

//void CSelectName::OnCheck1() 
//{
//	if(m_check.GetCheck()==1)
//		for(i=0; i<m_listName.GetItemCount(); i++)
//		{
//			m_listName.SetCheck(i,true);
//		}
//	else
//		for(i=0; i<m_listName.GetItemCount(); i++)
//		{
//			m_listName.SetCheck(i,false);
//		}
//
//	
//}
//
void CSelectName::OnSelectAll() 
{
	// TODO: Add your control notification handler code here
	for(int i=0; i<m_listName.GetItemCount(); i++)
	{
		m_listName.SetCheck(i,true);
	}
	
}

void CSelectName::OnDeselectAll() 
{
	// TODO: Add your control notification handler code here
	for(int i=0; i<m_listName.GetItemCount(); i++)
	{
		m_listName.SetCheck(i,false);
	}
	
	
}

void CSelectName::OnBrowse() 
{
	// TODO: Add your control notification handler code here
	CFileDialog dlg(FALSE,_T("std"),m_FileName,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
		_T("APL Data Files (*.std)|*.std|JSON Files (*.json)|*.json|APL Text Data Files (*.txt)|*.txt|P21 Files (*.stp)|*.stp|All Files (*.*)|*.*||"));
	if(dlg.DoModal()!=IDOK) return;
	m_FileName=dlg.GetPathName();
	UpdateData(FALSE);

}


