// SelectQuantity.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "SelectQuantity.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSelectQuantity dialog


CSelectQuantity::CSelectQuantity(CWnd* pParent /*=NULL*/)
	: CResizableDialog(CSelectQuantity::IDD, pParent)
{
	ext=0; ext_all=0;ext_rel=0;
	m_api=0;
}


void CSelectQuantity::DoDataExchange(CDataExchange* pDX)
{
	CResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSelectQuantity)
	DDX_Control(pDX, IDC_EXPAND_ALL, m_BtnExpandAll);
	DDX_Control(pDX, IDC_COLLAPSE_ALL, m_BtnCollapseAll);
	DDX_Control(pDX, IDC_LISTQUANT, m_listQuant);
	DDX_Control(pDX, IDC_TREE1, m_tree);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSelectQuantity, CResizableDialog)
	//{{AFX_MSG_MAP(CSelectQuantity)
	ON_BN_CLICKED(IDC_SELECT_ALL, OnSelectAll)
	ON_BN_CLICKED(IDC_DESELECT_ALL, OnDeselectAll)
	ON_BN_CLICKED(IDC_EXPAND_ALL, OnExpandAll)
	ON_BN_CLICKED(IDC_COLLAPSE_ALL, OnCollapseAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSelectQuantity message handlers

BOOL CSelectQuantity::OnInitDialog() 
{
	if(m_api==0)return FALSE;

	CResizableDialog::OnInitDialog();
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   


	CString buffer;
//	CaplInstance *pers,*org,*official,*inst;
	
	ListView_SetExtendedListViewStyle(m_listQuant.m_hWnd,
		ListView_GetExtendedListViewStyle(m_listQuant.m_hWnd)
			|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_CHECKBOXES|LVS_EX_INFOTIP);

	m_listQuant.InsertColumn(0, _T(""));
	m_listQuant.SetColumnWidth(0, 25);
	CRect rect;
	CaplInstance* inst;
	int i,j,k;

	m_listQuant.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_tree.MoveWindow(&rect);

	CImageList* imageList;
	CaplSetResourceHandle setres(module_inst);
	
	imageList=aplGetInstImageList();
	m_tree.SetImageList(imageList, TVSIL_NORMAL);

	m_tree.m_il_chek.Create(IDR_TB_CHEK, 16, 5, RGB(255,0,255));
	m_tree.SetImageList(&(m_tree.m_il_chek), TVSIL_STATE);
	

	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_LISTQUANT,TOP_LEFT, BOTTOM_RIGHT);
	AddAnchor(IDC_TREE1,TOP_LEFT, BOTTOM_RIGHT);
	
	AddAnchor(IDC_EXPAND_ALL,TOP_RIGHT);
	AddAnchor(IDC_COLLAPSE_ALL,TOP_RIGHT);
	

///////////////////////////////////////////////////////
	if(m_sel== APL_T(""))
	{		
		m_tree.ShowWindow(SW_NORMAL);
		m_listQuant.ShowWindow(SW_HIDE);

		m_BtnExpandAll.ShowWindow(SW_NORMAL);
		m_BtnCollapseAll.ShowWindow(SW_NORMAL);

		m_tree.SetRedraw(FALSE);
		
		aplExtent ext, rels;
		m_api->m_appr_mgr.GetAllSubOrganization((CaplInstance*)0, ext, &rels);
		for(i=0; i<ext.GetSize();i++){InsertItemInTree(new SSelectQuantityItemData(ext[i],0),TVI_ROOT);}
		m_api->m_appr_mgr.GetAllSubPerson(NULL, ext, rels);
		for(i=0; i<ext.GetSize();i++){InsertItemInTree(new SSelectQuantityItemData(ext[i],0),TVI_ROOT);}


//////////////////////////////// 
//		m_listQuant.InsertColumn(1, APL_T(""));
//		m_listQuant.SetColumnWidth(1, 150);
//		m_listQuant.InsertColumn(2, APL_T(""));
//		m_listQuant.SetColumnWidth(2, 150);
//		m_listQuant.InsertColumn(3, APL_T(""));
//		m_listQuant.SetColumnWidth(3, 150);

//		for(i=0; i<ext_all->GetSize();i++)
//		{
//			pers=0;org=0;official=0;
//			k=m_listQuant.InsertItem(-1,_T(""));
//			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
//
//			if(apidata.IsKindOf((*ext_all)[i],m_api->m_appr_mgr.e_pers_org)){
//				apidata.GetAttr((*ext_all)[i],m_api->m_appr_mgr.a_po_the_org, org);
//				apidata.GetAttr((*ext_all)[i],m_api->m_appr_mgr.a_po_the_pers, inst);
//				if(apidata.IsKindOf(inst,m_api->m_appr_mgr.e_person)){pers=inst;}
//				else if(apidata.IsKindOf(inst,m_api->m_appr_mgr.e_official)){official=inst;}
//				
//			}else if(apidata.IsKindOf((*ext_all)[i],m_api->m_appr_mgr.e_person)){
//				pers=(*ext_all)[i];
//			}else if(apidata.IsKindOf((*ext_all)[i],m_api->m_appr_mgr.e_org)){
//				org=(*ext_all)[i];
//			}else if(apidata.IsKindOf((*ext_all)[i],m_api->m_appr_mgr.e_official)){
//				official=(*ext_all)[i];
//			}
//			if(org!=0){
//				m_api->m_appr_mgr.GetItemName(org,buffer);
//				//apidata.GetAttr(org,m_api->m_appr_mgr.a_org_name, buffer);
//			}else{buffer=_T("");}
//			m_listQuant.SetItemText(k,1,buffer);
//
//			if(pers!=0){
//				//apidata.GetAttr(inst,m_api->m_appr_mgr.a_pers_first_name, buffer);
//				//apidata.GetAttr(inst,m_api->m_appr_mgr.a_pers_last_name, buffer);
//				//m_listQuant.SetItemText(k,3,buffer);
//				m_api->m_appr_mgr.GetItemName(pers,buffer);
//			}else{buffer=_T("");}
//			m_listQuant.SetItemText(k,2,buffer);
//			
//			if(official!=0){
//				m_api->m_appr_mgr.GetItemName(official,buffer);
//			}else{buffer=_T("");}
//			m_listQuant.SetItemText(k,3,buffer);
//			
//
//		}

		m_tree.SelectSetFirstVisible(m_tree.GetNextItem(TVI_ROOT,TVGN_CHILD));
		m_tree.SetRedraw(TRUE);

	}
///////////////////////////////////////////////////////////////
//	else if(m_sel==APL_T(""))
//	{
//		m_listQuant.InsertColumn(1, APL_T(""));
//		m_listQuant.SetColumnWidth(1, 200);
//		m_listQuant.InsertColumn(2, APL_T(""));
//		m_listQuant.SetColumnWidth(2, 200);
//
//		for(i=0; i<ext_all->GetSize();i++)
//		{
//			k=m_listQuant.InsertItem(-1,_T(""));
//			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
//			apidata.GetAttr((*ext_all)[i],m_api->m_categ_mgr.a_categ_id, buffer);
//			m_listQuant.SetItemText(k,1,buffer);
//			apidata.GetAttr((*ext_all)[i],m_api->m_categ_mgr.a_categ_name, buffer);
//			m_listQuant.SetItemText(k,2,buffer);
//		}
//	}
/////////////// ///////////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);
		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttrBN((*ext_all)[i],_T("id"), buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttrBN((*ext_all)[i],_T("name"), buffer);
			m_listQuant.SetItemText(k,2,buffer);

		}
	}
//////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);
		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 200);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttrBN((*ext_all)[i],_T("id"), buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttrBN((*ext_all)[i],_T("name"), buffer);
			m_listQuant.SetItemText(k,2,buffer);
		}
	}
///////////////// /////////////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);
		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 200);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttrBN((*ext_all)[i],_T("id"), buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttrBN((*ext_all)[i],_T("name"), buffer);
			m_listQuant.SetItemText(k,2,buffer);
		}
	}
//////////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_appr_mgr.a_appr_status_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
//////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 150);

		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_doc_mgr.a_entry_id, buffer);
			m_listQuant.SetItemText(k,1,buffer);

			apidata.GetAttr((*ext_all)[i],m_api->m_doc_mgr.a_entry_name, buffer);
			m_listQuant.SetItemText(k,2,buffer);
		}
	}
///////////// /////////////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_doc_mgr.a_dt_pdt, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
/////////////  /////////////////////////////////////////
	else if(m_sel== APL_T(" -"))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_bp_mgr.a_bp_type_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
/////////////  /////////////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_bp_mgr.a_bp_res_type_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
////////////////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		CaplAttr  *attr;
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);
		ent=apidata.GetEntityBN(_T("person_and_organization_role"));
		attr=apidata.GetAttrDefinition(ent,_T("name"));
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			if((*ext_all)[i]==0) continue;
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],attr, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
////////////////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 150);
		m_listQuant.InsertColumn(2,  APL_T("  "));
		m_listQuant.SetColumnWidth(2, 150);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			if((*ext_all)[i]==0) continue;
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_bp_mgr.a_pd_context_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttr((*ext_all)[i],m_api->m_bp_mgr.a_pd_context_life_cycle_stage, buffer);
			m_listQuant.SetItemText(k,2,buffer);
		}
	}
/////////////// /////////////////////////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			if((*ext_all)[i]==0) continue;
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_project_mgr->a_project_type_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
/////////////// /////////////////////////////////
	else if(m_sel== APL_T(" "))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 200);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_charact_mgr.a_apl_charact_type_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}
///////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 150);
		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 150);
		m_listQuant.InsertColumn(3,  APL_T(" "));
		m_listQuant.SetColumnWidth(3, 150);

		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_shape_id, buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_shape_name, buffer);
			m_listQuant.SetItemText(k,2,buffer);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_shape_unit, inst);
			if(inst==0) continue;
			apidata.GetAttrBN(inst,_T("name"), buffer);
			m_listQuant.SetItemText(k,3,buffer);
		}
	}
/////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 150);
		m_listQuant.InsertColumn(2,  APL_T(""));
		m_listQuant.SetColumnWidth(2, 150);
		m_listQuant.InsertColumn(3,  APL_T(""));
		m_listQuant.SetColumnWidth(3, 150);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_id, buffer);
			m_listQuant.SetItemText(k,1,buffer);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_name, buffer);
			m_listQuant.SetItemText(k,2,buffer);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_assortment_std, buffer);
			m_listQuant.SetItemText(k,3,buffer);
		}
	}
/////////////////////////////////////////////////////////
	else if(m_sel== APL_T(""))
	{
		m_listQuant.InsertColumn(1,  APL_T(""));
		m_listQuant.SetColumnWidth(1, 150);
		
		for(i=0; i<ext_all->GetSize();i++)
		{
			k=m_listQuant.InsertItem(-1,_T(""));
			m_listQuant.SetItemData(k,(long)(*ext_all)[i]);
			apidata.GetAttr((*ext_all)[i],m_api->m_prd_mgr.a_apl_language_name, buffer);
			m_listQuant.SetItemText(k,1,buffer);
		}
	}

	for(i=0; i<m_listQuant.GetItemCount();i++)
	{
		CaplInstance * tempInst=(CaplInstance *)m_listQuant.GetItemData(i);
		for(j=0;j<ext->GetSize();j++)
		{
			if(tempInst!=(*ext)[j]) continue;
			m_listQuant.SetCheck(i,true);
			break;
		}
	}
	return TRUE;  
}

void CSelectQuantity::InsertItemInTree(SSelectQuantityItemData* data,HTREEITEM parent) 
{
	if(data==0)return;
	if(data->inst==0)return;
	aplExtent ext_sub,rels_sub,ext,rels;
	CaplInstance* inst=0;
	int i=0;
	int num_icon;
	CString name;
	all_item.Add(data);

	ext_sub.Clear();
	if(apidata.IsKindOf(data->inst,m_api->m_appr_mgr.e_org)){
		m_api->m_appr_mgr.GetAllSubOrganization(data->inst, ext, &rels);
		ext_sub.Append(ext);
		rels_sub.Append(rels);
		m_api->m_appr_mgr.GetAllSubPerson(data->inst, ext, rels);
		ext_sub.Append(ext);
		rels_sub.Append(rels);
//	}else if(apidata.IsKindOf(data->inst,m_api->m_appr_mgr.e_pers_org)){
//		apidata.GetAttr(item,m_api->m_appr_mgr.a_po_the_pers, inst);
//	}else if(apidata.IsKindOf(data->inst,m_api->m_appr_mgr.e_person)){
//		inst=item;
//	}else if(apidata.IsKindOf(data->inst,m_api->m_appr_mgr.e_org)){
//		inst=item;
//	}else if(apidata.IsKindOf(item,m_api->m_appr_mgr.e_official)){
//		inst=item;
//	}else{
//		return;
	}

	num_icon=m_api->GetInstIco(data->inst);
	if(num_icon==-1)num_icon=ICON_FILE;
	m_api->GetItemName(data->inst,name);

	data->item=m_tree.InsertItem(name,num_icon,num_icon,parent);
	m_tree.SetItemData(data->item,(long)inst);

	for(i=0;i<ext_sub.GetSize();i++){
		InsertItemInTree(new SSelectQuantityItemData(ext_sub[i],rels_sub[i]),data->item);
	}
	if(ext_sub.GetSize()>0){
		m_tree.Expand(data->item,TVE_EXPAND);
	}
}

void CSelectQuantity::OnOK() 
{
	CaplInstance* inst;
	ext->Clear();
	if(ext_rel!=0){
		ext_rel->Clear();
	}
	if(m_sel== APL_T(""))
	{		
		for(int i=0; i<all_item.GetSize(); i++)
		{
			if(all_item[i]->item!=0){
				if(m_tree.GetCheck(all_item[i]->item)){
					ext->Add(all_item[i]->inst);
					if(ext_rel!=0){
						ext_rel->Add(all_item[i]->parent_rel);
					}
				}
			}
		}
	}else{
		for(int i=0;i<m_listQuant.GetItemCount();i++)
		{
			if(m_listQuant.GetCheck(i)==1)
			{
				inst=(CaplInstance *)m_listQuant.GetItemData(i);
				ext->Add(inst);
			}		
		}
	}
	CResizableDialog::OnOK();
}

//void CSelectQuantity::OnCheck1() 
//{
//	if(m_check.GetCheck()==1)
//		for(i=0; i<m_listQuant.GetItemCount(); i++)
//		{
//			m_listQuant.SetCheck(i,true);
//		}
//	else
//		for(i=0; i<m_listQuant.GetItemCount(); i++)
//		{
//			m_listQuant.SetCheck(i,false);
//		}
//	
//}

void CSelectQuantity::OnSelectAll() 
{
	// TODO: Add your control notification handler code here
	if(m_sel== APL_T(""))
	{	
		for(int i=0; i<all_item.GetSize(); i++)
		{
			if(all_item[i]->item!=0){
				m_tree.SetCheck(all_item[i]->item,TRUE);
			}
		}
	}else{
		for(int i=0; i<m_listQuant.GetItemCount(); i++)
		{
			m_listQuant.SetCheck(i,true);
		}
	}
}

void CSelectQuantity::OnDeselectAll() 
{
	// TODO: Add your control notification handler code here
	if(m_sel== APL_T(""))
	{	
		for(int i=0; i<all_item.GetSize(); i++)
		{
			if(all_item[i]->item!=0){
				m_tree.SetCheck(all_item[i]->item,FALSE);
			}
		}
	}else{
		for(int i=0; i<m_listQuant.GetItemCount(); i++)
		{
			m_listQuant.SetCheck(i,false);
		}
	}
}

void CSelectQuantity::OnExpandAll() 
{
	// TODO: Add your control notification handler code here
	for(int i=0; i<all_item.GetSize(); i++)
	{
		if(all_item[i]->item!=0){
			m_tree.Expand(all_item[i]->item,TVE_EXPAND);
		}
	}
}

void CSelectQuantity::OnCollapseAll() 
{
	// TODO: Add your control notification handler code here
	for(int i=0; i<all_item.GetSize(); i++)
	{
		if(all_item[i]->item!=0){
			m_tree.Expand(all_item[i]->item,TVE_COLLAPSE);
		}
	}
}
