// ShowAlertsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ShowAlertsDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CShowAlertsDlg dialog

CShowAlertsDlg::CShowAlertsDlg(CWnd* pParent /*=NULL*/)
	: CaplResizableDialog(CShowAlertsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CShowAlertsDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_api=0;
	m_tree_view=0;
	m_read_only=false;
	m_bSelectOutOfBoundsProjects=true;
	m_mode=APL_MODE_RECIEVED;
	m_alerts_ctrl.SetUniqueName(_T("CShowAlertsDlg"));
	m_cur_person=0;
	m_bIsAdmin=false;
}


void CShowAlertsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CShowAlertsDlg)
	DDX_Control(pDX, IDC_BORDER, m_border_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_TAB, m_tab_ctrl);
	DDX_Control(pDX, IDC_SHOW_COMPLETED, m_show_completed_check);
	DDX_Control(pDX, IDC_ADD, m_add_btn);
	DDX_Control(pDX, IDC_DELETE, m_delete_btn);
	DDX_Control(pDX, IDC_PROPERTIES, m_properties_btn);
	
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CShowAlertsDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CShowAlertsDlg)
	ON_WM_CONTEXTMENU()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_NOTIFY(NM_DBLCLK, IDS_ALERTS_CTRL, OnDblclkItem)
	ON_BN_CLICKED(IDC_SHOW_COMPLETED, OnShowCompleted)
	ON_BN_CLICKED(IDC_ADD, OnAddBtn)
	ON_BN_CLICKED(IDC_DELETE, OnDeleteBtn)
	ON_BN_CLICKED(IDC_PROPERTIES, OnPropertiesBtn)
	ON_NOTIFY(LVN_ITEMCHANGED, IDS_ALERTS_CTRL, OnSelChangedAlert)

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CShowAlertsDlg message handlers

BOOL CShowAlertsDlg::OnInitDialog() 
{
	CaplResizableDialog::OnInitDialog();
	if(m_api==NULL)
	{
		EndDialog(0);
		return FALSE;
	}

	//         aplSocketTransport
	CORRECT_LOOSE_MODAL_ON_CLASS(&(m_api->m_data));
	
	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	
	RECT rect={5,5,10,10};
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect); 
		
	m_alerts_ctrl.Create(WS_VISIBLE|WS_CHILD|WS_BORDER|LVS_SHOWSELALWAYS,rect,this,IDS_ALERTS_CTRL);
	
	m_border_ctrl.GetWindowRect(&rect);
	ScreenToClient(&rect);
	m_alerts_ctrl.MoveWindow(&rect);

	ListView_SetExtendedListViewStyle(m_alerts_ctrl.m_hWnd,
		ListView_GetExtendedListViewStyle(m_alerts_ctrl.m_hWnd)
			|LVS_EX_UNDERLINECOLD|LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	AddAnchor(IDC_TAB,TOP_LEFT);
	AddAnchor(IDC_ALERT_TREE_VIEW,TOP_LEFT,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	AddAnchor(IDC_SHOW_COMPLETED,BOTTOM_LEFT);
	AddAnchor(IDC_ADD,TOP_RIGHT);
	AddAnchor(IDC_DELETE,TOP_RIGHT);
	AddAnchor(IDC_PROPERTIES,TOP_RIGHT);

	m_add_btn.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_add_btn.SetTooltipText( APL_T(" "));
	m_add_btn.SetFlat(FALSE);
	m_delete_btn.SetIcon(GetAplTableIco(APL_TABLE_DEL));
	m_delete_btn.SetTooltipText( APL_T(" "));
	m_delete_btn.SetFlat(FALSE);
	m_properties_btn.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_properties_btn.SetTooltipText( APL_T(" "));
	m_properties_btn.SetFlat(FALSE);

	m_show_completed_check.SetCheck(1);

	m_cur_person=m_api->m_message_mgr.GetCurrentPerson();

	int tab_count=0;
	CString query = _T("");
	m_bIsAdmin=m_api->m_message_mgr.IsAdmin();

	CString person_id=_T("");
	if(m_cur_person && m_cur_person->GetId()) 
	{
		m_tab_ctrl.InsertItem(tab_count, APL_T(""));tab_count++;
		m_tab_ctrl.InsertItem(tab_count, APL_T(""));tab_count++;

		CString buf=_T("");
		m_api->m_message_mgr.GetItemName(m_cur_person,buf);
		SetWindowText( APL_T(" : ")+buf);
		person_id.Format(_T("%d"),m_cur_person->GetId());
		CString query = _T("");
		query = _T("SELECT Ext FROM Ext {apl_alert.person= #")+person_id+_T("} END_SELECT");
		m_api->m_data.NET_QueryEditParse(query);
		m_api->m_data.NET_QueryExecute(m_rec_alerts, APL_T("  "));
		m_api->m_message_mgr.LoadAlertsInfo(m_rec_alerts);

		query = _T("SELECT Ext FROM Ext {apl_alert.author= #")+person_id+_T("} END_SELECT");
		m_api->m_data.NET_QueryEditParse(query);
		m_api->m_data.NET_QueryExecute(m_given_alerts, APL_T("  "));
		m_api->m_message_mgr.LoadAlertsInfo(m_given_alerts);
		
	}
	else
	{
		AfxMessageBox( APL_T("     !"));
		if(m_bIsAdmin) m_mode=APL_MODE_ADMIN;
		else m_read_only=true;
	}
	if(m_bIsAdmin) 
	{
		m_tab_ctrl.InsertItem(tab_count, APL_T(""));

		query = _T("SELECT Ext FROM Ext {apl_alert.alert_text LIKE ''} END_SELECT");
		m_api->m_data.NET_QueryEditParse(query);
		m_api->m_data.NET_QueryExecute(m_all_alerts, APL_T("  "));
		m_api->m_message_mgr.LoadAlertsInfo(m_all_alerts);
	}
	SetTablesColumns();
	UpdateAlertsList();
	EnableButtons();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CShowAlertsDlg::CreateItem(CaplInstance *alert,const char *id)
{
	if(!alert) return;
	CString id_s=_T("");
	if(id) id_s=id;
	else m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_text,id_s);
	
	
	int new_item=m_alerts_ctrl.InsertItem(0,id_s);
	m_alerts_ctrl.SetItemData(new_item,(long)alert);

	RefreshItem(new_item);
}


void CShowAlertsDlg::UpdateAlertsList()
{
	LockWindowUpdate();
	long trd=aplStartWaitDlg( APL_T("  "));
	m_alerts_ctrl.DeleteAllItems();

	CString buf=_T("");

	aplExtent *ext;
	if(m_mode==APL_MODE_ADMIN) ext=&m_all_alerts;
	else if(m_mode==APL_MODE_RECIEVED) ext=&m_rec_alerts;
	else ext=&m_given_alerts;
	bool show_completed=false;
	if(m_show_completed_check.GetCheck()) show_completed=true;
	for(int i=0;i<ext->GetSize();i++)
	{
		CaplInstance *alert=ext->GetAt(i);
		if(alert->GetType()==0) continue;
		if(alert->GetAccessmode()>aplRO) continue;
		if(!show_completed)
		{
			m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_state,buf);
			if(buf!=CString(m_api->m_message_mgr.m_alert_state_active)) continue;
		}
		CreateItem((ext->GetAt(i)));
	}
	
	


/*	//  
	for(i=0;i<m_tree_view->m_tree.GetColumnsNum();i++)
	{
		m_tree_view->m_tree.m_wndHeader.SetItemImage(i, -1);
	}
	m_tree_view->m_tree.m_wndHeader.SetItemImage(1, 0);
	m_tree_view->m_tree.SortItems(1, true, NULL);
	m_tree_view->SortTree(1, true, m_tree_view->m_tree.GetRootItem());
	m_tree_view->m_tree.UpdateWindow();*/

	aplEndWaitDlg(trd);
	UnlockWindowUpdate();
	
}

void CShowAlertsDlg::RefreshItem(int nItem)
{
	if(nItem<0) return;
	CaplInstance *alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
	if(!alert) return;
	if(alert->GetAccessmode()>aplRO)return;

	//m_tree_view->m_tree.SetItemColor(hItem,RGB(0,0,0),false);
	
	
	CString buf=_T(""),perf_date=_T("");
	//m_tree_view->m_tree.SetItemImage(hItem,1,1);
	int count=0;
	
	CaplInstance *person=0,*author=0,*recipient=0;
	if(m_mode==APL_MODE_ADMIN)
	{
		m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_author,author);
		if(author) m_api->GetItemName(author,buf);
		//if(author==m_cur_person) buf=APL_T("");
		m_alerts_ctrl.SetItemText(nItem, count, buf);count++;
		m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_person,recipient);
		if(recipient) m_api->GetItemName(recipient,buf);
		//if(recipient==m_cur_person) buf=APL_T("");
		m_alerts_ctrl.SetItemText(nItem, count, buf);count++;
	}
	else
	{
		if(m_mode==APL_MODE_RECIEVED) m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_author,person);
		else m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_person,person);
		if(person) m_api->GetItemName(person,buf);
		//if(person==m_cur_person) buf=APL_T("");
		m_alerts_ctrl.SetItemText(nItem, count, buf);count++;
	}

	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_text,buf);
	m_alerts_ctrl.SetItemText(nItem, count, buf);count++;
	
	COleDateTime dt;
	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_date,perf_date);	
	if(perf_date!=_T(""))
	{
		aplString2Date(perf_date,dt);
		if(dt.GetStatus()==COleDateTime::valid)	
		{
			buf=dt.Format(_T("%d.%m.%Y  %H:%M"));
			m_alerts_ctrl.SetItemText(nItem,count,buf);
		}
	}
	count++;

	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_next_date,buf);	
	if(buf!=_T(""))
	{
		aplString2Date(buf,dt);
		if(dt.GetStatus()==COleDateTime::valid)	
		{
			buf=dt.Format(_T("%d.%m.%Y  %H:%M"));
			m_alerts_ctrl.SetItemText(nItem,count,buf);
		}
	}
	count++;

	COleDateTimeSpan dt_span;
	double span=0;
	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_span,span);	
	dt_span=span;
	if(dt_span.GetStatus()==COleDateTimeSpan::valid)
	{
		buf=dt_span.Format(_T("%H:%M"));
		m_alerts_ctrl.SetItemText(nItem,count,buf);
	}
	count++;

	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_state,buf);
	if(buf==_T("")) buf=CString(m_api->m_message_mgr.m_alert_state_active);
	m_alerts_ctrl.SetItemText(nItem, count, CaplTranslate::Translate(buf));count++;
/*	if(m_bSelectOutOfBoundsProjects)
	{
		COleDateTime cur_dt=COleDateTime::GetCurrentTime();
		CString cur_date=_T("");
		cur_dt.SetDateTime(cur_dt.GetYear(),cur_dt.GetMonth(),cur_dt.GetDay(),0,0,0);
		aplDate2String(cur_dt,cur_date);
		if(cur_date>perf_date && perf_date!=_T(""))
		{
			//m_tree_view->m_tree.SetItemColor(hItem,RGB(255,0,0),false);
		}
	}*/

}

void CShowAlertsDlg::OnDblclkItem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
	LPNMITEMACTIVATE lpnmitem = (LPNMITEMACTIVATE) pNMHDR;
	if(lpnmitem==0) return;
	int nItem=lpnmitem->iItem;
	if(nItem<0) return;
	CaplInstance *alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
	if(!alert) return;
	ShowProperties(alert,nItem);
}

bool CShowAlertsDlg::ShowProperties(CaplInstance *alert,int nItem)
{
	if(!alert) return false;
	if(nItem<0) return false;
	if(alert->GetAccessmode()>aplRO) return false;
	CString state=_T("");
	bool show_completed=false;
	if(m_show_completed_check.GetCheck()) show_completed=true;
	CaplInstance *old_author=0,*author=0,*old_recipient=0,*recipient=0;
	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_author,old_author);
	m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_person,old_recipient);
	if(m_api->m_message_mgr.ShowAlertProperties(alert)) 
	{
		if(alert->GetType()==0) 
		{
			m_alerts_ctrl.DeleteItem(nItem);
		}
		else
		{
			m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_author,author);
			m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_person,recipient);
			if(m_cur_person==author && author!=old_author) m_given_alerts.Add(alert);
			if(m_cur_person==recipient && recipient!=old_recipient) m_rec_alerts.Add(alert);
			if(author!=old_author)
			{
				if(m_cur_person!=author) 
				{
					m_given_alerts.Remove(m_given_alerts.Find(alert));
					if(m_mode==APL_MODE_GIVEN) 
					{
						m_alerts_ctrl.DeleteItem(nItem);
						return true;
					}
				}
			}
			if(recipient!=old_recipient)
			{
				if(m_cur_person!=recipient) 
				{
					m_rec_alerts.Remove(m_rec_alerts.Find(alert));
					if(m_mode==APL_MODE_RECIEVED) 
					{
						m_alerts_ctrl.DeleteItem(nItem);
						return true;
					}
				}
			}
			m_api->m_data.GetAttr(alert,m_api->m_message_mgr.a_alert_state,state);
			if(!show_completed && state==CString(m_api->m_message_mgr.m_alert_state_completed)) 
			{
				m_alerts_ctrl.DeleteItem(nItem);
			}
			else
			{
				RefreshItem(nItem);
			}
		}
		return true;
	}
	return false;
}

void CShowAlertsDlg::SetTablesColumns()
{
	int count=0;
	m_alerts_ctrl.DeleteAllColumns();

	if(m_mode==APL_MODE_ADMIN)
	{
		m_alerts_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, 80);count++;
		m_alerts_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, 80);count++;
		m_alerts_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, 150);count++;
	}
	else
	{
		if(m_mode==APL_MODE_GIVEN) m_alerts_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, 100);
		else m_alerts_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, 100);
		count++;
		m_alerts_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, 200);count++;
	}

	m_alerts_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, 110);count++;
	m_alerts_ctrl.SetColumnDate(count);
	m_alerts_ctrl.InsertColumn(count,  APL_T(" c "), LVCFMT_LEFT, 110);count++;
	m_alerts_ctrl.SetColumnDate(count);
	m_alerts_ctrl.InsertColumn(count,  APL_T(" "), LVCFMT_LEFT, 90);count++;
	m_alerts_ctrl.SetColumnNumeric(count);
	m_alerts_ctrl.InsertColumn(count,  APL_T(""), LVCFMT_LEFT, 80);count++;
	
}

void CShowAlertsDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	if(m_read_only) return;
	int i=0;

	int nItem=m_alerts_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_alert=0,*author=0,*recipient=0;
	CString state=_T("");
	if(nItem>=0)  
	{
		sel_alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
		if(sel_alert) 	
		{
			m_api->m_data.GetAttr(sel_alert,m_api->m_message_mgr.a_alert_state,state);
			if(state==_T("")) state=CString(m_api->m_message_mgr.m_alert_state_active);
			m_api->m_data.GetAttr(sel_alert,m_api->m_message_mgr.a_alert_author,author);
			m_api->m_data.GetAttr(sel_alert,m_api->m_message_mgr.a_alert_person,recipient);
		}
		
	}

    CMenu menu;CMenu* pPopup;
    VERIFY(menu.LoadMenu(IDR_CONTEXT_MENU));

	pPopup = menu.GetSubMenu(9);

	if(sel_alert)
	{
		//pPopup->EnableMenuItem(ID_CREATE_ALERT, MF_BYCOMMAND | MF_GRAYED);
		if(state==m_api->m_message_mgr.m_alert_state_active) pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		else pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		if(m_mode!=APL_MODE_ADMIN)
		{
			if(author!=m_cur_person)
			{
				pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
				//if(state==m_api->m_message_mgr.m_alert_state_completed) pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
			}
		}
	}
	else
	{
		pPopup->RemoveMenu(ID_MARK_COMPLETED, MF_BYCOMMAND);
		pPopup->RemoveMenu(ID_MARK_ACTIVE, MF_BYCOMMAND);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES, MF_BYCOMMAND | MF_GRAYED);
		pPopup->EnableMenuItem(ID_DELETE, MF_BYCOMMAND | MF_GRAYED);
	}

	CaplMenu::Install(this);

	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON |TPM_RETURNCMD,	point.x, point.y,this); // use main window for cmds

	bool show_completed=false;
	if(m_show_completed_check.GetCheck()) show_completed=true;
	switch(res)
	{
		case ID_CREATE_ALERT:
			{
				CreateAlert();
			}
			break;
		case ID_SHOW_PROPERTIES:
			{
				ShowProperties(sel_alert,nItem);
			}
			break;
		case ID_DELETE:
			{
				DeleteAlert(sel_alert,nItem);
			}
			break;
		case ID_MARK_COMPLETED:
			{
				if(m_api->m_message_mgr.SetAlertState(sel_alert,m_api->m_message_mgr.m_alert_state_completed))
				{
					if(sel_alert->GetType()==0 || !show_completed) m_alerts_ctrl.DeleteItem(nItem);
					else RefreshItem(nItem);
				}
			}
			break;
		case ID_MARK_ACTIVE:
			{
				if(m_api->m_message_mgr.SetAlertState(sel_alert,m_api->m_message_mgr.m_alert_state_active))
				{
					RefreshItem(nItem);
				}
			}
			break;
		default:break;
	}	
	
}


void CShowAlertsDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	*pResult = 0;
	int pos=m_tab_ctrl.GetCurSel();

	if(pos==0) m_mode=APL_MODE_RECIEVED;
	else if(pos==1) m_mode=APL_MODE_GIVEN;
	else if(pos==2) m_mode=APL_MODE_ADMIN;
	SetTablesColumns();
	UpdateAlertsList();
	EnableButtons();

}

void CShowAlertsDlg::EnableButtons()
{
	m_add_btn.EnableWindow(true);
	m_delete_btn.EnableWindow(true);
	m_properties_btn.EnableWindow(true);
	if(m_read_only) 
	{
		m_add_btn.EnableWindow(false);
		m_delete_btn.EnableWindow(false);
		m_properties_btn.EnableWindow(false);
		return;
	}
	int i=0;

	int nItem=m_alerts_ctrl.GetNextItem(-1,LVNI_SELECTED);
	CaplInstance *sel_alert=0,*author=0,*recipient=0;
	if(nItem>=0)  
	{
		sel_alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
		
		if(m_api->m_data.IsMyInstance(sel_alert, true))
		{
			if(sel_alert) 	
			{
				m_api->m_data.GetAttr(sel_alert,m_api->m_message_mgr.a_alert_author,author);
				m_api->m_data.GetAttr(sel_alert,m_api->m_message_mgr.a_alert_person,recipient);
			}
		}
	}

	if(sel_alert)
	{
		if(m_mode!=APL_MODE_ADMIN)
		{
			if(author!=m_cur_person)
			{
				m_delete_btn.EnableWindow(false);
			}
		}
	}
	else
	{
		m_delete_btn.EnableWindow(false);
		m_properties_btn.EnableWindow(false);
	}
}

void CShowAlertsDlg::OnAddBtn()
{
	CreateAlert();
}

void CShowAlertsDlg::OnDeleteBtn()
{
	int nItem=m_alerts_ctrl.GetNextItem(-1,LVNI_SELECTED);
	if(nItem<0) return;
	CaplInstance *sel_alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
	if(!sel_alert) return;
	DeleteAlert(sel_alert,nItem);
}

void CShowAlertsDlg::OnPropertiesBtn()
{
	int nItem=m_alerts_ctrl.GetNextItem(-1,LVNI_SELECTED);
	if(nItem<0) return;
	CaplInstance *sel_alert=(CaplInstance*)m_alerts_ctrl.GetItemData(nItem);
	if(!sel_alert) return;
	ShowProperties(sel_alert,nItem);
}

void CShowAlertsDlg::OnSelChangedAlert(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	EnableButtons();
}

void CShowAlertsDlg::OnShowCompleted() 
{
	UpdateAlertsList();
}

void CShowAlertsDlg::CreateAlert()
{
	CaplInstance *default_recipient=0;
	if(m_mode==APL_MODE_RECIEVED) default_recipient=m_cur_person;
	CaplInstance *new_alert=m_api->m_message_mgr.CreateAlert(default_recipient);
	if(new_alert)
	{
		if(m_bIsAdmin)
		{
			m_all_alerts.Add(new_alert);
			if(m_mode==APL_MODE_ADMIN)CreateItem(new_alert);
		}
		CaplInstance *author=0,*recipient=0;
		m_api->m_data.GetAttr(new_alert,m_api->m_message_mgr.a_alert_author,author);
		m_api->m_data.GetAttr(new_alert,m_api->m_message_mgr.a_alert_person,recipient);
		if(m_cur_person==recipient) 
		{
			m_rec_alerts.Add(new_alert);
			if(m_mode==APL_MODE_RECIEVED) CreateItem(new_alert);
		}
		if(m_cur_person==author) 
		{
			m_given_alerts.Add(new_alert);
			if(m_mode==APL_MODE_GIVEN) CreateItem(new_alert);
		}
	}
}

void CShowAlertsDlg::DeleteAlert(CaplInstance *alert,int nItem)
{
	if(!alert) return;
	if(nItem<0) return;
	if(alert->GetAccessmode()>aplRO) return;
	if(AfxMessageBox( APL_T("    ?"),MB_YESNO)==IDYES)
	{
		if(m_api->m_message_mgr.DeleteAlert(alert))
		{
			m_alerts_ctrl.DeleteItem(nItem);
		}
	}
}