// aplAccessView.cpp : implementation file
//

#include "stdafx.h"
#include "aplAccessView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplAccessView

IMPLEMENT_DYNCREATE(CaplAccessView, CaplPropsView)

CaplAccessView::CaplAccessView()
{
	m_pInplaceCombo		=NULL;
	m_lEditingId		=0;

	m_iSelPat			=0;
	m_bEdPat			=FALSE;
}

CaplAccessView::~CaplAccessView()
{
}


BEGIN_MESSAGE_MAP(CaplAccessView, CaplPropsView)
	//{{AFX_MSG_MAP(CaplAccessView)
	ON_NOTIFY_REFLECT(NM_CLICK, OnClick)
	ON_NOTIFY_REFLECT(NM_DBLCLK, OnDblclk)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CaplAccessView drawing

void CaplAccessView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CaplAccessView diagnostics

#ifdef _DEBUG
void CaplAccessView::AssertValid() const
{
	CaplPropsView::AssertValid();
}

void CaplAccessView::Dump(CDumpContext& dc) const
{
	CaplPropsView::Dump(dc);
}
#endif //_DEBUG

void CaplAccessView::__TranslateAcc(CString& csIn,int& iOut)
{
	CString csAccIn[]={_T("OWN"),_T("RW"),_T("RO"),_T("NA")};
	int		iAccOut[]={aplOWN,aplRW,aplRO,aplNO};

	int		i;

	for(i=0;i<sizeof(iAccOut)/sizeof(int);i++)
		if(csIn==csAccIn[i])
		{
			iOut=iAccOut[i];
			return;
		}

	iOut=-1;
}

void CaplAccessView::__TranslateAcc(int& iIn,CString& csOut)
{
	int		iAccIn[]={aplOWN,aplRW,aplRO,aplNO,-1};
	CString csAccOut[]={ APL_T(" "), APL_T("-"), APL_T(" "), APL_T(" "), APL_T(" ")};

	int		i;

	for(i=0;i<sizeof(iAccIn)/sizeof(int);i++)
		if(iIn==iAccIn[i])
		{
			csOut=csAccOut[i];
			return;
		}

	csOut=_T("");
}

void CaplAccessView::__TranslateAccShort(int& iIn,CString& csOut)
{
	int		iAccIn[]={aplOWN,aplRW,aplRO,aplNO};
	CString csAccOut[]={_T("OWN"),_T("RW"),_T("RO"),_T("NA")};

	int		i;

	for(i=0;i<sizeof(iAccIn)/sizeof(int);i++)
		if(iIn==iAccIn[i])
		{
			csOut=csAccOut[i];
			return;
		}

	csOut=_T("");
}

void CaplAccessView::_GetDefAcc(CString& csIn,int& iAcc)
{
	CString		cst;

	int			ipos1,ipos2;

	iAcc=-1;
	if(_T("")==csIn)
		return;

	ipos1=csIn.Find(_T("0:"));
	//	  -  ,  " "
	if(-1==ipos1)
		return;
	else
	{
		ipos2=csIn.Find(_T(";"),ipos1);
		//	  -    
		if(-1==ipos2)
			cst=csIn.Right(csIn.GetLength()-ipos1-2);
		else
			cst=csIn.Mid(ipos1+2,ipos2-ipos1-2);
	}

	__TranslateAcc(cst,iAcc);
}

void CaplAccessView::_ParseAcc(CString& csIn)
{
	CString		cst1,cst2;

	CString		csSep1=_T(";"),csSep2=_T(":");

	CLongArray	caIds;
	CIntArray	caAccs;

	int			i,ipos,it;
	long		lt;

	if(_T("")==csIn)
		return;

	cst1=csIn;
	//	   
	ipos=cst1.Find(csSep1);
	if(-1==ipos)
	{
		//	-    
		//	  "id:"
		ipos=cst1.Find(csSep2);
		if(-1!=ipos)
		{
			cst2=cst1.Left(ipos);
			lt=__atol(cst2);caIds.Add(lt);
			cst1.Delete(0,ipos+1);

			ipos=cst1.Find(csSep1);
			if(-1==ipos)
				cst2=cst1;
			else
				cst2=cst1.Left(ipos);
			__TranslateAcc(cst2,it);caAccs.Add(it);
			cst1.Delete(0,ipos+1);
		}

		for(i=0;i<caIds.GetSize();i++)
			m_mId2Acc.SetAt(caIds.GetAt(i),caAccs.GetAt(i));

		//	    
		if(FALSE==m_mId2Acc.Lookup(1,it))
			m_mId2Acc.SetAt(1,-1/*aplOWN*/);
		if(FALSE==m_mId2Acc.Lookup(2,it))
			m_mId2Acc.SetAt(2,-1/*aplOWN*/);

		return;
	}

	//	     
	cst2=cst1.Left(ipos);
	lt=__atol(cst2);
	if(0==lt)
		cst1.Delete(0,ipos+1);
	//	 
	do 
	{
		//	  "id:"
		ipos=cst1.Find(csSep2);
		cst2=cst1.Left(ipos);
		lt=__atol(cst2);caIds.Add(lt);
		cst1.Delete(0,ipos+1);

		ipos=cst1.Find(csSep1);
		if(-1==ipos)
			cst2=cst1;
		else
			cst2=cst1.Left(ipos);
		__TranslateAcc(cst2,it);caAccs.Add(it);
		cst1.Delete(0,ipos+1);
	}
	while(-1!=ipos);

//	//	 
//	//	  "id:"
//	ipos=cst1.Find(csSep2);
//	cst2=cst1.Left(ipos);
//	lt=atol(cst2);caIds.Add(lt);
//	cst1.Delete(0,ipos+1);
//
//	ipos=cst1.Find(csSep1);
//	if(-1==ipos)
//		cst2=cst1;
//	else
//		cst2=cst1.Left(ipos);
//	__TranslateAcc(cst2,it);caAccs.Add(it);
//	cst1.Delete(0,ipos+1);


	for(i=0;i<caIds.GetSize();i++)
		m_mId2Acc.SetAt(caIds.GetAt(i),caAccs.GetAt(i));

	//	    
	if(FALSE==m_mId2Acc.Lookup(1,it))
		m_mId2Acc.SetAt(1,-1/*aplOWN*/);
	if(FALSE==m_mId2Acc.Lookup(2,it))
		m_mId2Acc.SetAt(2,-1/*aplOWN*/);
}

BOOL CaplAccessView::GetAccessString(CString& csOut)
{
	POSITION		pos		=NULL;

	CaplInstance*	cit		=NULL;

	CString			csAcc,cst;

	int				it,it2;
	long			lt;

	if(0!=m_iSelPat)
	{
		cit=m_aeAccPats.GetAt(m_iSelPat-1);
		apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_pattern,csAcc);
	}
	else
	{

		//	      .   .     - 
		//	   .
		if(3==m_mId2Acc.GetCount() && TRUE==m_mId2Acc.Lookup(0,it) && 
		   TRUE==m_mId2Acc.Lookup(1,it) && TRUE==m_mId2Acc.Lookup(2,it))
		{
			m_mId2Acc.Lookup(0,it);
			m_mId2Acc.Lookup(1,it2);
			if(it==it2)
			{
				m_mId2Acc.Lookup(2,it2);
				if(it==it2)
				{
					__TranslateAccShort(it,cst);
					csAcc=_T("0:");
					csAcc+=cst;
					csAcc+=_T(";");

					csOut=csAcc;

					return TRUE;
				}
			}
		}

		// def. access
		if(FALSE==m_mId2Acc.Lookup(0,it))
			return FALSE;
		if(-1!=it)
		{
			__TranslateAccShort(it,cst);
			csAcc=_T("0:");
			csAcc+=cst;
			csAcc+=_T(";");
		}

		pos=m_mId2Acc.GetStartPosition();
		while(NULL!=pos)
		{
			m_mId2Acc.GetNextAssoc(pos,lt,it);
			if(0==lt)
				continue;
			if(-1==it)
				continue;
			cst.Format(_T("%ld"),lt);
			csAcc+=cst;
			csAcc+=_T(":");
			__TranslateAccShort(it,cst);
			csAcc+=cst;
			csAcc+=_T(";");
		}

		csAcc.Delete(csAcc.GetLength()-1,1);
	}

	csOut=csAcc;

	return TRUE;
}

void CaplAccessView::_ChangeBtnsState(BOOL bEn)
{
	CWnd*		pBtns[3]	={m_pAdd,m_pDel,m_pProps};
	static BOOL bState[3]	={FALSE,FALSE,FALSE};

	int			i;

	for(i=0;i<sizeof(bState)/sizeof(BOOL);i++)
		if(TRUE==bEn)
			pBtns[i]->EnableWindow(bState[i]);
		else
			bState[i]=pBtns[i]->EnableWindow(bEn);
}

void CaplAccessView::ChangeCtrlsState(void)
{
	CListCtrl*	pList	=NULL;

	POSITION	pos		=NULL;

	BOOL		bEnAdd	=FALSE;
	BOOL		bEnDel	=FALSE;
	BOOL		bEnProps=FALSE;

	long		lt;

	if(!IsWindowVisible())
		return;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	pos=pList->GetFirstSelectedItemPosition();

	if(0!=m_iSelPat)
	{
		if(NULL!=pos)
		{
			if(NULL!=m_inst)
			{
				if(m_inst->GetAccessmode()==aplOWN)
					bEnProps=TRUE;
			}
			else
				bEnProps=TRUE;
		}
	}
	else
	{
		if(NULL!=pos)
		{
			lt=pList->GetItemData(pList->GetNextSelectedItem(pos));

			if(NULL!=m_inst)
			{
				if(m_inst->GetAccessmode()==aplOWN)
				{
					//	  
					if(0==lt)
					{
						bEnAdd=TRUE;
						bEnProps=TRUE;
					}
					else
					if(-1==lt)
					{
						bEnAdd=TRUE;
					}
					else
					{
						bEnAdd=TRUE;
						bEnDel=TRUE;
						bEnProps=TRUE;
					}
				}
			}
			else
			{
				//	  
				if(0==lt)
				{
					bEnAdd=TRUE;
					bEnProps=TRUE;
				}
				else
				if(-1==lt)
				{
					bEnAdd=TRUE;
				}
				else
				{
					bEnAdd=TRUE;
					bEnDel=TRUE;
					bEnProps=TRUE;
				}
			}
		}
		else
		{
			if(NULL!=m_inst)
			{
				if(m_inst->GetAccessmode()==aplOWN)
					bEnAdd=TRUE;
			}
			else
				bEnAdd=TRUE;
		}
	}



	m_pAdd->EnableWindow(bEnAdd);
	m_pDel->EnableWindow(bEnDel);
	m_pProps->EnableWindow(bEnProps);
}


void CaplAccessView::_StartInplaceEditing(CRect& rt,int& iDefAcc,BOOL bTempl,BOOL bShowNC)
{
	CaplInstance*	cit		=NULL;

	CListCtrl*		pList	=NULL;

	DWORD			dwStyle =WS_CHILD|CBS_DROPDOWNLIST|CBS_SORT|WS_VISIBLE;

	int				iAcc[]={aplOWN,aplRW,aplRO,aplNO,-1};
	CString			csAcc[]={ APL_T(" "), APL_T("-"), APL_T(" "), APL_T(" "), APL_T(" ")};
	CString			cst;

	int				i,ipos,in;


	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	rt.top-=2;
	rt.bottom+=200;

	m_pInplaceCombo=new CComboBox;
	m_pInplaceCombo->Create(dwStyle,rt,this,1);
	m_pInplaceCombo->SetFont(pList->GetFont());

	in=sizeof(iAcc)/sizeof(int);
	if(FALSE==bShowNC)
		in--;

	if(FALSE==bTempl)
	{
		for(i=0;i<in;i++)
		{
			ipos=m_pInplaceCombo->InsertString(i,csAcc[i]);
			m_pInplaceCombo->SetItemData(ipos,iAcc[i]);
			if(iAcc[i]==iDefAcc)
				m_pInplaceCombo->SetCurSel(ipos);
		}
	}
	else
	{
		m_pInplaceCombo->InsertString(0, APL_T(""));
		for(i=0;i<m_aeAccPats.GetSize();i++)
		{
			cit=m_aeAccPats.GetAt(i);
			apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_name,cst);
			m_pInplaceCombo->InsertString(i+1,cst);
		}

		m_pInplaceCombo->SetCurSel(m_iSelPat);

		m_bEdPat=TRUE;
	}

	_ChangeBtnsState(FALSE);
}

BOOL CaplAccessView::_StopInplaceEditing(int& iOutAcc)
{
	CaplInstance*	cit		=NULL;

	CString			cst1=_T(""),cst2=_T("");

	BOOL			bFound	=FALSE;

	int			i;

	if(NULL==m_pInplaceCombo)
		return FALSE;

	if(FALSE==m_bEdPat)
	{
		iOutAcc=m_pInplaceCombo->GetItemData(m_pInplaceCombo->GetCurSel());
		m_pInplaceCombo->DestroyWindow();
		delete m_pInplaceCombo;
		m_pInplaceCombo=NULL;
	}
	else
	{
		m_pInplaceCombo->GetLBText(m_pInplaceCombo->GetCurSel(),cst1);
		if(cst1== APL_T(""))
		{
			iOutAcc=0;
			bFound=TRUE;
		}
		else
		{
			for(i=0;i<m_aeAccPats.GetSize();i++)
			{
				cit=m_aeAccPats.GetAt(i);
				apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_name,cst2);
				if(cst2==cst1)
				{
					iOutAcc=i+1;
					bFound=TRUE;
					break;
				}
			}
		}

		if(TRUE==bFound)
		{
			m_pInplaceCombo->DestroyWindow();
			delete m_pInplaceCombo;
			m_pInplaceCombo=NULL;

			m_bEdPat=FALSE;
		}
	}

	_ChangeBtnsState(TRUE);

	return TRUE;
}

BOOL CaplAccessView::InitColumns(void)
{
	CListCtrl*	pList		=NULL;

	CString		csTxt[]		={ APL_T(""), APL_T(" ")};
	int			iSz[]		={200,200};

	int			i;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	for(i=0;i<sizeof(iSz)/sizeof(int);i++)
		pList->InsertColumn(i,csTxt[i],LVCFMT_LEFT,iSz[i]);

	long lStyles=::GetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE);
	lStyles|=LVS_SINGLESEL|LVS_SHOWSELALWAYS;
	::SetWindowLong(GetListCtrl().m_hWnd,GWL_STYLE,lStyles);

	return TRUE;
}

BOOL CaplAccessView::LoadData(void)
{
	CString			cst;

	int				it;

	if(NULL==m_api)
		return TRUE;

	m_aeAccPats.Clear();
	m_mId2Acc.RemoveAll();
	
	apidata.GetEntityExtent(m_api->m_appr_mgr.e_apl_acc_pat,m_aeAccPats);

	if(NULL==m_inst)
	{
		m_mId2Acc.SetAt(0,aplOWN);
		m_mId2Acc.SetAt(1,-1/*aplOWN*/);
		m_mId2Acc.SetAt(2,-1/*aplOWN*/);
		return TRUE;
	}

	if(false==apidata.NET_GetExtentAccess2String(m_inst,m_csSysAcc,false))
		return FALSE;

	_GetDefAcc(m_csSysAcc,it);
	m_mId2Acc.SetAt(0,it);

	_ParseAcc(m_csSysAcc);

	return TRUE;
}

BOOL CaplAccessView::FillList(void)
{
	CaplInstance*	cit		=NULL;

	POSITION		pos		=NULL;

	CListCtrl*		pList	=NULL;

	CString			cst1,cst2;

	int				it,ipos,inum=0;
	long			lt;

	pList=&GetListCtrl();
	if(NULL==pList)
		return FALSE;

	pList->DeleteAllItems();

	//	" "
	ipos=pList->InsertItem(inum,_T(""));
	pList->SetItemText(ipos,0, APL_T(" "));
	if(0!=m_iSelPat)
	{
		cit=m_aeAccPats.GetAt(m_iSelPat-1);
		apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_name,cst1);
	}
	else
		cst1= APL_T("");

	pList->SetItemText(ipos,1,cst1);
	pList->SetItemData(ipos,0);

	inum++;

	//	
	ipos=pList->InsertItem(inum,_T(""));
	pList->SetItemData(ipos,-1);
	inum++;

	//	"  "
	ipos=pList->InsertItem(inum,_T(""));
	pList->SetItemText(ipos,0, APL_T("  "));
	if(TRUE==m_mId2Acc.Lookup(0,it))
		__TranslateAcc(it,cst1);
	else
		cst1= APL_T(" ");
	pList->SetItemText(ipos,1,cst1);
	pList->SetItemData(ipos,0);
	inum++;

	//	
	ipos=pList->InsertItem(inum,_T(""));
	pList->SetItemData(ipos,-1);
	inum++;

	if(0!=m_iSelPat)
	{
		//	" "
		ipos=pList->InsertItem(inum,_T(""));
		pList->SetItemText(ipos,0, APL_T(" "));
		if(TRUE==m_mId2Acc.Lookup(2,it))
			__TranslateAcc(it,cst1);
		else
			cst1= APL_T(" ");
		pList->SetItemText(ipos,1,cst1);
		pList->SetItemData(ipos,2);
		inum++;

		//	" "
		ipos=pList->InsertItem(inum,_T(""));
		pList->SetItemText(ipos,0, APL_T(" "));
		if(TRUE==m_mId2Acc.Lookup(1,it))
			__TranslateAcc(it,cst1);
		else
			cst1= APL_T(" ");
		pList->SetItemText(ipos,1,cst1);
		pList->SetItemData(ipos,1);
		inum++;
		//	
		ipos=pList->InsertItem(inum,_T(""));
		pList->SetItemData(ipos,-1);
		inum++;
	}

	//	
	pos=m_mId2Acc.GetStartPosition();
	
	bool bAutoDM= apidata.GetAutoDownloadMode();
	apidata.SetAutoDownloadMode(true);
	
	while(NULL!=pos)
	{
		m_mId2Acc.GetNextAssoc(pos,lt,it);
		if(0==lt || 1==lt || 2==lt)
			continue;
		cit=apidata.GetInstById(lt);
		if(0==cit) continue;
		apidata.GetAttrBN(cit,_T("name"),cst1);
		__TranslateAcc(it,cst2);

		ipos=pList->InsertItem(inum,_T(""));

		pList->SetItemText(ipos,0,cst1);
		pList->SetItemText(ipos,1,cst2);
		pList->SetItemData(ipos,lt);
		inum++;
	}
	
	apidata.SetAutoDownloadMode(bAutoDM);

	return TRUE;
}

void CaplAccessView::SetDefaultTemplate(LPCTSTR csTemplName)
{
	CaplInstance*	cit		=NULL;

	CString			cst;

	BOOL			bFound	=FALSE;

	int				i,it;

	LoadData();


	for(i=0;i<m_aeAccPats.GetSize();i++)
	{
		cit=m_aeAccPats.GetAt(i);
		apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_name,cst);
		if(cst==csTemplName)
		{
			bFound=TRUE;
			m_iSelPat=i+1;
			break;
		}
	}

	if(TRUE==bFound)
	{
		apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_pattern,cst);
		m_csSysAcc=cst;

		m_mId2Acc.RemoveAll();

		_GetDefAcc(m_csSysAcc,it);
		m_mId2Acc.SetAt(0,it);

		_ParseAcc(m_csSysAcc);
		
		FillList();
	}
}

/////////////////////////////////////////////////////////////////////////////
// CaplAccessView message handlers
void CaplAccessView::OnBAdd(void)
{
	CListCtrl*			pList	=NULL;

	CString				csAddAcc,cst;

	aplExtent			aeUsers;
	aplAccessModeType	acc;

	CaplInstance*		cit		=NULL;

	int					i;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	if(NULL!=m_inst)
		if(m_inst->GetAccessmode()!=aplOWN)
			return;

	if(false==apidata.SelectAplUsers(aeUsers,acc))
		return;

	for(i=0;i<aeUsers.GetSize();i++)
	{
		cit=aeUsers.GetAt(i);
		m_mId2Acc.SetAt(cit->GetId(),acc);
	}

	FillList();
}

void CaplAccessView::OnBDel(void)
{
	CListCtrl*			pList	=NULL;

	POSITION			pos		=NULL;

	int					ipos,it;
	long				lt;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	if(NULL!=m_inst)
		if(m_inst->GetAccessmode()!=aplOWN)
			return;

	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;

	ipos=pList->GetNextSelectedItem(pos);
	lt=pList->GetItemData(ipos);
	if(-1==lt)
		return;

	if(FALSE==m_mId2Acc.Lookup(lt,it))
		return;
	m_mId2Acc.RemoveKey(lt);

	FillList();
}

void CaplAccessView::OnBProps(void)
{
	CListCtrl*	pList	=NULL;

	POSITION	pos		=NULL;

	CRect		rt;

	BOOL		bTempl	=FALSE,bShowNC=FALSE;

	int			ipos,it;
	long		lt;

	pList=&GetListCtrl();
	if(NULL==pList)
		return;

	if(NULL!=m_inst)
		if(m_inst->GetAccessmode()!=aplOWN)
			return;

	pos=pList->GetFirstSelectedItemPosition();
	if(NULL==pos)
		return;

	ipos=pList->GetNextSelectedItem(pos);
	lt=pList->GetItemData(ipos);
	if(-1==lt)
		return;

	if(FALSE==m_mId2Acc.Lookup(lt,it))
		return;

	if(0==ipos)
		bTempl=TRUE;
	if(0==lt)
		bShowNC=TRUE;

	pList->GetSubItemRect(ipos,1,LVIR_BOUNDS,rt);
	_StartInplaceEditing(rt,it,bTempl,bShowNC);
	m_lEditingId=lt;
}

void CaplAccessView::OnClick(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CaplInstance*	cit		=NULL;

	CString			csAcc;

	int				it,it2;

	if(NULL!=m_pInplaceCombo)
	{
		if(FALSE==m_bEdPat)
		{
			if(TRUE==_StopInplaceEditing(it))
			{
				if(0!=m_iSelPat)
				{
					if(TRUE==m_mId2Acc.Lookup(m_lEditingId,it2))
						if(it2!=it)
							m_iSelPat=0;
				}
				m_mId2Acc.SetAt(m_lEditingId,it);
				m_lEditingId=0;
				FillList();
			}
		}
		else
		{
			if(TRUE==_StopInplaceEditing(it))
			{
				if(0!=m_iSelPat && 0==it)
				{
					m_mId2Acc.RemoveKey(1);
					m_mId2Acc.RemoveKey(2);
				}

				m_iSelPat=it;
				if(0!=m_iSelPat)
				{
					cit=m_aeAccPats.GetAt(m_iSelPat-1);
					apidata.GetAttr(cit,m_api->m_appr_mgr.a_apl_acc_pat_pattern,csAcc);
					m_csSysAcc=csAcc;

					m_mId2Acc.RemoveAll();

					_GetDefAcc(m_csSysAcc,it);
					m_mId2Acc.SetAt(0,it);

					_ParseAcc(m_csSysAcc);
				}
				else
					LoadData();
				FillList();
			}
		}
	}

	*pResult = 0;
}

void CaplAccessView::OnDblclk(NMHDR* pNMHDR, LRESULT* pResult) 
{

	NMITEMACTIVATE*		nmi		=NULL;
	CListCtrl*			pList	=NULL;

	nmi=(NMITEMACTIVATE*)pNMHDR;

	if(nmi->iSubItem!=0)
		OnBProps();

	*pResult = 0;
}