	// aplClassifierMgr.h: interface for the CaplClassifierMgr class.
//
//////////////////////////////////////////////////////////////////////
#pragma once

#include <StepData.h>
#include <aplNetStepData.h>
#include <apl_gui.h>
#include "aplStepManager.h"

//   
class TArrElValChar: public CaplTAggr<ElValChar*,ElValChar*,APLAGGR_UNIQUE_LIST_AUTOKILLREF>
{
/**< .   
   new   
     
..      !*/
public:
	void Clone(CaplTAggr <ElValChar*,ElValChar*,APLAGGR_UNIQUE_LIST_AUTOKILLREF> *original_aggr)
	{
		ElValChar* new_el;
		Clear();
		if(original_aggr==0)return;
		for(int i=0;i<original_aggr->Size;i++){
			new_el= new ElValChar(original_aggr->GetAt(i));
			Add(new_el);
		}
	}
};


#define APL_INSTANCE_CLIPBOARDFORMAT _T("APL_INSTANCE_CLIPBOARDFORMAT")

#define APL_SELECT_CLASSIFIER_SYSTEM	0x0001	// 
#define APL_SELECT_CLASSIFIER_LEVEL		0x0002	//   
#define APL_SELECT_CLASSIFIER_ITEM		0x0004	//   
#define APL_USE_SYSTEM_SETTINGS			0x0008
#define APL_CLASSIFIER_EDITOR			0x0010	//   
#define APL_CLASSIFIER_EXE_EDITOR		0x0020	//  EXE    
#define APL_CONCEPT						0x0040	//    
                                            //  ,     ,   ,        
#define APL_HIDE_ESQUISSE				0x0080	//    
#define APL_HIDE_TABLE					0x0100	//     (       )
#define APL_AUTO_HIDE_TABLE				0x0200	//        
#define APL_SHOW_ESQUISSE	            0x0400  //   . 

//     ,     
#define ACCESS2LEVEL_FOR_OBJECT aplRW
#define ACCESS2LEVEL_FOR_OBJECT_DESCR APL_T("  ")
//   ,      
#define ACCESS2SYSTEM_FOR_STRUCTURE aplOWN
#define ACCESS2SYSTEM_FOR_STRUCTURE_DESCR APL_T(" ")
//     ,      
#define ACCESS2LEVEL_FOR_STRUCTURE aplRW
#define ACCESS2LEVEL_FOR_STRUCTURE_DESCR APL_T("  ")

/*
	      "  "
	:
	*)         aplSTRING.     
	*)  default_relation      : CaplQLQuery::aplEQUAL, CaplQLQuery::aplLIKE,CaplQLQuery::aplNOTLIKE,
			CaplQLQuery::aplLIKELEFT, CaplQLQuery::aplLIKERIGHT,CaplQLQuery::aplNOTEQUAL,CaplQLQuery::aplNOTLIKELEFT,CaplQLQuery::aplNOTLIKERIGHT
		   - CaplQLQuery::aplLIKE
	*)     ...
*/

struct CLASS_DECL_APL_STEP_MGR  SSelectItemFilter												 
{																		 
	SSelectItemFilter();												 
																		 
	CaplEntity* search_entity; // ,    		 
	CString search_entity_name;	//      

	CaplTAggr <CaplAttr*,CaplAttr*,APLAGGR_UNIQUE|APLAGGR_LIST> selection_array; //   
	CStringArray selection_array_names; //   -       

	CaplAttr*	default_selection; //    	
	CaplQLQuery::aplQLLogRelation	default_relation; //    .
	CString	default_value; //     	

	CaplTAggr <CaplAttr*,CaplAttr*,APLAGGR_UNIQUE|APLAGGR_LIST>	display_array; //  	
	CaplAttr* sorting_field; //  

};

class CLASS_DECL_APL_STEP_MGR CaplClassifierMgr : public CaplStepManager  
{
public:
	/**	   ,     
		@param Item  ,   (   )
		@pBaseClassifierSystems/BaseClassifierSystem  /
		@param mode   (, ,  )

		APL_SELECT_CLASSIFIER_SYSTEM	                     (   APL_SELECT_CLASSIFIER_ITEM)
		APL_SELECT_CLASSIFIER_LEVEL		    (   APL_SELECT_CLASSIFIER_ITEM)
		APL_SELECT_CLASSIFIER_ITEM		            (   APL_SELECT_CLASSIFIER_LEVEL  APL_SELECT_CLASSIFIER_SYSTEM)
		APL_USE_SYSTEM_SETTINGS			
		APL_CLASSIFIER_EDITOR			   
		APL_CLASSIFIER_EXE_EDITOR		  EXE    
		APL_CONCEPT						      (     (CClassifierSelectDlg)
													//  ,       ,   ,        
		APL_HIDE_ESQUISSE				     (       (CSelectClassifierItemDlg)

		APL_HIDE_TABLE					     (         )
		                                 ,        ,   
										
		APL_SHOW_ESQUISSE	              .     APL_SELECT_CLASSIFIER_SYSTEM  APL_SELECT_CLASSIFIER_LEVEL
										 ,          ,   APL_HIDE_TABLE
										(, ,   level c  )

		@param lpszTitle   
		@param pWnd   MainWnd (        ,   
		       WinApp::InitInstance())
		extItems -  !=0,    "".       "",        
		@return <b>true</b>      <b>false</b>   */
	bool SelectItem(CaplInstance **Item, aplExtent &BaseClassifierSystems, UINT mode = APL_SELECT_CLASSIFIER_ITEM, LPCTSTR lpszTitle = NULL, SSelectItemFilter* filter = NULL);
	bool SelectItem(CaplInstance **Item, CaplInstance* BaseClassifierSystem=NULL, UINT mode = APL_SELECT_CLASSIFIER_ITEM, LPCTSTR lpszTitle = NULL, CWnd **pWnd=NULL, aplExtent *extItems=0);

	/**  .       -  
	 
		@param ParentElement   
		@param id   
		@param name   
		@param descr   
		@param TestUnique  true -       
		   id 
		@return        0    */	
	CaplInstance* CreateClassifierSystem(CaplInstance *ParentElement=NULL,LPCTSTR id = NULL, LPCTSTR name = NULL, LPCTSTR descr = NULL, bool TestUnique = true);

	/**     .       -  
	   
		@param ClassifierSystem  ( )
		@param ParentElement    
		@param id    
		@param name    
		@param descr    
		@param TestUnique  true -       
		   id   
		@return          0    */	
	CaplInstance* CreateClassifierLevel(CaplInstance* ClassifierSystem, CaplInstance *ParentElement=NULL, LPCTSTR id = NULL, LPCTSTR name = NULL, LPCTSTR descr = NULL, LPCTSTR code = NULL, bool TestUnique = true);

	/**     . ,     
	    ,      ( 
	    );   ,     
		@param ClassifierSystem      
		@param bCheckXmlReferences    xml 
		@return true     false    */	
	bool DeleteClassifierItem(CaplInstance* Item, bool bCheckXmlReferences = true);

	/**       
		@return true     false    */	
	bool ShowClassifierProperties(CaplInstance* Item);

	/**         
		@param Item     
		@param name_file  ,     
		@return true     false    */	
	bool PutClassifierEsquisse(CaplInstance *Item,const TCHAR* name_file);

	/**              .
		@param Item      
		@param blob_dest   ,       
		@param size_buf  
		@return true     false    */	
//	bool PutClassifierEsquisse(CaplInstance *Item, BYTE* blob_dest,long size_buf);

	/**           
	     temp  .     
	  
		@param Item      
		@param name_file  ,     
		@return true     false    */	
	bool GetClassifierEsquisse(CaplInstance *Item, CString &name_file, CString *original_name=NULL);

	/**            
	    .     
	  
		@param Item      
		@param blob_dest   ,       
		@param size_buf  
		@return true     false    */	
	bool GetClassifierEsquisse(CaplInstance *Item, BYTE** blob_dest,long &size_buf,CString &only_name, CString *original_name=NULL);

	/**        
		@param Item       
		@return true     false    */	
	bool DelClassifierEsquisse(CaplInstance *Item);

	
	/**     .      
	 	      recursive=true -     
	,                
		@param Item     
		@param name_file  ,     
		@return true     false    */	
	bool GetClassifierForms(CaplInstance *Item, 
					aplExtent &list_forms, bool recursive=true, pCaplInstance *based_item=0);

	/**       
		@param ClassifierSystem 
		@param ParentElement   .    -   
		@return true     false    */	
	bool MoveClassifierSystem(CaplInstance* MovedSystem, CaplInstance *NewParent=NULL);

	/**        
		@param ClassifierElement  
		@param ParentElement     .    -     
		@return true     false    */	
	bool MoveClassifierLevel(CaplInstance* MovedElement, CaplInstance *NewParent=NULL, bool bMoveBetweenSystems = false);

	/**     
	!      !
		@param name  
		@return        0    */	
	CaplInstance* GetClassifierSystemBN(LPCTSTR name, bool bFromBase = false);

	/**     
	!      !
		@param id  
		@return        0    */	
	CaplInstance* GetClassifierSystemById(LPCTSTR id, bool bFromBase = false);

	/**         . 
	!       !
		@param name  
		@param ClassifierSystem 
		@return          0    */	
	CaplInstance* GetClassifierLevelByName(LPCTSTR name, CaplInstance* ClassifierSystem);

	/**         
	!       !
		@param id  
		@param ClassifierSystem 
		@return          0    */	
	CaplInstance* GetClassifierLevelById(LPCTSTR id, CaplInstance* ClassifierSystem, bool bFromBase = true);

	/**       -     
		@param item    
		@param out_ext  -
		@param all_level     -  false  
	    ,  true -      
	,     
		@param chek_unique       all_level=true -  
	       .   -
	    ,     
		@param load_from_bd  true -       ;  false -       
		@return true     false    */	
	bool GetClassifierCharacteristic(CaplInstance* item,  aplExtent &out_ext,bool all_level=false,bool chek_unique=true,bool load_from_bd=true);
	
	bool GetClassifierElementFilters(CaplInstance* item,TArrElValChar** filters);

	/**      ,       
	(    )
		@param ClassifierLevel  .     ,      .
		@param out_ext  
		@param rels       
		@param load_data      
		@param load_from_bd  true -      ;  false -       
		@return true     false    */	
	bool GetSubItems(CaplInstance* ClassifierLevel, aplExtent &out_ext, aplExtent *rels=NULL,bool load_data=true,bool load_from_bd=true);

	/**      ,        
	(    )
		@param ClassifierLevels    
		@param out_ext  
		@param rels       
		@param load_data      
		@param load_from_bd  true -      ;  false -       
		@return true     false    */	
	bool GetSubItems(aplExtent &ClassifierLevels, aplExtent &out_ext, aplExtent *rels=NULL,bool load_data=true,bool load_from_bd=true);


	
	/**   .
		@param ClassifierSystem  .   0,      . 
		        ClassifierSystem.
		@param SubElements  -  .
		@param recursive  true -        .  false -    1 .
		@param bFromBase       .
		@return true     false    */	
	bool LoadSubClassifierSystems(CaplInstance* ClassifierSystem, aplExtent &SubElements, bool recursive = false, bool bFromBase = true);

	
	/**      
		@param ClassifierItem    - . 
		@param SubElements  -    .
		@param recursive  true -         .  false -    1 .
		@param bFromBase       .
		@return true     false    */	
	bool LoadSubClassifierLevels(CaplInstance* ClassifierItem, aplExtent &SubElements, bool recursive = false, bool bFromBase = true);


	/**         .    
	          
		@param Item  
		@param ClassifierLevel   
		@param TestUnique  true -        
		       
		@return        0    */	
	CaplInstance* CreateClassifierAssociation(CaplInstance *Item, CaplInstance* ClassifierLevel, bool TestUnique = true);

	/**         .    
	          
		@param Items   
		@param ClassifierLevel   
		@param TestUnique  true -        
		       
		@param Associators   -         
		@return true     false    */	
	bool CreateClassifierAssociation(aplExtent &Items, CaplInstance* ClassifierLevel, bool TestUnique = true, aplExtent *Associators=0);

	/**         
	@param Item  
	@param ClassifierLevel   
	@return <btrue</b>      <b>false</b>   */
	bool TestClassifierAssociation(CaplInstance *Item, CaplInstance *ClassifierItem,pCaplInstance *association=0);

	/**  ,    item 
		@param item  
		@param classifiers    
		@return true     false    */
	bool FindClassifiersContained(CaplInstance *item, aplExtent &classifiers, aplExtent *assoc_ext = NULL);
	bool FindClassifiersContained(aplExtent &items, aplExtent &classifiers, aplExtent *assoc_ext = NULL);

	///   item  ,     classifiers_id
	/// classifiers_id -     '|'.
	///  tru,    false,  
	bool CheckItemInClassifierById(CaplInstance *item, LPCTSTR classifiers_id);

	///   item  ,     option
	/// . CheckItemInClassifierById
	///  tru,    false,  
	///  bShowMsg==true -   "     "
	///     -  true
	bool CheckItemInClassifierByOption(CaplInstance *item, LPCTSTR option, bool bShowMsg);


	/**      
		@param map_item2level - :  -  (  
		@param bLoadClassifierInfo -      
		@return true     false    */
	bool GetClassifierLevel4Items(CaplMap &map_item2level, bool bLoadClassifierInfo=true);

	/**        . 
		@param Item 
		@param ClassifierLevel  
		@return true    (   )  false    */	
	bool DeleteClassifierAssociation(CaplInstance *Item, CaplInstance *ClassifierLevel);

	/**             . 
		@param inst     
		@return true     false    */	
	bool LoadClassifierInfo(CaplInstance* inst);

	/**             . 
		@param ext    () 
		@return true     false    */	
	bool LoadClassifierInfo(aplExtent &ext);

	/**          . 
		@return true     false    */	
	bool LoadDictionary();

	/**      . 
		@param element   
		@return     */	
	int GetLevelClassifierLevel(CaplInstance* element);

	/**           
	  .    - ,    
	
		@param element   
		@return true    (  )  false    */	
	bool TestConceptLevelOfElement(CaplInstance* element);

	/**           
	  .    - ,    
	
		@param element   
		@param supress_mesage  false    m_ModeInteractive -    
	      .  true -    
	
		@return true    (  )  false   
	           
	 */	
	bool TestObjectLevelOfLevel(CaplInstance* element,bool supress_mesage=false);
	

	/**          ;
	  .    - ,    
	  
		@param element   
		@param object   
		@return true    (  )  false   
	 */	
	bool TestObjectType(CaplInstance* element,CaplInstance* object);

	/**        
		@param Item    
		@param is_hide_move_button
		@param redraw         / ,
		  ,      true
		@param show_subelements       ( 
		    )
		@return true     false    */	
	bool MakeTable(CaplInstance *Item,bool is_hide_move_button=true,bool *redraw=NULL,bool show_subelements=true);

	/**       .      
	 	     recursive=true -     
	 ,             
	  .
		@param Item    ,    
		@param is_concept_control -     .  true -  
		 
		@param is_last_level -   true,       
		   .  false -        
		  
		@param min_level -    
		@param max_level -    
		@param recursive -  true -      .  
		false -     /
		@return        -  0.   -  
	       */	
	CaplInstance* GetConceptLevelParameters(CaplInstance *Item,bool &is_concept_control,bool &is_last_level,int &min_level,int &max_level);

	/**         .   
	          recursive=true -   
	  ,             
	 .
		@param Item    ,    
		@param can_object -       .
		@param is_object_control -     .  true -  
		 
		@param is_last_level -   true,       
		    .  false -       
		  
		@param min_level -    
		@param max_level -    
		@param recursive -  true -       .  
		false -      /
		@return        -  0.   -  
	       */		
	CaplInstance* GetObjectLevelParameters(CaplInstance *Item,bool &can_object,bool &is_object_control,bool &is_last_level,int &min_level,int &max_level,bool &is_multi_object);

	/**        .   
	          recursive=true -  
	    ,          
	    .
		@param Item    ,    
		@param is_object_type_control -     .  true -  
		 
		@param stored_entity -  entity,       
		@param recursive -  true -      .  
		false -       / 
		@return        -  0.   -  
	       */		
	CaplInstance* GetObjectTypeParameters(CaplInstance *Item,bool &is_object_type_control,CaplEntity **stored_entity,bool recursive=true);
	
	void AddIfNotFound(aplExtent &base,aplExtent &added);

	int GetNextLevelIndex(CaplInstance* instLevel, bool bRecalc = false);
	bool SetIndexToUnindexedAssociations(CaplInstance* instLevel);
	bool GetObjectCode(CaplInstance* instAssociation, CString &code);
	bool GetObjectCode(CaplInstance* instSystem, CaplInstance* instObject, CString &code);

	/**
		 ,    ,    
		   ,      
		@param ClassifierElement  ,    
		@return true     false    */	
	bool CreateObjectWithForm(CaplInstance* ClassifierElement,aplExtent *created_objects=0,aplExtent *created_associations=0);

	virtual bool Attach(CaplAPI *api);
	virtual void Detach();

	CaplClassifierMgr();
	virtual ~CaplClassifierMgr();

	CaplEntity*	e_apl_classifier_system;//
	CaplAttr*	a_apl_classifier_system_id;
	CaplAttr*	a_apl_classifier_system_name;
	CaplAttr*	a_apl_classifier_system_descr;
	CaplAttr*	a_apl_classifier_system_parent;
	CaplAttr*	a_apl_classifier_system_childs;
	CaplAttr*	a_apl_classifier_system_template;
	CaplAttr*	a_apl_classifier_system_is_multi_object;
	CaplAttr*	a_apl_classifier_system_inner_label;

	CaplAttr*	a_apl_classifier_system_is_concept_level_control;
	CaplAttr*	a_apl_classifier_system_is_concept_last_level;
	CaplAttr*	a_apl_classifier_system_concept_maxlevel;
	CaplAttr*	a_apl_classifier_system_concept_minlevel;
	CaplAttr*	a_apl_classifier_system_can_store_object; 
	CaplAttr*	a_apl_classifier_system_is_object_level_control; 
	CaplAttr*	a_apl_classifier_system_is_object_last_level;
	CaplAttr*	a_apl_classifier_system_object_maxlevel;
	CaplAttr*	a_apl_classifier_system_object_minlevel;
	CaplAttr*	a_apl_classifier_system_is_type_control;
	CaplAttr*	a_apl_classifier_system_forms;
	CaplAttr*	a_apl_classifier_system_stored_entity;
	CaplAttr*	a_apl_classifier_system_list_characteristics;
	CaplAttr*	a_apl_classifier_system_esquisse;
	CaplAttr*	a_apl_classifier_system_esquisse_name;
	CaplAttr*	a_apl_classifier_system_view_format;


	CaplEntity*	e_apl_classifier_level;//  
	CaplAttr*	a_apl_classifier_level_id;
	CaplAttr*	a_apl_classifier_level_code;
	CaplAttr*	a_apl_classifier_level_name;
	CaplAttr*	a_apl_classifier_level_name_eng;
	CaplAttr*	a_apl_classifier_level_descr;
	CaplAttr*	a_apl_classifier_level_parent;
	CaplAttr*	a_apl_classifier_level_childs;
	CaplAttr*	a_apl_classifier_level_system;
	CaplAttr*	a_apl_classifier_level_list_characteristics;
	CaplAttr*	a_apl_classifier_level_forms;
	CaplAttr*	a_apl_classifier_level_esquisse;
	CaplAttr*	a_apl_classifier_level_esquisse_name;
	CaplAttr*	a_apl_classifier_level_next_index;
	CaplAttr*	a_apl_classifier_level_construction;
	CaplAttr*	a_apl_classifier_level_wiring;
	CaplAttr*	a_apl_classifier_level_wiring_controls;
	CaplAttr*	a_apl_classifier_level_combustible_mat;
	CaplAttr*	a_apl_classifier_level_section_type;
	CaplAttr*	a_apl_classifier_level_req_characts;
	CaplAttr*	a_apl_classifier_level_related_pdf;
	CaplAttr*	a_apl_classifier_level_inner_label;
	CaplAttr*	a_apl_classifier_level_okpd_code;
	CaplAttr*	a_apl_classifier_level_is_system_level;
	
	CaplEntity*	e_apl_classifier_association;//      
	CaplAttr*	a_apl_classifier_association_item;
	CaplAttr*	a_apl_classifier_association_classifier;
	CaplAttr*	a_apl_classifier_association_index;
	CaplAttr*	a_apl_classifier_association_id;
	CaplAttr*	a_apl_classifier_association_system;
	CaplAttr*	a_apl_classifier_association_pdf_count;
	CaplAttr*	a_apl_classifier_association_inner_label;

protected:

	//        xml 
	bool ValidateClassifierElsXmlRefs( const aplExtent& exts );

protected:

	CaplMap m_list_filters;

private:

	static void FN_DeleteClassifierLevel(CaplAPI* api, CaplLoadData& loadData, DWORD dwData);
};

