#if !defined(AFX_APLLISTCTRL_H__A32BB432_C995_4C5B_AE18_E8B6853597EE__INCLUDED_)
#define AFX_APLLISTCTRL_H__A32BB432_C995_4C5B_AE18_E8B6853597EE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// aplListCtrl.h : header file
//

#include "apl_api.h"
/////////////////////////////////////////////////////////////////////////////
// CaplListCtrl window
#define LCC_RED 1
#define LCC_GREEN 2
#define LCC_BLUE 4
#define LCC_DARK 8
#define LCC_LIGHT 16

class CItem
{
public:
	CItem();
	~CItem(){};
	CaplInstance *m_inst;
	CaplInstance *m_folder;
	CString path;
	int m_type;
	int  color;
	int img1;
	int img2;
	int level1;
	int level2;
	ULONGLONG fsize;
};

class CaplCompareFolderListCtrl : public CListCtrl
{
// Construction
public:
	CaplCompareFolderListCtrl();
	virtual void DrawItem( LPDRAWITEMSTRUCT lpDrawItemStruct );


// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CaplCompareFolderListCtrl)
	public:
	virtual BOOL DestroyWindow();
	//}}AFX_VIRTUAL

// Implementation
public:
	CItem* GetItemData(int cur);
	void SelCur(int cur);
	void SetLevelCX(int cx = 5);
	void DeleteAllItems();
	COLORREF SetColor(COLORREF color, UINT id);
	void SetImageList(CImageList *img, UINT mode, int scol=0);
	virtual ~CaplCompareFolderListCtrl();

	// Generated message map functions
protected:
	int m_cx_level;
	int m_col;
	CImageList m_image;
	COLORREF m_dark;
	COLORREF m_blue;
	COLORREF m_lith;
	COLORREF m_red;
	COLORREF m_green;
	//{{AFX_MSG(CaplCompareFolderListCtrl)
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
private:
	COLORREF Invert(COLORREF color);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_APLLISTCTRL_H__A32BB432_C995_4C5B_AE18_E8B6853597EE__INCLUDED_)
