// aplLotDlg.cpp : implementation file
//

#include "stdafx.h"
#include "apl_api.h"
#include "aplLotDlg.h"
#include "dictionary.h"
#include "SelectInstDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CaplLotDlg dialog


CaplLotDlg::CaplLotDlg(CWnd* pParent /*=NULL*/)
	:CaplResizableDialog(CaplLotDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CaplLotDlg)
	m_lot_id = _T("");
	m_lot_size = 0.0;
	m_pdf_id = _T("");
	m_prd_id = _T("");
	m_prd_name = _T("");
	m_lot_descr = _T("");
	//}}AFX_DATA_INIT
	m_api=0;
	m_pdf=0; m_lot=0; m_unit=0; m_parent_lot=0;
}


void CaplLotDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplResizableDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CaplLotDlg)
	DDX_Control(pDX, IDC_TAB1, m_Tab);
	DDX_Control(pDX, IDC_B_PROPS_PROPS, m_bPropsProps);
	DDX_Control(pDX, IDC_B_PROPS_DEL, m_bPropsDel);
	DDX_Control(pDX, IDC_B_PROPS_ADD, m_bPropsAdd);
	DDX_Control(pDX, IDC_PRD_NAME, m_prd_name_ctrl);
	DDX_Control(pDX, IDC_PRD_ID, m_prd_id_ctrl);
	DDX_Control(pDX, IDC_PDF_ID, m_pdf_id_ctrl);
	DDX_Control(pDX, IDC_UNIT, m_unit_ctrl);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDC_PDF_DEL, m_pdf_del_ctrl);
	DDX_Control(pDX, IDC_PDF_BROWSE, m_pdf_browse_ctrl);
	DDX_Text(pDX, IDC_LOT_ID, m_lot_id);
	DDX_Text(pDX, IDC_LOT_SIZE, m_lot_size);
	DDX_Text(pDX, IDC_PDF_ID, m_pdf_id);
	DDX_Text(pDX, IDC_PRD_ID, m_prd_id);
	DDX_Text(pDX, IDC_PRD_NAME, m_prd_name);
	DDX_Text(pDX, IDC_LOT_DESCR, m_lot_descr);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CaplLotDlg, CaplResizableDialog)
	//{{AFX_MSG_MAP(CaplLotDlg)
	ON_BN_CLICKED(IDC_PDF_BROWSE, OnPdfBrowse)
	ON_BN_CLICKED(IDC_PDF_DEL, OnPdfDel)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB1, OnSelchangeTab1)
	ON_BN_CLICKED(IDC_B_PROPS_ADD, OnBPropsAdd)
	ON_BN_CLICKED(IDC_B_PROPS_DEL, OnBPropsDel)
	ON_BN_CLICKED(IDC_B_PROPS_PROPS, OnBPropsProps)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL CaplLotDlg::SetAnchors(void)
{
	AddAnchor(IDC_B_PROPS_ADD,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_DEL,TOP_RIGHT);
	AddAnchor(IDC_B_PROPS_PROPS,TOP_RIGHT);

	AddAnchor(IDC_TAB1,TOP_LEFT,BOTTOM_RIGHT);

	AddAnchor(IDC_T_ID,TOP_LEFT);
	AddAnchor(IDC_LOT_ID,TOP_LEFT,TOP_RIGHT);

	AddAnchor(IDC_T_DESCR,TOP_LEFT);
	AddAnchor(IDC_LOT_DESCR,TOP_LEFT,BOTTOM_RIGHT);
	
	AddAnchor(IDC_T_LOT_SZ,BOTTOM_LEFT);
	AddAnchor(IDC_LOT_SIZE,BOTTOM_LEFT);
	AddAnchor(IDC_UNIT,BOTTOM_LEFT,BOTTOM_RIGHT);
	
	AddAnchor(IDC_GRP_PDF,BOTTOM_LEFT,BOTTOM_RIGHT);
		AddAnchor(IDC_T_PRD_ID,BOTTOM_LEFT);
		AddAnchor(IDC_PRD_ID,BOTTOM_LEFT,BOTTOM_RIGHT);

		AddAnchor(IDC_T_PRD_NAME,BOTTOM_LEFT);
		AddAnchor(IDC_PRD_NAME,BOTTOM_LEFT,BOTTOM_RIGHT);

		AddAnchor(IDC_T_PDF_ID,BOTTOM_LEFT);
		AddAnchor(IDC_PDF_ID,BOTTOM_LEFT,BOTTOM_RIGHT);
		
		AddAnchor(IDC_PDF_BROWSE,BOTTOM_RIGHT);
		AddAnchor(IDC_PDF_DEL,BOTTOM_RIGHT);
		
	AddAnchor(IDOK,BOTTOM_RIGHT);
	AddAnchor(IDCANCEL,BOTTOM_RIGHT);
	
	return TRUE;
}

BOOL CaplLotDlg::InitViews(void)
{
	CaplCharactView*	pCharView	=NULL;
	CaplApprovalView*	pApprView	=NULL;
	CaplDocsView*		pDocsView	=NULL;
	CaplAccessView*		pAccView	=NULL;

	CWnd*				pWnd		=NULL;

	CArray<int,int>		caExcludes;

	CRect				rt;

	DWORD				dwStyles=WS_CHILD|WS_BORDER;

	CaplInstance*		cit			=m_lot;

	m_Tab.SetImageList(aplGetTabCtrlImageList());

	m_Tab.InsertItem(0, APL_T(""),0);
	m_Tab.AddTab(0,NULL);
	m_Tab.SetCurSel(0);

	caExcludes.Add(IDC_B_PROPS_ADD);
	caExcludes.Add(IDC_B_PROPS_DEL);
	caExcludes.Add(IDC_B_PROPS_PROPS);
	m_Tab.AddExcludeIDs(caExcludes);

	//pWnd=GetDlgItem(IDC_T_VIEW_FRAME);
	//pWnd->GetClientRect(rt);
	//pWnd->ClientToScreen(rt);
	m_Tab.GetWindowRect(rt);
	rt.DeflateRect(8,75,8,8);
	ScreenToClient(rt);

	if(NULL!=cit)
	{
		m_Tab.InsertItem(1, APL_T(""),1);
		pCharView=(CaplCharactView*)(RUNTIME_CLASS(CaplCharactView)->CreateObject());
		pCharView->Create(NULL,NULL,dwStyles,rt,this,0);
		pCharView->m_inst=cit;
		pCharView->m_api=m_api;

		pCharView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pCharView->OnInitialUpdate();
		m_Tab.AddTab(1,pCharView);
		AddAnchor(pCharView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(2, APL_T(""),2);
		pDocsView=(CaplDocsView*)(RUNTIME_CLASS(CaplDocsView)->CreateObject());
		pDocsView->Create(NULL,NULL,dwStyles,rt,this,0);
		pDocsView->m_inst=cit;
		pDocsView->m_api=m_api;

		pDocsView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pDocsView->OnInitialUpdate();
		m_Tab.AddTab(2,pDocsView);
		AddAnchor(pDocsView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

		m_Tab.InsertItem(3, APL_T(" "),3);
		pApprView=(CaplApprovalView*)(RUNTIME_CLASS(CaplApprovalView)->CreateObject());
		pApprView->Create(NULL,NULL,dwStyles,rt,this,0);
		pApprView->m_inst=cit;
		pApprView->m_api=m_api;

		pApprView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
		pApprView->OnInitialUpdate();
		m_Tab.AddTab(3,pApprView);
		AddAnchor(pApprView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);
	}

	if(NULL==cit)
		m_Tab.InsertItem(1, APL_T(""),17);
	else
		m_Tab.InsertItem(4, APL_T(""),17);

	pAccView=(CaplAccessView*)(RUNTIME_CLASS(CaplAccessView)->CreateObject());
	pAccView->Create(NULL,NULL,dwStyles|LVS_NOSORTHEADER,rt,this,0);
	pAccView->m_inst=cit;
	pAccView->m_api=m_api;

	pAccView->SetBtnsHandles(&m_bPropsAdd,&m_bPropsDel,&m_bPropsProps);
	pAccView->OnInitialUpdate();
	if(NULL==cit)
	{
		m_Tab.AddTab(1,pAccView);

		CString	csAccPatName;
		
		CaplEntity* et=NULL;

		et=m_api->m_prd_inst_mgr.e_lot;
		if(true==m_api->m_prd_inst_mgr.m_AutoUsurpire)
			if(TRUE==m_api->m_options_mgr.GetDefTmplName(et,csAccPatName))
				pAccView->SetDefaultTemplate(csAccPatName);
	}
	else
		m_Tab.AddTab(4,pAccView);

	AddAnchor(pAccView->m_hWnd,TOP_LEFT,BOTTOM_RIGHT);

	return TRUE;
}

void CaplLotDlg::ChangeViewBtnsState(BOOL bDis,BOOL bHide)
{
	CWnd*	pwnd	=NULL;

	int		iIDs[]={IDC_B_PROPS_ADD,IDC_B_PROPS_DEL,IDC_B_PROPS_PROPS};
	int		iShow=SW_SHOW;
	int		i;

	if(TRUE==bHide)
		iShow=SW_HIDE;	

	for(i=0;i<sizeof(iIDs)/sizeof(int);i++)
	{
		pwnd=GetDlgItem(iIDs[i]);
		pwnd->EnableWindow(bDis);
		pwnd->ShowWindow(iShow);
	}
}

void CaplLotDlg::GetAccessString(void)
{
	CaplAccessView*	pAccView	=NULL;

	CWnd*			pwnd		=NULL;

	int				i;
	
	for(i=0;i<m_Tab.GetItemCount();i++)
	{
		m_Tab.GetTabView(i,pwnd);
		if(pwnd!=NULL)
			if(pwnd->IsKindOf(RUNTIME_CLASS(CaplAccessView)))
			{
				pAccView=(CaplAccessView*)pwnd;
				pAccView->GetAccessString(m_csAccessString);
			}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CaplLotDlg message handlers

BOOL CaplLotDlg::OnInitDialog() 
{
	CaplInstance *inst_unit=0;

	CaplResizableDialog::OnInitDialog();

	ModifyStyleEx(0, WS_EX_DLGMODALFRAME | WS_EX_WINDOWEDGE | WS_EX_CONTROLPARENT);   
	ModifyStyle(0, WS_MAXIMIZEBOX);   

	m_bPropsAdd.SetIcon(GetAplStdIco16(APLSTDICO_PLUS));
	m_bPropsAdd.SetFlat(FALSE);
	m_bPropsDel.SetIcon(GetAplStdIco16(APLSTDICO_MINUS));
	m_bPropsDel.SetFlat(FALSE);
	m_bPropsProps.SetIcon(GetAplTableIco(APL_TABLE_PROP));
	m_bPropsProps.SetFlat(FALSE);

	{	//  Tab-   
		CRect rectTab,rectCancel;
		m_Tab.GetWindowRect(rectTab);
		m_cancel_btn.GetWindowRect(rectCancel);
		rectTab.bottom=rectCancel.top-5;
		rectTab.right=rectCancel.right;
		ScreenToClient(rectTab);
		m_Tab.MoveWindow(rectTab);
	}

	InitViews();

	m_lot_size=1;

	if(m_api==0) 
		m_ok_btn.EnableWindow(FALSE);
	else 
	{
		if(m_lot!=0)
		{
			m_api->m_prd_inst_mgr.LoadLotInfo(m_lot);
			apidata.GetAttrBN(m_lot,S::id,m_lot_id);
			apidata.GetAttrBN(m_lot,S::description,m_lot_descr);
			apidata.GetAttrBN(m_lot,_T("size"),m_unit);
			if(m_unit!=0)
			{
				apidata.GetAttrBN(m_unit,S::value_component,m_lot_size);
				apidata.GetAttrBN(m_unit,S::unit_component,inst_unit);
			}
			if(m_pdf==0)
				apidata.GetAttrBN(m_lot,S::formation,m_pdf);
		}
		if(m_pdf!=0)
		{
//			apidata.SetAutoDownloadMode(true);
			apidata.GetAttrBN(m_pdf,S::id,m_pdf_id);
			CaplInstance *prd=0;
			apidata.GetAttrBN(m_pdf,S::of_product,prd);
			apidata.GetAttrBN(prd,S::id,m_prd_id);
			apidata.GetAttrBN(prd,S::name,m_prd_name);
		}
	}
	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	if((m_lot==0) && (m_pdf!=0))
	{
		m_pdf_browse_ctrl.EnableWindow(FALSE);
		m_pdf_del_ctrl.EnableWindow(FALSE);
	}
	if(m_api!=0)
	{
		CString buf,buf1;
		aplExtent ext0;
		int i,j,k;
		apidata.GetEntityExtentBN(_T("step_unit"),ext0);
		for(i=0;i<ext0.Size;i++)
		{
			//if(CaplTreeCharacteristicItem::m_ShowID_or_Name==0)
			{
				apidata.GetAttrBN(ext0[i],S::id,buf);
			}
			/*else
			{
				apidata.GetAttrBN(ext0[i],S::name,buf);
				if(apidata.IsKindOfBN(ext0[i],S::si_unit))
				{
					apidata.GetAttrBN(ext0[i],S::prefix,buf1);
					buf1+=_T(" "); buf1+=buf;buf=buf1;
				}
			}*/
			k=m_unit_ctrl.AddString(buf);
			m_unit_ctrl.SetItemData(k,(UINT)ext0[i]);
		}
		k=m_unit_ctrl.AddString(_T(""));
		m_unit_ctrl.SetItemData(k,0);
		m_unit_ctrl.SetCurSel(k);
		if(inst_unit!=0)
		{
			i=0;
			while(1)
			{
				j=m_unit_ctrl.GetItemData(i);
				if(j==CB_ERR)
					break;
				if(j==(int)inst_unit)
				{
					m_unit_ctrl.SetCurSel(i);
					break;
				}
				i++;
			}
		}
	}

	m_Tab.InitStates();
	SetAnchors();

	UpdateData(FALSE);

	return TRUE;
}

void CaplLotDlg::OnPdfBrowse() 
{
	// TODO: Add your control notification handler code here

	CaplInstance *pdf=m_api->m_prd_inst_mgr.SelectInstance(APL_MODE_SELECT_PDF);
	if(pdf==0) return;
	if(pdf!=m_pdf)
	{
		CString buf;
		apidata.GetAttrBN(pdf,S::id,buf);
		m_pdf_id_ctrl.SetWindowText(buf);
		CaplInstance *prd=0;
		apidata.GetAttrBN(pdf,S::of_product,prd);
		apidata.GetAttrBN(prd,S::id,buf);
		m_prd_id_ctrl.SetWindowText(buf);
		apidata.GetAttrBN(prd,S::name,buf);
		m_prd_name_ctrl.SetWindowText(buf);
		m_pdf=pdf;
	}
	
}

void CaplLotDlg::OnPdfDel() 
{
	// TODO: Add your control notification handler code here
	m_pdf_id_ctrl.SetWindowText(_T(""));
	m_prd_id_ctrl.SetWindowText(_T(""));
	m_prd_name_ctrl.SetWindowText(_T(""));
	m_pdf=0;
}

void CaplLotDlg::OnOK() 
{
	if(!UpdateData(true))
		return;
	if(m_lot_id==_T(""))
	{
		AfxMessageBox( APL_T("   !"));
		return;
	}

	CaplAttrValue tst_values[1];

	CaplEntity *e_lot=apidata.GetEntityBN(_T("apl_lot"));
	tst_values[0].value.Set((LPCTSTR)m_lot_id);
	tst_values[0].attr=apidata.GetAttrDefinition(e_lot,S::id);

	if(!apidata.NET_TestUniqueAttrValues(e_lot,m_lot,1,&tst_values[0],false))
	{
		AfxMessageBox( APL_T("     !!!"));
		return;
	}

	double count=0;
	CaplInstance *inst0=0,*inst1=0;
	if(m_lot==0)
	{
		m_lot=apidata.CreateInstance(e_lot);
		m_unit=apidata.CreateInstanceBN(S::measure_with_unit);
		apidata.PutAttrBN(m_lot,_T("size"),m_unit);
		if(m_parent_lot!=0)
			apidata.PutAttrBN(m_lot,_T("parent"),m_parent_lot);

	}
	else
	{
		apidata.GetAttrBN(m_lot,_T("size"),m_unit);
		apidata.GetAttrBN(m_unit,S::value_component,count);
		apidata.GetAttrBN(m_unit,S::unit_component,inst0);
	}
	apidata.PutAttrBN(m_lot,S::id,m_lot_id);
	apidata.PutAttrBN(m_lot,S::description,m_lot_descr);
	CaplInstance *pdf=0;
	if(m_lot->GetId()!=0) 
		apidata.GetAttrBN(m_lot,S::formation,pdf);
	if(m_pdf!=pdf) 
		apidata.PutAttrBN(m_lot,S::formation,m_pdf);
	
	if(m_lot_size!=count) 
		apidata.PutAttrBN(m_unit,S::value_component,m_lot_size);

	int k=m_unit_ctrl.GetCurSel();
	if(k!=-1) 
		inst1=(CaplInstance*)m_unit_ctrl.GetItemData(k);
	if(inst0!=inst1) 
		apidata.PutAttrBN(m_unit,S::unit_component,inst1);

	GetAccessString();
	CaplResizableDialog::OnOK();
}

void CaplLotDlg::OnSelchangeTab1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CaplPropsView* pView	=NULL;
	
	BOOL	bDis	=TRUE;
	BOOL	bHide	=FALSE;

	if(0==m_Tab.GetCurSel())
		bDis=FALSE;

	ChangeViewBtnsState(bDis,!bDis);

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	if(NULL!=pView)
	{
		pView->InitView();
		pView->ChangeCtrlsState();
	}		
	
	*pResult = 0;
}

void CaplLotDlg::OnBPropsAdd() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBAdd();
}

void CaplLotDlg::OnBPropsDel() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBDel();
}

void CaplLotDlg::OnBPropsProps() 
{
	CaplPropsView* pView	=NULL;

	if(0==m_Tab.GetCurSel())
		return;

	m_Tab.GetTabView(m_Tab.GetCurSel(),(CWnd*&)pView);
	pView->OnBProps();
}
