// aplStepMgr.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "resource.h"
#include <afxdllx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static AFX_EXTENSION_MODULE AplStepMgrDLL = { NULL, NULL };

HINSTANCE CaplFormManagerDlgDLL=0;
HINSTANCE module_inst=0;
extern void InitWaitThread();
extern void init_si_name_map();
extern void InitImageLists();
extern void DestroyImageLists();

CImageList InstImageList;
CImageList EffImageList;
CImageList StateImageList;
CImageList RelImageList;
CImageList ObjStateImageList;
CImageList ItemSubtypeImageList;
CImageList TabCtrlImageList;


HINSTANCE m_hItemAttrBuildDll=0;
bool (*m_fItemAttrBuild)(bool, CaplAPI *,  CaplAttr *, CaplInstance *, CString &, CWnd*)=0;

static bool b_LoadContextMenuIcon=false;

void LoadContextMenuIcon()
{
	if(b_LoadContextMenuIcon)return;

	CaplSetResourceHandle setres(module_inst);

	CaplMenu::LoadToolBar(IDR_MENU_ICONS);
	CaplMenu::LoadToolBar(IDR_NOTES_CONTEXT);

	b_LoadContextMenuIcon=true;
}


extern CRITICAL_SECTION *aplQSortByMultiAttr_crisec;

extern "C" int APIENTRY DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	module_inst=hInstance;
	// Remove this if you use lpReserved
	UNREFERENCED_PARAMETER(lpReserved);

	if (dwReason == DLL_PROCESS_ATTACH)
	{
		TRACE0("APLSTEPMGR.DLL Initializing!\n");
		
		// Extension DLL one-time initialization
		if (!AfxInitExtensionModule(AplStepMgrDLL, hInstance))
			return 0;

		// Insert this DLL into the resource chain
		// NOTE: If this Extension DLL is being implicitly linked to by
		//  an MFC Regular DLL (such as an ActiveX Control)
		//  instead of an MFC application, then you will want to
		//  remove this line from DllMain and put it in a separate
		//  function exported from this Extension DLL.  The Regular DLL
		//  that uses this Extension DLL should then explicitly call that
		//  function to initialize this Extension DLL.  Otherwise,
		//  the CDynLinkLibrary object will not be attached to the
		//  Regular DLL's resource chain, and serious problems will
		//  result.

		new CDynLinkLibrary(AplStepMgrDLL);

		//     .    
		//init_si_name_map();

		// 	CWnd* pwnd= CWnd::FromHandle(hinst);

		CaplSetResourceHandle setres(module_inst);

		InitImageLists();

		//CaplMenu::LoadToolBar(IDR_MENU_ICONS);
		//CaplMenu::LoadToolBar(IDR_NOTES_CONTEXT);

		CaplStepManager::LoadGlobalParams();

#ifdef _DEBUG
		CaplFormManagerDlgDLL=AfxLoadLibrary(_T("aplFormManagerDlgD.dll"));
#else
		CaplFormManagerDlgDLL=AfxLoadLibrary(_T("aplFormManagerDlg.dll"));
#endif // _DEBUG


		TCHAR *csLibName;
		#ifdef DEBUG
			csLibName=_T("ItemAttrBuilder.dll");
		#else
			csLibName=_T("ItemAttrBuilder.dll");
		#endif

		m_hItemAttrBuildDll=AfxLoadLibrary(csLibName);

		if(m_hItemAttrBuildDll==0)
		{
			csLibName=_T("ItemAttrBuilderApl.dll");
			m_hItemAttrBuildDll=AfxLoadLibrary(csLibName);
		}



		if(NULL!=m_hItemAttrBuildDll)
		{
			(FARPROC&)m_fItemAttrBuild=::GetProcAddress(m_hItemAttrBuildDll,"ItemAttrBuild");
		}
		else m_fItemAttrBuild=0;

	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		TRACE0("APLSTEPMGR.DLL Terminating!\n");
		// Terminate the library before destructors are called
		AfxTermExtensionModule(AplStepMgrDLL);
		
		if(CaplFormManagerDlgDLL!=0){
			AfxFreeLibrary(CaplFormManagerDlgDLL);
		}

		DestroyImageLists();

		if(m_hItemAttrBuildDll!=0) 
		{ 
			AfxFreeLibrary(m_hItemAttrBuildDll); 
			m_hItemAttrBuildDll=0;
			m_fItemAttrBuild=0;
		}
		if(0!=aplQSortByMultiAttr_crisec)
		{ 
			DeleteCriticalSection(aplQSortByMultiAttr_crisec); 
			delete aplQSortByMultiAttr_crisec; 
			aplQSortByMultiAttr_crisec=0;
		}

	}
	return 1;   // ok
}
