// StPntSelectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "StPntSelectDlg.h"

#include "aplWorkFlowManager.h"
#include <apl_api.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStPntSelectDlg dialog


CStPntSelectDlg::CStPntSelectDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CStPntSelectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CStPntSelectDlg)
	m_sName = _T("");
	m_iPoint = -1;
	//}}AFX_DATA_INIT

	m_api= NULL;
	m_process= NULL;
	m_start_point= NULL;
}


void CStPntSelectDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CStPntSelectDlg)
	DDX_Control(pDX, IDC_STP_ST, m_pointsCB);
	DDX_Control(pDX, IDCANCEL, m_cancelBtn);
	DDX_Control(pDX, IDOK, m_okBtn);
	DDX_Text(pDX, IDC_STP_PROCESS, m_sName);
	DDX_CBIndex(pDX, IDC_STP_ST, m_iPoint);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CStPntSelectDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CStPntSelectDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStPntSelectDlg message handlers

void CStPntSelectDlg::OnOK() 
{
	UpdateData();

	if(m_iPoint!=-1)
	{
		m_start_point= (CaplInstance*)m_pointsCB.GetItemData(m_iPoint);
	}
	
	CaplTranslateDialog::OnOK();
}

BOOL CStPntSelectDlg::OnInitDialog() 
{
	CaplTranslateDialog::OnInitDialog();

	m_cancelBtn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancelBtn.SetFlat(FALSE);
	m_okBtn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_okBtn.SetFlat(FALSE);

	if(m_api && m_api->m_data.IsConnected())
	{
		if(m_process)
		{
			aplExtent acts, st_points;
			CString str, sName;
			int iNum;
			
			m_wf_mgr->GetProcessComponents(m_process, acts);

			m_api->m_data.GetAttr(m_process, m_wf_mgr->a_action_id, m_sName);
			m_sName+=_T(" : ");
			m_api->m_data.GetAttr(m_process, m_wf_mgr->a_action_name, str);
			m_sName+=str;
			
			int m= 100;
			for(int i= 0; i<acts.GetSize(); i++)
			{
				if(m_api->m_data.IsKindOf(acts[i], m_wf_mgr->e_start_point))
				{	
					m_api->m_data.GetAttr(acts[i], m_wf_mgr->a_action_id, sName);
					m_api->m_data.GetAttr(acts[i], m_wf_mgr->a_action_name, str);
					if(!str.IsEmpty())
						sName+=_T(" : ")+str;

					iNum= m_pointsCB.AddString(sName);
					m_pointsCB.SetItemData(iNum, (DWORD)acts[i]);
					m_iPoint= 0;
				}
			}
			
			UpdateData(FALSE);

			if(m_pointsCB.GetCount()<2)
				OnOK();
		}
	}
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
