#include "stdafx.h"

#include <apl_excel.h>

#define iTemplateStartLine 5

class COutStr
{
public:

	COutStr();

	CaplInstance *m_rel;

	CString m_pos;
	CString m_pos4sort;
	CString m_name;
	CString m_type;
	CString m_doc;
	
	CString m_usage;
	CString m_unit;

	double m_count;
	double m_count_sb;

	CString m_material;
	
	double m_diam;
	double m_l;
	double m_h;
	double m_b;

	double m_weigth;

	CString m_route;

	int m_indexColor;
};

COutStr::COutStr() : m_rel(0), m_count(0), m_count_sb(0), m_diam(0), m_l(0), m_h(0), m_b(0), m_weigth(0), m_indexColor(0)
{

}

typedef CaplTAggr <COutStr*,COutStr*, APLAGGR_AUTOKILLREF|APLAGGR_LIST>  TOutStrArray;


int CompareOutStrByPos( const void *p1,const void *p2)
{
	COutStr *l1=*((COutStr**)p1);
	COutStr *l2=*((COutStr**)p2);
	return l1->m_pos4sort.Compare(l2->m_pos4sort);
}

COLORREF colors[10]={RGB(0,0,0),
					RGB(155,194,230),// c
					RGB(255,230,153),// };
					RGB(169,208,142), // 
					RGB(244,176,132), // 
					RGB(198,89,17) // .
};



//*********************************************************************************************
bool bExportAssembly(CaplAPI *m_api, CaplInstance *pdf, double sb_count, TOutStrArray &FullOutArray);
bool bSaveToSheet(TOutStrArray &outArray, CaplExcelSheet &sheet, int iStartLine, int trdWaitDlg);

//*********************************************************************************************

bool GetPdfName(CaplAPI *m_api, CaplInstance *pdf, CString &sPdfName, bool bOnlyId=false)
{
	sPdfName="";
	if(0==m_api) return false;
	if(0==pdf) return false;
	if(pdf->IsDeleted()) return false;
	if(pdf->GetAccessmode()>aplRO) {sPdfName="???"; return false;}

	CaplInstance *prd;
	m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_prd, prd);
	if(0==prd) return false;
	if(prd->IsDeleted()) return false;
	if(prd->GetAccessmode()>aplRO) return false;

	CString buf, sId,sName,sVer;

	m_api->m_data.GetAttr(pdf, m_api->m_prd_mgr.a_pdf_id, sVer);
	m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_id, sId);
	m_api->m_data.GetAttr(prd, m_api->m_prd_mgr.a_prd_name, sName);

	sPdfName=sId;
	if(sVer!="") {sPdfName+='-'; sPdfName+=sVer;}

	if(!bOnlyId && sName!="")
	{
		CString buf1=sPdfName; buf1.MakeLower();
		CString buf2=sName;    buf2.MakeLower();

		if(buf1.Find(buf2)<0)
		{
			if(sPdfName!="") sPdfName+=' ';
			sPdfName+=sName;
		}
	}
	return true;
}

//*********************************************************************************************

__declspec (dllexport) bool add_export_mns(CaplAPI* api, aplExtent& inExtent, bool bUpdateUI)
{
	if(0==api) return false;
	if(0==inExtent.GetSize()) return false;
	
	CaplInstance *pdf=inExtent[0];
	
	if(0==pdf) return false;
	if(pdf->IsDeleted()) return false;
	if(pdf->GetAccessmode()>aplRO) return false;
	if(!api->m_data.IsKindOf(pdf,api->m_prd_mgr.e_pdf)) return false;

	if(bUpdateUI) return true;

	CString sParentName;
	GetPdfName(api, pdf, sParentName, true);


	CString buf;

	//  
	buf=AfxGetApp()->m_pszHelpFilePath;
	int i=buf.ReverseFind('\\');
	CString sTemplateFile=buf.Left(i+1);
	sTemplateFile+="MNS-template.xlsx";

	CFileFind ff;
	if(!ff.FindFile(sTemplateFile))
	{
		buf.Format("    '%s'! ",LPCSTR(sTemplateFile));
		AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
		return false;
	}

	//CString sOutFileName="C:\\Users\\Alexey\\Desktop\\out.xlsx";
	CString sOutFileName=sParentName;
	CaplFile::NormalizeFileName(sOutFileName);
	sOutFileName+=".xlsx";
	CFileDialog f_dlg(FALSE,_T("*.xlsx"),sOutFileName,OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, APL_T(" excel (*.xlsx)|*.xlsx|  (*.*)|*.*|"),0);
	if(f_dlg.DoModal()!=IDOK) return false;
	sOutFileName=f_dlg.GetPathName(); 

	::DeleteFile(sOutFileName);
	if(!::CopyFile(sTemplateFile,sOutFileName,TRUE)) 
	{
		AfxMessageBox("  ",MB_OK|MB_ICONSTOP);
		return false;
	}

	//    CaplExcelFile   
	{
		//   
		CaplExcelFile excelFile;
		if(!excelFile.Open(sOutFileName))
		{
			buf.Format("   '%s'! ",LPCSTR(sTemplateFile));
			AfxMessageBox(buf,MB_OK|MB_ICONSTOP);
			return false;
		}

		CaplExcelSheet sheet;
		if(!sheet.OpenSheet(&excelFile,1)){AfxMessageBox("   1  ",MB_OK|MB_ICONSTOP);  excelFile.Close(); return false; }

		TOutStrArray FullOutArray;

		CString ;
		GetPdfName(api,pdf, sParentName);
		COutStr *header=new COutStr();
		header->m_name=sParentName;
		FullOutArray.Add(header);

		long trd=aplStartWaitDlg( "  ...");

		aplInstArray ext_pdf;
		aplRealArray count_array;
		aplInstArray ext_unit;

		api->m_prd_mgr.DisassemblyProductEx(0,0,pdf,ext_pdf,count_array,ext_unit,0,0,false,0,0);

		bExportAssembly(api, pdf, 1.0, FullOutArray);


		for(i=0;i<ext_pdf.GetSize();i++)
		{
			CaplInstance *pdf2=ext_pdf[i];
			if(0==pdf2) continue;
			if(pdf2->IsDeleted()) continue;
			if(pdf2->GetAccessmode()>aplRO) continue;

			api->m_data.GetAttr(pdf2, api->m_prd_mgr.a_apl_pdf_type, buf);
			if(buf=="material" || buf=="part") continue;

			bExportAssembly(api, pdf2, count_array[i], FullOutArray);
		}


		aplSetTextWaitDlg(trd, "  Excell ...");

		bSaveToSheet(FullOutArray, sheet, iTemplateStartLine, trd);

		sheet.SetName(sParentName);


		aplSetTextWaitDlg(trd, " ...");
		excelFile.Save();
		excelFile.Close();

		aplEndWaitDlg(trd);
	}

	if(IDYES==AfxMessageBox(_T(" !     ?"),MB_ICONINFORMATION|MB_YESNO))
	{
		ShellExecute(0,_T("open"),sOutFileName,NULL,NULL,SW_SHOW);
	}

	return false;

}

//*********************************************************************************************

bool bExportAssembly(CaplAPI *m_api, CaplInstance *pdf, double sb_count, TOutStrArray &FullOutArray)
{
	CString sParentName;
	GetPdfName(m_api,pdf, sParentName, true);

	aplExtent ext_rel, ext_pdf; 
	m_api->m_prd_mgr.LoadAllSubProduct(0,0,pdf,ext_rel,ext_pdf,false);

	CString buf, sId;

	//  -    (    .)
	if(ext_pdf.GetSize()==1)
	{
		CaplInstance *pdf4=ext_pdf[0];
		m_api->m_data.GetAttr(pdf4, m_api->m_prd_mgr.a_apl_pdf_type, buf);
		if(buf=="material") return true; //   
	}
	
	int i,j,k;
	CaplInstance *pdf2, *unit;

	//  
	aplExtent ext_doc, ext_doc_rel;
	CaplMap map_pdf_doc;
	m_api->m_doc_mgr.FindAssociatedDocuments(ext_pdf,ext_doc, ext_doc_rel);
	CaplInstance *doc, *item, *dt;
	for(i=0; i<ext_doc_rel.GetSize(); i++)
	{
		CaplInstance *rel=ext_doc_rel[i];
		m_api->m_data.GetAttr(rel,m_api->m_doc_mgr.a_apl_doc_ref_item,item);
		m_api->m_data.GetAttr(rel,m_api->m_doc_mgr.a_apl_doc_ref_doc,doc);

		if(0==item || 0==doc) continue;
		m_api->m_data.GetAttr(doc,m_api->m_doc_mgr.a_doc_kind ,dt);
		if(0==dt) continue;
		
		m_api->m_data.GetAttr(dt,m_api->m_doc_mgr.a_dt_pdt, buf);
		buf.MakeLower();
		if(buf.Find("")<0) continue;

		map_pdf_doc.Add(item, doc);
	}
	map_pdf_doc.SortIn();

	//   
	CaplInstance *charact_d=m_api->m_charact_mgr.GetCharacteristicBN("");
	CaplInstance *charact_l=m_api->m_charact_mgr.GetCharacteristicBN("");
	CaplInstance *charact_h=m_api->m_charact_mgr.GetCharacteristicBN("");
	CaplInstance *charact_b=m_api->m_charact_mgr.GetCharacteristicBN("");
	CaplInstance *charact_m=m_api->m_charact_mgr.GetCharacteristicBN("");
	CaplInstance *charact_r=m_api->m_charact_mgr.GetCharacteristicById("");

	CaplMap  mapCharactD;
	CaplMap  mapCharactL;
	CaplMap  mapCharactH;
	CaplMap  mapCharactB;
	CaplMap  mapCharactM;
	CaplMap  mapCharactR;

	CaplInstance *charact;
	aplExtent ext_all_caharact;
	m_api->m_charact_mgr.FindAssociatedCharacteristics(ext_pdf, ext_all_caharact);
	for(i=0; i<ext_all_caharact.GetSize(); i++)
	{
		CaplInstance *char_val=ext_all_caharact[i];
		if(0==char_val) continue;
		if(char_val->IsDeleted()) continue;
		if(char_val->GetAccessmode()>aplRO) continue;
		//if(!m_api->m_data.IsKindOf(char_val, m_api->m_charact_mgr.e_meas_value)) continue;

		m_api->m_data.GetAttr(char_val,m_api->m_charact_mgr.a_apl_charact_val_item, item);
		m_api->m_data.GetAttr(char_val,m_api->m_charact_mgr.a_apl_charact_val_charact, charact);
		//m_api->m_data.GetAttr(char_val,m_api->m_charact_mgr.a_apl_charact_val_meas_val, dval);

		if(0!=charact_d && charact_d==charact) mapCharactD.Add(item,char_val);
		if(0!=charact_l && charact_l==charact) mapCharactL.Add(item,char_val);
		if(0!=charact_h && charact_h==charact) mapCharactH.Add(item,char_val);
		if(0!=charact_b && charact_b==charact) mapCharactB.Add(item,char_val);
		if(0!=charact_m && charact_m==charact) mapCharactM.Add(item,char_val);
		if(0!=charact_r && charact_r==charact) mapCharactR.Add(item,char_val);
	}

	
	//  
	TOutStrArray  out_arr;

	for(i=0; i<ext_rel.GetSize(); i++)
	{
		CaplInstance *rel=ext_rel[i];

		m_api->m_data.GetAttr(rel,m_api->m_prd_mgr.a_pdr_r_ted,pdf2);
		if(0==pdf2) continue;
		if(pdf2->IsDeleted()) continue;

		COutStr *pOurStr=new(COutStr);
		out_arr.Add(pOurStr);

		pOurStr->m_rel=rel;

		// 
		m_api->m_data.GetAttr(rel,m_api->m_prd_mgr.a_pdr_id, pOurStr->m_pos);

		k=10-pOurStr->m_pos.GetLength();
		buf="";
		for(j=0;j<k;j++) buf+=' ';
		buf+=pOurStr->m_pos;

		pOurStr->m_pos4sort=buf;

		// 
		GetPdfName(m_api,pdf2, pOurStr->m_name);

		pOurStr->m_usage=sParentName;

		// Unit
		m_api->m_data.GetAttr(rel,m_api->m_prd_mgr.a_apl_qacu_unit, unit);
		if(0!=unit)  m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, pOurStr->m_unit);
		if(pOurStr->m_unit=="") pOurStr->m_unit=""; 
		else if(pOurStr->m_unit==".") pOurStr->m_unit="";  

		// Count
		m_api->m_data.GetAttr(rel,m_api->m_prd_mgr.a_apl_qacu_value, pOurStr->m_count);
		pOurStr->m_count_sb = sb_count;

		// 
		m_api->m_data.GetAttr(pdf2, m_api->m_prd_mgr.a_pdfwss_source, buf);
		if(buf=="bought") pOurStr->m_type='';
		else
		{
			m_api->m_data.GetAttr(pdf2, m_api->m_prd_mgr.a_apl_pdf_type, buf);
			if(buf=="part") pOurStr->m_type="";
			else if(buf=="assembly") pOurStr->m_type="";
			else if(buf=="kit") pOurStr->m_type="";
			else if(buf=="komplex") pOurStr->m_type="";
			else if(buf=="material") pOurStr->m_type="";
			else if(buf=="zone") pOurStr->m_type="";
			else if(buf=="module") pOurStr->m_type="";
			else if(buf=="system") pOurStr->m_type="";
			else pOurStr->m_type=CaplProductManager::StrConvertPdfType2Rus(buf);
		}

		//  
		CaplInstance *doc=(CaplInstance*)map_pdf_doc.QGetByInP(pdf2);
		if(0!=doc) m_api->m_data.GetAttr(doc, m_api->m_doc_mgr.a_doc_id, pOurStr->m_doc);


		// /
		if(pOurStr->m_type=="" || pOurStr->m_type=="" )
		{
			aplExtent ext_rel3, ext_pdf3; 
			m_api->m_prd_mgr.LoadAllSubProduct(0,0,pdf2,ext_rel3,ext_pdf3, false);
			if(ext_pdf3.GetSize()==1)
			{
				CaplInstance *pdf4=ext_pdf3[0];
				m_api->m_data.GetAttr(pdf4, m_api->m_prd_mgr.a_apl_pdf_type, buf);
				if(buf=="material")
				{
					GetPdfName(m_api,pdf4,  pOurStr->m_material);

					buf=pOurStr->m_material; buf.MakeUpper();
	
					//    -
					if(buf.Find("")>=0)
					{
						if(buf.Find("4543-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("14637-")>=0) pOurStr->m_indexColor=1; // 
						else if(buf.Find("13663-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("1050-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("1577-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("8568-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("1577-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("380-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("13345-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("4543-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("16523-")>=0) pOurStr->m_indexColor=1;
						else if(buf.Find("7350-")>=0) pOurStr->m_indexColor=2; // 
						else if(buf.Find("9941-")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("9940-")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("5582-")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("2590")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("5632-")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("15527-")>=0) pOurStr->m_indexColor=3; // 
						else if(buf.Find("21631-")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("18482-")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("859-")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("613-")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("17232-")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("10007-")>=0) pOurStr->m_indexColor=4; // 
						else if(buf.Find("535-")>=0) pOurStr->m_indexColor=5; // 
					}
					else
					{
						if(buf.Find("6")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find(".")>=0) pOurStr->m_indexColor=3;
						else if(buf.Find("")>=0) pOurStr->m_indexColor=4;
						else if(buf.Find("")>=0 && buf.Find("1218")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("")>=0 && buf.Find("189")>=0) pOurStr->m_indexColor=2;
						else if(buf.Find("20")>=0) pOurStr->m_indexColor=1;					
						else if(buf.Find("10")>=0) pOurStr->m_indexColor=1;	
						else if(buf.Find("092")>=0) pOurStr->m_indexColor=1;
					}
				}
			}
		}

		// 
		CaplInstance *char_val;

		char_val=(CaplInstance*)mapCharactD.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_meas_val,  pOurStr->m_diam);

		char_val=(CaplInstance*)mapCharactL.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_meas_val,  pOurStr->m_l);

		char_val=(CaplInstance*)mapCharactH.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_meas_val,  pOurStr->m_h);

		char_val=(CaplInstance*)mapCharactB.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_meas_val,  pOurStr->m_b);

		char_val=(CaplInstance*)mapCharactM.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_meas_val,  pOurStr->m_weigth);

		char_val=(CaplInstance*)mapCharactR.QGetByInP(pdf2);
		if(0!=char_val) m_api->m_data.GetAttr(char_val, m_api->m_charact_mgr.a_apl_charact_val_descr_val,  pOurStr->m_route);
		
	}

	// 
	qsort(out_arr.Data,out_arr.GetSize(),sizeof(COutStr*),CompareOutStrByPos);

	//    

	
	//  
	if(FullOutArray.GetSize()>1) FullOutArray.Add(new COutStr());
	
	// 
	/*COutStr *header=new COutStr();
	header->m_name=sParentName;
	FullOutArray.Add(header);*/

	for(i=0;i<out_arr.GetSize();i++) FullOutArray.Add(out_arr[i]);

	out_arr.AutoKillReference=false;
	out_arr.Clear();

	return true;
}

//**********************************************************************************************************
bool isAllDig(const CString &str)
{
	int i,k=str.GetLength();
	for(i=0;i<k;i++)
	{
		char t=str[i];
		if(t>='0' && t<='9') continue;
		return false;
	}
	return true;
}

//**********************************************************************************************************

bool bSaveToSheet(TOutStrArray &outArray, CaplExcelSheet &sheet, int iStartLine, int trdWaitDlg)
{
	int i, j, k, colcount=sheet.GetColunmsCount();
	bool b=true;

	const int iColPos=2;
	const int iColName=3;
	const int iColType=4;
	const int iColDoc=5;
	const int iColUsage=6;
	const int iColUnit=8;
	const int iColCount=9;
	const int iColCountSb=10;
	const int iColMaterial=12;
	const int iColD=13;
	const int iColL=14;
	const int iColH=15;
	const int iColB=16;
	const int iColWeight=17;
	const int iColRoute=18;

	_variant_t varVal;

	//   
	aplSetTextWaitDlg(trdWaitDlg, "  Excel ( )...");

	int iCounter=10;
	CString buf, sMsg;

	k=outArray.GetSize();
	/*for(i=0; i<k;i++)
	{
		iCounter--;
		if(iCounter<0)
		{
			iCounter=9;
			sMsg.Format("  Excel\n (  %i / %i)",i,k);
			aplSetTextWaitDlg(trdWaitDlg, sMsg);
		}

		j=iStartLine+i;
		b=sheet.CopyRangeWithoutShift(iStartLine, 1, iStartLine, colcount, j, 1, j, colcount);  //   
	}*/
	b=sheet.CopyRangeWithoutShift(iStartLine, 1, iStartLine, colcount, iStartLine+1, 1, iStartLine+k, colcount);  //   

	int iRow=iStartLine-1;;
	iCounter=10;	

	for(i=0;i<outArray.GetSize();i++)
	{
		iCounter--;
		if(iCounter<0)
		{
			iCounter=9;
			sMsg.Format("  Excel (%i / %i)",i,outArray.GetSize());
			aplSetTextWaitDlg(trdWaitDlg, sMsg);
		}

		COutStr *pOurStr=outArray[i];

		iRow++;

		if(pOurStr->m_name=="") //   - 
		{
			sheet.MakeCellColorRGB(iRow, iColName, RGB(255,255,0));
			for(j=1;j<colcount;j++) sheet.SetCell(iRow ,j, "", NULL);
			continue;
		}

		sheet.SetCell(iRow ,iColName, pOurStr->m_name, NULL);


		if(pOurStr->m_count==0 && pOurStr->m_count_sb==0 && pOurStr->m_pos=="") //  
		{
			sheet.MakeCellColorRGB(iRow, iColName, RGB(255,255,0));
			for(j=iColName+1;j<colcount;j++) sheet.SetCell(iRow ,j, NULL, NULL);
			continue;
		}

		sheet.SetCell(iRow ,iColPos, pOurStr->m_pos, NULL);
		sheet.SetCell(iRow ,iColType, pOurStr->m_type, NULL);
		if(pOurStr->m_doc!="") sheet.SetCell(iRow ,iColDoc, "", NULL);

		if(pOurStr->m_usage!="") sheet.SetCell(iRow ,iColUsage, pOurStr->m_usage, NULL);
		if(pOurStr->m_unit!="")  sheet.SetCell(iRow ,iColUnit, pOurStr->m_unit, NULL);

		varVal=pOurStr->m_count;		sheet.SetCell(iRow ,iColCount, varVal, NULL);
		varVal=pOurStr->m_count_sb;		sheet.SetCell(iRow ,iColCountSb, varVal, NULL);

		if(pOurStr->m_material!="")  sheet.SetCell(iRow ,iColMaterial, pOurStr->m_material, NULL);

		if(pOurStr->m_diam!=0)	{varVal=pOurStr->m_diam;	sheet.SetCell(iRow ,iColD, varVal, NULL);}
		if(pOurStr->m_l!=0)		{varVal=pOurStr->m_l;		sheet.SetCell(iRow ,iColL, varVal, NULL);}
		if(pOurStr->m_h!=0)		{varVal=pOurStr->m_h;		sheet.SetCell(iRow ,iColH, varVal, NULL);}
		if(pOurStr->m_b!=0)		{varVal=pOurStr->m_b;		sheet.SetCell(iRow ,iColB, varVal, NULL);}
		if(pOurStr->m_weigth!=0){varVal=pOurStr->m_weigth;	sheet.SetCell(iRow ,iColWeight, varVal, NULL);}
		if(pOurStr->m_indexColor>0)  sheet.MakeCellColorRGB(iRow, iColWeight, colors[pOurStr->m_indexColor] );

		if(pOurStr->m_route!="")
		{
			sheet.SetCell(iRow ,iColRoute, pOurStr->m_route, NULL);
			buf=pOurStr->m_route;
			buf.MakeLower();
			if(buf.Find("")>=0) sheet.MakeCellColorRGB(iRow, iColRoute, RGB(255,213,234));
			else if( !(buf.Find("")>=0 || isAllDig(buf)) ) sheet.MakeCellColorRGB(iRow, iColRoute, RGB(195,228,255));
		}
	}

	//    (    )
	iRow++;
	for(j=1;j<colcount;j++) sheet.SetCell(iRow ,j, "", NULL);

	return true;
}