#if !defined(AFX_MAINDIALOG_H__B5710ED7_8500_4C7D_AC8B_589B858C546C__INCLUDED_)
#define AFX_MAINDIALOG_H__B5710ED7_8500_4C7D_AC8B_589B858C546C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// maindialog.h : header file
//
#include "stdafx.h"
#include "resource.h"

#include "PrdHelper.h"
#include "CharHelper.h"
#include "PdfItem.h"

/////////////////////////////////////////////////////////////////////////////
// CMainDialog dialog

class CMainDialog : public CaplResizableDialog
{
// Construction
public:
	CMainDialog(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CMainDialog)
	enum { IDD = IDD_MAIN_DIALOG };
	CStatic	m_t_protocol_ctrl;
	CaplButton		m_cbCancel;
	CaplButton		m_cbSave;
	CaplButton		m_cbMoveUp;
	CaplButton		m_cbMoveDown;
	CaplButton		m_cbCalc;
	BOOL			m_bCalcCost;
	BOOL			m_bCalcWeight;
	BOOL			m_bUseDT;
	BOOL			m_bUseSN;
	CComboBox		m_cbContext;
	COleDateTime	m_codtDateFilter;
	COleDateTime	m_codtTimeFilter;
	CString			m_csCdCost;
	CString			m_csCdWeight;
	CString			m_csCostUnit;
	CString			m_csPrdID;
	CString			m_csPrdName;
	CString			m_csPrdVer;
	CString			m_csSNFilter;
	CString			m_csWeightUnit;
	//}}AFX_DATA


	CaplAPI*		m_api;
	CaplInstance*	m_inst;

	CPrdHelper*		m_pPrdHelper;

	CPdfItem*		m_pItem;

	BOOL			m_bNeedRebuild;

	virtual bool	Expand(UINT iAction);
	virtual bool	Expand(HTREEITEM hItem,UINT iAction);
	virtual bool	Expanded(HTREEITEM hItem,UINT iAction, HWND hWnd);
	virtual void	UpdateUserData();
	virtual void	Sort(int nCol);
	virtual void	RefreshAllItems(void);



// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMainDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:


	void			ControlsSetAnchors(void);
	//				   -,     .
	void			ControlsFillPriorityCharTypesList(void);
	//				     -.
	void			ControlsMoveInPriorityList(int iDir);
	//				       
	void			ControlsGetPriorityList(aplExtent& aeCharTypes);
	//				  
	void			ControlsFillContextsList(void);

	//				    
	BOOL			ControlsGetDTFilter(COleDateTime& codtFilter);
	//				     
	BOOL			ControlsGetSNFilter(CString& csFilter);

	//				   -  
	BOOL			ControlsShowCalculatedChars(double* dChars);

	//				 
	BOOL			ControlsInitTreeList(void);
	//				   
	BOOL			ControlsTreeListAddCols(void);
	HTREEITEM		ControlsTreeListSetItem(CPdfItem* pPdfItem,HTREEITEM hParentItem);
	BOOL			ControlsTreeListExpandAll(HTREEITEM hItem);

	//				     -  
	BOOL			RebuildPdfStructure(void);
	
	void			WriteToLog(const char *message,bool to_file=true,bool show_msg_box=false,bool show_time=true);


	CaplTreeListCtrlView* m_view;

	CaplInstance*	m_ciCostChar;
	CaplInstance*	m_ciWeightChar;

	CStdioFile m_log_file;
	bool m_log_file_opened;
	CString	m_curFolder;
	CString m_prog_path;

	// Generated message map functions
	//{{AFX_MSG(CMainDialog)
	virtual BOOL OnInitDialog();
	afx_msg void OnDestroy();
	afx_msg void OnBSave();
	afx_msg void OnCheckFilters();
	afx_msg void OnCheckCalcChars();
	afx_msg void OnBChooseWeight();
	afx_msg void OnBChooseCost();
	afx_msg void OnBMoveUp();
	afx_msg void OnBMoveDown();
	afx_msg void OnBCalc();
	afx_msg void OnDTFilterChange(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnSNFilterChange();
	afx_msg void OnContextChange();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINDIALOG_H__B5710ED7_8500_4C7D_AC8B_589B858C546C__INCLUDED_)
