#include "StdAfx.h"
#include "Condition.h"

CCondition::CCondition(void)
{
	Clear();
}

CCondition::CCondition( const CCondition& obj )
{
	m_caOperations.Append(obj.m_caOperations);
	m_saDefaultValues.Append(obj.m_saDefaultValues);
	m_sName = obj.m_sName;
	m_sAttr = obj.m_sAttr;
	m_type = obj.m_type;
	m_sVal = obj.m_sVal;
	m_dtTime = obj.m_dtTime;
	m_ciVal = obj.m_ciVal;	
}

CCondition& CCondition::operator=(const CCondition& obj)
{ 
	m_caOperations.Append(obj.m_caOperations);
	m_saDefaultValues.Append(obj.m_saDefaultValues);
	m_sName = obj.m_sName;
	m_sAttr = obj.m_sAttr;
	m_type = obj.m_type;
	m_sVal = obj.m_sVal;
	m_dtTime = obj.m_dtTime;
	m_ciVal = obj.m_ciVal;

	return *this;
}

void CCondition::Clear()
{
	m_caOperations.RemoveAll();
	m_saDefaultValues.RemoveAll();
	m_sName.Empty();
	m_sAttr.Empty();
	m_type = COND_STRING;
	m_sVal.Empty();
	m_dtTime = COleDateTime::GetCurrentTime();
	m_ciVal = NULL;
	m_ciChooseParent = NULL;
}

CCondition::~CCondition(void)
{
}