// RefClassifChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefClassifChildDlg.h"


// CRefClassifChildDlg dialog

IMPLEMENT_DYNAMIC(CRefClassifChildDlg, CaplTranslateDialog)

CRefClassifChildDlg::CRefClassifChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefClassifChildDlg::IDD, pParent)
{
	m_api = api;
	m_refusal_dlg=0;

	m_ciRef = 0;
	m_ciConditions = 0;
	m_ciManifistation = 0;
	m_ciDof = 0;
	m_ciReason = 0;
	m_ciMethod = 0;
	m_ciConseq = 0;
	m_ciCulprit = 0;
	
}

CRefClassifChildDlg::~CRefClassifChildDlg()
{
}

void CRefClassifChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_CHOOSE_CONDITIONS, m_choose_conditions);
	DDX_Control(pDX, IDC_CHOOSE_MANIFISTATION, m_choose_manifistation);
	DDX_Control(pDX, IDC_CHOOSE_DOF, m_choose_dof);
	DDX_Control(pDX, IDC_CHOOSE_REASON, m_choose_reason);
	DDX_Control(pDX, IDC_CHOOSE_METHOD, m_choose_method);
	DDX_Control(pDX, IDC_CHOOSE_CONSEQ, m_choose_conseq);
	DDX_Control(pDX, IDC_CHOOSE_CULPRIT, m_choose_culprit);

	DDX_Control(pDX, IDC_CLEAR_CONDITIONS, m_clear_conditions);
	DDX_Control(pDX, IDC_CLEAR_MANIFISTATION, m_clear_manifistation);
	DDX_Control(pDX, IDC_CLEAR_DOF, m_clear_dof);
	DDX_Control(pDX, IDC_CLEAR_REASON, m_clear_reason);
	DDX_Control(pDX, IDC_CLEAR_METHOD, m_clear_method);
	DDX_Control(pDX, IDC_CLEAR_CONSEQ, m_clear_conseq);
	DDX_Control(pDX, IDC_CLEAR_CULPRIT, m_clear_culprit);

	DDX_Text(pDX, IDC_CONDITIONS_ID, m_sConditionsId);
	DDX_Text(pDX, IDC_MANIFISTATION_ID, m_sManifistationId);
	DDX_Text(pDX, IDC_DOF_ID, m_sDofId);
	DDX_Text(pDX, IDC_REASON_ID, m_sReasonId);
	DDX_Text(pDX, IDC_METHOD_ID, m_sMethodId);
	DDX_Text(pDX, IDC_CONSEQ_ID, m_sConseqId);
	DDX_Text(pDX, IDC_CULPRIT_ID, m_sCulpritId);
	DDX_Text(pDX, IDC_REF_MANIF_DESCR, m_sRefManifDescr);

	DDX_Text(pDX, IDC_CONDITIONS_NAME, m_sConditionsName);
	DDX_Text(pDX, IDC_MANIFISTATION_NAME, m_sManifistationName);
	DDX_Text(pDX, IDC_DOF_NAME, m_sDofName);
	DDX_Text(pDX, IDC_REASON_NAME, m_sReasonName);
	DDX_Text(pDX, IDC_METHOD_NAME, m_sMethodName);
	DDX_Text(pDX, IDC_CONSEQ_NAME, m_sConseqName);
	DDX_Text(pDX, IDC_CULPRIT_NAME, m_sCulpritName);
}


BEGIN_MESSAGE_MAP(CRefClassifChildDlg, CaplTranslateDialog)
	ON_BN_CLICKED(IDC_CLEAR_CONDITIONS, &CRefClassifChildDlg::OnBnClickedClearConditions)
	ON_BN_CLICKED(IDC_CLEAR_MANIFISTATION, &CRefClassifChildDlg::OnBnClickedClearManifistation)
	ON_BN_CLICKED(IDC_CLEAR_DOF, &CRefClassifChildDlg::OnBnClickedClearDof)
	ON_BN_CLICKED(IDC_CLEAR_REASON, &CRefClassifChildDlg::OnBnClickedClearReason)
	ON_BN_CLICKED(IDC_CLEAR_METHOD, &CRefClassifChildDlg::OnBnClickedClearMethod)
	ON_BN_CLICKED(IDC_CLEAR_CONSEQ, &CRefClassifChildDlg::OnBnClickedClearConseq)
	ON_BN_CLICKED(IDC_CLEAR_CULPRIT, &CRefClassifChildDlg::OnBnClickedClearCulprit)
	ON_BN_CLICKED(IDC_CHOOSE_CONDITIONS, &CRefClassifChildDlg::OnBnClickedChooseConditions)
	ON_BN_CLICKED(IDC_CHOOSE_MANIFISTATION, &CRefClassifChildDlg::OnBnClickedChooseManifistation)
	ON_BN_CLICKED(IDC_CHOOSE_DOF, &CRefClassifChildDlg::OnBnClickedChooseDof)
	ON_BN_CLICKED(IDC_CHOOSE_REASON, &CRefClassifChildDlg::OnBnClickedChooseReason)
	ON_BN_CLICKED(IDC_CHOOSE_METHOD, &CRefClassifChildDlg::OnBnClickedChooseMethod)
	ON_BN_CLICKED(IDC_CHOOSE_CONSEQ, &CRefClassifChildDlg::OnBnClickedChooseConseq)
	ON_BN_CLICKED(IDC_CHOOSE_CULPRIT, &CRefClassifChildDlg::OnBnClickedChooseCulprit)
END_MESSAGE_MAP()

void CRefClassifChildDlg::OnCancel()
{

}

void CRefClassifChildDlg::OnOK()
{

}

BOOL CRefClassifChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	InitInstances();
	FillDataBase();

	return TRUE;
}

void CRefClassifChildDlg::SetReadOnly()
{
	m_choose_conditions.EnableWindow(FALSE);
	m_choose_manifistation.EnableWindow(FALSE);
	m_choose_dof.EnableWindow(FALSE);
	m_choose_reason.EnableWindow(FALSE);
	m_choose_method.EnableWindow(FALSE);
	m_choose_conseq.EnableWindow(FALSE);
	m_choose_culprit.EnableWindow(FALSE);

	m_clear_conditions.EnableWindow(FALSE);
	m_clear_manifistation.EnableWindow(FALSE);
	m_clear_dof.EnableWindow(FALSE);
	m_clear_reason.EnableWindow(FALSE);
	m_clear_method.EnableWindow(FALSE);
	m_clear_conseq.EnableWindow(FALSE);
	m_clear_culprit.EnableWindow(FALSE);

	CWnd *wnd;
	wnd=GetDlgItem(IDC_REF_MANIF_DESCR);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
}


void CRefClassifChildDlg::InitBtns()
{
	m_choose_conditions.SetFlat(TRUE);
	m_choose_conditions.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_conditions.SetTooltipText(APL_T("  "));

	m_choose_manifistation.SetFlat(TRUE);	
	m_choose_manifistation.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_manifistation.SetTooltipText(APL_T("  "));

	m_choose_dof.SetFlat(TRUE);	
	m_choose_dof.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_dof.SetTooltipText(APL_T(" "));

	m_choose_reason.SetFlat(TRUE);	
	m_choose_reason.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_reason.SetTooltipText(APL_T(" "));

	m_choose_method.SetFlat(TRUE);	
	m_choose_method.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_method.SetTooltipText(APL_T("  "));

	m_choose_conseq.SetFlat(TRUE);	
	m_choose_conseq.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_conseq.SetTooltipText(APL_T(" "));

	m_choose_culprit.SetFlat(TRUE);	
	m_choose_culprit.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_choose_culprit.SetTooltipText(APL_T(" "));

	m_clear_conditions.SetFlat(TRUE);	
	m_clear_conditions.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_conditions.SetTooltipText(APL_T(" "));

	m_clear_manifistation.SetFlat(TRUE);	
	m_clear_manifistation.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_manifistation.SetTooltipText(APL_T(" "));

	m_clear_dof.SetFlat(TRUE);	
	m_clear_dof.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_dof.SetTooltipText(APL_T(" "));

	m_clear_reason.SetFlat(TRUE);	
	m_clear_reason.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_reason.SetTooltipText(APL_T(" "));

	m_clear_method.SetFlat(TRUE);	
	m_clear_method.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_clear_method.SetTooltipText(APL_T(" "));

	m_clear_conseq.SetFlat(TRUE);	
	m_clear_conseq.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_clear_conseq.SetTooltipText(APL_T(" "));

	m_clear_culprit.SetFlat(TRUE);	
	m_clear_culprit.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_clear_culprit.SetTooltipText(APL_T(" "));
}

void CRefClassifChildDlg::OnBnClickedClearConditions()
{
	UpdateData();
	m_ciConditions = 0;
	m_sConditionsId.Empty();
	m_sConditionsName.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearManifistation()
{
	UpdateData();
	m_ciManifistation = 0;
	m_sManifistationId.Empty();
	m_sManifistationName.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearDof()
{
	UpdateData();
	m_ciDof = 0;
	m_sDofName.Empty();
	m_sDofId.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearReason()
{
	UpdateData();
	m_ciReason = 0;
	m_sReasonName.Empty();
	m_sReasonId.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearMethod()
{
	UpdateData();
	m_ciMethod = 0;
	m_sMethodName.Empty();
	m_sMethodId.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearConseq()
{
	UpdateData();
	m_ciConseq = 0;
	m_sConseqName.Empty();
	m_sConseqId.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedClearCulprit()
{
	UpdateData();
	m_ciCulprit = 0;
	m_sCulpritName.Empty();
	m_sCulpritId.Empty();
	UpdateData(FALSE);
}

void CRefClassifChildDlg::ShowClassificatorNonfoundError(CString sClassifier)
{
	CString sMsg;
	sMsg.Format(APL_T("    \"%s\""), sClassifier);
	MessageBox(sMsg, APL_T(""), MB_ICONERROR);
}

void CRefClassifChildDlg::OnBnClickedChooseConditions()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_CONDITIONS_CLASSIFIER_LVL);
	if(system == NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_CONDITIONS_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciConditions, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_CONDITIONS_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciConditions, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sConditionsId);
		m_api->m_data.GetAttr(m_ciConditions, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sConditionsName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseManifistation()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_MANIF_CLASSIFIER_LVL);
	if(system==NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_MANIF_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciManifistation, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_MANIF_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciManifistation, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sManifistationId);
		m_api->m_data.GetAttr(m_ciManifistation, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sManifistationName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseDof()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_DOF_CLASSIFIER_LVL);
	if(system==NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_DOF_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciDof, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_DOF_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciDof, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sDofId);
		m_api->m_data.GetAttr(m_ciDof, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sDofName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseReason()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_REASON_CLASSIFIER_LVL);
	if(system==NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_REASON_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciReason, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_REASON_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciReason, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sReasonId);
		m_api->m_data.GetAttr(m_ciReason, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sReasonName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseMethod()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_METHOD_CLASSIFIER_LVL);
	if(system==NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_METHOD_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciMethod, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_METHOD_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciMethod, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sMethodId);
		m_api->m_data.GetAttr(m_ciMethod, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sMethodName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseConseq()
{
	UpdateData();
	CaplInstance *system = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_CONSEQ_CLASSIFIER_LVL);
	if(system==NULL)
	{
		ShowClassificatorNonfoundError(REFUSAL_CONSEQ_CLASSIFIER_LVL);		
		return;
	}
	if(m_api->m_classifier_mgr.SelectItem(&m_ciConseq, system, APL_SELECT_CLASSIFIER_LEVEL, REFUSAL_CONSEQ_CLASSIFIER_LVL))
	{
		m_api->m_data.GetAttr(m_ciConseq, m_api->m_classifier_mgr.a_apl_classifier_level_id, m_sConseqId);
		m_api->m_data.GetAttr(m_ciConseq, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sConseqName);
	}
	UpdateData(FALSE);
}

void CRefClassifChildDlg::OnBnClickedChooseCulprit()
{
	UpdateData();
	if(m_refusal_dlg->m_sSetupCode==APL_NO_T(""))
	{
		aplExtent ext;
		CaplInstance *p_o=m_api->m_appr_mgr.SelectPersonOrOrganization(APL_MODE_SELECT_PERSON|APL_MODE_SELECT_ORG,ext, APL_T(" "), APL_T("   "));
		if(0==p_o) return;
		m_ciCulprit=p_o;
	}
	else if(!m_api->m_appr_mgr.SelectOrganization(&m_ciCulprit, APL_T(" ")))
		return;

	GetOrganizationData(m_ciCulprit,m_sCulpritId,m_sCulpritName);
	UpdateData(FALSE);
}

void CRefClassifChildDlg::GetClassifierLvlData(CaplInstance *ciLvl, CString &id, CString &name)
{
	if(!ciLvl) return;
	m_api->m_data.GetAttr(ciLvl, m_api->m_classifier_mgr.a_apl_classifier_level_id, id);
	m_api->m_data.GetAttr(ciLvl, m_api->m_classifier_mgr.a_apl_classifier_level_name, name);
}

void CRefClassifChildDlg::GetOrganizationData(CaplInstance *ciOrg, CString &id, CString &name)
{
	if(!ciOrg) return;

	if(m_api->m_data.IsKindOf(ciOrg,m_api->m_appr_mgr.e_person))
	{
		m_api->m_data.GetAttr(ciOrg, m_api->m_appr_mgr.a_pers_id, m_sCulpritId);
		m_api->m_appr_mgr.GetPersonName(ciOrg,m_sCulpritName);
	}
	else if(m_api->m_data.IsKindOf(ciOrg,m_api->m_appr_mgr.e_org))
	{
		m_api->m_data.GetAttr(ciOrg, m_api->m_appr_mgr.a_org_id, m_sCulpritId);
		m_api->m_data.GetAttr(ciOrg, m_api->m_appr_mgr.a_org_name, m_sCulpritName);
	}
	else
	{
		m_sCulpritId=_T("");
		m_sCulpritName=_T("");
	}
	//m_api->m_data.GetAttr(ciOrg, m_api->m_appr_mgr.a_org_id, id);
	//m_api->m_data.GetAttr(ciOrg, m_api->m_appr_mgr.a_org_name, name);
}

void CRefClassifChildDlg::FillDataBase()
{
	if(!m_ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();

	GetClassifierLvlData(m_ciConditions, m_sConditionsId, m_sConditionsName);
	GetClassifierLvlData(m_ciManifistation, m_sManifistationId, m_sManifistationName);
	GetClassifierLvlData(m_ciDof, m_sDofId, m_sDofName);
	GetClassifierLvlData(m_ciReason, m_sReasonId, m_sReasonName);
	GetClassifierLvlData(m_ciMethod, m_sMethodId, m_sMethodName);
	GetClassifierLvlData(m_ciConseq, m_sConseqId, m_sConseqName);
	GetOrganizationData(m_ciCulprit, m_sCulpritId, m_sCulpritName);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_manifestation_str, m_sRefManifDescr);

	UpdateData(FALSE);
}

void CRefClassifChildDlg::SaveRefData(CaplInstance *ciRef)
{
	if(!ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateData();
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_conditions, m_ciConditions);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_manifestation, m_ciManifistation);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_dof, m_ciDof);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_faultreason, m_ciReason);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_method, m_ciMethod);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_consequences, m_ciConseq);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_culprit, m_ciCulprit);
	m_api->m_data.PutAttr(ciRef, mgr->a_apl_refusal_manifestation_str, m_sRefManifDescr);
}

void CRefClassifChildDlg::InitInstances()
{
	if(!m_ciRef) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_conditions, m_ciConditions);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_manifestation, m_ciManifistation);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_dof, m_ciDof);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_faultreason, m_ciReason);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_method, m_ciMethod);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_consequences, m_ciConseq);
	m_api->m_data.GetAttr(m_ciRef, mgr->a_apl_refusal_culprit, m_ciCulprit);
}