#pragma once
#include "resource.h"
#include "CaplFaultMgr.h"
#include "RefusalPropertyDlg.h"

// CRefClassifChildDlg dialog

class CRefClassifChildDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefClassifChildDlg)

public:
	CRefClassifChildDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefClassifChildDlg();

// Dialog Data
	enum { IDD = IDD_REF_CLASSIF };

	CaplAPI *m_api;
	CaplInstance *m_ciRef;
	CaplInstance *m_ciConditions;
	CaplInstance *m_ciManifistation;
	CaplInstance *m_ciDof;
	CaplInstance *m_ciReason;
	CaplInstance *m_ciMethod;
	CaplInstance *m_ciConseq;
	CaplInstance *m_ciCulprit;

	CaplButton m_choose_conditions;
	CaplButton m_choose_manifistation;
	CaplButton m_choose_dof;
	CaplButton m_choose_reason;
	CaplButton m_choose_method;
	CaplButton m_choose_conseq;
	CaplButton m_choose_culprit;

	CaplButton m_clear_conditions;
	CaplButton m_clear_manifistation;
	CaplButton m_clear_dof;
	CaplButton m_clear_reason;
	CaplButton m_clear_method;
	CaplButton m_clear_conseq;
	CaplButton m_clear_culprit;

	CString m_sConditionsId;
	CString m_sManifistationId;
	CString m_sDofId;
	CString m_sReasonId;
	CString m_sMethodId;
	CString m_sConseqId;
	CString m_sCulpritId;
	CString m_sRefManifDescr;

	CString m_sConditionsName;
	CString m_sManifistationName;
	CString m_sDofName;
	CString m_sReasonName;
	CString m_sMethodName;
	CString m_sConseqName;
	CString m_sCulpritName;

	CRefusalPropertyDlg *m_refusal_dlg;


	void SetReadOnly();

	//  
	void InitBtns();

	//     / 
	void GetClassifierLvlData(CaplInstance *ciLvl, CString &id, CString &name);
	void GetOrganizationData(CaplInstance *ciLvl, CString &id, CString &name);

	//     
	void FillDataBase();

	//    
	void SaveRefData(CaplInstance *ciRef);

	//   
	void InitInstances();

	//      
	void ShowClassificatorNonfoundError(CString sClassifier);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnBnClickedClearConditions();
	afx_msg void OnBnClickedClearManifistation();
	afx_msg void OnBnClickedClearDof();
	afx_msg void OnBnClickedClearReason();
	afx_msg void OnBnClickedClearMethod();
	afx_msg void OnBnClickedClearConseq();
	afx_msg void OnBnClickedClearCulprit();
	afx_msg void OnBnClickedChooseConditions();
	afx_msg void OnBnClickedChooseManifistation();
	afx_msg void OnBnClickedChooseDof();
	afx_msg void OnBnClickedChooseReason();
	afx_msg void OnBnClickedChooseMethod();
	afx_msg void OnBnClickedChooseConseq();
	afx_msg void OnBnClickedChooseCulprit();
};
