// RefDocumentsChildDlg.cpp : implementation file
//

#include "stdafx.h"
#include "RefDocumentsChildDlg.h"


// CRefDocumentsChildDlg dialog

IMPLEMENT_DYNAMIC(CRefDocumentsChildDlg, CaplTranslateDialog)

CRefDocumentsChildDlg::CRefDocumentsChildDlg(CaplAPI *api, CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CRefDocumentsChildDlg::IDD, pParent)
{
	m_api = api;
	m_ciRef = 0;
	m_pParentDlg = 0;
}

CRefDocumentsChildDlg::~CRefDocumentsChildDlg()
{
}

void CRefDocumentsChildDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_CREATE_NEW, m_create_new);
	DDX_Control(pDX, IDC_ADD_EXIST, m_add_exist);
	DDX_Control(pDX, IDC_VIEW, m_view);
	DDX_Control(pDX, IDC_CHECK_OUT, m_check_out);
	DDX_Control(pDX, IDC_CHECK_IN, m_check_in);
	DDX_Control(pDX, IDC_UNDO_CHECK_OUT, m_undo_check_out);
	DDX_Control(pDX, IDC_DELETE, m_delete);
	DDX_Control(pDX, IDC_LIST, m_list);
}


BEGIN_MESSAGE_MAP(CRefDocumentsChildDlg, CaplTranslateDialog)
	ON_NOTIFY(HDN_ITEMCHANGED, 0, &CRefDocumentsChildDlg::OnHdnItemchangedList)
	ON_BN_CLICKED(IDC_ADD_EXIST, &CRefDocumentsChildDlg::OnBnClickedAddExist)
	ON_BN_CLICKED(IDC_CREATE_NEW, &CRefDocumentsChildDlg::OnBnClickedCreateNew)
	ON_BN_CLICKED(IDC_DELETE, &CRefDocumentsChildDlg::OnBnClickedDelete)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &CRefDocumentsChildDlg::OnLvnItemchangedList)
	ON_BN_CLICKED(IDC_VIEW, &CRefDocumentsChildDlg::OnBnClickedView)
	ON_BN_CLICKED(IDC_CHECK_OUT, &CRefDocumentsChildDlg::OnBnClickedCheckOut)
	ON_BN_CLICKED(IDC_CHECK_IN, &CRefDocumentsChildDlg::OnBnClickedCheckIn)
	ON_BN_CLICKED(IDC_UNDO_CHECK_OUT, &CRefDocumentsChildDlg::OnBnClickedUndoCheckOut)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST, OnDblClick)
	ON_NOTIFY(NM_CLICK, IDC_LIST, &CRefDocumentsChildDlg::OnNMClickList)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST, &CRefDocumentsChildDlg::OnLvnKeydownList)
	ON_NOTIFY(LVN_ITEMACTIVATE, IDC_LIST, &CRefDocumentsChildDlg::OnLvnItemActivateList)
	ON_NOTIFY(LVN_ITEMCHANGING, IDC_LIST, &CRefDocumentsChildDlg::OnLvnItemchangingList)
END_MESSAGE_MAP()

BOOL CRefDocumentsChildDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	InitBtns();
	InitList();
	FillList();

	UpdateToolBar();
	return TRUE;
}

void CRefDocumentsChildDlg::OnCancel()
{

}

void CRefDocumentsChildDlg::OnOK()
{

}

void CRefDocumentsChildDlg::InitBtns()
{
	CBitmap bmp;

	// 
	bmp.LoadBitmap(IDB_DOC_ICONS);
	imageList.Create(32,32,ILC_COLOR16|ILC_MASK,20,20);
	imageList.Add(&bmp,RGB(192,192,192));
	
	// 
	m_create_new.SetFlat(TRUE);
	m_create_new.SetIcon(imageList.ExtractIcon(0));
	m_create_new.SetTooltipText(APL_T("  "));
	m_add_exist.SetFlat(TRUE);
	m_add_exist.SetIcon(imageList.ExtractIcon(1));
	m_add_exist.SetTooltipText(APL_T("   "));

	m_view.SetFlat(TRUE);
	m_view.SetIcon(imageList.ExtractIcon(2));
	m_view.SetTooltipText(APL_T(" "));
	m_check_out.SetFlat(TRUE);
	m_check_out.SetIcon(imageList.ExtractIcon(3));
	m_check_out.SetTooltipText(APL_T("  "));
	m_check_in.SetFlat(TRUE);
	m_check_in.SetIcon(imageList.ExtractIcon(4));
	m_check_in.SetTooltipText(APL_T(" "));
	m_undo_check_out.SetFlat(TRUE);
	m_undo_check_out.SetIcon(imageList.ExtractIcon(5));
	m_undo_check_out.SetTooltipText(APL_T(" "));

	m_delete.SetFlat(TRUE);
	m_delete.SetIcon(imageList.ExtractIcon(6));
	m_delete.SetTooltipText(APL_T("    "));


	if(m_api->m_data.IsReadOnly())
	{
		m_create_new.EnableWindow(FALSE);
		m_add_exist.EnableWindow(FALSE);
		m_delete.EnableWindow(FALSE);
	}

}

void CRefDocumentsChildDlg::InitList()
{
	CRect rect;
	m_list.GetClientRect(rect);

	m_list.InsertColumn(0, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.4));
	m_list.InsertColumn(1, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));
	m_list.InsertColumn(2, APL_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.3));

	m_list.SetImageList(aplGetInstImageList(), LVSIL_SMALL);	
}

void CRefDocumentsChildDlg::FillList()
{
	if(0!=m_ciRef)
	{
		aplExtent aeDocs, aeRels;
		CaplInstance *ciDoc = 0;

		m_api->m_doc_mgr.FindAssociatedDocuments(m_ciRef, aeDocs, m_aeCurrentAssoc);
		for(int i=0; i<m_aeCurrentAssoc.Size; i++)
		{
			if(!m_aeCurrentAssoc[i]) continue;

			m_api->m_data.GetAttr(m_aeCurrentAssoc[i], m_api->m_doc_mgr.a_apl_doc_ref_doc, ciDoc);
			if(!ciDoc) continue;

			int nIndex = AddDocument(ciDoc, false);		
			m_list.SetItemData(nIndex, (DWORD)m_aeCurrentAssoc[i]);
		}
	}

	if(0!=m_pParentDlg)
	{
		if(m_pParentDlg->m_extDocs4Add.GetSize()>0)
		{
			int i;
			m_api->m_doc_mgr.LoadDocInfo(m_pParentDlg->m_extDocs4Add);
			for(i=0;i<m_pParentDlg->m_extDocs4Add.GetSize();i++)
			{
				CaplInstance *ciDoc=m_pParentDlg->m_extDocs4Add[i];
				int nIndex = AddDocument(ciDoc, true);		
			}
		}
	}
}

int CRefDocumentsChildDlg::AddDocument(CaplInstance *ciDoc, bool bSetDocAsData)
{
	CString buf;
	int icon = ICON_DOCUMENT;
	CaplInstance *ciKind, *ciRev, *ciAuthor, *ciLocker;

	//   
	m_api->m_data.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_lock, ciLocker);
	if(ciLocker) icon = ICON_DOCUMENT_CHECKOUTED;

	// 
	buf.Empty();
	m_api->GetItemName(ciDoc, buf);
	int nIndex = m_list.InsertItem( m_list.GetItemCount(), buf, icon);

	//  
	buf.Empty();
	m_api->m_data.GetAttr(ciDoc, m_api->m_doc_mgr.a_doc_kind, ciKind);
	if(ciKind) m_api->m_data.GetAttr(ciKind, m_api->m_doc_mgr.a_dt_pdt, buf);
	m_list.SetItemText(nIndex, 1, buf);	

	//   
	buf.Empty();
	m_api->m_data.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_active, ciRev);
	if(ciRev) 
	{
		m_api->m_data.GetAttr(ciRev, m_api->m_doc_mgr.a_apl_doc_rev_autor, ciAuthor);
		if(ciAuthor) m_api->GetItemName(ciAuthor, buf);
	}

	m_list.SetItemText(nIndex, 2, buf);
	if(bSetDocAsData) m_list.SetItemData(nIndex, (DWORD)ciDoc);

	return nIndex;
}

void CRefDocumentsChildDlg::OnHdnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMHEADER phdr = reinterpret_cast<LPNMHEADER>(pNMHDR);

	*pResult = 0;
}

void CRefDocumentsChildDlg::OnDblClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBnClickedView();
	*pResult = 0;
}

void CRefDocumentsChildDlg::UpdateToolBar(int nIndex)
{
	if(nIndex == -1)
		nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);

	if(nIndex == -1)
	{
		//   
		m_view.EnableWindow(FALSE);
		m_check_out.EnableWindow(FALSE);
		m_check_in.EnableWindow(FALSE);
		m_undo_check_out.EnableWindow(FALSE);
		m_delete.EnableWindow(FALSE);
	}
	else
	{
		//  
		m_view.EnableWindow(TRUE);
		m_delete.EnableWindow(TRUE);	

		CaplInstance *ciDoc = (CaplInstance*)m_list.GetItemData(nIndex);

		if(m_api->m_data.IsKindOf(ciDoc, m_api->m_doc_mgr.e_apl_doc_ref))
			m_api->m_data.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciDoc);

		if(!ciDoc)
		{
			//    
			m_view.EnableWindow(FALSE);
			m_check_out.EnableWindow(FALSE);
			m_check_in.EnableWindow(FALSE);
			m_undo_check_out.EnableWindow(FALSE);
			m_delete.EnableWindow(FALSE);
		}
		else 
		{
			//  
			CaplInstance *ciLocker = 0;
			m_api->m_data.GetAttr(ciDoc, m_api->m_doc_mgr.a_apl_doc_lock, ciLocker);

			if(ciLocker)
			{
				m_check_in.EnableWindow(TRUE);
				m_undo_check_out.EnableWindow(TRUE);
				m_check_out.EnableWindow(FALSE);
			}
			else
			{
				m_check_in.EnableWindow(FALSE);
				m_undo_check_out.EnableWindow(FALSE);
				m_check_out.EnableWindow(TRUE);
			}
		}
	}

	SetFocus();
}

void CRefDocumentsChildDlg::SaveRefData( CaplInstance *ciRef, bool bExitDlg )
{
	if(!ciRef) return;
	if(!bExitDlg) return;

	int i = 0;
	aplExtent aeDocs;

	//   ,    
	for(i=0; i<m_aeDeleted.Size; i++)
	{
		if(m_aeDeleted[i]->GetId() == 0) continue;
		m_api->m_data.DeleteInstance(m_aeDeleted[i]);
	}
	
	for(i=0; i<m_list.GetItemCount(); i++)
	{
		CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(i);
		if(!ciObj) continue;
		if(!ciObj->GetType()) continue;

		if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_doc))
		{
			//   
			m_api->m_doc_mgr.CreateAssociation(ciRef, ciObj);			
		}
	}	
}

bool CRefDocumentsChildDlg::Check(CaplInstance *ciDoc)
{
	CaplInstance *cit = 0;
	for(int i=0; i<m_list.GetItemCount(); i++)
	{
		cit = (CaplInstance*)m_list.GetItemData(i);
		if(m_api->m_data.IsKindOf(cit, m_api->m_doc_mgr.e_apl_doc_ref))
			m_api->m_data.GetAttr(cit, m_api->m_doc_mgr.a_apl_doc_ref_doc, cit);

		if(cit == ciDoc)
		{
			MessageBox(APL_T("    ."), APL_T(" "), MB_ICONINFORMATION);
			return false;
		}
	}

	return true;
}

void CRefDocumentsChildDlg::OnBnClickedAddExist()
{
	if(!UpdateData()) return;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	CaplInstance* inst = mgr->SelectInstance(APL_MODE_SELECT_DOC, APL_T(" "));
	if(inst)
	{
		if(!Check(inst)) return;

		int nIndex = AddDocument(inst, true);
		UpdateToolBar();
	}

	UpdateData(FALSE);
}

void CRefDocumentsChildDlg::OnBnClickedCreateNew()
{
	CaplInstance *inst = m_api->m_doc_mgr.CreateDocument(_T(""), _T(""), _T(""), 0, _T(""));

	if(inst)
	{
		if(!Check(inst)) return;

		int nIndex = AddDocument(inst, true);		
		UpdateToolBar();
	}
}

void CRefDocumentsChildDlg::DiscardChanges()
{
	
}

int CRefDocumentsChildDlg::GetIndexByInst(CaplInstance *ciObject)
{
	for(int i=0; i<m_list.GetItemCount(); i++)
	{
		CaplInstance *cit = (CaplInstance*)m_list.GetItemData(i);
		if(m_api->m_data.IsKindOf(cit, m_api->m_doc_mgr.e_apl_doc_ref))
			m_api->m_data.GetAttr(cit, m_api->m_doc_mgr.a_apl_doc_ref_doc, cit);

		if(ciObject == cit) return i;		
	}

	return -1;
}

void CRefDocumentsChildDlg::DelDocumentAsAttr(CaplInstance *ciDoc)
{
	CaplInstance *ciRef, *cit;

	for(int i=0; i<m_list.GetItemCount(); i++)
	{
		ciRef = (CaplInstance*)m_list.GetItemData(i);
		if(!ciRef) continue;

		if(m_api->m_data.IsKindOf(ciRef, m_api->m_doc_mgr.e_doc))
		{
			if(ciRef == ciDoc)
				m_list.DeleteItem(i);
		}
		else if(m_api->m_data.IsKindOf(ciRef, m_api->m_doc_mgr.e_apl_doc_ref))
		{
			m_api->m_data.GetAttr(ciRef, m_api->m_doc_mgr.a_apl_doc_ref_doc, cit);
			if(cit == ciDoc)
			{
				m_aeDeleted.Add(ciRef);
				m_list.DeleteItem(i);
			}
		}
	}
}

void CRefDocumentsChildDlg::DelDocument(CaplInstance *ciDoc, bool bShowQuestion)
{
	int nResult = IDYES;
	if(bShowQuestion) nResult = MessageBox(APL_T("    ?"), APL_T(""), MB_ICONSTOP|MB_YESNO|MB_DEFBUTTON2);

	if(nResult == IDYES)
		m_list.DeleteItem( GetIndexByInst(ciDoc) );	
}

void CRefDocumentsChildDlg::DelAssoc(CaplInstance *ciReference, bool bShowQuestion)
{
	int nResult = IDYES;
	if(bShowQuestion) nResult = MessageBox(APL_T("    ?"), APL_T(""), MB_ICONSTOP|MB_YESNO|MB_DEFBUTTON2);

	if(nResult == IDYES)
	{		
		m_aeDeleted.Add(ciReference);
		m_list.DeleteItem( m_list.GetNextItem(-1, LVIS_SELECTED) );
	}
}

void CRefDocumentsChildDlg::OnBnClickedDelete()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciDocAsAttr = 0;
	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	CaplInstance *ciDoc = 0;

	if(m_pParentDlg->m_FaultMgr->m_bReadOnly)
	{
		::MessageBox(0, APL_T("   !"),APL_T(" "), MB_ICONSTOP|MB_OK);
		return;
	}


	if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_doc))
	{
		//     
		DelDocument(ciObj);
		ciDocAsAttr = ciObj;
	}
	else if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_apl_doc_ref))
	{
		//    
		DelAssoc(ciObj);

		m_api->m_data.GetAttr(ciObj, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciDoc);
		ciDocAsAttr = ciDoc;
	}

	UpdateToolBar();
	if(m_pParentDlg->m_pRefResearchResults->m_ciAct == ciDocAsAttr) m_pParentDlg->m_pRefResearchResults->ClearAct();
	if(m_pParentDlg->m_pRefResults->m_ciReklDoc == ciDocAsAttr) m_pParentDlg->m_pRefResults->ClearRekl();
}

void CRefDocumentsChildDlg::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	//UpdateToolBar(pNMLV->iItem);

	*pResult = 0;
}

void CRefDocumentsChildDlg::OnBnClickedView()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_apl_doc_ref))
		m_api->m_data.GetAttr(ciObj, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciObj);
		
	m_api->m_doc_mgr.View(ciObj);
}

void CRefDocumentsChildDlg::OnBnClickedCheckOut()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_apl_doc_ref))
		m_api->m_data.GetAttr(ciObj, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciObj);

	m_api->m_doc_mgr.CheckOut(ciObj, _T(""));
	m_list.SetItemState(nIndex, LVIS_SELECTED, -1);

	LVITEM item;
	item.iItem = nIndex;
	item.mask = LVIF_IMAGE;
	item.iImage = ICON_DOCUMENT_CHECKOUTED;
	m_list.SetItem(&item);

	UpdateToolBar();
}

void CRefDocumentsChildDlg::OnBnClickedCheckIn()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_apl_doc_ref))
		m_api->m_data.GetAttr(ciObj, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciObj);

	m_api->m_doc_mgr.CheckIn(ciObj, _T(""));
	m_list.SetItemState(nIndex, LVIS_SELECTED, -1);
	SetItemIcon(nIndex, true);

	UpdateToolBar();
}

void CRefDocumentsChildDlg::OnBnClickedUndoCheckOut()
{
	int nIndex = m_list.GetNextItem(-1, LVIS_SELECTED);
	if(nIndex == -1) return;

	CaplInstance *ciObj = (CaplInstance*)m_list.GetItemData(nIndex);
	if(!ciObj) return;

	if(m_api->m_data.IsKindOf(ciObj, m_api->m_doc_mgr.e_apl_doc_ref))
		m_api->m_data.GetAttr(ciObj, m_api->m_doc_mgr.a_apl_doc_ref_doc, ciObj);

	m_api->m_doc_mgr.UndoCheckOut(ciObj);
	m_list.SetItemState(nIndex, LVIS_SELECTED, -1);
	SetItemIcon(nIndex, true);

	UpdateToolBar();
}

void CRefDocumentsChildDlg::SetItemIcon(int nIndex, bool bNormal)
{
	LVITEM item;
	item.iItem = nIndex;
	item.mask = LVIF_IMAGE;

	if(bNormal) item.iImage = ICON_DOCUMENT;
	else item.iImage = ICON_DOCUMENT_CHECKOUTED;

	m_list.SetItem(&item);
}

void CRefDocumentsChildDlg::OnNMClickList(NMHDR *pNMHDR, LRESULT *pResult)
{
	UpdateToolBar();
		
	*pResult = 0;
}

void CRefDocumentsChildDlg::OnLvnKeydownList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	
	*pResult = 0;
}

void CRefDocumentsChildDlg::OnLvnItemActivateList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMIA = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);

	*pResult = 0;
}

void CRefDocumentsChildDlg::OnLvnItemchangingList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);

	*pResult = 0;
}
