#pragma once
#include "resource.h"

// CRefFilesChildDlg dialog

class CRefFilesChildDlg : public CaplTranslateDialog
{
	DECLARE_DYNAMIC(CRefFilesChildDlg)

public:
	CRefFilesChildDlg(CaplAPI *api, CWnd* pParent = NULL);   // standard constructor
	virtual ~CRefFilesChildDlg();

// Dialog Data
	enum { IDD = IDD_REF_FILES };

	CaplButton m_new;
	CaplButton m_show;
	CaplButton m_del;

	CImageList imageList;
	CSortListCtrl m_list;

	CaplAPI *m_api;
	aplExtent m_aeDelFiles;
	CaplInstance *m_ciRef;	

	void InitBtns();
	void InitList();
	void FillList();
	void DiscardChanges();
	void UpdateToolBar();
	bool CheckFile(CString sPath);
	void AddString(CaplInstance *ciFiles);
	void SaveRefData(CaplInstance *ciRef, bool bExitDlg);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();

	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnBnClickedNew();
	afx_msg void OnBnClickedShow();
	afx_msg void OnBnClickedDel();
	afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult);
};
