// RefusalDlg.cpp : implementation file
//

#pragma once
#include "stdafx.h"
#include "RefusalPropertyDlg.h"
#include <aplFaultsReport.h>

// CRefusalPropertyDlg dialog

IMPLEMENT_DYNAMIC(CRefusalPropertyDlg, CaplTranslateDialog)

CRefusalPropertyDlg::CRefusalPropertyDlg(CaplAPI *api, CaplFaultMgr *FaultMgr, CWnd* pParent /*=NULL*/)
: CaplTranslateDialog(CRefusalPropertyDlg::IDD, pParent)
{
	m_api = api;
	m_FaultMgr = FaultMgr;

	m_ciRef = NULL;
	m_ciEdItem = NULL;
	m_ciMainPdf = NULL;
	m_ciIngItem = NULL;
	m_ciSystem = NULL;
	m_ciType = NULL;
	m_ciStage = NULL;
	m_ciOrg = NULL;
	m_ciSector = NULL;
	m_ciEdLot = NULL;
	m_ciIngLot = NULL;	
	m_ciParentRef = NULL;
	m_ciTmpRef = 0;

	m_bChildDlg = false;

	m_pRefResults=0;
	m_pRefusalClassif=0;
	m_pRefResearchResults=0;
	m_pRefDoc=0;
	m_pRefAppr=0;
	m_pRefCharact=0;
	m_pRefChild=0;
	m_pRefAdminInfo=0;
	m_pRefFiles=0;
	m_ciSourceRefusal=0;

}

void CRefusalPropertyDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);

	DDX_Control(pDX, IDC_TAB, m_tab);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDOK, m_ok_btn);

	DDX_Control(pDX, IDC_REF_TYPE, m_combo_ref_type);
	DDX_Control(pDX, IDC_REF_STATE, m_combo_ref_state);
	DDX_Control(pDX, IDC_REF_DOC, m_combo_ref_doc);
	DDX_Control(pDX, IDC_REF_DOC_DATE, m_date_ref_doc_date);
	DDX_Control(pDX, IDC_CHOOSE_ORG, m_btn_choose_org);
	DDX_Control(pDX, IDC_CHOOSE_SECTOR, m_btn_choose_sector);
	DDX_Control(pDX, IDC_REF_DATE_DETECT, m_date_ref_date_detect);
	DDX_Control(pDX, IDC_REF_DATE_REMOVE, m_date_ref_date_remove);
	DDX_Control(pDX, IDC_CHECK_DATE_REMOVE, m_check_ref_date_remove);
	DDX_Control(pDX, IDC_CHOOSE_MAIN_PDF, m_btn_choose_main_pdf);
	DDX_Control(pDX, IDC_CHOOSE_SYSTEM, m_btn_choose_system);
	DDX_Control(pDX, IDC_CHOOSE_ING_ITEM, m_btn_choose_ing_item);
	DDX_Control(pDX, IDC_CHOOSE_ED_ITEM, m_btn_choose_ed_item);
	DDX_Control(pDX, IDC_REF_ING_ITEM_DATE, m_date_ref_ing_item_date);
	DDX_Control(pDX, IDC_REF_ED_ITEM_DATE, m_date_ref_ed_item_date);
	DDX_Control(pDX, IDC_REF_RES, m_list_ref_res);
	DDX_Control(pDX, IDC_REF_STAGE, m_combo_ref_stage);
	DDX_Control(pDX, IDC_CLEAR_ORG, m_clear_org);
	DDX_Control(pDX, IDC_CLEAR_SECTOR, m_clear_sector);
	DDX_Control(pDX, IDC_CLEAR_MAIN_PDF, m_clear_main_pdf);
	DDX_Control(pDX, IDC_CLEAR_SYSTEM, m_clear_system);
	DDX_Control(pDX, IDC_CLEAR_ING_ITEM, m_clear_ing_item);
	DDX_Control(pDX, IDC_CLEAR_ED_ITEM, m_clear_ed_item);
	DDX_Control(pDX, IDC_CHOOSE_ED_PDF, m_btn_choose_ed_pdf);
	DDX_Control(pDX, IDC_CLEAR_ED_PDF, m_clear_ed_pdf);
	DDX_Control(pDX, IDC_CHOOSE_ING_REF, m_btn_choose_ing_ref);
	DDX_Control(pDX, IDC_CLEAR_ING_REF, m_btn_clear_ing_ref);

	DDX_Text(pDX, IDC_REF_DESCR, m_sRefDescr);
	DDX_Text(pDX, IDC_REF_DOC_NUM, m_sRefDocNum);
	DDX_Text(pDX, IDC_REF_ORG, m_sRefOrg);
	DDX_Text(pDX, IDC_REF_SECTOR, m_sRefSector);
	DDX_Text(pDX, IDC_REF_MAIN_PDF, m_sRefMainPdf);
	DDX_Text(pDX, IDC_REF_SYSTEM, m_sRefSystem);
	DDX_Text(pDX, IDC_REF_ING_ITEM_SHIFR, m_sRefIngItemShifr);
	DDX_Text(pDX, IDC_REF_ING_ITEM_NAME, m_sRefIngItemName);
	DDX_Text(pDX, IDC_REF_ING_ITEM_LOT, m_sRefIngItemLot);
	DDX_Text(pDX, IDC_REF_ING_ITEM_SN, m_sRefIngItemSn);
	DDX_Text(pDX, IDC_EXT_VIEW, m_sExtView);

	DDX_Text(pDX, IDC_REF_ED_ITEM_SHIFR, m_sRefEdItemShifr);
	DDX_Text(pDX, IDC_REF_ED_ITEM_NAME, m_sRefEdItemName);
	DDX_Text(pDX, IDC_REF_ED_ITEM_LOT, m_sRefEdItemLot);
	DDX_Text(pDX, IDC_REF_ED_ITEM_SN, m_sRefEdItemSn);		
	DDX_Text(pDX, IDC_RESOURCES, m_sResources);

	DDX_Text(pDX, IDC_PARENT_TYPE, m_sParentType);
	DDX_Text(pDX, IDC_PARENT_STATE, m_sParentState);
	DDX_Text(pDX, IDC_PARENT_DOC, m_sParentDoc);
	DDX_Text(pDX, IDC_PARENT_DOC_NUM, m_sParentDocNum);
	DDX_Text(pDX, IDC_PARENT_DATE, m_sParentDate);
	DDX_Control(pDX, IDC_REF_DOC_NUM, m_RefDocNumCtrl);
}

BEGIN_MESSAGE_MAP(CRefusalPropertyDlg, CaplTranslateDialog)
	ON_WM_DESTROY()

	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB, OnSelchangeTab)
	ON_NOTIFY(TCN_SELCHANGING, IDC_TAB, OnSelchangingTab)

	ON_BN_CLICKED(IDC_CHOOSE_ORG, OnChooseOrg)
	ON_BN_CLICKED(IDC_CHOOSE_ED_ITEM, OnChooseEdItem)
	ON_BN_CLICKED(IDC_CHOOSE_ED_PDF, OnChooseEdPdf)
	ON_BN_CLICKED(IDC_CHOOSE_ING_ITEM, OnChooseIngItem)
	ON_BN_CLICKED(IDC_CHOOSE_SYSTEM, OnChooseSystem)
	ON_BN_CLICKED(IDC_CHOOSE_MAIN_PDF, OnChooseMainPdf)
	ON_BN_CLICKED(IDC_CHECK_DATE_REMOVE, OnCheckDateRemove)

	ON_BN_CLICKED(IDC_CLEAR_ORG, OnClearOrg)
	ON_BN_CLICKED(IDC_CLEAR_MAIN_PDF, OnClearMainPdf)
	ON_BN_CLICKED(IDC_CLEAR_SYSTEM, OnClearSystem)
	ON_BN_CLICKED(IDC_CLEAR_ING_ITEM, OnClearIng)
	ON_BN_CLICKED(IDC_CLEAR_ED_ITEM, OnClearEd)
	ON_BN_CLICKED(IDC_CLEAR_ED_PDF, OnClearEdPdf)
	ON_BN_CLICKED(IDC_CREATE_FAULTS_REPORT_BUTTON, &CRefusalPropertyDlg::OnBnClickedCreateFaultsReportButton)
	ON_BN_CLICKED(IDC_CHOOSE_SECTOR, &CRefusalPropertyDlg::OnBnClickedChooseSector)
	ON_BN_CLICKED(IDC_CLEAR_SECTOR, &CRefusalPropertyDlg::OnBnClickedClearSector)
	ON_CBN_SELCHANGE(IDC_REF_DOC, &CRefusalPropertyDlg::OnCbnSelchangeRefDoc)
	ON_BN_CLICKED(IDC_CLEAR_ING_REF, &CRefusalPropertyDlg::OnBnClickedClearIngRef)
	ON_BN_CLICKED(IDC_CHOOSE_ING_REF, &CRefusalPropertyDlg::OnBnClickedChooseIngRef)
END_MESSAGE_MAP()

void CRefusalPropertyDlg::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int nTab = m_tab.GetCurSel(); 
	TC_ITEM tci; 
	tci.mask = TCIF_PARAM; 

	m_tab.GetItem(nTab, &tci); 
	ASSERT(tci.lParam); 

	CWnd* pWnd = (CWnd *)tci.lParam; 
	if(pWnd) pWnd->ShowWindow(SW_SHOW); 	

	*pResult = 0;
}

void CRefusalPropertyDlg::OnSelchangingTab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int nTab = m_tab.GetCurSel(); 
	TC_ITEM tci;
	tci.mask = TCIF_PARAM; 

	m_tab.GetItem(nTab, &tci);
	ASSERT(tci.lParam); 

	CWnd* pWnd = (CWnd *)tci.lParam;
	if(pWnd) pWnd->ShowWindow(SW_HIDE); 

	*pResult = 0;
}

WNDPROC m_combo_ref_stage_long=0;
LRESULT CALLBACK combo_ref_stage_nowheel_long(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	if( message == WM_MOUSEWHEEL ) return 0;
	return CallWindowProc(m_combo_ref_stage_long,hwnd, message, wParam, lParam);
}


BOOL CRefusalPropertyDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();

	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_bChildDlg) MoveDialog();
	InitComboBoxes();
	InitBtns();

	bool bNeedClear_ciRef=false;
	if(0==m_ciRef && 0!=m_ciSourceRefusal) {m_ciRef=m_ciSourceRefusal;  bNeedClear_ciRef=true;} //     

	InitTabs();
	SetActiveTabs();
	FillInfoFromInst();
	FillInfoAboutRelatingRefusal();	
	
	if(bNeedClear_ciRef) m_ciRef=0;

	if(m_FaultMgr->m_bReadOnly)	SetReadOnly();

	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T(" "), m_sSetupCode,0);
	m_sSetupCode.MakeLower();
	if(m_sSetupCode==APL_NO_T(""))
	{
		int i=m_combo_ref_doc.AddString(_T(""));
		m_combo_ref_doc.SetCurSel(i);
		m_combo_ref_doc.EnableWindow(FALSE);
		m_RefDocNumCtrl.SetReadOnly();
	}

	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "),m_sSpavPKI,_T(""));
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "),m_sSpavKomponent,_T(""));
	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "),m_sSpavElement,_T(""));


	//    
	if(m_api->m_options_mgr.CheckInstallCode(APL_NO_T("")))
	{
		m_combo_ref_stage_long=(WNDPROC)GetWindowLong(m_combo_ref_stage.m_hWnd, GWL_WNDPROC); 
		SetWindowLong(m_combo_ref_stage.m_hWnd, GWL_WNDPROC, (LONG)combo_ref_stage_nowheel_long);
	}

	return TRUE;
}

void CRefusalPropertyDlg::SetReadOnly()
{
	m_ok_btn.EnableWindow(FALSE);
	m_btn_choose_org.EnableWindow(FALSE);
	m_btn_choose_sector.EnableWindow(FALSE);
	m_btn_choose_main_pdf.EnableWindow(FALSE);
	m_btn_choose_system.EnableWindow(FALSE);
	m_btn_choose_ing_item.EnableWindow(FALSE);
	m_btn_choose_ed_item.EnableWindow(FALSE);
	m_btn_choose_ed_pdf.EnableWindow(FALSE);
	m_btn_choose_ing_ref.EnableWindow(FALSE);
	m_clear_org.EnableWindow(FALSE);
	m_clear_sector.EnableWindow(FALSE);	
	m_clear_main_pdf.EnableWindow(FALSE);
	m_clear_system.EnableWindow(FALSE);
	m_clear_ing_item.EnableWindow(FALSE);
	m_clear_ed_item.EnableWindow(FALSE);
	m_clear_ed_pdf.EnableWindow(FALSE);
	m_btn_clear_ing_ref.EnableWindow(FALSE);


	m_combo_ref_type.EnableWindow(FALSE);
	m_combo_ref_state.EnableWindow(FALSE);
	m_combo_ref_doc.EnableWindow(FALSE);
	m_combo_ref_stage.EnableWindow(FALSE);

	m_check_ref_date_remove.EnableWindow(FALSE);

	m_date_ref_doc_date.EnableWindow(FALSE);
	m_date_ref_date_detect.EnableWindow(FALSE);
	m_date_ref_date_remove.EnableWindow(FALSE);
	m_date_ref_ing_item_date.EnableWindow(FALSE);
	m_date_ref_ed_item_date.EnableWindow(FALSE);


	CWnd *wnd;
	wnd=GetDlgItem(IDC_REF_DESCR);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_REF_DOC_NUM);	if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
	wnd=GetDlgItem(IDC_EXT_VIEW);		if(wnd) {((CEdit*)wnd)->SetReadOnly(TRUE);};
		

	if(m_pRefusalClassif)		m_pRefusalClassif->SetReadOnly();
	if(m_pRefResults)			m_pRefResults->SetReadOnly();
	if(m_pRefResearchResults)	m_pRefResearchResults->SetReadOnly();
}
void CRefusalPropertyDlg::InitBtns()
{
	m_ok_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));

	m_cancel_btn.SetFlat(FALSE);	
	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));

	m_btn_choose_org.SetFlat(TRUE);	
	m_btn_choose_org.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_org.SetTooltipText(APL_T("  ( )"));

	m_btn_choose_sector.SetFlat(TRUE);	
	m_btn_choose_sector.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_sector.SetTooltipText(APL_T("  (  "));

	m_btn_choose_main_pdf.SetFlat(TRUE);	
	m_btn_choose_main_pdf.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_main_pdf.SetTooltipText(APL_T("  "));

	m_btn_choose_system.SetFlat(TRUE);	
	m_btn_choose_system.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_system.SetTooltipText(APL_T(" "));

	m_btn_choose_ing_item.SetFlat(TRUE);	
	m_btn_choose_ing_item.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_ing_item.SetTooltipText(APL_T("  ()"));

	m_btn_choose_ed_item.SetFlat(TRUE);	
	m_btn_choose_ed_item.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_ed_item.SetTooltipText(APL_T("   ( )"));

	m_btn_choose_ed_pdf.SetFlat(TRUE);	
	m_btn_choose_ed_pdf.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_ed_pdf.SetTooltipText(APL_T("   ( )"));

	m_btn_choose_ing_ref.SetFlat(TRUE);	
	m_btn_choose_ing_ref.SetIcon(aplGetButtonIco(APL_24_SELECT));
	m_btn_choose_ing_ref.SetTooltipText(APL_T("  "));

	m_clear_org.SetFlat(TRUE);	
	m_clear_org.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_org.SetTooltipText(APL_T(" "));

	m_clear_sector.SetFlat(TRUE);	
	m_clear_sector.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_sector.SetTooltipText(APL_T(" "));

	m_clear_main_pdf.SetFlat(TRUE);	
	m_clear_main_pdf.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_main_pdf.SetTooltipText(APL_T(" "));

	m_clear_system.SetFlat(TRUE);	
	m_clear_system.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_system.SetTooltipText(APL_T(" "));

	m_clear_ing_item.SetFlat(TRUE);	
	m_clear_ing_item.SetIcon(aplGetButtonIco(APL_24_CANCEL));
	m_clear_ing_item.SetTooltipText(APL_T(" "));

	m_clear_ed_item.SetFlat(TRUE);	
	m_clear_ed_item.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_clear_ed_item.SetTooltipText(APL_T(" "));

	m_clear_ed_pdf.SetFlat(TRUE);	
	m_clear_ed_pdf.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_clear_ed_pdf.SetTooltipText(APL_T(" "));

	m_btn_clear_ing_ref.SetFlat(TRUE);	
	m_btn_clear_ing_ref.SetIcon(aplGetButtonIco(APL_24_CANCEL));	
	m_btn_clear_ing_ref.SetTooltipText(APL_T(" "));
}

void CRefusalPropertyDlg::InitTabs()
{
	int nPos = 0;
	TC_ITEM TabItem;
	TabItem.mask = TCIF_TEXT;

	//  
	TabItem.pszText = LPTSTR(APL_T(""));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefusalClassif = new CRefClassifChildDlg(m_api);
	m_pRefusalClassif->m_ciRef = m_ciRef;
	m_pRefusalClassif->m_refusal_dlg=this;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefusalClassif;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefusalClassif->Create(CRefClassifChildDlg::IDD, &m_tab);
	m_pRefusalClassif->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
	m_pRefusalClassif->ShowWindow(SW_SHOW); 	
	nPos++;

	//  
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(" "));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefResearchResults = new CRefResearchResultsChildDlg(m_api);
	m_pRefResearchResults->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefResearchResults;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefResearchResults->Create(CRefResearchResultsChildDlg::IDD, &m_tab);
	m_pRefResearchResults->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(""));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefResults = new CRefResultsChildDlg(m_api);
	m_pRefResults->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefResults;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefResults->Create(CRefResultsChildDlg::IDD, &m_tab);
	m_pRefResults->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(""));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefDoc = new CRefDocumentsChildDlg(m_api);
	m_pRefDoc->m_ciRef = m_ciRef;
	m_pRefDoc->m_pParentDlg = this;	
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefDoc;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefDoc->Create(CRefDocumentsChildDlg::IDD, &m_tab);
	m_pRefDoc->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(" "));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefAppr = new CRefApprovalChildDlg(m_api);
	m_pRefAppr->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefAppr;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefAppr->Create(CRefApprovalChildDlg::IDD, &m_tab);
	m_pRefAppr->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(""));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefCharact = new CRefCharactChildDlg(m_api);
	m_pRefCharact->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefCharact;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefCharact->Create(CRefCharactChildDlg::IDD, &m_tab);
	m_pRefCharact->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(" "));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefChild = new CRefChildsChildDlg(m_api, m_FaultMgr, this);
	m_pRefChild->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefChild;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefChild->Create(CRefChildsChildDlg::IDD, &m_tab);
	m_pRefChild->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = LPTSTR(APL_T(" "));
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefFiles = new CRefFilesChildDlg(m_api, this);
	m_pRefFiles->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefFiles;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefFiles->Create(CRefFilesChildDlg::IDD, &m_tab);
	m_pRefFiles->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//  	
	TabItem.mask = TCIF_TEXT;
	TabItem.pszText = _T("*");
	m_tab.InsertItem( nPos, &TabItem );	

	m_pRefAdminInfo = new CRefAdminInfoChildDlg(m_api, this);
	m_pRefAdminInfo->m_ciRef = m_ciRef;
	TabItem.mask = TCIF_PARAM; 
	TabItem.lParam = (LPARAM)m_pRefAdminInfo;
	m_tab.SetItem(nPos, &TabItem);
	m_pRefAdminInfo->Create(CRefAdminInfoChildDlg::IDD, &m_tab);
	m_pRefAdminInfo->SetWindowPos(NULL, 10, 30, 0, 0, SWP_NOSIZE | SWP_NOZORDER);	
	nPos++;

	//   
	m_pRefResearchResults->m_pDocDlg = m_pRefDoc;
	m_pRefResults->m_pDocDlg = m_pRefDoc;
}

void CRefusalPropertyDlg::SetActiveTabs()
{

}

void CRefusalPropertyDlg::FillInfoFromInst()
{
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	m_combo_ref_state.SelectString(-1, APL_T(""));
	m_combo_ref_doc.SetCurSel(0);

	CaplInstance *refusal=m_ciRef;
	//if(0==refusal && 0!=m_ciSourceRefusal)refusal=m_ciSourceRefusal;

	if(refusal)
	{
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_planer, m_ciMainPdf);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_system, m_ciSystem);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_item, m_ciIngItem);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_part, m_ciEdItem);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_type, m_ciType); 
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_stage, m_ciStage);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_item_lot, m_ciIngLot);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_part_lot, m_ciEdLot);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_sector, m_ciSector);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_state, m_sRefState);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_doc_type, m_sRefDoc);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_doc_num, m_sRefDocNum);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_doc_date, m_sRefDocDate);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_org, m_ciOrg);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_date_detection, m_sRefDateDetect);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_date_removal, m_sRefDateRemove);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_ext_view, m_sExtView);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_resources_str, m_sResources);
		m_api->m_data.GetAttr(refusal, mgr->a_apl_refusal_description, m_sRefDescr);

		if(0!=m_ciSourceRefusal)m_sRefDocNum=_T("");

		if(!m_ciParentRef) m_api->m_data.GetAttr(m_ciRef, ((CaplPreExploitationMgr*)m_api->m_expl_mgr)->a_apl_refusal_parent, m_ciParentRef);
	}

	GetCommomInfoFromInst();
}

void CRefusalPropertyDlg::GetCommomInfoFromInst()
{
	CString t_str;
	COleDateTime time;
	CaplInstance *ciPdf=0, *ciPrd=0, *ciLot=0, *ciLvl=0;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	// 
	if(m_ciType) 
	{
		//m_api->GetItemName(m_ciType, m_sRefType);
		m_api->m_data.GetAttr(m_ciType, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sRefType);
		m_combo_ref_type.SelectString(0, m_sRefType);
	}

	// 
	if(m_sRefState.IsEmpty()) m_sRefState = APL_T("");
	m_combo_ref_state.SelectString(-1, m_sRefState);

	// 

	// 		
	m_combo_ref_doc.SelectString(-1, m_sRefDoc);
	IsEnableReportBtn();

	//  

	//   
	if(!m_sRefDocDate.IsEmpty())
	{
		aplString2Date(m_sRefDocDate, time);
		m_date_ref_doc_date.SetTime(time);
	}

	// 		
	if(m_ciOrg) m_api->GetItemName(m_ciOrg, m_sRefOrg);

	//  
	if(!m_sRefDateDetect.IsEmpty())
	{
		aplString2Date(m_sRefDateDetect, time);
		m_date_ref_date_detect.SetTime(time);
	}

	//  		
	if(!m_sRefDateRemove.IsEmpty())
	{
		aplString2Date(m_sRefDateRemove, time);
		m_date_ref_date_remove.SetTime(time);

		m_check_ref_date_remove.SetCheck(1);
		m_date_ref_date_remove.EnableWindow(TRUE);
	}
	else
	{
		m_check_ref_date_remove.SetCheck(0);
		m_date_ref_date_remove.EnableWindow(FALSE);
	}

	//  

	//   

	// 
	if(m_ciSector) m_api->GetItemName(m_ciSector, m_sRefSector);

	// 
	if(m_ciStage) 
	{
		//m_api->GetItemName(m_ciStage, m_sRefType);
		m_api->m_data.GetAttr(m_ciStage, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sRefType);
		m_combo_ref_stage.SelectString(1, m_sRefType);
	}		

	//  
	if(m_ciMainPdf)
	{
		//if(m_FaultMgr->IsPlaner(m_ciMainPdf)) mgr->GetPlanerName(m_ciMainPdf, m_sRefMainPdf);
		//else mgr->GetPKIName(m_ciMainPdf, m_sRefMainPdf);

		m_api->m_prd_mgr.GetItemName(m_ciMainPdf,m_sRefMainPdf);
	}
	else
	{
		m_sRefMainPdf.Empty();
	}

	// 
	if(m_ciSystem)
	{
		m_FaultMgr->GetSystemName(m_ciSystem, m_sRefSystem);
	}
	else m_sRefSystem.Empty();

	// 
	if(m_ciIngItem || m_ciIngLot)
	{
		GetInfoAboutIngItem();
	}
	else
	{
		m_sRefIngItemShifr.Empty();
		m_sRefIngItemName.Empty();
		m_sRefIngItemLot.Empty();
		m_sRefIngItemSn.Empty();
	}

	//  
	if(m_ciEdItem || m_ciEdLot)
	{
		GetInfoAboutEdItem();
	}
	else
	{
		m_sRefEdItemShifr.Empty();
		m_sRefEdItemName.Empty();
		m_sRefEdItemLot.Empty();
		m_sRefEdItemSn.Empty();
	}		

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::UpdateRefusalData()
{
	UpdateData();

	int nIndex = -1;
	COleDateTime time;

	// 
	nIndex = m_combo_ref_type.GetCurSel();
	if(nIndex != -1) m_ciType = (CaplInstance*)m_combo_ref_type.GetItemData(nIndex);
	else m_ciType = 0;

	// 
	m_combo_ref_state.GetWindowText(m_sRefState);

	// 
	m_combo_ref_doc.GetWindowText(m_sRefDoc);

	//   
	m_date_ref_doc_date.GetTime(time);
	aplDate2String(time, m_sRefDocDate);

	// 
	nIndex = m_combo_ref_stage.GetCurSel();
	if(nIndex != -1) m_ciStage = (CaplInstance*)m_combo_ref_stage.GetItemData(nIndex);
	else m_ciStage = 0;

	//  
	m_date_ref_date_detect.GetTime(time);
	aplDate2String(time, m_sRefDateDetect);

	//  
	if(m_check_ref_date_remove.GetCheck() == 1)
	{
		m_date_ref_date_remove.GetTime(time);
		aplDate2String(time, m_sRefDateRemove);
	}
	else
	{
		m_sRefDateRemove.Empty();
	}
}

void CRefusalPropertyDlg::SaveRefusalBase(CaplInstance *&ciRefusal, bool bExitDlg)
{
	CString buf;
	COleDateTime time;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	UpdateRefusalData();
	if(!ciRefusal) ciRefusal = m_api->m_data.CreateInstance(mgr->e_apl_refusal);		

	if(ciRefusal)
	{
		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_parent, m_ciParentRef);				

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_type, m_ciType); 

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_state, m_sRefState);

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_description, m_sRefDescr);

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_doc_type, m_sRefDoc);


		if(m_sRefDocNum==_T(""))
		{
			if(m_sSetupCode==APL_NO_T(""))
			{
				int year=(COleDateTime::GetCurrentTime()).GetYear();
				buf.Format(APL_NO_T("\\_%i"),year);
				int counter=m_api->m_options_mgr.GetCounterWithIncrementBN(buf);
				m_sRefDocNum.Format(_T("%i-%05i"),year,counter);
			}
			else
			{
				CString sDocType4AutoNum;
				m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\   "), sDocType4AutoNum,0);
				sDocType4AutoNum.MakeLower();
				buf=m_sRefDoc;
				buf.MakeLower();
				if(buf!=_T("") && buf ==sDocType4AutoNum)
				{
					//  
					//COleDateTime odt=COleDateTime::GetCurrentTime();
					int year=(COleDateTime::GetCurrentTime()).GetYear();
					buf.Format(APL_NO_T("\\_%i"),year);
					int counter=m_api->m_options_mgr.GetCounterWithIncrementBN(buf);
					m_sRefDocNum.Format(_T("%i-%05i"),year,counter);
				}
			}
		}

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_doc_num, m_sRefDocNum);

		//    +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_doc_date, m_FaultMgr->NullTimeInDate(m_sRefDocDate));

		// ,     +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_org, m_ciOrg);

		// ,     +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_sector, m_ciSector);

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_stage, m_ciStage);

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_date_detection, m_FaultMgr->NullTimeInDate(m_sRefDateDetect));

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_date_removal, m_FaultMgr->NullTimeInDate(m_sRefDateRemove));

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_planer, m_ciMainPdf);

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_system, m_ciSystem);

		//  +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_item, m_ciIngItem);

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_item_lot, m_ciIngLot);

		//   +
 		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_part, m_ciEdItem);

		//    +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_part_lot, m_ciEdLot);

		//   +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_ext_view, m_sExtView);

		//    +
		m_api->m_data.PutAttr(ciRefusal, mgr->a_apl_refusal_resources_str, m_sResources);

		//   +
		SaveResources(ciRefusal);

		//    "" +
		m_pRefusalClassif->SaveRefData(ciRefusal);

		//    " " +
		m_pRefResearchResults->SaveRefData(ciRefusal);

		//    "" +
		m_pRefResults->SaveRefData(ciRefusal);

		//    "" +
		m_pRefDoc->SaveRefData(ciRefusal, bExitDlg);

		//    "" -
		m_pRefAppr->SaveRefData(ciRefusal, bExitDlg);

		//    "" +
		m_pRefCharact->SaveRefData(ciRefusal, bExitDlg);

		//    " " +
		m_pRefFiles->SaveRefData(ciRefusal, bExitDlg);

		//  
		m_api->SaveChanges();
	}
	else
	{
		MessageBox(APL_T("  /    "), APL_T(""), MB_ICONSTOP);
	}
}

void CRefusalPropertyDlg::SaveResources(CaplInstance *ciRefusal)
{
	//    
	if(ciRefusal == m_ciRef)
	{
		//        
		for(int i=0; i<m_list_ref_res.GetItemCount(); i++)
		{
			CaplInstance *ciCharVal = (CaplInstance*)m_list_ref_res.GetItemData(i);

			for(int j=1; j<m_list_ref_res.GetHeaderCtrl()->GetItemCount(); j++)
			{
				CString txt = m_list_ref_res.GetItemText(i, j);
				if(txt.IsEmpty())
					continue;
				else 
				{
					double dVal = __atof(txt);
					m_api->m_data.PutAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_meas_val, dVal);
				}
			}
		}
	}
	else
	{
		//    ,,   
		//    Item  .     
		for(int i=0; i<m_list_ref_res.GetItemCount(); i++)
		{
			CaplInstance *ciCharVal = (CaplInstance*)m_list_ref_res.GetItemData(i);
			m_api->m_data.PutAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_item, ciRefusal);
		}
	}
}

bool CRefusalPropertyDlg::Check()
{
	//   
	if((0==m_ciIngItem) && (0==m_ciEdItem) && (0==m_ciMainPdf))
	{
		MessageBox(APL_T("     !"), APL_T(" "), MB_ICONSTOP);
		return false;
	}

	//  
	COleDateTime timeDetect, timeRemoval, timeDoc;
	m_date_ref_date_detect.GetTime(timeDetect);
	m_date_ref_date_remove.GetTime(timeRemoval);
	m_date_ref_doc_date.GetTime(timeDoc);

	if(timeDetect > timeRemoval && m_check_ref_date_remove.GetCheck())
	{
		MessageBox(APL_T("       !"), APL_T(" "), MB_ICONSTOP);
		m_date_ref_date_detect.SetFocus();
		return false;
	}

	if(timeDetect > timeDoc)
	{
		MessageBox(APL_T("         !"), APL_T(" "), MB_ICONSTOP);
		m_date_ref_doc_date.SetFocus();
		return false;
	}

	return true;
}

void CRefusalPropertyDlg::OnOK()
{
	if(!Check()) return;

	SaveRefusalBase(m_ciRef, true);
	SetResourceToMainRefusal();

	m_aeRefusalToUpdate.Add(m_ciRef);
	m_aeRefusalToUpdate.Sort();

	CaplTranslateDialog::OnOK();
}

void CRefusalPropertyDlg::OnChooseOrg()
{
	UpdateRefusalData();

	if(m_api->m_appr_mgr.SelectOrganization(&m_ciOrg, APL_T(" ( )"))) 
	{
		m_api->GetItemName(m_ciOrg, m_sRefOrg);
		m_ciSector = 0;
		m_sRefSector.Empty();
	}

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnChooseEdPdf()
{
	UpdateRefusalData();
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(mgr->FindPdf1(&m_ciEdItem, aplFindPKIPdf))
		GetInfoAboutEdItem();	
}

void CRefusalPropertyDlg::OnClearEdPdf()
{
	UpdateData();

	m_ciEdItem = NULL;
	m_ciEdLot = NULL;

	m_sRefEdItemShifr = _T("");
	m_sRefEdItemName = _T("");
	m_sRefEdItemLot = _T("");
	m_sRefEdItemSn = _T("");
	m_list_ref_res.DeleteAllItems();

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnChooseEdItem()
{
	UpdateRefusalData();

	if(m_api->m_prd_mgr.FindPKIEx(&m_ciEdItem, &m_ciEdLot,false,false,false,LPCTSTR(m_sSpavElement)))
	{
		if( CheckEdItemComposition() ) GetInfoAboutEdItem();				
		else OnClearEd();
	}	
}

void CRefusalPropertyDlg::GetInfoAboutEdItem()
{
	CString t_str;
	COleDateTime time;
	bool bPrdInst = true;
	CaplInstance *ciPrd, *ciPdf, *ciLot;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciEdLot) m_api->m_data.GetAttr(m_ciEdLot, m_api->m_prd_inst_mgr.a_lot_id, m_sRefEdItemLot);

	if(m_ciEdItem && m_ciEdItem->GetAccessmode()<=aplRO)
	{
		if(m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_mgr.e_pdf)) bPrdInst = false;

		if(bPrdInst ) m_api->m_data.GetAttr(m_ciEdItem, m_api->m_prd_inst_mgr.a_prd_inst_pdf, ciPdf);
		else ciPdf = m_ciEdItem;

		if(ciPdf && ciPdf->GetAccessmode()<=aplRO)
		{
			//  
			m_sRefEdItemSn.Empty();

			//   
			m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
			if(ciPrd)
			{
				m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, m_sRefEdItemShifr);
				m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_name, m_sRefEdItemName);
			}
		}

		if(bPrdInst)
		{
			// 
			m_api->m_data.GetAttr(m_ciEdItem, m_api->m_prd_inst_mgr.a_prd_inst_lot, ciLot);
			if(ciLot) m_api->m_data.GetAttr(ciLot, m_api->m_prd_inst_mgr.a_lot_id, m_sRefEdItemLot);

			//  
			m_api->m_data.GetAttr(m_ciEdItem, m_api->m_prd_inst_mgr.a_prd_inst_sn, m_sRefEdItemSn);

			//  
			m_api->m_data.GetAttr(m_ciEdItem, m_api->m_prd_inst_mgr.a_prd_inst_datetime, t_str);
			aplString2Date(t_str, time);
			m_date_ref_ed_item_date.SetTime(time);			
		}

		//  
		LoadResources();
	}

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::MakeEdItemEmpty()
{
	m_ciEdItem = NULL;
	m_sRefEdItemShifr.Empty();
	m_sRefEdItemName.Empty();
	m_sRefEdItemLot.Empty();
	m_sRefEdItemSn.Empty();
}

void CRefusalPropertyDlg::MakeIngItemEmpty()
{
	m_ciEdItem = NULL;
	m_sRefIngItemShifr.Empty();
	m_sRefIngItemName.Empty();
	m_sRefIngItemLot.Empty();
	m_sRefIngItemSn.Empty();
}

bool CRefusalPropertyDlg::CheckEdItemComposition()
{
	return true;
	if(!m_ciEdItem) return true;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	if(m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_mgr.e_pdf)) return true;

	if(m_ciIngItem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciIngItem, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciSystem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciSystem, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciMainPdf)
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("      ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	return true;
}

bool CRefusalPropertyDlg::CheckIngItemComposition()
{
	return true;
	if(!m_ciIngItem) return true;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciEdItem && !m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_mgr.e_pdf))
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciIngItem, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	if(m_ciSystem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciIngItem, m_ciSystem, true))
		{
			MessageBox(APL_T("    ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciMainPdf)
	{
		if(!m_FaultMgr->IsChildItem(m_ciIngItem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	return true;
}

bool CRefusalPropertyDlg::CheckSystemComposition()
{
	return true;
	if(!m_ciSystem) return true;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciEdItem->GetAccessmode()>=aplRO) return false;

	if(m_ciIngItem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciIngItem, m_ciSystem, true))
		{
			MessageBox(APL_T("    ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciEdItem && !m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_mgr.e_pdf))
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciSystem, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	if(m_ciMainPdf)
	{
		if(!m_FaultMgr->IsChildItem(m_ciSystem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	return true;
}

bool CRefusalPropertyDlg::CheckMainPdfComposition()
{
	return true;
	if(!m_ciMainPdf) return true;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciSystem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciSystem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciIngItem)
	{
		if(!m_FaultMgr->IsChildItem(m_ciIngItem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("     ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}
	else if(m_ciEdItem && !m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_mgr.e_pdf))
	{
		if(!m_FaultMgr->IsChildItem(m_ciEdItem, m_ciMainPdf, true))
		{
			MessageBox(APL_T("      ."), APL_T(" "), MB_ICONEXCLAMATION);
			return false;
		}
		else
		{
			return true;
		}
	}

	return true;
}

void CRefusalPropertyDlg::OnChooseIngItem()
{
	UpdateRefusalData();

	if(m_api->m_prd_mgr.FindPKIEx(&m_ciIngItem, &m_ciIngLot, true,false,false,LPCTSTR(m_sSpavKomponent)))
	{
		if( CheckIngItemComposition() ) GetInfoAboutIngItem();		
		else OnClearIng();
	}
}

void CRefusalPropertyDlg::GetInfoAboutIngItem()
{
	CString t_str;
	COleDateTime time;
	CaplInstance *ciPrd, *ciPdf, *ciLot;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciIngLot) m_api->m_data.GetAttr(m_ciIngLot, m_api->m_prd_inst_mgr.a_lot_id, m_sRefIngItemLot);

	if(m_ciIngItem  && m_ciIngItem->GetAccessmode()<=aplRO)
	{
		m_api->m_data.GetAttr(m_ciIngItem, m_api->m_prd_inst_mgr.a_prd_inst_pdf, ciPdf);
		if(ciPdf && ciPdf->GetAccessmode()<=aplRO)
		{
			//   
			m_api->m_data.GetAttr(ciPdf, m_api->m_prd_mgr.a_pdf_prd, ciPrd);
			if(ciPrd)
			{
				m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_id, m_sRefIngItemShifr);
				m_api->m_data.GetAttr(ciPrd, m_api->m_prd_mgr.a_prd_name, m_sRefIngItemName);
			}
		}

		// 
		m_api->m_data.GetAttr(m_ciIngItem, m_api->m_prd_inst_mgr.a_prd_inst_lot, ciLot);
		if(ciLot) m_api->m_data.GetAttr(ciLot, m_api->m_prd_inst_mgr.a_lot_id, m_sRefIngItemLot);

		//  
		m_api->m_data.GetAttr(m_ciIngItem, m_api->m_prd_inst_mgr.a_prd_inst_sn, m_sRefIngItemSn);

		//  
		m_api->m_data.GetAttr(m_ciIngItem, m_api->m_prd_inst_mgr.a_prd_inst_datetime, t_str);
		aplString2Date(t_str, time);
		m_date_ref_ing_item_date.SetTime(time);
	}

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnChooseSystem()
{
	UpdateRefusalData();
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(mgr->SelectPlanerSystem1(&m_ciSystem, aplSelectPlanerSystem, 0))
	{
		if( !CheckSystemComposition() )
		{
			OnClearSystem();
			return;
		}

		m_FaultMgr->GetSystemName(m_ciSystem, m_sRefSystem);
		UpdateData(FALSE);
	}
}

void CRefusalPropertyDlg::OnChooseMainPdf()
{
	UpdateRefusalData();
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	
	if(m_api->m_prd_mgr.FindPKIEx(&m_ciMainPdf, 0, true, true,false,LPCTSTR(m_sSpavPKI)))
	{		
		m_FaultMgr->GetPlanerName(m_ciMainPdf, m_sRefMainPdf);		
		UpdateData(FALSE);
	}
}

void CRefusalPropertyDlg::InitComboBoxes()
{
	InitComboType();
	InitComboStage();	
}

void CRefusalPropertyDlg::InitComboType()
{
	CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_TYPE_CLASSIFIER_LVL);
	if(!ciLvl) return;

	m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, aeItems);
	for(int i=0; i<aeItems.Size; i++)
	{
		m_api->m_data.GetAttr(aeItems[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, sName);
		if(sName.IsEmpty()) continue;

		int nIndex = m_combo_ref_type.AddString(sName);
		m_combo_ref_type.SetItemData(nIndex, (DWORD)aeItems[i]);
	}
}

void CRefusalPropertyDlg::InitComboStage()
{
	CString sName, msg;
	aplExtent aeItems;
	CaplInstance *ciLvl = m_api->m_classifier_mgr.GetClassifierSystemBN(REFUSAL_STAGE_CLASSIFIER_LVL);
	if(!ciLvl) return;


	m_api->m_classifier_mgr.LoadSubClassifierLevels(ciLvl, aeItems);
	for(int i=0; i<aeItems.Size; i++)
	{
		m_api->m_data.GetAttr(aeItems[i], m_api->m_classifier_mgr.a_apl_classifier_level_name, sName);
		if(sName.IsEmpty()) continue;

		int nIndex = m_combo_ref_stage.AddString(sName);
		m_combo_ref_stage.SetItemData(nIndex, (DWORD)aeItems[i]);
	}
}

void CRefusalPropertyDlg::OnCheckDateRemove()
{	
	if(m_check_ref_date_remove.GetCheck() == 1) m_date_ref_date_remove.EnableWindow(TRUE);
	else m_date_ref_date_remove.EnableWindow(FALSE);	
}

bool CRefusalPropertyDlg::PrepareResourceList()
{
	/*m_list_ref_res.DeleteAllItems();

	if(!m_ciEdItem) return false;
	if(!m_api->m_data.IsKindOf(m_ciEdItem, m_api->m_prd_inst_mgr.e_prd_inst)) return false;

	aplExtent aeCharacts;
	CString sName, buf, unit_name;
	bool bDynamic, bInsertEmptyCharact = true;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
	CaplInstance *ciPdf = 0, *ciCharact = 0, *ciUnit = 0, *ciCharactType = 0, *ciChVal = 0;

	//  
	m_api->m_data.GetAttr(m_ciEdItem, m_api->m_prd_inst_mgr.a_prd_inst_pdf, ciPdf);
	if(!ciPdf) return false;

	//   
	m_api->m_charact_mgr.FindAssociatedCharacteristics(ciPdf, aeCharacts);
	
	//  
	CRect rect;
	for(int j=m_list_ref_res.GetHeaderCtrl()->GetItemCount()-1; j>=0; j--) 
		m_list_ref_res.DeleteColumn(j);

	m_list_ref_res.GetClientRect(&rect);
	m_list_ref_res.InsertColumn(0,_T(""), LVCFMT_LEFT, (int)(rect.Width()*0.5));
	m_list_ref_res.InsertColumn(1,APL_T("  "), LVCFMT_LEFT, (int)(rect.Width()*0.49));
	//m_list_ref_res.InsertColumn(2,APL_T("  "), LVCFMT_LEFT, (int)(rect.Width()*0.25));

	for(int i=0; i<aeCharacts.Size;i++)
	{
		m_api->m_data.GetAttr(aeCharacts[i], m_api->m_charact_mgr.a_apl_charact_val_charact, ciCharact);
		if(!ciCharact) continue;

		m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_dynamic, bDynamic);
		if(!bDynamic) continue;

		m_api->m_data.GetAttr(aeCharacts[i], m_api->m_charact_mgr.a_apl_charact_val_type, ciCharactType);
		if(ciCharactType != mgr->m_ResTypes.Vyrab) continue;

		m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_name, sName);
		m_api->m_data.GetAttr(ciCharact, m_api->m_charact_mgr.a_apl_charact_unit, ciUnit);

		if(ciUnit)
		{
			m_api->m_data.GetAttr(ciUnit, m_api->m_charact_mgr.a_apl_unit_id, buf);
			if(!buf.IsEmpty()) unit_name = _T(", ") + buf;
		}
		buf.Format(_T("%s%s"), sName, unit_name);

		int ind = m_list_ref_res.InsertItem(m_list_ref_res.GetItemCount(), buf);
		m_list_ref_res.SetItemText(ind, 1, _T(""));
		m_list_ref_res.SetItemEditType(0, 1, aplRealCtrl);

		//m_list_ref_res.SetItemText(ind, 2, _T(""));

		bInsertEmptyCharact = false;
		m_list_ref_res.SetItemData(ind, DWORD(aeCharacts[i]));		
	}

	if(bInsertEmptyCharact)
	{		
		ciCharact = m_api->m_charact_mgr.GetCharacteristicBN(APL_T("  "));

		int ind = m_list_ref_res.InsertItem(m_list_ref_res.GetItemCount(), APL_T("  "));
		m_list_ref_res.SetItemText(ind, 1, _T(""));
		//m_list_ref_res.SetItemText(ind, 2, _T(""));
		m_list_ref_res.SetItemData(ind, DWORD(ciCharact));	

		m_list_ref_res.SetItemEditType(0, 1, aplRealCtrl);
	}*/

	return true;
}

void CRefusalPropertyDlg::LoadResources()
{
/*	if(!PrepareResourceList()) return; 
	if(!m_ciEdItem) return;

	aplExtent ext, gr;
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	if(m_ciRef) mgr->aplFindAssociatedCharacteristics(m_ciRef, ext);
	SortCharactsBN(m_api, ext);
	CaplInstance *charact, *unit, *charact_type, *ciChVal;
	bool bDynamic, bHour, bFind;
	CString name, buf, unit_name;
	double val;
	int ind, i, j, col_ind;

	for(i=0; i<ext.Size;i++)
	{
		bHour = false;
		m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_charact, charact);
		if(!charact) continue;
		m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_dynamic, bDynamic);
		if(!bDynamic) continue;
		m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_type, charact_type);

		if(charact_type==mgr->m_ResTypes.Vyrab) col_ind = 1;
		else if(charact_type==mgr->m_ResTypes.LastRem) col_ind = 2;
		else continue;

		m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_name, name);
		m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_unit, unit);
		if(unit)
		{
			m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, buf);
			if(buf.CompareNoCase(APL_T(""))==0)
				bHour = true;
			if(!buf.IsEmpty())
				unit_name=_T(", ")+buf;
		}
		buf.Format(_T("%s%s"), name, unit_name);

		//   
		bFind = false;
		for(j=0; j<m_list_ref_res.GetItemCount(); j++)
		{
			CaplInstance *cit, *ciCharVal = (CaplInstance*)m_list_ref_res.GetItemData(j);

			if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_apl_charact_value))
				m_api->m_data.GetAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_charact, cit);
			else
				if(m_api->m_data.IsKindOf(ciCharVal, m_api->m_charact_mgr.e_apl_charact))
					cit = ciCharVal;

			if(cit==charact)
			{
				ind = j;
				bFind = true;
				break;
			}
		}
		if(!bFind)	continue;
		m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_meas_val, val);

		if(!bHour)
		{
			buf.Format(_T("%g"), val);
			m_list_ref_res.SetItemEditType(ind, col_ind, aplRealCtrl);
		}
		else
		{
			aplGetAsHM(val, buf);			
			m_list_ref_res.SetItemEditType(ind, col_ind, aplTimeCtrl);
		}

		m_list_ref_res.SetItemText(ind, col_ind, buf);
		m_list_ref_res.SetItemData(ind, (DWORD)ext[i]);
	}	

	if(0==m_ciTmpRef)
	{
		m_ciTmpRef = m_api->m_data.CreateInstance(mgr->e_apl_refusal, true);
		m_api->m_data.NET_SaveExtent(m_ciTmpRef);
	}
	for(i=0; i<m_list_ref_res.GetItemCount(); i++)
	{
		charact = (CaplInstance*)m_list_ref_res.GetItemData(i);
		if(m_api->m_data.IsKindOf(charact, m_api->m_charact_mgr.e_apl_charact))
		{
			ciChVal = m_api->m_charact_mgr.CreateMeasuredCharacteristic(m_ciTmpRef, charact,  mgr->m_ResTypes.Vyrab, 0, -1, -1);
			m_list_ref_res.SetItemData(i, (DWORD)ciChVal);
			m_aeNewCharVal.Add(ciChVal);
		}
	}*/
}

void CRefusalPropertyDlg::OnClearOrg()
{
	UpdateData();

	m_ciOrg = NULL;
	m_sRefOrg = _T("");

	m_ciSector = 0;
	m_sRefSector.Empty();

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnClearMainPdf()
{
	UpdateData();

	m_ciMainPdf = NULL;
	m_sRefMainPdf = _T("");

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnClearSystem()
{
	UpdateData();

	m_ciSystem = NULL;
	m_sRefSystem = _T("");

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnClearIng()
{
	UpdateData();

	m_ciIngItem = NULL;
	m_ciIngLot = NULL;

	m_sRefIngItemShifr = _T("");
	m_sRefIngItemName = _T("");
	m_sRefIngItemLot = _T("");
	m_sRefIngItemSn = _T("");

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnClearEd()
{
	UpdateData();

	m_ciEdItem = NULL;
	m_sRefEdItemShifr = _T("");
	m_sRefEdItemName = _T("");
	m_sRefEdItemLot = _T("");
	m_sRefEdItemSn = _T("");
	m_list_ref_res.DeleteAllItems();

	UpdateData(FALSE);
}

/*void CRefusalPropertyDlg::FillRefusalCharacts()
{
CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;
CaplInstance *Parent, *Planer, *charact, *unit, *type;
CString name, buf, unit_name;
int i, col_ind, j, ind;
aplExtent ext, gr;
bool bHour;
double val;

Planer = m_ciMainPdf
if(!Planer) return;
mgr->aplFindAssociatedCharacteristics(m_ciRef, ext);

for(i=0; i<ext.Size; i++)
{
m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_charact, charact);
m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_element, Parent);
m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_type, type);
bHour = false;
ind = -1;

if(Parent==m_ciEdItem && m_ciEdItem!=NULL)
{
m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_name, name);
m_api->m_data.GetAttr(charact, m_api->m_charact_mgr.a_apl_charact_unit, unit);
if(type==mgr->m_ResTypes.Vyrab)
col_ind = 1;
else if(type==mgr->m_ResTypes.LastRem)
col_ind = 2;
else continue;

if(unit)
{
m_api->m_data.GetAttr(unit, m_api->m_charact_mgr.a_apl_unit_id, buf);
if(buf.CompareNoCase(APL_T(""))==0)
bHour = true;
if(!buf.IsEmpty())
unit_name=_T(", ")+buf;
}

for(j=0; j<m_list_ref_res.GetItemCount(); j++)
{
if(charact==(CaplInstance*)m_list_ref_res.GetItemData(j))
ind=j;
}

if(ind<0)
{
buf.Format(_T("%s%s"), name, unit_name);
ind = m_list_ref_res.InsertItem(0, buf);
m_list_ref_res.SetItemData(ind, DWORD(charact));
}

m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_meas_val, val);
if(!bHour)
{
buf.Format(_T("%g"), val);
m_list_ref_res.SetItemEditType(ind, col_ind, aplRealCtrl);
}
else
{
mgr->GetAsHM(val, buf);
m_list_ref_res.SetItemEditType(ind, col_ind, aplTimeCtrl);
}
m_list_ref_res.SetItemText(ind, col_ind, buf);
}
else if(Parent==Planer)
{
m_api->m_data.GetAttr(ext[i], m_api->m_charact_mgr.a_apl_charact_val_meas_val, val);
if(mgr->IsHoursCharact(charact))
mgr->GetAsHM(val, m_sPlanerHours);
else if(charact==mgr->m_ResCharacts.Fliers)
{
m_sPlanerCycles.Format(_T("%g"), val);
int indL = m_sPlanerCycles.Find(_T("."));
if(indL>-1)
m_sPlanerCycles = m_sPlanerCycles.Left(m_sPlanerCycles.GetLength()>indL+3 ? indL+3 : m_sPlanerCycles.GetLength());
}
}
}
}*/

void CRefusalPropertyDlg::OnBnClickedCreateFaultsReportButton()
{
	CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

	//   
	CaplInstance *ciRefusalTmp = m_api->m_data.CreateInstance(mgr->e_apl_refusal, true);
	m_api->m_data.NET_SaveExtent(ciRefusalTmp);
	SaveRefusalBase(ciRefusalTmp, false);

	if(!ciRefusalTmp) 
	{
		MessageBox(APL_T("    !"), APL_T(""), MB_ICONSTOP);
		return;
	}

	//  
	CString sDocType;
	m_combo_ref_doc.GetWindowText(sDocType);

	if(sDocType == APL_T(" ")) GenFaultReportSheet(m_api, ciRefusalTmp);
	else if(sDocType == APL_T("  ")) GenProductReturnReport(m_api, ciRefusalTmp);

	//   
	if(ciRefusalTmp->GetType()) m_api->m_data.DeleteInstance(ciRefusalTmp, false);	
}

void CRefusalPropertyDlg::OnBnClickedChooseSector()
{
	UpdateRefusalData();

	aplExtent aeRoot;
	if(m_ciOrg) aeRoot.Add(m_ciOrg);

	if(m_api->m_appr_mgr.SelectOrganization(&m_ciSector, APL_T(" (  )"), &aeRoot)) 
		m_api->GetItemName(m_ciSector, m_sRefSector);

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnBnClickedClearSector()
{
	UpdateData();

	m_ciSector = NULL;
	m_sRefSector = _T("");

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::IsEnableReportBtn()
{
	CString str;
	m_combo_ref_doc.GetWindowText(str);

	if(str == APL_T(" ") || str == APL_T("  ")) GetDlgItem(IDC_CREATE_FAULTS_REPORT_BUTTON)->EnableWindow(TRUE);
	else GetDlgItem(IDC_CREATE_FAULTS_REPORT_BUTTON)->EnableWindow(FALSE);
}

void CRefusalPropertyDlg::OnCbnSelchangeRefDoc()
{
	IsEnableReportBtn();
}

void CRefusalPropertyDlg::SetResourceToMainRefusal()
{
	if(m_ciRef)
	{
		for(int i=0; i<m_list_ref_res.GetItemCount(); i++)
		{
			CaplInstance *ciCharVal = (CaplInstance*)m_list_ref_res.GetItemData(i);
			m_api->m_data.PutAttr(ciCharVal, m_api->m_charact_mgr.a_apl_charact_val_item, m_ciRef);
		}
	}
}

void CRefusalPropertyDlg::DiscardChanges()
{
	if(m_ciTmpRef) m_api->m_data.DeleteInstance(m_ciTmpRef, false);
	for(int i=0; i<m_aeNewCharVal.Size; i++) delete m_aeNewCharVal[i];
}

void CRefusalPropertyDlg::OnCancel()
{	
	DiscardChanges();

	if(m_pRefDoc) m_pRefDoc->DiscardChanges();
	if(m_pRefAppr) m_pRefAppr->DiscardChanges();
	if(m_pRefCharact) m_pRefCharact->DiscardChanges();	

	m_api->SaveChanges();
	CaplTranslateDialog::OnCancel();
}

void CRefusalPropertyDlg::OnDestroy()
{
	delete m_pRefResults;
	delete m_pRefusalClassif;
	delete m_pRefResearchResults;
	delete m_pRefDoc;
	delete m_pRefAppr;	
	delete m_pRefCharact;
	delete m_pRefAdminInfo;
	delete m_pRefFiles;

	m_pRefChild->m_pTreeList->m_tree.DeleteAllItems();
	delete m_pRefChild;
}

void CRefusalPropertyDlg::FillInfoAboutRelatingRefusal()
{
	UpdateData();

	if(!m_ciParentRef)
	{
		m_sParentType.Empty();
		m_sParentState.Empty();
		m_sParentDoc.Empty();
		m_sParentDocNum.Empty();
		m_sParentDate.Empty();
	}
	else
	{
		COleDateTime time;
		CaplInstance *ciType = 0;
		CaplPreExploitationMgr *mgr = (CaplPreExploitationMgr*)m_api->m_expl_mgr;

		// 
		m_api->m_data.GetAttr(m_ciParentRef, mgr->a_apl_refusal_type, ciType);
		if(ciType) m_api->m_data.GetAttr(ciType, m_api->m_classifier_mgr.a_apl_classifier_level_name, m_sParentType);

		// 
		m_api->m_data.GetAttr(m_ciParentRef, mgr->a_apl_refusal_state, m_sParentState);

		// 
		m_api->m_data.GetAttr(m_ciParentRef, mgr->a_apl_refusal_doc_type, m_sParentDoc);

		//  
		m_api->m_data.GetAttr(m_ciParentRef, mgr->a_apl_refusal_doc_num, m_sParentDocNum);

		//  
		m_api->m_data.GetAttr(m_ciParentRef, mgr->a_apl_refusal_date_detection, m_sParentDate);
		if(!m_sParentDate.IsEmpty())
		{
			aplString2Date(m_sParentDate, time);
			m_sParentDate.Format(_T("%.2d.%.2d.%.4d"), time.GetDay(), time.GetMonth(), time.GetYear());
		}
	}

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnBnClickedClearIngRef()
{
	UpdateData();

	m_sParentType.Empty();
	m_sParentState.Empty();
	m_sParentDoc.Empty();
	m_sParentDocNum.Empty();
	m_sParentDate.Empty();
	m_ciParentRef = 0;

	UpdateData(FALSE);
}

void CRefusalPropertyDlg::OnBnClickedChooseIngRef()
{
	CGetRefusalDlg dlg(m_api, m_FaultMgr);	
	dlg.m_ciChildRef = m_ciRef;
	
	if(dlg.DoModal() == IDOK)
	{
		m_ciParentRef = dlg.m_ciParentRef;
		FillInfoAboutRelatingRefusal();
	}
}

void CRefusalPropertyDlg::MoveDialog()
{
	int nDelta = 10;
	CRect clientRect;
	GetWindowRect(clientRect);

	clientRect.left += nDelta;
	clientRect.top += nDelta;
	clientRect.right += nDelta;
	clientRect.bottom += nDelta;

	MoveWindow(clientRect);
}