// AlternateListView.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "PSMDoc.h"
#include "TreeProductItem.h"
#include "AlternateListView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAlternateListView

IMPLEMENT_DYNCREATE(CAlternateListView, CaplListView)

CAlternateListView::CAlternateListView()
{
	SetUniqueName(_T("CAlternateListView"));
}

CAlternateListView::~CAlternateListView()
{
}


BEGIN_MESSAGE_MAP(CAlternateListView, CaplListView)
	//{{AFX_MSG_MAP(CAlternateListView)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
	ON_WM_CONTEXTMENU()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlternateListView drawing

void CAlternateListView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CAlternateListView diagnostics

#ifdef _DEBUG
void CAlternateListView::AssertValid() const
{
	CListView::AssertValid();
}

void CAlternateListView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAlternateListView message handlers

int CAlternateListView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CaplListView::OnCreate(lpCreateStruct) == -1)
		return -1;
	// TODO: Add your specialized creation code here
    ListView_SetExtendedListViewStyle(m_hWnd,
		ListView_GetExtendedListViewStyle(m_hWnd)
                | LVS_EX_FULLROWSELECT|/*LVS_EX_GRIDLINES|*/LVS_EX_INFOTIP);

	LIST.InsertColumn(0, APL_T(""),LVCFMT_LEFT,80);
	LIST.InsertColumn(1, APL_T(""),LVCFMT_LEFT,120);
	LIST.InsertColumn(2, APL_T(""),LVCFMT_LEFT,140);
	LIST.InsertColumn(3, APL_T(" )"),LVCFMT_LEFT,120);
	LIST.InsertColumn(4, APL_T(" )"),LVCFMT_LEFT,200);
	LoadColumnWidths();
	return 0;
}


void CAlternateListView::UpdateTreeItem(CaplTreeItem *item)
{
	if(item==m_cur_item) return;
	m_cur_item=item;
	GetListCtrl().DeleteAllItems();
	if(item==0) return;
	CString m_type = _T("");
	aplExtent ext0,ext1;
	int i,k;
	CaplInstance *baseinst=0;
	CString buf;

	if(item->m_type!=APL_TREE_ITEM_PRODUCT) return;


	bool bPdfRelation=true;//   bkb dthcbzvb

	if(bPdfRelation)
	{
		CaplInstance *pdf=((CaplProductTreeItem*)item)->m_pdf;
		if(0==pdf) return;
		item->m_doc->m_api.m_prd_mgr.LoadPdfAlternates(pdf,ext0,ext1);
	}
	else
	{
		CaplInstance *prd=((CaplProductTreeItem*)item)->m_prd;
		if(0==prd) return;
		item->m_doc->m_api.m_prd_mgr.LoadProductAlternates(prd,ext0,ext1); 
	}

	CString sId,sName,sDescr,sAltDescr,sBasis;

	for(i=0;i<ext0.Size;i++)
	{
		sId=_T(""); sName=_T(""); sDescr=_T(""); sAltDescr=_T("");  sBasis=_T("");
		
		if(!bPdfRelation)
		{
			CaplInstance*inst1;
			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_alt,inst1);
			if(inst1==0) continue;
			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_basis,sBasis);
			item->m_doc_data.GetAttr(inst1,item->m_doc->m_api.m_prd_mgr.a_prd_id,sId);
			item->m_doc_data.GetAttr(inst1,item->m_doc->m_api.m_prd_mgr.a_prd_name,sName);
			item->m_doc_data.GetAttr(inst1,item->m_doc->m_api.m_prd_mgr.a_prd_descr,sDescr);
			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_descr,sAltDescr);
		}
		else
		{
			CaplInstance *alt_pdf,*alt_prd;
			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_pdf_alt,alt_pdf);
			if(alt_pdf==0) continue;
			item->m_doc_data.GetAttr(alt_pdf,item->m_doc->m_api.m_prd_mgr.a_pdf_prd,alt_prd);
			if(alt_prd==0) continue;

			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_pdf_basis,sBasis);
			item->m_doc_data.GetAttr(alt_prd,item->m_doc->m_api.m_prd_mgr.a_prd_id,sId);
			item->m_doc_data.GetAttr(alt_prd,item->m_doc->m_api.m_prd_mgr.a_prd_name,sName);
			item->m_doc_data.GetAttr(alt_pdf,item->m_doc->m_api.m_prd_mgr.a_pdf_descr,sDescr);
			item->m_doc_data.GetAttr(ext0[i],item->m_doc->m_api.m_prd_mgr.a_alt_pdf_descr,sAltDescr);
		}
			
		k=LIST.InsertItem(0,sBasis);
		LIST.SetItemData(k,(long)ext0[i]);
		LIST.SetItemText(k,1,sId);
		LIST.SetItemText(k,2,sName);
		LIST.SetItemText(k,3,sDescr);
		LIST.SetItemText(k,4,sAltDescr);
	}

	SortColumn(m_aCombinedSortedColumns[0]);
	SortColumn(m_aCombinedSortedColumns[0]);
	SetRedraw(TRUE);
	StopBusy();
}


LRESULT CAlternateListView::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			CaplTreeItem* item = (CaplTreeItem*)lParam;
			m_cur_item=0;
			UpdateTreeItem(item);
		}
	}
	
	return CaplListView::WindowProc(message, wParam, lParam);
}

void CAlternateListView::OnContextMenu(CWnd* pWnd, CPoint point)
{
	CMenu menu;  gSetPsmResourceHandle();
	VERIFY(menu.LoadMenu(IDR_LIST_CONTEXT_MENU));
	// 	VERIFY(menu.LoadToolBar(IDR_MENU_ICONS));
	CaplMenu::Install(this); // 	VERIFY(CaplMenu::Install(pWnd, ePopupMenu ));

	CMenu* pPopup = menu.GetSubMenu(2);
	ASSERT(pPopup != NULL);
	if(pPopup==0) return;

	int line=-1;
	if(point.x<0 || point.y<0)
	{
		POSITION pos;
		pos=LIST.GetFirstSelectedItemPosition();
		line=LIST.GetNextSelectedItem(pos);
		if(line<0) return;
		RECT rect;
		LIST.GetItemRect(line,&rect,LVIR_BOUNDS );
		point.x=rect.left;
		point.y=rect.bottom;
		LIST.ClientToScreen(&point);
	}
	else
	{
		CPoint point1=point;
		LIST.ScreenToClient(&point1);
		line=LIST.HitTest(point1); 
	}
	
	if(line<0)
	{
		pPopup->EnableMenuItem(ID_SHOW_REL_PROPERTIES,MF_BYCOMMAND|MF_GRAYED);
		pPopup->EnableMenuItem(ID_SHOW_PROPERTIES,MF_BYCOMMAND|MF_GRAYED);
	}


	BOOL res=pPopup->TrackPopupMenu(TPM_LEFTALIGN|
		TPM_RIGHTBUTTON|TPM_RETURNCMD,point.x, point.y,pWnd);
	
	switch(res)
	{
	case ID_FILE_SAVE:
		{
			CString buf;
			if(m_cur_item!=0) m_cur_item->GetName(buf);
			apl_SaveListCtrlToFile(&GetListCtrl(),buf,buf);

		} break;

	case ID_EDIT_COPY_CELL:
		{
			CString text;
			LIST.ScreenToClient(&point);
			LVHITTESTINFO HitTestInfo;
			HitTestInfo.pt=point;
			HitTestInfo.flags=0;//LVHT_ONITEMLABEL|LVHT_ONITEMICON;
			HitTestInfo.iItem=-1;
			HitTestInfo.iSubItem=-1;
			LIST.SubItemHitTest(&HitTestInfo); 
			if(HitTestInfo.iItem>=0)
			{
				if(HitTestInfo.iSubItem<0 )HitTestInfo.iSubItem=0;
				text=LIST.GetItemText(HitTestInfo.iItem,HitTestInfo.iSubItem);
			}
			if(text!=_T(""))
			{
				COleDataSource*	pSource = new COleDataSource();
				if(pSource==0) return;
				HGLOBAL hMem;

				hMem=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,text.GetLength()+1);
				if (!hMem) return;
				char *xxx=(char*)GlobalLock(hMem);
				memcpy(xxx,LPCTSTR(text),text.GetLength()+1);		
				GlobalUnlock(hMem);
				pSource->CacheGlobalData(CF_TEXT, hMem);
				pSource->SetClipboard();
			}

		}	break;
	case ID_EDIT_COPY:
		{
			COleDataSource*	pSource = new COleDataSource();
			if(pSource==0) return;
			HGLOBAL hMem;

			CString text,text1;
			text.Empty();
			CHeaderCtrl* hc=LIST.GetHeaderCtrl();
			if(hc==0)return;
			int col_max=hc->GetItemCount();

			TCHAR buf[256];
			HDITEM HeaderItem;
			HeaderItem.mask = HDI_TEXT;
			HeaderItem.pszText = buf;
			HeaderItem.cchTextMax = 256;

			for(int col=0;col<col_max;col++){
				if(col!=0){text+=_T("; ");}
				hc->GetItem(col, &HeaderItem);
				text += buf;
				text +=_T(": ");
				text1=LIST.GetItemText(line,col);
				text+=text1.IsEmpty()?_T("?"):text1;
			}

			hMem=GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE|GMEM_ZEROINIT,(text.GetLength()+1)*sizeof(TCHAR));
			if (!hMem) return;
			TCHAR *xxx=(TCHAR*)GlobalLock(hMem);
			memcpy(xxx,LPCTSTR(text),(text.GetLength()+1)*sizeof(TCHAR));		
			GlobalUnlock(hMem);
			pSource->CacheGlobalData(CF_TEXT, hMem);
			pSource->SetClipboard();

		}
		break;
		case ID_SHOW_REL_PROPERTIES :
			{
				if(line<0) return;
				CaplInstance *inst = (CaplInstance*)LIST.GetItemData(line);
				if(0==inst || 0== m_cur_item) return;
				((CaplProductTreeItem*)m_cur_item)->ShowRelationProperties(inst);
			}
			break;

		case ID_SHOW_PROPERTIES:
			{
				if(line<0) return;
				CaplInstance *inst = (CaplInstance*)LIST.GetItemData(line);
				if(0==inst || 0== m_cur_item) return;
				if(m_cur_item->m_doc_data.IsKindOf(inst,m_cur_item->m_doc->m_api.m_prd_mgr.e_alt))
				{
					m_cur_item->m_doc_data.GetAttr(inst,m_cur_item->m_doc->m_api.m_prd_mgr.a_alt_alt,inst);
					if(0!=inst)m_cur_item->m_doc->m_api.m_prd_mgr.ShowProperties(inst);
				}
				else if(m_cur_item->m_doc_data.IsKindOf(inst,m_cur_item->m_doc->m_api.m_prd_mgr.e_alt_pdf))
				{
					m_cur_item->m_doc_data.GetAttr(inst,m_cur_item->m_doc->m_api.m_prd_mgr.a_alt_pdf_alt,inst);
					if(0!=inst)m_cur_item->m_doc->m_api.m_prd_mgr.ShowProperties(inst);
				}

			}
			break;
	}
}
