#include "stdafx.h"
#include "CaplVirtualFolderItem.h"
#include "aplDocTreeItem.h"

CaplVirtualFolderItem::CaplVirtualFolderItem(CTreeCtrl *tree, CPSMDoc *doc, CaplInstance *val, CaplInstance *folder)
{
	m_type=APL_TREE_ITEM_VIRTUAL_FOLDER;
	m_par_item_docs_ext=0;;
	m_group_item=0;
	m_name="";
	m_doc=doc;
	m_tree=tree;
	if(doc!=0) doc->m_items.Add(this);
}

CaplVirtualFolderItem::~CaplVirtualFolderItem(void)
{
}

//****************************************************************

void CaplVirtualFolderItem::GetAccessedInstances(aplExtent &ext)
{
	ext.Clear();
}

void CaplVirtualFolderItem::GetMainInstances(aplExtent &ext)
{
	ext.Clear();
}

//****************************************************************
bool CaplVirtualFolderItem::Expand(UINT action)
{
	// action = 2 ->  
	// action = 1 -> 
	//_APL_TREE_ITEM_CHEK_PARAM
	if(action==TVE_EXPAND)
	{
		if(m_fictive_item!=0)
		{
			m_tree->DeleteItem(m_fictive_item);
			m_fictive_item=0;
		}
		ShowContent();
	}
	else if(action==TVE_COLLAPSE)
	{
		CollapseItem(true);
	}
	return true;
}

//****************************************************************
bool CaplVirtualFolderItem::GetName(CString &name)
{
	name=m_name;
	return true;
}


//****************************************************************
bool CaplVirtualFolderItem::RefreshItem()
{
	CString name,buf,buf1;
	UINT ico=0;
	ico=ICON_VIRTUAL_DOC_FOLDER;
	if(m_tree==0) return false;
	GetName(name);
	SetItemImage(ico, IDX_IL_TREE_ITEM);
	m_tree->SetItemText(m_item,name);
	Sort();
	m_tree->RedrawWindow();

	return true;
}
//****************************************************************
bool CaplVirtualFolderItem::CreateTreeItem(HTREEITEM parent_item)
{
//	_APL_TREE_ITEM_CHEK_PARAM
	CString buf;
	GetName(buf);
	InsetItem(buf,ICON_ACTIVITY,parent_item);
	RefreshItem();
	m_fictive_item=m_tree->InsertItem(_T("fictive"),0,0,m_item);
	return true;
}

//****************************************************************
void CaplVirtualFolderItem::ShowProperties()
{
	return;
}

//****************************************************************
void CaplVirtualFolderItem::ShowCmd(long cmd)
{
	/*switch(cmd)
	{
		case ID_ITEM_VIEW: ShowProperties();break;
		default: PrepareContextMenu(cmd);break;
	}
	*/
}
//****************************************************************
BOOL CaplVirtualFolderItem::ShowToolBarButton(CCmdUI* pCmdUI)
{

	pCmdUI->Enable(FALSE);
	return FALSE;
}
//****************************************************************
bool CaplVirtualFolderItem::TrackPopupMenu(CWnd *wnd, CPoint &point, UINT view_mode)
{
	return true;
}

//****************************************************************
bool CaplVirtualFolderItem::PasteItem(CaplTreeItem *item, CPoint *point)
{
	if(item==0) return false;
	if(m_tree==0) return false;
	if(m_doc==0) return false;
	return false;
}

//****************************************************************
bool CaplVirtualFolderItem::ShowInListCtrl(CListCtrl *list)
{
	if(list==0) return false;
	//CHECK_SHOW_LIST_CTRL(m_refusal);
	if(m_doc==0)return false;
	int i=list->InsertItem(0, APL_T(":"));
	list->SetItemText(i,1,APL_T(" "));
	return true;
}
//****************************************************************
bool CaplVirtualFolderItem::ShowContent()
{
	int i;
	CaplInstance *rel,*doc;
	for(i=0; i<m_items.GetSize();i++)
	{
		rel=m_items[i];
		if(0==rel) continue;
		if(rel->IsDeleted()) continue;
		if(rel->GetAccessmode()>aplRO) continue;

		if( m_doc->m_api.m_data.IsKindOf(rel, m_doc->m_api.m_doc_mgr.e_doc)) {doc=rel; rel=0;}
		else if( m_doc->m_api.m_data.IsKindOf(rel, m_doc->m_api.m_doc_mgr.e_apl_doc_ref))
		{
			m_doc->m_api.m_data.GetAttr(rel,m_doc->m_api.m_doc_mgr.a_apl_doc_ref_doc,doc);
		}
		else continue;
		
		if(0==doc) continue;
		if(doc->IsDeleted()) continue;
		if(doc->GetAccessmode()>aplRO) continue;
		
		
		CaplDocTreeItem *doc_item= new CaplDocTreeItem(m_tree,m_doc,doc,rel);
		doc_item->CreateTreeItem(m_item);
		//m_all_documents.Add(inst0); //     
		doc_item->m_par_item_docs_ext=&m_all_documents;
	}
	return true;
}