// FindPSSPluginsDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "FindPSSPluginsDlg.h"
#include "aplPluginItem.h"
#include "apl_gui.h"
#include "PSMDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFindPSSPluginsDlg dialog


CFindPSSPluginsDlg::CFindPSSPluginsDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CFindPSSPluginsDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFindPSSPluginsDlg)
	m_Path = _T("");
	//}}AFX_DATA_INIT
	m_SelectedFiles.RemoveAll();
	GetExePath(m_Path);

}


void CFindPSSPluginsDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFindPSSPluginsDlg)
	DDX_Control(pDX, IDOK, m_ok_btn);
	DDX_Control(pDX, IDCANCEL, m_cancel_btn);
	DDX_Control(pDX, IDC_LIST, m_List_Ctrl);
	DDX_Text(pDX, IDC_PATH_EDIT, m_Path);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFindPSSPluginsDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CFindPSSPluginsDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFindPSSPluginsDlg message handlers

BOOL CFindPSSPluginsDlg::OnInitDialog() 
{

	CaplTranslateDialog::OnInitDialog();
	CRect rect;
	m_List_Ctrl.GetWindowRect(&rect);
	m_List_Ctrl.InsertColumn(0, APL_T(" "), LVCFMT_LEFT, rect.Width()/3-10);
	m_List_Ctrl.InsertColumn(1, APL_T(""), LVCFMT_LEFT, rect.Width()*2/3-10);

	m_List_Ctrl.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);

	m_cancel_btn.SetIcon(GetAplStdIco16(APLSTDICO_CANCEL));
	m_cancel_btn.SetFlat(FALSE);
	m_ok_btn.SetIcon(GetAplStdIco16(APLSTDICO_OK));
	m_ok_btn.SetFlat(FALSE);

	FindAddIns(m_Path);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFindPSSPluginsDlg::FindAddIns(CString &path)
{
	CString cur_file, str;
	int i;
	bool bFind;
	CFileFind ff;
	BOOL not_end=TRUE;
	m_List_Ctrl.DeleteAllItems();
	CStringArray list_exept;

	if(ff.FindFile(path+_T("*.dll")))
	{
		do{
			not_end=ff.FindNextFile();
			bFind = false;
			str.Empty();
			cur_file = ff.GetFileName();
			if(ff.IsDirectory()) continue;
			if(ff.IsDots()) continue;
			//     
			//  ,     .
			for(i=0; i<m_SkipFiles.GetSize(); i++)
			{
				if(m_SkipFiles[i].CompareNoCase(cur_file)==0)
				{
					bFind = true;
					list_exept.Add(cur_file);
					break;
				}
			}
			if(bFind) continue;
			//   
			if(cur_file.CompareNoCase(_T("apl_gui.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("apl_gui_d.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplAPIX.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplAPIXD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplOCIcall.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplOCIcallD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplWorkFlowMgr.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplWorkFlowMgrD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplCryptManager.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplCryptManagerD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplCryptographicProvider.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplCryptographicProviderD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplFormManager.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplFormManagerD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplFormManagerDlg.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplFormManagerDlgD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplProjectManager.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplProjectManagerD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplReportMgr.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplReportMgr_d.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplSocketTransport.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplSocketTransportD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplStepManagerX.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplStepManagerXD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplStepMgr.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("aplStepMgrD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplTransportClient.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AplTransportClientD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AutoRestartSrv.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("AutoRestartSrvD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("CaplData.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("CaplDataD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("CaplDataWithFile.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("CaplDataWithFileD.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("core_dll.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("core_dll_d.dll"))==0) continue;
			if(cur_file.CompareNoCase(_T("ExplotationMgr.dll"))==0) continue;
			// dll    
			HMODULE hMod = AfxLoadLibrary(cur_file);
			if(hMod)
			{
				int ind = -1;
				try
				{
					bool (*lpGetFunctionsList)(CArray<CaplItemInfo*, CaplItemInfo*>*);
					(FARPROC&)lpGetFunctionsList = GetProcAddress(hMod,"GetFunctionsList"); //-V614
					if(lpGetFunctionsList)
					{
						int ind = m_List_Ctrl.InsertItem(0, cur_file);
						m_List_Ctrl.SetItemData(ind,1);
						LPCTSTR (*lpName)();
						(FARPROC&)lpName= GetProcAddress(hMod, "GetAddInName"); //-V614
						if(lpName)
							str = lpName();
						m_List_Ctrl.SetItemText(ind, 1, str);
					}
					AfxFreeLibrary(hMod);
				}
				catch(...)
				{
					AfxFreeLibrary(hMod);
				}
			}
		}while(not_end);
	}
	for(i=0;i<list_exept.GetSize();i++){
		int ind = m_List_Ctrl.InsertItem(m_List_Ctrl.GetItemCount(), list_exept[i]);
		m_List_Ctrl.SetItemText(ind, 1,  APL_T("!!      "));
		m_List_Ctrl.SetItemData(ind,0);
	}
	
	m_List_Ctrl.SortColumn(0);
	m_List_Ctrl.SetItemSortState(0, DESCENDING);
	((CSortableHeaderCtrl*)m_List_Ctrl.GetHeaderCtrl())->SetSortImage(0, FALSE);
	m_List_Ctrl.ReSort();
}


int CFindPSSPluginsDlg::GetFirstFileIndex()
{
	return 0;
}

CString CFindPSSPluginsDlg::GetNextFile(int &index)
{
	if(index<0 || index>m_SelectedFiles.GetSize()-1)
	{
		index = -1;
		return _T("");
	}
	CString buf = m_SelectedFiles[index];
	index++;
	if(index>=m_SelectedFiles.GetSize())
		index = -1;
	return buf;
}

void CFindPSSPluginsDlg::OnOK() 
{
	CString path;
	GetExePath(path);
	if(m_Path!=path){
		path=m_Path;
	}else{
		path=_T("");
	}

	int ind = -1;
	while((ind=m_List_Ctrl.GetNextItem(ind, LVIS_SELECTED))>-1)
		m_SelectedFiles.Add(m_Path+m_List_Ctrl.GetItemText(ind, 0));
	
	CaplTranslateDialog::OnOK();
}

int CFindPSSPluginsDlg::AddFileNameToSkip(LPCTSTR file_name)
{
	return m_SkipFiles.Add(file_name);
}
