// ImportEfDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "resource.h"
#include "aplStepManager.h"
#include "ImportEfDlg.h"
#include "ImpEfPrdDlg.h"
#include "ImpEfCategDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImportEfDlg dialog
#define ICO_CATEGORY 0
#define ICO_PRODUCT 5
#define ICO_ASM 10
#define ICO_PART 15
#define ICO_MATER 20

CImportEfDlg::CImportEfDlg(CWnd* pParent /*=NULL*/)
	: CaplTranslateDialog(CImportEfDlg::IDD, pParent)
{

	//{{AFX_DATA_INIT(CImportEfDlg)
		// NOTE: the ClassWizard will add member initialization here
	m_create_folder = TRUE;
	m_imp_category = FALSE;
	m_imp_geom = TRUE;
	m_imp_doc = TRUE;
	m_auto_asm_set = TRUE;
	m_set_new_rew_active = TRUE;
	m_dbl_click_edit = FALSE;
	//}}AFX_DATA_INIT
	m_api=0;
	m_ReloadFolder=false;
}


void CImportEfDlg::DoDataExchange(CDataExchange* pDX)
{
	CaplTranslateDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CImportEfDlg)
	DDX_Control(pDX, IDC_CREATE_FOLDER, m_create_folder_ctrl);
	DDX_Control(pDX, IDC_FOLDER_NAME, m_folder_name_ctrl);
	DDX_Control(pDX, IDC_AUTO_NORMALIZE, m_auto_normalize_btn);
	DDX_Control(pDX, IDC_NORMALIZE, m_NormalizeBtn);
	DDX_Control(pDX, IDC_STATIC_SUB_ACTION, m_subaction);
	DDX_Control(pDX, IDC_PROGRESS2, m_progress1);
	DDX_Control(pDX, IDC_STATIC_ACTION, m_action);
	DDX_Control(pDX, IDC_PROGRESS1, m_progress);
	DDX_Control(pDX, IDC_SAVE_DB, m_SaveDbBtn);
	DDX_Control(pDX, IDC_SAVE_FILE, m_SaveFileBtn);
	DDX_Control(pDX, IDC_SINCHRONIZE, m_SinchonizeBtn);
	DDX_Control(pDX, IDC_PRD_TREE, m_tree);
	DDX_Control(pDX, IDC_FILE_NAME, m_FileName);
	DDX_Check(pDX, IDC_CREATE_FOLDER, m_create_folder);
	DDX_Check(pDX, IDC_IMP_CATEGORY, m_imp_category);
	DDX_Check(pDX, IDC_IMP_GEOMETRY, m_imp_geom);
	DDX_Check(pDX, IDC_IMP_DOC, m_imp_doc);
	DDX_Check(pDX, IDC_AUTO_ASM_SET, m_auto_asm_set);
	DDX_Check(pDX, IDC_SET_NEW_REVISION_ACTIVE, m_set_new_rew_active);
	DDX_Check(pDX, IDC_DBL_CLIK_EDIT, m_dbl_click_edit);
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_AUTO_SET_MADE, m_AutoSetMadeCtrl);
	DDX_Control(pDX, IDC_ID_MADE_SUBSTR, m_MadeIdSubstrCtrl);
	DDX_Control(pDX, IDC_AUTO_SET_BOUGHT, m_AutoSetBoughtCtrl);
	DDX_Control(pDX, IDC_AUTOSET_STD, m_AutoSetStdCtrl);
	DDX_Control(pDX, IDC_AUTO_PARSE_STD_NAME, m_autoParseStdNameCtrl);
	DDX_Control(pDX, IDC_CREATE_FOLDER_ALL, m_create_folder_all_ctrl);
	DDX_Control(pDX, IDC_DBL_CLIK_EDIT, m_dbl_click_edit_ctrl);
	DDX_Control(pDX, IDC_DENY_CREATE_STD, m_DenyCreateStdCtrl);
}


BEGIN_MESSAGE_MAP(CImportEfDlg, CaplTranslateDialog)
	//{{AFX_MSG_MAP(CImportEfDlg)
	ON_BN_CLICKED(IDC_OPEN_FILE, OnSelectFile)
	ON_BN_CLICKED(IDC_SAVE_FILE, OnSaveFile)
	ON_BN_CLICKED(IDC_NORMALIZE, OnNormalize)
	ON_BN_CLICKED(IDC_SINCHRONIZE, OnSinchronize)
	ON_NOTIFY(NM_DBLCLK, IDC_PRD_TREE, OnDblclkPrdTree)
	ON_BN_CLICKED(IDC_SAVE_DB, OnSaveDb)
	ON_NOTIFY(TVN_KEYDOWN, IDC_PRD_TREE, OnKeydownPrdTree)
	ON_BN_CLICKED(IDC_DEL, OnDel)
	ON_BN_CLICKED(IDC_EDIT, OnEdit)
	ON_BN_CLICKED(IDC_DBL_CLIK_EDIT, OnDblClikEdit)
	ON_BN_CLICKED(IDC_CREATE_FOLDER, OnCreateFolder)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_AUTO_SET_MADE, &CImportEfDlg::OnBnClickedAutoSetMade)
//	ON_WM_CLOSE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CImportEfDlg message handlers
BOOL CImportEfDlg::OnInitDialog()
{
	CaplTranslateDialog::OnInitDialog();
	// TODO: Add extra initialization here
	m_auto_normalize_btn.SetCheck(1);
	imagelist.Create(IDR_IMPORT_EF_ICO,20,2,RGB(255,255,255));
	m_tree.SetImageList(&imagelist,TVSIL_NORMAL);

	m_NormalizeBtn.EnableWindow(FALSE);
	m_SaveDbBtn.EnableWindow(FALSE);
	m_SaveFileBtn.EnableWindow(FALSE);
	m_SinchonizeBtn.EnableWindow(FALSE);

	CWinApp *app=AfxGetApp();
	if(app!=0)
	{
		BOOL b;

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bdbl_click_edit"),FALSE);
		m_dbl_click_edit_ctrl.SetCheck(b);

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bAutoSetMade"),FALSE);
		m_AutoSetMadeCtrl.SetCheck(b);
		
		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bAutoSetBought"),FALSE);
		m_AutoSetBoughtCtrl.SetCheck(b);

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bAutoParseStdName"),FALSE);
		m_autoParseStdNameCtrl.SetCheck(b);

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bAutoSetStd"),FALSE);
		m_AutoSetStdCtrl.SetCheck(b);

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bDenyCreateStd"),FALSE);
		m_DenyCreateStdCtrl.SetCheck(b);

		CString buf=app->GetProfileString(_T("CImportEfDlg"),_T("sMadeSubStr"),_T(""));
		m_MadeIdSubstrCtrl.SetWindowText(buf);

		b=app->GetProfileInt(_T("CImportEfDlg"),_T("bCreateFolderAll"),FALSE);
		m_create_folder_all_ctrl.SetCheck(b);
	}

	OnBnClickedAutoSetMade();

	m_api->m_options_mgr.GetOptionValueBN( APL_NO_T("\\     STEP"),m_sTopFolderName, _T(""));
	if(m_sTopFolderName!=_T(""))
	{
		m_create_folder_ctrl.SetCheck(1);
		m_create_folder_ctrl.EnableWindow(FALSE);
		m_folder_name_ctrl.SetWindowText(m_sTopFolderName);
		m_folder_name_ctrl.SetReadOnly(TRUE);
	}

	//OnSelectFile();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

//******************************************************************
void CImportEfDlg::OnSelectFile() 
{
	CFileDialog dlg(true,0,0,OFN_FILEMUSTEXIST,
		 APL_T("  STEP (*.stp;*.step;*.p21)|*.stp; *.step; *.p21|  (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)
	{
		CString buf=dlg.GetPathName( );
		m_sFilePath=dlg.GetFolderPath();
		m_sFilePath+='\\';
		aplP21Header header;
		m_FileName.SetWindowText(buf);
		
		pc_map.Clear();
		prd_map.Clear();;
		pd_map.Clear();
		inst_stat_map.Clear();

		m_progress.SetPos(0);
		m_progress1.SetPos(0);
		m_action.SetWindowText( APL_T("  "));
		m_subaction.SetWindowText(_T(""));
		
		AfxGetApp()->DoWaitCursor(1);
		data.LoadP21(LPCTSTR(buf),header);
		AfxGetApp()->DoWaitCursor(0);
		m_SinchonizeBtn.EnableWindow(FALSE);
		m_NormalizeBtn.EnableWindow(TRUE);
		m_SaveFileBtn.EnableWindow(TRUE);
		m_SaveDbBtn.EnableWindow(FALSE);
		m_Normalize=false;
		m_Sincronize=false;

		struct tm *newtime;
		time_t long_time;
		time( &long_time );
		newtime = localtime( &long_time ); 

		if(m_sTopFolderName==_T(""))
		{
			buf.Format( APL_T("_ %i.%i.%i  %i:%i"),newtime->tm_mday,newtime->tm_mon+1,
				newtime->tm_year+1900,newtime->tm_hour,newtime->tm_min);
			
			m_folder_name_ctrl.SetWindowText(buf);
		}
		
		UpdateData(TRUE);
		if(m_auto_normalize_btn.GetCheck()==1) OnNormalize();
		else ShowContentInTree();
	}
}
//******************************************************************	
void CImportEfDlg::OnSaveFile() 
{
	CString buf;
	m_FileName.GetWindowText(buf);
	CFileDialog dlg(FALSE,_T("stp"),LPCTSTR(buf),OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		 APL_T("  STEP (*.stp;*.step;*.p21)|*.stp; *.step; *.p21|  (*.*)|*.*||"));
	if(dlg.DoModal()==IDOK)
	{
		buf=dlg.GetPathName( );
		aplP21Header header;
		data.SaveP21(LPCTSTR(buf),header,aplWIN7BIT);
	}
}
//******************************************************************	
void CImportEfDlg::OnSaveDb() 
{
	UpdateData(TRUE);
	for(int i=0;i<inst_stat_map.Size;i++)
	{
		if(inst_stat_map[i].out==STATUS_CONFLICT || inst_stat_map[i].out==STATUS_UNALLOWED)
		{
			AfxMessageBox( APL_T("       -\n  !!!"),MB_OK|MB_ICONSTOP);
			return;
		}
	}
	PrepareDBSave();
}
//******************************************************************	
void CImportEfDlg::OnSinchronize()
{
	if(m_Sincronize) m_SaveDbBtn.EnableWindow(FALSE);

	inst_stat_map.Clear();
	pc_map.Clear();
	prd_map.Clear();;
	pd_map.Clear();

	
	if(!m_Normalize)
	{	OnNormalize();
		ShowContentInTree();
	}
	if(!m_Normalize) return;

	
	if(!m_api->m_data.IsConnected())
	{
		if(!m_api->Connect(_T(""),_T(""),_T("")))
		{
			AfxMessageBox( APL_T("   !!!"),MB_OK|MB_ICONSTOP);
			return;
		}
	}

	SincronizePrd();
	SincronizeCateg();

	ShowContentInTree();

	m_Sincronize=true;
	for(int i=0;i<inst_stat_map.Size;i++)
	{
		if(inst_stat_map[i].out==STATUS_CONFLICT || inst_stat_map[i].out==STATUS_UNALLOWED)
		{
			m_Sincronize=false; break;
		}
	}
	if(m_Sincronize) m_SaveDbBtn.EnableWindow(TRUE);
}
//******************************************************************
//        
/*bool ParseStrToStdAttr(CString &str, CString &id, CString &name, CString &ver)
{
	id=_T(""); name=_T(""); ver=_T("");
	if(str==_T("")) return true;

	CString buf=str;
	buf.MakeUpper();

	//  ,  
	int i_gost=buf.Find(APL_NO_T(""));
	if(0==i_gost) {id=str; return true;}
	if(i_gost<0) i_gost=buf.Find(APL_NO_T(""));
	if(i_gost<=0) {id=str; return true;}

	ver=str.Right(str.GetLength()-i_gost);

	buf=str.Left(i_gost);
	buf.TrimRight();
	
	//   -    

	int i, i_name=0;
	for(i=0;i<buf.GetLength();i++)
	{
		char c=buf[i];
		if(c==_T(' ')) {i_name=i; continue;}
		if( c >=_T('0') && c <= _T('9')) break;
	}

	if(0==i_name) id=buf; 
	else
	{
		name=buf.Left(i_name);
		id=buf.Right(buf.GetLength()-i_name); 
		id.TrimLeft();
	}
	return true;
}*/


//******************************************************************	
void CImportEfDlg::OnNormalize()
{
	UpdateData(TRUE);

	bool bAutoParseStdName=false;
	if(m_autoParseStdNameCtrl.GetCheck())bAutoParseStdName=true;

	m_action.SetWindowText( APL_T(""));
	m_progress.SetRange(0,1);

	if(m_imp_category) NormalizeCategory();
	m_progress.SetPos(1);

	//TranslateMappedItem();
	m_Normalize=true;
	//  
	aplExtent ext_sdr;
	CaplInstance *sr,*pds,*pd,*pdf,*prd;
	CString n1,n2;
	int i;
	//    SR (SolidWorks)
	data.GetEntityExtentBN(_T("shape_definition_representation"),ext_sdr);
	for(i=0;i<ext_sdr.Size;i++)
	{
		CaplAggr aggr0;
		data.GetAttrBN(ext_sdr[i],_T("used_representation"),sr);
		data.GetAttrBN(sr,_T("name"),n1);
		if(n1!=_T(""))
		{
			data.GetAttrBN(ext_sdr[i],_T("definition"),pds);
			data.GetAttrBN(pds,_T("definition"),pd);
			data.GetAttrBN(pd,_T("formation"),pdf);
			data.GetAttrBN(pdf,_T("of_product"),prd);
			data.GetAttrBN(prd,_T("name"),n2);
			if((n2==_T(""))||(n2==_T("PART")))data.PutAttrBN(prd,_T("name"),n1);
		}
	}

	aplExtent ext_pdf;
	CString buf, id,name, prd_id,prd_name,ver;
	data.GetEntityExtentBN(S::pdf,ext_pdf);
	for(i=0;i<ext_pdf.Size;i++)
	{
		pdf=ext_pdf[i];

		data.GetAttrBN(pdf,S::id,buf);
		if(0==buf.CompareNoCase(_T("ANY"))) data.PutAttrBN(pdf,S::id,_T(""));
	
		data.GetAttrBN(pdf,S::description,buf);
		if(0==buf.CompareNoCase(_T("UNSPECIFIED") )) data.PutAttrBN(pdf,S::description,_T(""));
			
		data.GetAttrBN(pdf,_T("of_product"),prd);
		if(0==prd)continue;
		data.GetAttrBN(prd,_T("id"),id);
		data.GetAttrBN(prd,_T("name"),name);
		if(id==_T("") && name!=_T("")) 
		{
			if(bAutoParseStdName)
			{
				//ParseStrToStdAttr(name, prd_id,prd_name,ver);

				//   -    
				int k, i_name=0;
				for(k=0;k<name.GetLength();k++)
				{
					TCHAR c=name[k];
					if(c==_T(' ')) {i_name=k; continue;}
					if( c >=_T('0') && c <= _T('9')) break;
				}

				if(0==i_name) {id=name; name=_T("");}
				else
				{
					buf=name.Left(i_name);
					id=name.Right(name.GetLength()-i_name); 
					id.TrimLeft();
					name=buf;
				}
				data.PutAttrBN(prd,_T("id"),id);
				data.PutAttrBN(prd,_T("name"),name);
				//data.PutAttrBN(pdf,S::id,ver);
			}
			else
			{
				data.PutAttrBN(prd,_T("id"),name);
				data.PutAttrBN(prd,_T("name"),_T(""));
			}
			continue;
		}
		if(name.Find(id)>0)
		{
			name.Replace(id,_T(""));
			name.TrimRight();
			data.PutAttrBN(prd,_T("name"),name);
		}
	}

	ShowContentInTree();

	m_NormalizeBtn.EnableWindow(FALSE);
	m_SinchonizeBtn.EnableWindow(TRUE);
}

//******************************************************************	
void GetAllSubElement(CaplStepData &data, aplExtent &extent, aplExtent &sub_elements,
					  LPCTSTR in_attr, LPCTSTR out_attr,
					  CaplInstance *element, LPCTSTR element_type=0)
					  
{
	sub_elements.Clear();
	if(in_attr==0) return;
	if(out_attr==0) return;
	int i,j;
	CaplInstance *inst;
	if(element!=0)
	{
		//   
		for(i=0;i<extent.Size;i++)
		{
			data.GetAttrBN(extent[i],in_attr,inst);
			if(inst==element)
			{
				data.GetAttrBN(extent[i],out_attr,inst);
				if(inst!=0) sub_elements.Add(inst);	
			}
		}
	}
	else
	{
		//  
		if(element_type==0) return;
		data.GetEntityExtentBN(element_type,sub_elements);
		
		for(i=0;i<extent.Size;i++)
		{
			data.GetAttrBN(extent[i],out_attr,inst);
			j=sub_elements.Find(inst);
			if(j!=-1) sub_elements.Remove(j);
		}
	}
}
//******************************************************************	
void CImportEfDlg::InsertCategoryInTree(CaplInstance *categ, HTREEITEM treeitem,
						  aplExtent &ext_rel,CaplMap &map_cat_item)
{
	if(categ==0) return;
	int i;
	CString name;
	aplExtent ext;
	int ico=ICO_CATEGORY;
	i=inst_stat_map.GetByIn((long)categ);
	if(i!=-1) ico+=i;

	data.GetAttrBN(categ,S::name,name);
	HTREEITEM item=m_tree.InsertItem(LPCTSTR(name),ico,ico,treeitem);
	m_tree.SetItemData(item,(long)categ);
	tree_map.Add((long)item,(long)categ);
	if(data.IsKindOfBN(categ,S::prd_rel_prd_cat))map_cat_item.Add((long)categ,(long)item);
	GetAllSubElement(data,ext_rel,ext,_T("category"),_T("sub_category"),categ,S::product_category);
	for(i=0;i<ext.Size;i++)
	{
		InsertCategoryInTree(ext[i],item,ext_rel,map_cat_item);
	}
}
//******************************************************************

//******************************************************************	
void CImportEfDlg::ShowContentInTree()
{
	tree_map.Clear();
	//m_tree.SetRedraw(FALSE);
	m_tree.LockWindowUpdate( );
	m_tree.DeleteAllItems();
	//m_tree.SetRedraw(TRUE);
	m_tree.UnlockWindowUpdate( );
	m_action.SetWindowText( APL_T(""));
	m_progress.SetRange(0,2);

	int i,j,k,n;
	CaplMap pc_map;
	CString buf,id,name;
	aplExtent ext_pd,ext_acu;
	aplExtent ext,ext_prpc,ext_cat_rel;

	data.GetEntityExtentBN(S::assembly_component_usage,ext_acu);
	data.GetEntityExtentBN(S::pd,ext_pd);
	
	//  
	if(m_imp_category)
	{
		CaplMap map_cat_item;
		data.GetEntityExtentBN(S::product_category_relationship,ext_cat_rel);
		GetAllSubElement(data,ext_cat_rel,ext,_T("category"),_T("sub_category"),0,S::product_category);
		m_progress.SetPos(0);
		m_progress1.SetRange32(0,ext.Size);
		m_subaction.SetWindowText( APL_T(""));
		for(i=0;i<ext.Size;i++)
		{
			InsertCategoryInTree(ext[i],TVI_ROOT,ext_cat_rel,map_cat_item);
			m_progress1.SetPos(i+1);
		}
	
		//   
		data.GetEntityExtentBN(S::prd_rel_prd_cat,ext_prpc);
		m_progress.SetPos(1);
		m_progress1.SetRange32(0,ext_prpc.Size);
		m_subaction.SetWindowText( APL_T(".  "));
		for(i=0;i<ext_prpc.Size;i++)
		{
			for(j=0;j<map_cat_item.Size;j++)
			{
				if((long)ext_prpc[i]==map_cat_item[j].in)
				{
					HTREEITEM item=(HTREEITEM)map_cat_item[j].out;
					CaplAggr aggr0;
					data.GetAttrBN(ext_prpc[i],_T("products"),aggr0);
					for(k=0;k<aggr0.GetSize();k++)
					{
						CaplInstance *inst0;
						aggr0.GetByIndex(k,inst0);
						data.GetAttrBN(inst0,S::id,id);
						data.GetAttrBN(inst0,S::name,name);
						buf=id+_T(" : ")+name;
						HTREEITEM item1=m_tree.InsertItem(LPCTSTR(buf),ICO_PRODUCT,ICO_PRODUCT,item);
						m_tree.SetItemData(item1,(long)inst0);
						tree_map.Add((long)item1,(long)inst0);
						for(n=0;n<ext_pd.Size;n++)
						{
							CaplInstance *i_pdf, *i_prd;
							data.GetAttrBN(ext_pd[n],S::formation,i_pdf);
							data.GetAttrBN(i_pdf,S::of_product,i_prd);
							if(i_prd==inst0)
							{
								InsertProductInTree(ext_pd[n],item1,ext_acu);
							}
						}
					}
				}
			}
			m_progress1.SetPos(i+1);
		}
	}
	//  
	ext.Clear();
	GetAllSubElement(data,ext_acu,ext,S::relating_pd,S::related_pd,0,S::pd);
	m_progress.SetPos(2);
	m_progress1.SetRange32(0,ext.Size);
	m_subaction.SetWindowText( APL_T(""));
	for(i=0;i<ext.Size;i++)
	{
		InsertProductInTree(ext[i],TVI_ROOT,ext_acu);
		m_progress1.SetPos(i+1);
	}
}
//******************************************************************	

//******************************************************************	

//******************************************************************	
//       
void CImportEfDlg::NormalizeCategory()
{
	int i,j,k,k1,pc_count=0;
	aplExtent ext,ext_pcr;
	CString name;

	data.GetEntityExtentBN(S::product_category,ext);
	data.GetEntityExtentBN(S::product_category_relationship,ext_pcr);
	
	CaplTAggr <Str_Inst*,Str_Inst*,
		APLAGGR_UNIQUE|APLAGGR_LIST|APLAGGR_AUTOKILLREF> s_i;

	m_subaction.SetWindowText( APL_T(""));
	m_progress1.SetPos(0);
	m_progress1.SetRange32(0,ext.Size);

	for(i=0;i<ext.Size;i++)
	{
		m_progress.SetPos(i+1);
		data.GetAttrBN(ext[i],S::name,name);
		bool found=false;
		for(j=0; j<s_i.Size;j++)
		{
			if(name==s_i[j]->str)
			{
				
				CaplInstance *r1=0, *r2=0,*inst1, *inst2;
				aplExtent HighCat1,HighCat2;
				//     
				for(k=0;k<ext_pcr.Size;k++)
				{
					data.GetAttrBN(ext_pcr[k],_T("category"),inst1);
					data.GetAttrBN(ext_pcr[k],_T("sub_category"),inst2);
					if(inst2==s_i[j]->inst) HighCat1.Add(inst1);
					if(inst2==ext[i]) HighCat2.Add(inst1);

				}
				//    
				bool f_equ=true;
				for(k=0;k<HighCat1.Size;k++)
				{
					bool f_found=false;
					for(k1=0;k1<HighCat2.Size;k1++)
					{
						if(HighCat1[k]==HighCat2[k1]) { f_found=true; break;}
					}
					if(!f_found) {f_equ=false; break;}
				}
				if(f_equ)
				{
					//    
					found=true;
					//  
					if(data.IsKindOfBN(ext[i],S::prd_rel_prd_cat))
					{
						CaplAggr aggr0,aggr1;
						data.GetAttrBN(ext[i],_T("products"),aggr0);
						data.GetAttrBN(s_i[j]->inst,_T("products"),aggr1);
						for(int i0=0;i0<aggr0.GetSize();i0++)
						{
							CaplInstance *inst0=0;
							aggr0.GetByIndex(i0,inst0);
							if(inst0!=0)
							{
								bool notfound=true;
								for(int i1=0;i1<aggr1.GetSize();i1++)
								{
									CaplInstance *inst1=0;
									aggr1.GetByIndex(i1,inst1);
									if(inst1==inst0) {notfound=false; break;}
								}
								if(notfound)aggr1.Add(inst0);
							}
						}
						data.PutAttrBN(s_i[j]->inst,_T("products"),aggr1);
					}
					//   PCR
					for(k=0;k<ext_pcr.Size;k++)
					{
						CaplInstance *inst;
						data.GetAttrBN(ext_pcr[k],_T("category"),inst);
						if(inst==ext[i]) data.PutAttrBN(ext_pcr[k],_T("category"),s_i[j]->inst);
						data.GetAttrBN(ext_pcr[k],_T("sub_category"),inst);
						if(inst==ext[i]) data.PutAttrBN(ext_pcr[k],_T("sub_category"),s_i[j]->inst);
					}
					data.DeleteInstance(ext[i]);
				}

			}
		}
		if(found==false)
		{
			//    
			Str_Inst *str_inst= new Str_Inst;
			str_inst->str=name;
			str_inst->inst=ext[i];
			s_i.Add(str_inst);
		}
	}
}
//******************************************************************
void GetPrdItemName(CaplStepData *data, CaplInstance *pd, CString &buf)
{
	if(pd==0) return;
	if(data==0) return;

	CaplInstance *pdf,*prd;
	CString id,name,ver;
	data->GetAttrBN(pd,S::formation,pdf);
	data->GetAttrBN(pdf,S::of_product,prd);
	data->GetAttrBN(pdf,S::id,ver);
	data->GetAttrBN(prd,S::id,id);
	data->GetAttrBN(prd,S::name,name);
	buf=id+_T(" : ")+ name +_T(" : ")+ver;

}
//******************************************************************	
void CImportEfDlg::InsertProductInTree(CaplInstance *pd,
						  HTREEITEM treeitem,aplExtent &ext_rel)
{
	if(pd==0) return ;
	int i;
	CString buf;
	aplExtent ext;

	GetPrdItemName(&data,pd,buf);
	
	int ico=ICO_PART;
	i=inst_stat_map.GetByIn((long)pd);

	if(i==STATUS_UNALLOWED)
	{
		int k=0;
	}
	if(i!=-1) ico+=i;

	HTREEITEM item=m_tree.InsertItem(LPCTSTR(buf),ico,ico,treeitem);
	m_tree.SetItemData(item,(long)pd);
	tree_map.Add((long)item,(long)pd);
	GetAllSubElement(data,ext_rel,ext,S::relating_pd,S::related_pd,pd,S::pd);
	for(i=0;i<ext.Size;i++)
	{
		InsertProductInTree(ext[i],item,ext_rel);
	}
	if(ext.Size>0)
	{
		m_tree.SetItemImage(item,ico+(ICO_ASM-ICO_PART),ico+(ICO_ASM-ICO_PART));
		m_tree.Expand(item,TVE_EXPAND);
	}
	return ;
}
//******************************************************************
void CImportEfDlg::SincronizePrd()
{
	m_extPdr4Delete.Clear();
	int i;
	aplExtent ext,ext_prd,ext_pdf,ext_pd,ext_acu;
	CaplAttrValue tst_values[2];
	CString id;
	CaplEntity *ent;
	CaplInstance *i_prd,*o_prd, *i_pdf, *o_pd;

	bool bDenyCreateStd=false;
	if(m_DenyCreateStdCtrl.GetCheck()) bDenyCreateStd=true;

	prd_map.Clear();
	//   PRODUCT
	data.GetEntityExtentBN(S::product,ext_prd);
	ent=m_api->m_prd_mgr.e_prd;
	for (i=0;i<ext_prd.Size;i++)
	{
		data.GetAttrBN(ext_prd[i],S::id,id);
		tst_values[0].value.Set((LPCTSTR)id);
		tst_values[0].attr=m_api->m_prd_mgr.a_prd_id;

		m_api->m_data.NET_FindInstancesWithAttrValues(ent,1,&tst_values[0],ext,false);
		if(ext.Size>0)
		{
			prd_map.Add((long)ext_prd[i],(long)ext[0]);
		}
	}
	//  PDF  PD
	ent=m_api->m_data.GetEntityBN(S::pdf);

	tst_values[0].attr=m_api->m_data.GetAttrDefinitionBN(S::pdf,S::id);
	tst_values[1].attr=m_api->m_data.GetAttrDefinitionBN(S::pdf,S::of_product);

	aplExtent ext_extist_pdf; ext_extist_pdf.Unique=false;

	data.GetEntityExtentBN(S::pd,ext_pd);
	for (i=0;i<ext_pd.Size;i++)
	{
		data.GetAttrBN(ext_pd[i],S::formation,i_pdf);
		data.GetAttrBN(i_pdf,S::of_product,i_prd);
		o_prd=(CaplInstance*)prd_map.GetByIn((long)i_prd);
		if((long)o_prd==-1) o_prd=0;
		if(o_prd!=0)
		{
			data.GetAttrBN(i_pdf,S::id,id);
			tst_values[0].value.Set((LPCTSTR)id);
			tst_values[1].value.Set(o_prd);

			m_api->m_data.NET_FindInstancesWithAttrValues(ent,2,&tst_values[0],ext,false);
			if(ext.Size>0)
			{
				pd_map.Add((long)ext_pd[i],(long)ext[0]);
				ext_extist_pdf.Add(ext[0]);
			}
		}
	}

	m_api->m_prd_mgr.LoadPrdInfo(ext_extist_pdf);


	//     
	CString sState,buf;
	inst_stat_map.Clear();
	data.GetEntityExtentBN(S::assembly_component_usage,ext_acu);
	ent=m_api->m_data.GetEntityBN(S::assembly_component_usage);
	for (i=0;i<ext_pd.Size;i++)
	{
		o_pd=(CaplInstance*)pd_map.GetByIn((long)ext_pd[i]);
		if(o_pd==(CaplInstance*)-1) 
		{
			int status=STATUS_NEW;
			if(bDenyCreateStd)
			{
				bool bSetStd=false;
				CaplInstance *prd,*pdf;
				data.GetAttrBN(ext_pd[i],S::formation,pdf);
				data.GetAttrBN(pdf,S::of_product,prd);
				data.GetAttrBN(prd,S::id,buf);
				if(buf.Find( APL_T(""))>0) 
					bSetStd=true;
				else
				{
					data.GetAttrBN(o_pd,S::id,buf);
					if(buf.Find( APL_T(""))>0) bSetStd=true;
				}
				if(bSetStd) status=STATUS_UNALLOWED;
			}
			inst_stat_map.Add((long)ext_pd[i],status); continue;
		}
		//     ->   
		GetAllSubElement(data,ext_acu,ext,_T("relating_product_definition"),_T("related_product_definition"),
			0,S::pd);
		if(ext.Size==0){inst_stat_map.Add((long)ext_pd[i],STATUS_EXIST); continue;}
		
		//     ->     
		tst_values[0].value.Set(o_pd);
		tst_values[0].attr=m_api->m_data.GetAttrDefinitionBN(S::assembly_component_usage,_T("relating_product_definition"));
		m_api->m_data.NET_FindInstancesWithAttrValues(ent,1,&tst_values[0],ext,false);
		if(0==ext.Size)
		{
			//    
			inst_stat_map.Add((long)ext_pd[i],STATUS_EXIST); continue;
		}

		//     
		if(o_pd->GetAccessmode()<=aplRW)
		{
			m_api->m_data.GetAttr(o_pd,m_api->m_prd_mgr.a_apl_pdf_state,sState);
			if(sState==_T("") || sState==_T("working"))
			{
				inst_stat_map.Add((long)ext_pd[i],STATUS_EXIST); 
				m_extPdr4Delete.Append(ext);
				continue;
			}
		}

		inst_stat_map.Add((long)ext_pd[i],STATUS_CONFLICT);
	}
}
//******************************************************************	
void CImportEfDlg::SincronizeCateg()
{
	int i;
	aplExtent ext,ext_pc;
	CaplAttrValue tst_values[2];
	CString name;
	CaplEntity *ent;

	//   PRODUCT
	data.GetEntityExtentBN(S::product_category,ext_pc);
	ent=m_api->m_data.GetEntityBN(S::product_category);
	for (i=0;i<ext_pc.Size;i++)
	{
		data.GetAttrBN(ext_pc[i],S::name,name);
		tst_values[0].value.Set((LPCTSTR)name);
		tst_values[0].attr=m_api->m_data.GetAttrDefinitionBN(S::product_category,S::name);

		m_api->m_data.NET_FindInstancesWithAttrValues(ent,1,&tst_values[0],ext,false);
		if(ext.Size==0) inst_stat_map.Add((long)ext_pc[i],STATUS_NEW);
		else if(ext.Size==1)
		{
			inst_stat_map.Add((long)ext_pc[i],STATUS_EXIST);	
			pc_map.Add((long)ext_pc[i],(long)ext[0]);
		}
		else  inst_stat_map.Add((long)ext_pc[i],STATUS_CONFLICT);	
	}
}
//******************************************************************	
void CImportEfDlg::OnDblclkPrdTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	if(m_dbl_click_edit==FALSE)
	{
		*pResult = 0;
		return;
	}
	*pResult = 1;
	OnEdit();
}
//******************************************************************	
void CImportEfDlg::OnKeydownPrdTree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_KEYDOWN* pTVKeyDown = (TV_KEYDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here
	*pResult = 0;
	if(pTVKeyDown==0) return;
	if(pTVKeyDown->wVKey==46) OnDel();
}
//******************************************************************	
void CImportEfDlg::OnDel() 
{
	int i;
	HTREEITEM item=m_tree.GetSelectedItem();
	if(item==0) return;
	CaplInstance *inst=(CaplInstance *)m_tree.GetItemData(item);
	if(inst==0) return;
	if(data.IsKindOfBN(inst,S::product_category))
	{
		//  
		CString name,buf;
		data.GetAttrBN(inst,S::name,name);
		buf.Format( APL_T("     \"%s\" ?"),name);
		if(IDYES!=AfxMessageBox(buf,MB_YESNO))	return;

		//   
		CaplInstance *inst1;
		aplExtent ext_parent_cat, ext_cat_rel;
		data.GetEntityExtentBN(S::product_category_relationship,ext_cat_rel);
		for(i=0;i<ext_cat_rel.Size; i++)
		{
			data.GetAttrBN(ext_cat_rel[i],_T("sub_category"),inst1);
			if(inst==inst1)
			{
				data.GetAttrBN(ext_cat_rel[i],_T("category"),inst1);
				ext_parent_cat.Add(inst1);
			}
		}
		if(ext_parent_cat.Size==0) 
			if(IDYES!=AfxMessageBox( APL_T("   !\n     ?"),MB_YESNO))	return;

		//    
		CaplInstance *par_cat=0;
		if(ext_parent_cat.Size>0)
		{
			par_cat=ext_parent_cat[0];
			if(data.IsKindOfBN(inst,S::prd_rel_prd_cat))
			{
				if(data.IsKindOfBN(par_cat,S::prd_rel_prd_cat))
				{
					CaplAggr aggr0,aggr1;
					data.GetAttrBN(inst,_T("products"),aggr0);
					data.GetAttrBN(par_cat,_T("products"),aggr1);
					for(int i0=0;i0<aggr0.GetSize();i0++)
					{
						CaplInstance *inst0=0;
						aggr0.GetByIndex(i0,inst0);
						if(inst0!=0)
						{
							bool notfound=true;
							for(int i1=0;i1<aggr1.GetSize();i1++)
							{
								CaplInstance *inst1=0;
								aggr1.GetByIndex(i1,inst1);
								if(inst1==inst0) {notfound=false; break;}
							}
							if(notfound)aggr1.Add(inst0);
						}
					}
					data.PutAttrBN(par_cat,_T("products"),aggr1);
				}
			}
		}
		//  
		for(i=0;i<ext_cat_rel.Size; i++)
		{
			data.GetAttrBN(ext_cat_rel[i],_T("sub_category"),inst1);
			if(inst==inst1) data.DeleteInstance(ext_cat_rel[i]);
			else
			{
				data.GetAttrBN(ext_cat_rel[i],_T("category"),inst1);
				if(inst==inst1)
				{
					if(par_cat!=0) data.PutAttrBN(ext_cat_rel[i],_T("category"),par_cat);
					else data.DeleteInstance(ext_cat_rel[i]);
				}
			}
		}

		/*      
		for(i=0;i<tree_map.Size;i++)
		{
			if(tree_map[i].out==(long)inst)
				m_tree.DeleteItem((HTREEITEM)(tree_map[i].in));
		}*/
		data.DeleteInstance(inst);
		ShowContentInTree();
	}
}
//******************************************************************	
void CImportEfDlg::OnEdit() 
{
	CString buf,id,name,ver,descr;
	int i,j;
	HTREEITEM item=m_tree.GetSelectedItem();
	if(item==0) return;
	CaplInstance *inst=(CaplInstance *)m_tree.GetItemData(item);
	if(inst==0) return;
	if(data.IsKindOfBN(inst,S::pd))
	{
		// 
		CaplInstance *pd=inst,*pdf,*prd,*prd1;
		data.GetAttrBN(pd,S::formation,pdf);
		data.GetAttrBN(pdf,S::of_product,prd);
		data.GetAttrBN(pdf,S::id,ver);
		data.GetAttrBN(prd,S::id,id);
		data.GetAttrBN(prd,S::name,name);
		CImpEfPrdDlg dlg;
		dlg.m_id=id; dlg.m_name=name; dlg.m_ver=ver;

		dlg.m_data=&data;
		dlg.m_prd=prd;
		dlg.m_pdf=pdf;
		
		if(dlg.DoModal()==IDOK)
		{
			m_SaveDbBtn.EnableWindow(FALSE);
			data.PutAttrBN(pdf,S::id,dlg.m_ver);
			data.PutAttrBN(prd,S::id,dlg.m_id);
			data.PutAttrBN(prd,S::name,dlg.m_name);
		
			//GetPrdItemName(&data,pd,buf);
			//    pd
			aplExtent ext_pd,ext;
			data.GetEntityExtentBN(S::pd,ext_pd);
			for(i=0;i<ext_pd.Size;i++)
			{
				data.GetAttrBN(ext_pd[i],S::formation,pdf);
				data.GetAttrBN(pdf,S::of_product,prd1);
				if(prd1==prd) ext.Add(ext_pd[i]);
			}
			//   
			for(i=0;i<tree_map.Size;i++)
			{
				for(j=0;j<ext.Size;j++)
				if(tree_map[i].out==(long)ext[j])
				{
					GetPrdItemName(&data,ext[j],buf);
					m_tree.SetItemText((HTREEITEM)tree_map[i].in,buf);
				}
			}
			//  
			buf=dlg.m_id+_T(" : ")+dlg.m_name;
			for(i=0;i<tree_map.Size;i++)
			{
				if(tree_map[i].out==(long)prd)
					m_tree.SetItemText((HTREEITEM)tree_map[i].in,buf);
			}
		}
	}
	else if(data.IsKindOfBN(inst,S::product_category))
	{
		//  
		CaplInstance *cat=inst;
		data.GetAttrBN(cat,S::name,name);
		data.GetAttrBN(cat,S::description,descr);
		CImpEfCategDlg dlg;
		dlg.m_name=name; dlg.m_descr=descr;
		if(dlg.DoModal()==IDOK)
		{
			data.PutAttrBN(cat,S::name,dlg.m_name);
			data.PutAttrBN(cat,S::description,dlg.m_descr);
		
			//      
			//   
			for(i=0;i<tree_map.Size;i++)
			{
				if(tree_map[i].out==(long)cat)
					m_tree.SetItemText((HTREEITEM)(tree_map[i].in),dlg.m_name);
			}
		}
	}
}

//******************************************************************	
void CImportEfDlg::PrepareDBSave()
{
	m_ReloadFolder=true;
	AfxGetApp()->DoWaitCursor(1);
	m_progress.SetRange(0,9);
	m_progress.SetPos(0);

	bool bAutoSetMade=false;
	if(m_AutoSetMadeCtrl.GetCheck())bAutoSetMade=true;
	CString sMadeSubStr;
	m_MadeIdSubstrCtrl.GetWindowText(sMadeSubStr);
	sMadeSubStr.MakeUpper();
	bool bAutoSetBought=false;
	if(bAutoSetMade && m_AutoSetBoughtCtrl.GetCheck())bAutoSetBought=true;

	bool bAutoSetStd=false;
	if(m_AutoSetStdCtrl.GetCheck())bAutoSetStd=true;

	if(bAutoSetMade && sMadeSubStr==_T(""))
	{
		CString msg=APL_T("  \n\"  ,\n    :\"\n   .");
		msg+=APL_T("\n\n      .   ?");
		if(IDYES!=AfxMessageBox(msg,MB_YESNO|MB_ICONQUESTION))	return;
	}

	int i,j;
	CString buf,buf1,id,name,descr,doc_type;
	CaplInstance *inst, *i_prd,*o_prd, *i_pdf, *o_pdf, *i_pd;
	CaplInstance *i_acu, *o_acu, *i_mwu;
	CaplInstance *pc=0;
	CaplEntity *ent;
	CaplAggr aggr0;
	aplExtent ext,ext_prd, ext_pdf, ext_pd, ext_acu;
	CaplTAggr <Tnauo_element*,Tnauo_element*,APLAGGR_AUTOKILLREF> elements;
	

	
	//   PRODUCT
	m_progress.SetPos(1);
	m_action.SetWindowText( APL_T(" PRODUCT"));
	data.GetEntityExtentBN(S::product,ext_prd);
	for (i=0;i<ext_prd.Size;i++)
	{
		i_prd=ext_prd[i];
		o_prd=(CaplInstance*)prd_map.GetByIn((long)i_prd);
		if((o_prd==0)||((long)o_prd==-1))
		{
			o_prd=m_api->m_data.CreateInstanceBN(S::product);
			prd_map.Add((long)i_prd,(long)o_prd);
		}

		if(o_prd->GetAccessmode()<=aplRW)
		{
			data.GetAttrBN(i_prd,S::id,buf);
			m_api->m_data.GetAttrBN(o_prd,S::id,buf1);
			if(buf!=buf1)m_api->m_data.PutAttrBN(o_prd,S::id,buf);
			data.GetAttrBN(i_prd,S::name,buf);
			m_api->m_data.GetAttrBN(o_prd,S::name,buf1);
			if(buf!=buf1)m_api->m_data.PutAttrBN(o_prd,S::name,buf);
			data.GetAttrBN(i_prd,S::description,buf);
			m_api->m_data.GetAttrBN(o_prd,S::description,buf1);
			if(buf!=buf1)m_api->m_data.PutAttrBN(o_prd,S::description,buf);
		}
	}
	
	//  PDF  PD
	CaplInstance *prd;
	m_progress.SetPos(3);
	m_action.SetWindowText( APL_T(" PD"));
	data.GetEntityExtentBN(S::pd,ext_pd);
	for (i=0;i<ext_pd.Size;i++)
	{
		i_pd=ext_pd[i];
		data.GetAttrBN(i_pd,S::formation,i_pdf);
		o_pdf=(CaplInstance*)pd_map.GetByIn((long)i_pd);
		if((long)o_pdf==-1) o_pdf=0;
		if(o_pdf==0)
		{
			o_pdf=m_api->m_data.CreateInstanceBN(_T("apl_product_definition_formation"));
			pd_map.Add((long)i_pd,(long)o_pdf);
			
			data.GetAttrBN(i_pdf,S::id,buf);
			m_api->m_data.PutAttrBN(o_pdf,S::id,buf);
			data.GetAttrBN(i_pdf,S::description,buf);
			m_api->m_data.PutAttrBN(o_pdf,S::description,buf);
			data.GetAttrBN(i_pdf,_T("make_or_buy"),buf);
			m_api->m_data.PutAttrBN(o_pdf,_T("make_or_buy"),buf);

			m_api->m_data.PutAttrBN(o_pdf,_T("formation_type"),_T("part"));

			data.GetAttrBN(i_pdf,S::of_product,prd);
			inst=(CaplInstance*)prd_map.GetByIn((long)prd);
			if((long)inst==-1) inst=0;
			m_api->m_data.PutAttrBN(o_pdf,S::of_product,inst);

			if(bAutoSetMade)
			{
				data.GetAttrBN(prd,S::id,buf);
				buf.MakeUpper();
				if(buf.Find(sMadeSubStr)>=0)
				{
					buf=_T("made");
				}
				else
				{
					if(bAutoSetBought)buf=_T("bought");
					else buf=_T("not_known");
				}
				m_api->m_data.PutAttrBN(o_pdf,_T("make_or_buy"),buf);				
			}
			if(bAutoSetStd)
			{
				bool bSetStd=false;
				data.GetAttrBN(prd,S::id,buf);
				if(buf.Find( APL_T(""))>0) 
					 bSetStd=true;
				else
				{
					data.GetAttrBN(i_pdf,S::id,buf);
					if(buf.Find( APL_T(""))>0) bSetStd=true;
				}

				if(bSetStd)
				{
					m_api->m_data.PutAttrBN(o_pdf,S::is_standard_part,true);
				}
			}
		}
		else
		{
			//  PDF  
			if(o_pdf->GetAccessmode()<=aplRW)
			{
				m_api->m_data.GetAttr(o_pdf,m_api->m_prd_mgr.a_apl_pdf_state,buf);
				if(buf==_T("") || buf==_T("working"))
				{
					data.GetAttrBN(i_pdf,S::id,buf);
					m_api->m_data.GetAttrBN(o_pdf,S::id,buf1);
					if(buf!=buf1)m_api->m_data.PutAttrBN(o_pdf,S::id,buf);

					data.GetAttrBN(i_pdf,S::description,buf);
					m_api->m_data.GetAttrBN(o_pdf,S::description,buf1);
					if(buf!=buf1)m_api->m_data.PutAttrBN(o_pdf,S::description,buf);

					data.GetAttrBN(i_pdf,_T("make_or_buy"),buf);
					m_api->m_data.GetAttrBN(o_pdf,_T("make_or_buy"),buf1);
					if(buf!=buf1)m_api->m_data.PutAttrBN(o_pdf,_T("make_or_buy"),buf);
				}
			}
		}
	}

	//   
	for(i=0;i<m_extPdr4Delete.GetSize();i++) m_api->m_data.DeleteInstance(m_extPdr4Delete[i]);

	//  
	m_progress.SetPos(4);
	m_action.SetWindowText( APL_T(" "));
	data.GetEntityExtentBN(S::assembly_component_usage,ext_acu);
	for (i=0;i<ext_acu.Size;i++)
	{
		CaplInstance *relating,*related;
		CString pos;
		double rval=1.0;
		i_acu=ext_acu[i];
		data.GetAttrBN(i_acu,_T("relating_product_definition"),relating);
		data.GetAttrBN(i_acu,_T("related_product_definition"),related);
		data.GetAttrBN(i_acu,S::id,pos);
		if(data.IsKindOfBN(i_acu,_T("quantified_assembly_component_usage")))
		{
			m_api->m_data.GetAttrBN(i_acu,_T("quantity"),i_mwu);
			m_api->m_data.GetAttrBN(i_mwu,_T("value_component"),rval);
		}

		o_acu=0;
		for(j=0;j<elements.Size;j++)
		{
			if(elements[j]->relating!=relating) continue;
			if(elements[j]->related!=related) continue;
			//if(elements[j]->pos!=pos) continue;      
			o_acu=elements[j]->new_inst;
			break;
		}
		if(o_acu==0)
		{
			o_acu=m_api->m_data.CreateInstance(m_api->m_prd_mgr.e_qacu_nauo);
			Tnauo_element *el= new Tnauo_element;
			el->relating=relating;
			el->related=related;
			el->pos=pos;
			el->new_inst=o_acu;
			elements.Add(el);

			m_api->m_data.PutAttrBN(o_acu,_T("value_component"),rval);

			inst=(CaplInstance*)pd_map.GetByIn((long)relating);
			if((long)inst==-1) inst=0;
			m_api->m_data.PutAttrBN(o_acu,_T("relating_product_definition"),inst);

			inst=(CaplInstance*)pd_map.GetByIn((long)related);
			if((long)inst==-1) inst=0;
			m_api->m_data.PutAttrBN(o_acu,_T("related_product_definition"),inst);

			m_api->m_data.PutAttrBN(o_acu,S::id,pos);
			data.GetAttrBN(i_acu,S::name,buf);
			m_api->m_data.PutAttrBN(o_acu,S::name,buf);
			data.GetAttrBN(i_acu,S::description,buf);
			m_api->m_data.PutAttrBN(o_acu,S::description,buf);
		}
		else
		{
			double rval1;
			m_api->m_data.GetAttrBN(o_acu,_T("value_component"),rval1);
			rval+=rval1;
			m_api->m_data.PutAttrBN(o_acu,_T("value_component"),rval);

			if(pos!=_T("")) //   
			{
				m_api->m_data.GetAttrBN(o_acu,S::id,buf);
				if(buf.Find(pos)<0)
				{
					if(buf!=_T("")) buf+=_T(",");
					buf+=pos;
					m_api->m_data.PutAttrBN(o_acu,S::id,buf);
				}
			}
		}
	}


	//   
	m_progress.SetPos(5);
	m_action.SetWindowText( APL_T(" "));
	aplExtent ext_asm;
	if(m_auto_asm_set)
	{
		for (i=0;i<ext_acu.Size;i++)
		{
			data.GetAttrBN(ext_acu[i],_T("relating_product_definition"),inst);
			o_pdf=(CaplInstance*)pd_map.GetByIn((long)inst);
			if((o_pdf!=0)&&((long)o_pdf!=-1))
			{
				if(o_pdf->GetAccessmode()<=aplRW)
					m_api->m_data.PutAttrBN(o_pdf,S::formation_type,_T("assembly"));
			}
		}
	}

	//    
	m_progress.SetPos(6);
	m_action.SetWindowText( APL_T(" "));
	if(m_create_folder==TRUE)
	{
		m_folder_name_ctrl.GetWindowText(buf);

		CaplInstance *top_folder=0;
		if(m_sTopFolderName!=_T(""))
		{
			top_folder=m_api->m_folder_mgr.FindFolderByName(m_sTopFolderName,0);
			if(0==top_folder) top_folder=m_api->m_folder_mgr.CreateFolder(0,m_sTopFolderName,_T(""));

			buf=_T("");
		}
		if(buf==_T(""))
		{
			struct tm *newtime;
			time_t long_time;
			time( &long_time );
			newtime = localtime( &long_time ); 
			buf.Format( APL_T("_ %i.%i.%i  %i:%i"),newtime->tm_mday,newtime->tm_mon+1,
				newtime->tm_year+1900,newtime->tm_hour,newtime->tm_min);
			if(m_sTopFolderName==_T("")) m_folder_name_ctrl.SetWindowText(buf);
		}
		pc=m_api->m_folder_mgr.CreateFolder(top_folder,buf,_T(""));

		if(m_create_folder_all_ctrl.GetCheck())
		{
			CaplInstance *pc1=m_api->m_folder_mgr.CreateFolder(pc,APL_T(""),_T(""));;

			for(i=0;i<pd_map.Size;i++)
			{
				aggr0.Add((CaplInstance*)pd_map[i].out);
			}
			m_api->m_data.PutAttrBN(pc1,_T("content"),aggr0);
		}

		GetAllSubElement(data,ext_acu,ext,S::relating_pd,S::related_pd,0,S::pd);
		aplExtent ext_top_prd;
		for(i=0;i<ext.Size;i++)
		{
			data.GetAttrBN(ext[i],S::formation,inst);
			data.GetAttrBN(inst,S::of_product,inst);
			o_prd=(CaplInstance*)prd_map.GetByIn((long)inst);
			if(o_prd!=0) ext_top_prd.Add(o_prd);
		}
		aggr0.Clear();
		for(i=0;i<ext_top_prd.Size;i++)
		{
			aggr0.Add(ext_top_prd[i]);
		}
		m_api->m_data.PutAttrBN(pc,_T("content"),aggr0);
		//m_api->m_data.PutAttrBN(pc1,_T("products"),aggr0);
	}

	m_progress.SetPos(7);
	m_action.SetWindowText( APL_T(" "));
	if(m_imp_category)
	{
		//  
		aplExtent ext_pc;
		CaplInstance *i_pc, *o_pc;
		data.GetEntityExtentBN(S::product_category,ext_pc);
		for (i=0;i<ext_pc.Size;i++)
		{
			i_pc=ext_pc[i];
			o_pc=(CaplInstance*)pc_map.GetByIn((long)i_pc);
			if((o_pc==0)||((long)o_pc==-1))
			{
				o_pc=m_api->m_data.CreateInstanceBN(S::prd_rel_prd_cat);
				pc_map.Add((long)i_pc,(long)o_pc);

				data.GetAttrBN(i_pc,S::name,buf);
				m_api->m_data.PutAttrBN(o_pc,S::name,buf);
				data.GetAttrBN(i_pc,S::description,buf);
				m_api->m_data.PutAttrBN(o_pc,S::description,buf);
			}
		}
		//   
		CaplAttrValue tst_values[2];
		aplExtent ext,ext_pcr;
		CaplInstance *i_pc1, *o_pc1,*i_pc2, *o_pc2, *o_pcr;

		data.GetEntityExtentBN(S::product_category_relationship,ext_pcr);
		ent=m_api->m_data.GetEntityBN(S::product_category_relationship);
		for (i=0;i<ext_pcr.Size;i++)
		{
			o_pcr=0;
			data.GetAttrBN(ext_pcr[i],_T("category"),i_pc1);
			o_pc1=(CaplInstance*)pc_map.GetByIn((long)i_pc1);
			if((o_pc1!=0)&&(o_pc1!=(CaplInstance*)-1))
			{
				data.GetAttrBN(ext_pcr[i],_T("sub_category"),i_pc2);
				o_pc2=(CaplInstance*)pc_map.GetByIn((long)i_pc2);
				if((o_pc2!=0)&&(o_pc2!=(CaplInstance*)-1))
				{
					if((o_pc1->GetId()!=0)&&(o_pc2->GetId()!=0))
					{
						tst_values[0].value.Set(o_pc1);
						tst_values[0].attr=m_api->m_data.GetAttrDefinitionBN(S::product_category_relationship,_T("category"));
						tst_values[1].value.Set(o_pc2);
						tst_values[1].attr=m_api->m_data.GetAttrDefinitionBN(S::product_category_relationship,_T("sub_category"));

						m_api->m_data.NET_FindInstancesWithAttrValues(ent,2,&tst_values[0],ext,false);
						if(ext.Size>0) {o_pcr=ext[0];}
					}
					if(o_pcr==0)
					{
						o_pcr=m_api->m_data.CreateInstanceBN(S::product_category_relationship);
						m_api->m_data.PutAttrBN(o_pcr,_T("category"),o_pc1);
						m_api->m_data.PutAttrBN(o_pcr,_T("sub_category"),o_pc2);
					}
				}
			}
		}

		//   
		CArray<apl_NET_LoadQuery,  apl_NET_LoadQuery &> m_aplQuery;
		CaplAttr *attr;

		for(i=0;i<pc_map.Size;i++)
		{
			//  
			if(data.IsKindOfBN((CaplInstance*)pc_map[i].in,S::prd_rel_prd_cat))
			{
				if(m_api->m_data.IsKindOfBN((CaplInstance*)pc_map[i].out,S::prd_rel_prd_cat))
				{
					//   
					if(((CaplInstance*)(pc_map[i].out))->GetId()!=0)
					{
						attr=m_api->m_data.GetAttrDefinitionBN(_T("product_related_product_category"),_T("products"));
						if(attr!=0) {apl_NET_LoadQuery q(1, _T('i'), ((CaplInstance*)(pc_map[i].out))->GetId(), 0, attr->id); m_aplQuery.Add(q);}
						m_api->m_data.NET_Load(m_aplQuery.GetData(), m_aplQuery.GetSize());
					}
					//  
					CaplAggr aggr0,aggr1;
					data.GetAttrBN((CaplInstance*)pc_map[i].in,_T("products"),aggr0);
					m_api->m_data.GetAttrBN((CaplInstance*)pc_map[i].out,_T("products"),aggr1);
					for(int i0=0;i0<aggr0.GetSize();i0++)
					{
						CaplInstance *inst0=0;
						aggr0.GetByIndex(i0,inst0);
						inst0=(CaplInstance*)prd_map.GetByIn((long)inst0);
						if((inst0!=0)&&(inst0!=(CaplInstance*)-1))
						{
							bool notfound=true;
							for(int i1=0;i1<aggr1.GetSize();i1++)
							{
								CaplInstance *inst1=0;
								aggr1.GetByIndex(i1,inst1);
								if(inst1==inst0) {notfound=false; break;}
							}
							if(notfound)aggr1.Add(inst0);
						}
					}
					m_api->m_data.PutAttrBN((CaplInstance*)pc_map[i].out,_T("products"),aggr1);
				}
			}
		}
	}
	m_progress.SetPos(8);
	m_action.SetWindowText( APL_T(" "));
	if(m_imp_doc)
	{
		//  
		m_progress1.SetRange32(0,ext_pd.Size-1);
		CaplMap doc_map;
		CaplInstance *i_doc,*o_doc,*kind;
		for (i=0;i<ext_pd.Size;i++)
		{
			m_progress1.SetPos(i);
			i_pd=ext_pd[i];
			if(!data.IsKindOfBN(i_pd,_T("product_definition_with_associated_documents")))
				continue;
			CaplAggr aggr_doc;
			o_pdf=(CaplInstance*)pd_map.GetByIn((long)i_pd);
			if((long)o_pdf==-1)continue;

			data.GetAttrBN(i_pd,_T("documentation_ids"),aggr_doc);
			for(j=0;j<aggr_doc.GetSize();j++)
			{
				aggr_doc.GetByIndex(j,i_doc);

				o_doc=(CaplInstance*)doc_map.GetByIn((long)i_doc);
				if((long)o_doc==-1)o_doc=0;
				if(o_doc==0)
				{
					//     
					data.GetAttrBN(i_doc,S::id,id);
					data.GetAttrBN(i_doc,S::name,name);
					data.GetAttrBN(i_doc,S::description,descr);
					data.GetAttrBN(i_doc,S::kind,kind);
					data.GetAttrBN(kind,S::product_data_type,doc_type);
					
					CaplInstance *i_doc_type=m_api->m_doc_mgr.GetDocumentTypeBN(doc_type);
					if(i_doc_type==0)
					{
						i_doc_type=m_api->m_data.CreateInstanceBN(S::document_type);
						m_api->m_data.PutAttrBN(i_doc_type,S::product_data_type,doc_type);
					}
					//   
					CFileFind ffind;
					CString sFileName=m_sFilePath+id;
					if(ffind.FindFile(sFileName)==FALSE) continue;
					ffind.FindNextFile();

					bool set_active=false;
					if(m_set_new_rew_active==TRUE) set_active=true;

					//     id  
					CString n_id=ffind.GetFileTitle();//  
					o_doc=m_api->m_doc_mgr.FindDocById(n_id);
					if(o_doc==0)
					{
						o_doc=m_api->m_doc_mgr.CreateDocument(n_id,name,descr,i_doc_type,sFileName,true);
					}
					else
					{
						CaplInstance *o_doc_rev=m_api->m_doc_mgr.CreateDocumentRevision(o_doc,sFileName,true,set_active);
						m_api->m_data.GetAttrBN(o_doc_rev,S::of_document,o_doc);
					}
					
					//CaplInstance *o_doc_rev=stdoc.UpploadDocRevision(n_id,name,descr,doc_type,id,set_active);
					//m_api->m_data.GetAttrBN(o_doc_rev,S::of_document,o_doc);
					doc_map.Add((long)i_doc,(long)o_doc);
				}
				//   PDF
				m_api->m_doc_mgr.CreateAssociation(o_pdf,o_doc);
				//stdoc.CreateDocToInstRel(o_doc,o_pdf);
			}
		}
	}
	m_progress.SetPos(9);
	m_action.SetWindowText( APL_T(" "));
	m_api->m_data.NET_SaveChanges();

	if(m_imp_geom==TRUE)
	{
		int i,j;

		CaplInstance *i_doc_type=m_api->m_doc_mgr.GetDocumentTypeBN(_T("STEP"));
		if(i_doc_type==0)
		{
			i_doc_type=m_api->m_data.CreateInstanceBN(S::document_type);
			m_api->m_data.PutAttrBN(i_doc_type,S::product_data_type,_T("STEP"));
		}
		//  STEP 
		

		//  ID  PD
		aplExtent out_ext,ext_sdr,ext_rr,ext_srr,ext_cdsr;
		CaplInstance *sdr, *pds, *pd, *sr,*sr1,*sr2,*to;//,*sa;
		data.GetEntityExtentBN(_T("shape_definition_representation"),ext_sdr);
		data.GetEntityExtentBN(_T("representation_relationship"),ext_rr);
		data.GetEntityExtentBN(_T("context_dependent_shape_representation"),ext_cdsr);
		CaplEntity *ent_srr=data.GetEntityBN(_T("shape_representation_relationship"));
		CaplEntity *ent_sa=data.GetEntityBN(_T("shape_aspect"));
		data.GetEntityExtent(ent_srr,ext_srr);

		m_progress1.SetRange32(0,ext_sdr.Size-1);
		//  
		for(i=0;i<ext_sdr.Size;i++)
		{
			m_progress1.SetPos(i);
			sdr=ext_sdr[i];
			data.GetAttrBN(sdr,_T("used_representation"),sr);
			data.GetAttrBN(sdr,_T("definition"),pds);
			data.GetAttrBN(pds,_T("definition"),i_pd);
			if(!data.IsKindOfBN(i_pd,_T("product_definition"))) continue;
			//data.GetAttrBN(sa,_T("of_shape"),sa);
			//data.GetAttrBN(sa,_T("definition"),sa);
			
			CaplInstance *o_pd=(CaplInstance*)pd_map.GetByIn((long)i_pd);
			if((long)o_pd==-1) o_pd=0;
			if(o_pd!=0)
			{
				buf.Format(_T("%i"),o_pd->GetId());
				data.PutAttrBN(i_pd,S::id,buf);
				data.PutAttrBN(sr,S::name,buf);
			}
		}
		//  
		CaplStepData out_data;
		out_data.LoadDictionary(data.m_CurSchema);

		for(i=0;i<ext_sdr.Size;i++)
		{
			m_progress1.SetPos(i);
			out_ext.Clear();
			sdr=ext_sdr[i];
			data.GetAttrBN(sdr,_T("used_representation"),sr);
			data.GetAttrBN(sdr,_T("definition"),pds);
			data.GetAttrBN(pds,_T("definition"),pd);
	    	i_pd=pd;
			if(!data.IsKindOfBN(i_pd,_T("product_definition"))) continue;
			//data.GetAttrBN(sa,_T("of_shape"),pd);
			//data.GetAttrBN(pd,_T("definition"),pd);
			CaplInstance *pds1,*nauo1,*pd1;
			
			//      
			for(j=0;j<ext_srr.Size;j++)
			{
				if(ext_srr[j]->GetType()==ent_srr)
				{
					data.GetAttrBN(ext_srr[j],_T("rep_1"),sr1);
					data.GetAttrBN(ext_srr[j],_T("rep_2"),sr2);
					if((sr1==sr)||(sr2==sr))
					{
						//
						CaplAggr aggr_in,aggr_out;
						if(sr1==sr)
						{
							data.GetAttrBN(sr,S::items,aggr_out);
							data.GetAttrBN(sr2,S::items,aggr_in);
						}
						else
						{
							data.GetAttrBN(sr,S::items,aggr_out);
							data.GetAttrBN(sr1,S::items,aggr_in);
						}
						aggr_out.Append(aggr_in);
						data.PutAttrBN(sr,S::items,aggr_out);
					}
				}
			}
			data.aplGetAllInstanceRef(sr,out_ext);
			//out_ext.Add(pds);
			out_ext.Add(sdr);
			//  
			for(j=0;j<ext_cdsr.Size;j++)
			{
				data.GetAttrBN(ext_cdsr[j],_T("represented_product_relation"),pds1);
				data.GetAttrBN(pds1,_T("definition"),nauo1);
				data.GetAttrBN(nauo1,S::relating_pd,pd1);
				if(pd==pd1)
				{
					data.GetAttrBN(ext_rr[j],_T("rep_1"),sr1);
					data.GetAttrBN(ext_rr[j],_T("rep_2"),sr2);
					data.GetAttrBN(ext_rr[j],_T("transformation_operator"),to);
					data.aplGetAllInstanceRef(to,out_ext);
					out_ext.Add(ext_rr[j]);
					if(sr==sr1)
					{	
						out_ext.Add(sr2);
						data.PutAttrBN(ext_rr[j],_T("rep_1"),sr2);
						data.PutAttrBN(ext_rr[j],_T("rep_2"),sr1);
						if(data.IsKindOfBN(to,_T("item_defined_transformation")))
						{
							CaplInstance *to1,*to2;
							data.GetAttrBN(to,_T("transform_item_1"),to1);
							data.GetAttrBN(to,_T("transform_item_2"),to2);
							data.PutAttrBN(to,_T("transform_item_1"),to2);
							data.PutAttrBN(to,_T("transform_item_2"),to1);
						}
					}
					else out_ext.Add(sr1);
				}
			}
			//    
			CString tmp; aplGetTempPath(tmp);

			data.GetAttrBN(pd,S::formation,i_pdf);	
			data.GetAttrBN(i_pdf,S::of_product,i_prd);
			data.GetAttrBN(i_prd,S::id,buf);
			data.GetAttrBN(i_pdf,S::id,id);

			if(id!=_T("")) {buf+=_T("-");buf+=id;}
			id=buf+_T("_std");
			buf=tmp+id+_T(".std");
			out_data.ClearData();
			data.aplFarCopyInstances(out_ext,out_data);
			//aplP21Header header;
			//out_data.SaveP21(buf,header);
			out_data.SaveToFile(buf);
			out_data.ClearData();

			//  
			CaplInstance *o_doc=0;
			o_pdf=(CaplInstance*)pd_map.GetByIn((long)i_pd);
			if((long)o_pdf==-1) o_pdf=0;
			if(o_pdf!=0)
			{
				id.Format(_T("%i"),o_pdf->GetId());
				o_doc=m_api->m_doc_mgr.FindDocById(id);
			}
			if(o_doc==0)
			{
				o_doc=m_api->m_doc_mgr.CreateDocument(id,name,descr,i_doc_type,buf,true);
				m_api->m_data.PutAttrBN(o_doc,S::name,_T("STEP"));
				m_api->m_data.PutAttrBN(o_doc,S::description,_T("from EF"));			}
			else
			{
				CaplInstance *o_doc_rev=m_api->m_doc_mgr.CreateDocumentRevision(o_doc,buf,true,true);
				m_api->m_data.GetAttrBN(o_doc_rev,S::of_document,o_doc);
				m_api->m_data.PutAttrBN(o_doc,S::name,_T("STEP"));
				m_api->m_data.PutAttrBN(o_doc,S::description,_T("from EF"));
			}
			m_api->m_doc_mgr.CreateAssociation(o_pdf,o_doc);
			//m_api->m_data.GetAttrBN(o_doc_rev,S::of_document,o_doc);
			//stdoc.CreateDocToInstRel(o_doc,o_pdf);
			SetFileAttributes(buf, FILE_ATTRIBUTE_NORMAL);
			CFile::Remove(buf);
		}
	}
	m_action.SetWindowText( APL_T(""));
	m_api->m_data.NET_SaveChanges();
	m_action.SetWindowText( APL_T(" !"));
	AfxGetApp()->DoWaitCursor(-1);
	AfxMessageBox(_T("Ok"));
	m_SaveDbBtn.EnableWindow(FALSE);

}
//******************************************************************
void CImportEfDlg::OnDblClikEdit() 
{
	UpdateData(TRUE);
}
//******************************************************************
void CImportEfDlg::TranslateMappedItem()
{
	int i,j,k,n=0;
	aplExtent ext_sdr,ext_sr,ext_acu;
	CaplInstance *mi,*rm,*sr, *cdsr, *pds, *pd, *sr0, *ri1,*ri2;
	CaplEntity *ent_mi=data.GetEntityBN(_T("mapped_item"));
	CStringArray str_array;
	str_array.Add(_T("shape_representation_relationship"));
	str_array.Add(_T("representation_relationship_with_transformation"));
	CaplEntity *e_rrwt=data.GetComplexEntityBN(str_array);
	data.GetEntityExtentBN(_T("shape_representation"),ext_sr);
	data.GetEntityExtentBN(S::assembly_component_usage,ext_acu);

	CaplMap pd_sr_map;
	//   
	data.GetEntityExtentBN(_T("shape_definition_representation"),ext_sdr);
	for(i=0;i<ext_sdr.Size;i++)
	{
		CaplAggr aggr0;
		data.GetAttrBN(ext_sdr[i],_T("used_representation"),sr);
		data.GetAttrBN(ext_sdr[i],_T("definition"),pds);
		data.GetAttrBN(pds,_T("definition"),pd);
		pd_sr_map.Add((long)pd,(long)sr);
	}
	//   . MI
	for(i=0;i<ext_sr.Size;i++)
	{
		CaplAggr aggr0;
		data.GetAttrBN(ext_sr[i],S::items,aggr0);
		for(j=0;j<aggr0.GetSize();j++)
		{
			aggr0.GetByIndex(j,mi);
			if(data.IsKindOf(mi,ent_mi))
			{
				//  MI
				data.GetAttrBN(mi,_T("mapping_source"),rm);
				data.GetAttrBN(rm,_T("mapped_representation"),sr);
				data.GetAttrBN(rm,_T("mapping_origin"),ri1);
				data.GetAttrBN(mi,_T("mapping_target"),ri2);
				n++;

				//  
				CaplInstance *rrwt, *idt;
				rrwt=data.CreateInstance(e_rrwt);
				idt=data.CreateInstanceBN(_T("item_defined_transformation"));
				data.PutAttrBN(rrwt,_T("transformation_operator"),idt);
				data.PutAttrBN(idt,_T("transform_item_1"),ri1);
				data.PutAttrBN(idt,_T("transform_item_2"),ri2);
				data.PutAttrBN(rrwt,_T("rep_1"),sr);
				data.PutAttrBN(rrwt,_T("rep_2"),ext_sr[i]);

				//  
				aggr0.Remove(j);j--;
				data.PutAttrBN(ext_sr[i],S::items,aggr0);
				data.DeleteInstance(mi);
				data.DeleteInstance(rm);
	
				//     NAUO
				for(k=0;k<ext_acu.Size;k++)
				{
					data.GetAttrBN(ext_acu[k],S::relating_pd,pd);
					sr0=(CaplInstance*)pd_sr_map.GetByIn((long)pd);
					if(sr0==ext_sr[i])
					{
						data.GetAttrBN(ext_acu[k],S::related_pd,pd);
						sr0=(CaplInstance*)pd_sr_map.GetByIn((long)pd);
						if(sr0==sr)
						{
							//  
							cdsr=data.CreateInstanceBN(_T("context_dependent_shape_representation"));
							pds=data.CreateInstanceBN(_T("product_definition_shape"));
							data.PutAttrBN(cdsr,_T("represented_product_relation"),ext_acu[k]);
							data.PutAttrBN(cdsr,_T("definition"),pds);
							data.PutAttrBN(pds,_T("definition"),ext_acu[k]);
							ext_acu.Remove(k);
						}
					}
				}
			}
		}
	}
}


void CImportEfDlg::OnCreateFolder() 
{
	if (m_create_folder_ctrl.GetCheck())
	{
		m_folder_name_ctrl.EnableWindow(TRUE);
		m_create_folder_all_ctrl.EnableWindow(TRUE);
	}
	else
	{
		m_folder_name_ctrl.EnableWindow(FALSE);
		m_create_folder_all_ctrl.EnableWindow(FALSE);
	}
}

void CImportEfDlg::OnBnClickedAutoSetMade()
{
	// TODO: Add your control notification handler code here
	if(m_AutoSetMadeCtrl.GetCheck())
	{
		m_MadeIdSubstrCtrl.EnableWindow(TRUE);
		m_AutoSetBoughtCtrl.EnableWindow(TRUE);
	}
	else
	{
		m_MadeIdSubstrCtrl.EnableWindow(FALSE);
		m_AutoSetBoughtCtrl.EnableWindow(FALSE);
	}

}


BOOL CImportEfDlg::DestroyWindow()
{
	CWinApp *app=AfxGetApp();
	if(app!=0)
	{
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bAutoSetMade"),m_AutoSetMadeCtrl.GetCheck());
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bAutoSetBought"),m_AutoSetBoughtCtrl.GetCheck());
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bAutoSetStd"),m_AutoSetStdCtrl.GetCheck());
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bDenyCreateStd"),m_DenyCreateStdCtrl.GetCheck());
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bAutoParseStdName"),m_autoParseStdNameCtrl.GetCheck());
		CString sMadeSubStr;
		m_MadeIdSubstrCtrl.GetWindowText(sMadeSubStr);
		app->WriteProfileString(_T("CImportEfDlg"),_T("sMadeSubStr"),sMadeSubStr);

		app->WriteProfileInt(_T("CImportEfDlg"),_T("bCreateFolderAll"),m_create_folder_all_ctrl.GetCheck());
		app->WriteProfileInt(_T("CImportEfDlg"),_T("bdbl_click_edit"),m_dbl_click_edit_ctrl.GetCheck());
	}

	CaplTranslateDialog::OnClose();	

	return CaplTranslateDialog::DestroyWindow();
}
