// MailFrame.cpp : implementation file
//

#include "stdafx.h"
#include "psm.h"
#include "MailFrame.h"
#include "MailListView.h"
#include "MailRTFView.h"
#include "PSMDoc.h"
#include "aplTopLevelItem.h"
#include "aplMessageTreeItem.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMailFrame

IMPLEMENT_DYNCREATE(CMailFrame, CFrameWnd)

CMailFrame::CMailFrame()
{
}

CMailFrame::~CMailFrame()
{
}


BEGIN_MESSAGE_MAP(CMailFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMailFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMailFrame message handlers

BOOL CMailFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	CMailListView* pView;
	pView = (CMailListView*)CreateView(pContext);
	ASSERT(pView);

	SetActiveView(pView);
	
	return TRUE;
}

int CMailFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT|TBSTYLE_LIST|TBSTYLE_WRAPABLE, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAILFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if(aplGetBitPerPixel(0)>8)
	{
		CBitmap bmp0;
		bmp0.LoadBitmap(IDB_MESSAGE_FRAME);
		m_il_ToolBar.Create(20,18,ILC_COLOR24|ILC_MASK,0,20);
		m_il_ToolBar.Add(&bmp0,RGB(192,192,192));
		m_wndToolBar.GetToolBarCtrl().SetImageList(&m_il_ToolBar);

		HIMAGELIST tmp_il1=aplImageListCopyAsSpecificBlend((HIMAGELIST)(*m_wndToolBar.GetToolBarCtrl().GetImageList()),25,true);//,RGB(255,255,255));
		m_il_mf_gray.Attach(tmp_il1);
		m_wndToolBar.GetToolBarCtrl().SetDisabledImageList(&m_il_mf_gray);

	}
	
	return 0;
}

void CMailFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

IMPLEMENT_DYNCREATE(CMailBodyFrame, CFrameWnd)

CMailBodyFrame::CMailBodyFrame()
{
	m_rtfView=0;
	m_htmlView=0;
}

CMailBodyFrame::~CMailBodyFrame()
{
	if(!m_sTmpFile4Delete.IsEmpty()) {CFile::Remove(m_sTmpFile4Delete); m_sTmpFile4Delete.Empty();}
}


BEGIN_MESSAGE_MAP(CMailBodyFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMailBodyFrame)
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMailFrame message handlers

BOOL CMailBodyFrame::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	m_rtfView = (CMailRTFView*)CreateView(pContext);
	ASSERT(m_rtfView);
	SetActiveView(m_rtfView);

	UINT viewID = AFX_IDW_PANE_FIRST + 1000;
	CRect rect(0, 0, 0, 0); // Gets resized later.
	m_htmlView=new CaplHtmlView; 
	BOOL b1=m_htmlView->Create(NULL, NULL, WS_CHILD, rect, this, viewID, 0);
	m_htmlView->ModifyStyle(0,WS_BORDER);
	m_htmlView->SendMessage(WM_INITIALUPDATE, 0, 0);
	return TRUE;
}

int CMailBodyFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if(!m_wndDlgBar.Create(this, IDD_MAIL_DIALOG_BAR, CBRS_TOP, IDD_MAIL_DIALOG_BAR))
	{
		TRACE0("Failed to create dialog bar\n");
		return -1;      // fail to create		
	}
	
	return 0;
}

void CMailBodyFrame::OnDestroy() 
{
	CFrameWnd::OnDestroy();	
}

LRESULT CMailBodyFrame::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	if(message==((CPSMApp*)AfxGetApp())->m_view_update)
	{
		if(wParam==APL_UPDATE_TREE_ITEM)
		{
			if(lParam && ((CaplTreeItem*)lParam)->m_type==APL_TREE_ITEM_MESSAGE)
			{
				CaplMessageTreeItem* item = (CaplMessageTreeItem*)lParam;
				//CMailRTFView* view= (CMailRTFView*)GetActiveView();
				CView *actView=GetActiveView();
				if(0!=m_rtfView && 0!=actView)
				{
					CaplInstance* mes= item->m_message;
					if(mes) ShowMessage(mes, item);
				}
			}
		}
		else if(wParam==3)
		{
			CView* actView= GetActiveView();
			if(actView==m_rtfView)
			{
				m_rtfView->EndRead();
			}
		}
	}
	return CFrameWnd::WindowProc(message, wParam, lParam);
}

//*******************************************************************************

void CMailBodyFrame::ShowMessage(CaplInstance *mes, CaplMessageTreeItem *item)
{
	if(0==mes) return;
	if(mes->GetAccessmode()>aplRO) return;

	CPSMDoc* doc=m_rtfView->GetDocument();
	if(0==doc) return;

	CString sFrom, sTo, sSubject, sContentFormat;
	sFrom= CaplMessageTreeItem::GetMessageSend(doc, mes);
	sTo= CaplMessageTreeItem::GetMessageRecip(doc, mes);

	CaplAPI &m_api=doc->m_api;
	m_api.m_data.GetAttr(mes,m_api.m_message_mgr.a_message_subject, sSubject);
	UpdateHeader(sFrom, sTo, sSubject);

	CaplInstance *main_message=0;
	m_api.m_data.GetAttr(mes, m_api.m_message_mgr.a_message_copy, main_message);	
	if(0!=main_message) m_api.m_message_mgr.LoadMessageInfo(main_message);
	m_api.m_data.GetAttr(mes,m_api.m_message_mgr.a_message_content_format, sContentFormat);
	if(sContentFormat==_T("") && 0!=main_message) 
		m_api.m_data.GetAttr(main_message, m_api.m_message_mgr.a_message_content_format, sContentFormat);

	if(sContentFormat==_T("html"))
	{
		SwitchView(m_htmlView);
		CString sContent,sTmpFile;
		m_api.m_message_mgr.GetMessageContent(mes,sContent);
		
		if(!m_sTmpFile4Delete.IsEmpty()) {CFile::Remove(m_sTmpFile4Delete); m_sTmpFile4Delete.Empty();}
		
		if(CaplMessageManager::SaveHtmlContentToTempFile(sContent,sTmpFile))
		{
			CString sUrl=_T("file:\\")+sTmpFile; 
			m_htmlView->Navigate(sUrl);
			
			m_sTmpFile4Delete=sTmpFile;
		}
		else m_htmlView->Navigate(_T("about:blank"));

		m_htmlView->SetEditMode(false);
	}
	else
	{
		SwitchView(m_rtfView);
		m_rtfView->UpdateBody(mes);
		m_rtfView->m_cur_item= item;
	}
}

//*******************************************************************************
void CMailBodyFrame::SwitchView(CView *pNewView)
{
	if(0==pNewView) return;
	CView *pActiveView=GetActiveView();
	if(pNewView==pActiveView) return;

	if(pActiveView==m_rtfView) m_rtfView->EndRead();

    // Exchange view window IDs so RecalcLayout() works.
   UINT temp = ::GetWindowLong(pActiveView->m_hWnd, GWL_ID);
   ::SetWindowLong(pActiveView->m_hWnd, GWL_ID, ::GetWindowLong(pNewView->m_hWnd, GWL_ID));
   ::SetWindowLong(pNewView->m_hWnd, GWL_ID, temp);

   pActiveView->ShowWindow(SW_HIDE);
   pNewView->ShowWindow(SW_SHOW);
   SetActiveView(pNewView);
   RecalcLayout();
   pNewView->Invalidate();
}


//*******************************************************************************

void CMailBodyFrame::UpdateHeader(CString sFrom,  CString sTo,  CString sSubject)
{
	CEdit* pEdit= NULL;
	pEdit= (CEdit*) m_wndDlgBar.GetDlgItem(IDC_MAIL_DB_FROM_EDIT);
	if(pEdit)pEdit->SetWindowText(sFrom);
	pEdit= (CEdit*) m_wndDlgBar.GetDlgItem(IDC_MAIL_DB_TO_EDIT);
	if(pEdit)pEdit->SetWindowText(sTo);
	pEdit= (CEdit*) m_wndDlgBar.GetDlgItem(IDC_MAIL_DB_SUBJECT_EDIT);
	if(pEdit)pEdit->SetWindowText(sSubject);
}
